# Risk Gap - Da Vinci Risk Adjustment Implementation Guide v2.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Risk Gap**

## OperationDefinition: Risk Gap 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-ra/OperationDefinition/risk-gap | *Version*:2.1.0 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:RiskGap |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.29.33.2 | | |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License | | |

 
The risk-gap operation is used to determine condition Category (CC) gaps for a patient/member. 

### Custom Header: contextId

#### Purpose

The contextId header is an optional, non-standard HTTP header used to transmit an internal or system-specific identifier associated with the current request context. For example, a contextId maybe a 'gap-request-id' that is used by some systems to track an appointment that later is morphed into an encounter, and this "gap-request-id" can then be used by the server system to produce a Risk Adjustment Coding Gap Report.

#### Usage

Include the contextId header in FHIR API POST operations. Implementers are expected to document the meaning of contextId used in their implementation and expected format if any constraints apply.

#### Syntax

contextId: `<string>` 
 `<string>`: A system-specific identifier, such as an internal request id, gap-request-id, or similar identifier used for internal tracking.

POST [base]/MeasureReport/$risk-gap 
 Host: example.org 
 Content-Type: application/fhir+json 
 contextId: gap-request-id-123

Servers receiving the contextId should log, propagate, or process the header according to their internal policies.

URL: [base]/MeasureReport/$risk-gap

URL: [base]/MeasureReport/[id]/$risk-gap

### Parameters

* **Use**: IN
  * **Name**: periodStart
  * **Scope**: 
  * **Cardinality**: 1..1
  * **Type**: [date](http://hl7.org/fhir/R4/datatypes.html#date)
  * **Binding**: 
  * **Documentation**: The start of a clinical evaluation period.
* **Use**: IN
  * **Name**: periodEnd
  * **Scope**: 
  * **Cardinality**: 1..1
  * **Type**: [date](http://hl7.org/fhir/R4/datatypes.html#date)
  * **Binding**: 
  * **Documentation**: The end of a clinical evaluation period.
* **Use**: IN
  * **Name**: subject
  * **Scope**: 
  * **Cardinality**: 1..1
  * **Type**: [Patient](http://hl7.org/fhir/R4/patient.html)([US Core Patient Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-patient.html))
  * **Binding**: 
  * **Documentation**: Patient resource as input parameter, which provides data such as patient's first name, last name, date of birth
* **Use**: IN
  * **Name**: coverage
  * **Scope**: 
  * **Cardinality**: 1..1
  * **Type**: [Coverage](http://hl7.org/fhir/R4/coverage.html)([US Core Coverage Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-coverage.html))
  * **Binding**: 
  * **Documentation**: This is a reference to the Coverage resource, which provides information such as the subscriberId
* **Use**: IN
  * **Name**: TIN
  * **Scope**: 
  * **Cardinality**: 0..1
  * **Type**: [string](http://hl7.org/fhir/R4/datatypes.html#string)([token](https://hl7.org/fhir/R4/search.html#token))
  * **Binding**: 
  * **Documentation**: This is the provider rganization's TIN
* **Use**: IN
  * **Name**: ccType
  * **Scope**: 
  * **Cardinality**: 0..*
  * **Type**: [code](http://hl7.org/fhir/R4/datatypes.html#code)
  * **Binding**: [Condition Category Type](ValueSet-cc-type.md)(Extensible)
  * **Documentation**: This Condition Category (CC) gaps will be filterd based on the CC type code, whether it is suspected, historic, and/or net-new.
* **Use**: IN
  * **Name**: evidenceStatus
  * **Scope**: 
  * **Cardinality**: 0..*
  * **Type**: [code](http://hl7.org/fhir/R4/datatypes.html#code)
  * **Binding**: [Evidence Status](ValueSet-evidence-status.md)(Extensible)
  * **Documentation**: This Condition Category (CC) gaps will be filterd based on the evidence status, whether the gap is an open-gap, invalid-gap, closed-gap, and/or pending.
* **Use**: IN
  * **Name**: providerTaxonomy
  * **Scope**: 
  * **Cardinality**: 0..*
  * **Type**: [code](http://hl7.org/fhir/R4/datatypes.html#code)
  * **Binding**: [ProviderTaxonomy](http://hl7.org/fhir/R4/valueset-provider-taxonomy.html)(Extensible)
  * **Documentation**: This Condition Category (CC) gaps will be filterd based on provider taxonomy.
* **Use**: IN
  * **Name**: encounter
  * **Scope**: 
  * **Cardinality**: 0..1
  * **Type**: [Encounter](http://hl7.org/fhir/R4/encounter.html)([US Core Encounter Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-encounter.html))
  * **Binding**: 
  * **Documentation**: This is a reference to the Encounter resource, which provides information such as the encounter id and date of service.
* **Use**: IN
  * **Name**: referenced
  * **Scope**: 
  * **Cardinality**: 0..*
  * **Type**: [Resource](http://hl7.org/fhir/R4/resource.html)
  * **Binding**: 
  * **Documentation**: Resources that are referenced by other input parameters, specifically Coverage and Encounter, defined in this operation.
* **Use**: OUT
  * **Name**: return
  * **Scope**: 
  * **Cardinality**: 0..1
  * **Type**: [Bundle](http://hl7.org/fhir/R4/bundle.html)
  * **Binding**: 
  * **Documentation**: This operation returns a Bundle of MeasureReports and associated resources



## Resource Content

```json
{
  "resourceType" : "OperationDefinition",
  "id" : "risk-gap",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-ra/OperationDefinition/risk-gap",
  "version" : "2.1.0",
  "name" : "RiskGap",
  "title" : "Risk Gap",
  "status" : "draft",
  "kind" : "operation",
  "date" : "2025-11-20T19:49:53+00:00",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "The risk-gap operation is used to determine condition Category (CC) gaps for a patient/member.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "code" : "risk-gap",
  "resource" : ["MeasureReport"],
  "system" : false,
  "type" : true,
  "instance" : true,
  "parameter" : [
    {
      "name" : "periodStart",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "The start of a clinical evaluation period.",
      "type" : "date"
    },
    {
      "name" : "periodEnd",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "The end of a clinical evaluation period.",
      "type" : "date"
    },
    {
      "name" : "subject",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "Patient resource as input parameter, which provides data such as patient's first name, last name, date of birth",
      "type" : "Patient",
      "targetProfile" : [
        "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient|7.0.0"
      ]
    },
    {
      "name" : "coverage",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "This is a reference to the Coverage resource, which provides information such as the subscriberId",
      "type" : "Coverage",
      "targetProfile" : [
        "http://hl7.org/fhir/us/core/StructureDefinition/us-core-coverage|7.0.0"
      ]
    },
    {
      "name" : "TIN",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "This is the provider rganization's TIN",
      "type" : "string",
      "searchType" : "token"
    },
    {
      "name" : "ccType",
      "use" : "in",
      "min" : 0,
      "max" : "*",
      "documentation" : "This Condition Category (CC) gaps will be filterd based on the CC type code, whether it is suspected, historic, and/or net-new.",
      "type" : "code",
      "binding" : {
        "strength" : "extensible",
        "valueSet" : "http://hl7.org/fhir/us/davinci-ra/ValueSet/cc-type"
      }
    },
    {
      "name" : "evidenceStatus",
      "use" : "in",
      "min" : 0,
      "max" : "*",
      "documentation" : "This Condition Category (CC) gaps will be filterd based on the evidence status, whether the gap is an open-gap, invalid-gap, closed-gap, and/or pending.",
      "type" : "code",
      "binding" : {
        "strength" : "extensible",
        "valueSet" : "http://hl7.org/fhir/us/davinci-ra/ValueSet/evidence-status"
      }
    },
    {
      "name" : "providerTaxonomy",
      "use" : "in",
      "min" : 0,
      "max" : "*",
      "documentation" : "This Condition Category (CC) gaps will be filterd based on provider taxonomy.",
      "type" : "code",
      "binding" : {
        "strength" : "extensible",
        "valueSet" : "http://hl7.org/fhir/ValueSet/provider-taxonomy"
      }
    },
    {
      "name" : "encounter",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "This is a reference to the Encounter resource, which provides information such as the encounter id and date of service.",
      "type" : "Encounter",
      "targetProfile" : [
        "http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter|7.0.0"
      ]
    },
    {
      "name" : "referenced",
      "use" : "in",
      "min" : 0,
      "max" : "*",
      "documentation" : "Resources that are referenced by other input parameters, specifically Coverage and Encounter, defined in this operation.",
      "type" : "Resource"
    },
    {
      "name" : "return",
      "use" : "out",
      "min" : 0,
      "max" : "1",
      "documentation" : "This operation returns a Bundle of MeasureReports and associated resources",
      "type" : "Bundle"
    }
  ]
}

```
