# Evaluate Measure - Da Vinci Risk Adjustment Implementation Guide v2.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Evaluate Measure**

## OperationDefinition: Evaluate Measure 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-ra/OperationDefinition/ra.evaluate-measure | *Version*:2.1.0 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:RAEvaluateMeasure |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.29.33.1 | | |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License | | |

 
The ra.evaluate-measure operation is used to evaluate Digital Condition Category and obtain the results. 

**The $ra.evaluate-measure is DRAFT and open for review.**

This operation executes digital condition category (dCC) measures specified in Clinical Quality Language (CQL) against the patient data to produce a [Risk Adjustment Coding Gap Report Bundle](StructureDefinition-ra-measurereport-bundle.md). Patient data, dCC measures, and CQL libraries are pre-populated on FHIR server.

Conformance Requirement 1: 

* If the operation is invoked at the instance level, the parameters `measureId`, `measureIdentifier`, and `measureUrl` is not allowed
* If the operation is invoked at the type level, one of the `measureId`, `measureIdentifier`, and `measureUrl` parameters is required

URL: [base]/Measure/$ra.evaluate-measure

URL: [base]/Measure/[id]/$ra.evaluate-measure

### Parameters

* **Use**: IN
  * **Name**: periodStart
  * **Scope**: 
  * **Cardinality**: 1..1
  * **Type**: [date](http://hl7.org/fhir/R4/datatypes.html#date)
  * **Binding**: 
  * **Documentation**: The start of a clinical evaluation period. The periodStart and periodEnd parameters will be compared with the clinical evaluation period (`MeasureReport.period.start` and `MeasureReport.period.end`) of a [Risk Adjustment Coding Gap MeasureReport](StructureDefinition-ra-measurereport.md) available on the Server. The MeasureReport will be returned if there is an overlap of the two periods.
* **Use**: IN
  * **Name**: periodEnd
  * **Scope**: 
  * **Cardinality**: 1..1
  * **Type**: [date](http://hl7.org/fhir/R4/datatypes.html#date)
  * **Binding**: 
  * **Documentation**: The end of a clinical evaluation period.
* **Use**: IN
  * **Name**: subject
  * **Scope**: 
  * **Cardinality**: 1..1
  * **Type**: [string](http://hl7.org/fhir/R4/datatypes.html#string)([reference](https://hl7.org/fhir/R4/search.html#reference))
  * **Binding**: 
  * **Documentation**: Subject will be a reference to either Patient ([US Core Patient](http://hl7.org/fhir/us/core/STU3.1.1/StructureDefinition-us-core-patient.html)) or Group ([Patient Group](StructureDefinition-ra-patient-group.md)). Must provide either Patient/123 or Group/123, cannot simply provide 123. If only 123 is provided, then the operation would not know if it is a Patient reference or a Group reference.
* **Use**: IN
  * **Name**: measureId
  * **Scope**: 
  * **Cardinality**: 0..*
  * **Type**: [id](http://hl7.org/fhir/R4/datatypes.html#id)
  * **Binding**: 
  * **Documentation**: The id of a Measure resource for risk adjustment model, e.g., CMS HCC v24
* **Use**: IN
  * **Name**: measureIdentifier
  * **Scope**: 
  * **Cardinality**: 0..*
  * **Type**: [string](http://hl7.org/fhir/R4/datatypes.html#string)([token](https://hl7.org/fhir/R4/search.html#token))
  * **Binding**: 
  * **Documentation**: The business identifier of a Measure resource for risk adjustment model, e.g., CMS HCC v24.
* **Use**: IN
  * **Name**: measureUrl
  * **Scope**: 
  * **Cardinality**: 0..*
  * **Type**: [canonical](http://hl7.org/fhir/R4/datatypes.html#canonical)
  * **Binding**: 
  * **Documentation**: This the URL of a Measure resource for risk adjustment model, e.g., CMS HCC v24
* **Use**: OUT
  * **Name**: return
  * **Scope**: 
  * **Cardinality**: 0..1
  * **Type**: [Bundle](http://hl7.org/fhir/R4/bundle.html)
  * **Binding**: 
  * **Documentation**: The $ra.evaluate-measure operation will always return one [Parameters](https://www.hl7.org/fhir/parameters.html) whether the subject is a single patient or a group of patients. [Risk Adjustment Coding Gap Report Bundle](StructureDefinition-ra-measurereport-bundle.md) for a patient is in a `Parameters.parameter` element. A Risk Adjustment Coding Gap Report Bundle contains the Risk Adjustment Coding Gap Reports for the same patient. For example, if a Group has 10 valid patients, then a [Parameters](https://www.hl7.org/fhir/parameters.html) will contain 10 `Parameters.parameter`elements, with each `Parameters.parameter` for a unique patient.



## Resource Content

```json
{
  "resourceType" : "OperationDefinition",
  "id" : "ra.evaluate-measure",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-ra/OperationDefinition/ra.evaluate-measure",
  "version" : "2.1.0",
  "name" : "RAEvaluateMeasure",
  "title" : "Evaluate Measure",
  "status" : "draft",
  "kind" : "operation",
  "date" : "2025-11-20T19:49:53+00:00",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "The ra.evaluate-measure operation is used to evaluate Digital Condition Category and obtain the results.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "code" : "ra.evaluate-measure",
  "base" : "http://hl7.org/fhir/OperationDefinition/Measure-evaluate-measure",
  "resource" : ["Measure"],
  "system" : false,
  "type" : true,
  "instance" : true,
  "parameter" : [
    {
      "name" : "periodStart",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "The start of a clinical evaluation period. The periodStart and periodEnd parameters will be compared with the clinical evaluation period (`MeasureReport.period.start` and `MeasureReport.period.end`)           of a [Risk Adjustment Coding Gap MeasureReport](StructureDefinition-ra-measurereport.html) available on the Server. The MeasureReport will be returned if there is an overlap of the two periods.",
      "type" : "date"
    },
    {
      "name" : "periodEnd",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "The end of a clinical evaluation period.",
      "type" : "date"
    },
    {
      "name" : "subject",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "Subject will be a reference to either Patient ([US Core Patient](http://hl7.org/fhir/us/core/STU3.1.1/StructureDefinition-us-core-patient.html)) or Group ([Patient Group](StructureDefinition-ra-patient-group.html)). Must provide either Patient/123 or Group/123, cannot simply provide 123. If only 123 is provided, then the operation would not know if it is a Patient reference or a Group reference.",
      "type" : "string",
      "searchType" : "reference"
    },
    {
      "name" : "measureId",
      "use" : "in",
      "min" : 0,
      "max" : "*",
      "documentation" : "The id of a Measure resource for risk adjustment model, e.g., CMS HCC v24",
      "type" : "id"
    },
    {
      "name" : "measureIdentifier",
      "use" : "in",
      "min" : 0,
      "max" : "*",
      "documentation" : "The business identifier of a Measure resource for risk adjustment model, e.g., CMS HCC v24.",
      "type" : "string",
      "searchType" : "token"
    },
    {
      "name" : "measureUrl",
      "use" : "in",
      "min" : 0,
      "max" : "*",
      "documentation" : "This the URL of a Measure resource for risk adjustment model, e.g., CMS HCC v24",
      "type" : "canonical"
    },
    {
      "name" : "return",
      "use" : "out",
      "min" : 0,
      "max" : "1",
      "documentation" : "The $ra.evaluate-measure operation will always return one [Parameters](https://www.hl7.org/fhir/parameters.html) whether the subject is a single patient or a group of patients. [Risk Adjustment Coding Gap Report Bundle](StructureDefinition-ra-measurereport-bundle.html) for a patient is in a `Parameters.parameter` element. A Risk Adjustment Coding Gap Report Bundle contains the Risk Adjustment Coding Gap Reports for the same patient. For example, if a Group has 10 valid patients, then a [Parameters](https://www.hl7.org/fhir/parameters.html) will contain 10 `Parameters.parameter`elements, with each `Parameters.parameter` for a unique patient.",
      "type" : "Bundle"
    }
  ]
}

```
