# Encounter with Dr Hippocrates on 2021-10-15 for Patient 01 - Da Vinci Risk Adjustment Implementation Guide v2.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Encounter with Dr Hippocrates on 2021-10-15 for Patient 01**

## Example Encounter: Encounter with Dr Hippocrates on 2021-10-15 for Patient 01

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Last updated: 2021-10-15 09:56:57-0400

Profile: [US Core Encounter Profileversion: null7.0.0)](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-encounter.html)

**status**: Finished

**class**: [ActCode: AMB](http://terminology.hl7.org/7.0.0/CodeSystem-v3-ActCode.html#v3-ActCode-AMB) (ambulatory)

**type**: 99396: Periodic comprehensive preventive medicine reevaluation and management of an individual including an age and gender appropriate history, examination, counseling/anticipatory guidance/risk factor reduction interventions, and the ordering of laboratory/diagnostic procedures, established patient; 40-64 years

**subject**: [Eve Everywoman (official) Female, DoB: 1975-01-16 ( Medical record number: 12345 (use: usual, ))](Patient-ra-patient01.md)

### Participants

| | |
| :--- | :--- |
| - | **Individual** |
| * | [Practitioner Harold Hippocrates](Practitioner-ra-prac01pat01.md) |

**period**: 2021-10-15 --> 2021-10-15

### Diagnoses

| | |
| :--- | :--- |
| - | **Condition** |
| * | [Condition Manic episode, unspecified](Condition-ra-condition12pat01.md) |

**serviceProvider**: [Organization GHH Outpatient Clinic](Organization-ra-org02pat02.md)



## Resource Content

```json
{
  "resourceType" : "Encounter",
  "id" : "ra-encounter46pat01",
  "meta" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/instance-name",
        "valueString" : "Encounter with Dr Hippocrates on 2021-10-15 for Patient 01"
      },
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/instance-description",
        "valueMarkdown" : "This is an Encounter example for encounter with Dr Hippocrates on 2021-10-15 for Patient 01."
      }
    ],
    "lastUpdated" : "2021-10-15T09:56:57.250-04:00",
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter|7.0.0"
    ]
  },
  "status" : "finished",
  "class" : {
    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
    "code" : "AMB",
    "display" : "ambulatory"
  },
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://www.ama-assn.org/go/cpt",
          "code" : "99396",
          "display" : "Periodic comprehensive preventive medicine reevaluation and management of an individual including an age and gender appropriate history, examination, counseling/anticipatory guidance/risk factor reduction interventions, and the ordering of laboratory/diagnostic procedures, established patient; 40-64 years"
        }
      ],
      "text" : "99396: Periodic comprehensive preventive medicine reevaluation and management of an individual including an age and gender appropriate history, examination, counseling/anticipatory guidance/risk factor reduction interventions, and the ordering of laboratory/diagnostic procedures, established patient; 40-64 years"
    }
  ],
  "subject" : {
    "reference" : "Patient/ra-patient01"
  },
  "participant" : [
    {
      "individual" : {
        "reference" : "Practitioner/ra-prac01pat01"
      }
    }
  ],
  "period" : {
    "start" : "2021-10-15",
    "end" : "2021-10-15"
  },
  "diagnosis" : [
    {
      "condition" : {
        "reference" : "Condition/ra-condition12pat01"
      }
    }
  ],
  "serviceProvider" : {
    "reference" : "Organization/ra-org02pat02"
  }
}

```
