# Remark Reason Codes - Da Vinci Risk Adjustment Implementation Guide v2.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Remark Reason Codes**

## CodeSystem: Remark Reason Codes 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-ra/CodeSystem/remark-reason | *Version*:2.1.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:RemarkReason |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.29.16.5 | | |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License | | |

 
Reason codes for remark 

 This Code system is referenced in the content logical definition of the following value sets: 

* [RemarkReason](ValueSet-remark-reason.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "remark-reason",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-ra/ImplementationGuide/davinci-ra"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-ra/ImplementationGuide/davinci-ra"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-ra/CodeSystem/remark-reason",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.29.16.5"
    }
  ],
  "version" : "2.1.0",
  "name" : "RemarkReason",
  "title" : "Remark Reason Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-20T19:49:53+00:00",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "Reason codes for remark",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 International, all rights reserved Creative Commons License",
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 3,
  "concept" : [
    {
      "code" : "never-had-condition",
      "display" : "Patient never had the condition",
      "definition" : "Reason for the assessed-not-present remark is because the patient has never had this condition."
    },
    {
      "code" : "inactive-condition",
      "display" : "Condition no longer active",
      "definition" : "Reason for the assessed-not-present remark is because the patient's condition is no longer active."
    },
    {
      "code" : "inapplicable-gap",
      "display" : "Inapplicable gap",
      "definition" : "Reason for the assessed-not-present remark is because the patient has an active condition but the gap does not accurately describe it."
    }
  ]
}

```
