# Coding Gap Remark Codes - Da Vinci Risk Adjustment Implementation Guide v2.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Coding Gap Remark Codes**

## CodeSystem: Coding Gap Remark Codes 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-ra/CodeSystem/coding-gap-remark | *Version*:2.1.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:CodingGapRemark |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.29.16.2 | | |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License | | |

 
Code sytstem that indicates coded remark for a coding gap. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [CodingGapRemark](ValueSet-coding-gap-remark.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "coding-gap-remark",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-ra/ImplementationGuide/davinci-ra"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-ra/ImplementationGuide/davinci-ra"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-ra/CodeSystem/coding-gap-remark",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.29.16.2"
    }
  ],
  "version" : "2.1.0",
  "name" : "CodingGapRemark",
  "title" : "Coding Gap Remark Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-20T19:49:53+00:00",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "Code sytstem that indicates coded remark for a coding gap.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 International, all rights reserved Creative Commons License",
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 7,
  "concept" : [
    {
      "code" : "assessed-present",
      "display" : "Assessed and present",
      "definition" : "Assessed the gap and acknowledged it is still present."
    },
    {
      "code" : "assessed-not-present",
      "display" : "Assessed and not present",
      "definition" : "Assessed the gap and acknowledged it is not present."
    },
    {
      "code" : "in-progress",
      "display" : "In progress",
      "definition" : "Assessed the gap and actions are taken to address the gap."
    },
    {
      "code" : "deferred",
      "display" : "Deferred",
      "definition" : "Assessed the gap and actions will be taken in the future to address the gap."
    },
    {
      "code" : "not-assessed",
      "display" : "Not assessed",
      "definition" : "Gap was shown to the provider but no action was taken to assess the gap."
    },
    {
      "code" : "not-presented",
      "display" : "Not presented",
      "definition" : "System did not present the gap to the end user."
    },
    {
      "code" : "not-ingested",
      "display" : "Not ingested",
      "definition" : "System cannot process the gap that was received."
    }
  ]
}

```
