# Risk Adjustment Reporting Client Capability Statement - Da Vinci Risk Adjustment Implementation Guide v2.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Risk Adjustment Reporting Client Capability Statement**

## CapabilityStatement: Risk Adjustment Reporting Client Capability Statement 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-ra/CapabilityStatement/ra-reporting-client | *Version*:2.1.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:RAClientCapabilityStatement |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.29.13.3 | | |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License | | |

 
This profile defines the expected capabilities of a Da Vinci Risk Adjustment Reporting Client when conforming to the Da Vinci Risk Adjustment Implementation Guide for interactions between Reporting Clients and Reporting Servers. Clients are the actors making the request for Risk Adjustment Coding Gap Reports for patient(s) and for Risk Adjustmenet Models that are available on the Server. This CapabilityStatement resource includes the complete list of the**recommended**Da Vinci Risk Adjustment profiles and RESTful operations that a Risk Adjustment Reporting Client could support. Clients have the option of choosing from this list based on their local use cases and other contextual requirements. 

 [Raw OpenAPI-Swagger Definition file](ra-reporting-client.openapi.json) | [Download](ra-reporting-client.openapi.json) 

## Risk Adjustment Reporting Client Capability Statement

* Implementation Guide Version: 2.1.0 
* FHIR Version: 4.0.1 
* Supported Formats: `xml`, `json`
* Supported Patch Formats: `application/json-patch+json`
* Published on: 2025-11-20 19:49:53+0000 
* Published by: HL7 International / Clinical Quality Information 

> **Note to Implementers: FHIR Capabilities**Any FHIR capability may be 'allowed' by the system unless explicitly marked as 'SHALL NOT'. A few items are marked as MAY in the Implementation Guide to highlight their potential relevance to the use case.

### SHALL Support the Following Implementation Guides

* [http://hl7.org/fhir/us/davinci-ra/ImplementationGuide/hl7.fhir.us.davinci-ra](index.md)

## FHIR RESTful Capabilities

### Mode: client

Da Vinci Risk Adjustment Reporting Client **SHALL** support the operation and profiles specified in this implementation guide.

**Security**

> 

For general security consideration refer to the [Security and Privacy Considerations](http://hl7.org/fhir/R4/secpriv-module.html).


**Summary of System-wide Interactions**

* **SHOULD**support the `batch`interaction.
* **MAY**support the `transaction`interaction.
* **MAY**support the `search-system`interaction.
* **MAY**support the `history-system`interaction.

### Capabilities by Resource/Profile

#### Summary

The summary table lists the resources that are part of this configuration, and for each resource it lists:

* The relevant profiles (if any)
* The interactions supported by each resource (**R**ead, **S**earch, **U**pdate, and **C**reate, are always shown, while **VR**ead, **P**atch, **D**elete, **H**istory on **I**nstance, or **H**istory on **T**ype are only present if at least one of the resources has support for them.
* The required, recommended, and some optional search parameters (if any).
* The linked resources enabled for `_include`
* The other resources enabled for `_revinclude`
* The operations on the resource (if any)

| | | | | | | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| [MeasureReport](#MeasureReport1-1) | Supported Profiles  [Risk Adjustment Coding Gap MeasureReport](StructureDefinition-ra-measurereport.md) | **Y** | **Y** | y? | y? |  | y? | y? | date, evaluatedResource, identifier, measure, patient, period, reporter, status, subject, measurereport-category | `MeasureReport:evaluatedResources` |  |  |
| [Bundle](#Bundle1-2) | Supported Profiles  [Risk Adjustment Coding Gap Report Bundle](StructureDefinition-ra-measurereport-bundle.md) | **Y** | **Y** |  |  |  | y? | y? |  |  |  |  |

-------

#### Resource Conformance: SHALL MeasureReport

Core FHIR Resource

[MeasureReport](http://hl7.org/fhir/R4/measurereport.html)

Reference Policy

`literal`,
`logical`

Interaction summary

* **SHALL** support 
`read`

Read allows maintainers of the MeasureReports to get the logical definitions of the MeasureReports

`search-type`

Search allows maintainers of the MeasureReports to find the logical definition of a MeasureReport


* **MAY** support `history-instance`, `history-type`
`update`

Update allows maintainers of the MeasureReports to update the logical definitions of a MeasureReport by its id or create a new one if it is new

`patch`

Patch allows maintainers of the MeasureReports to update the logical definition of a MeasureReport by posting a set of changes to it


Supported Profiles
[Risk Adjustment Coding Gap MeasureReport](StructureDefinition-ra-measurereport.md)

Search Parameters


 

#### Resource Conformance: MAY Bundle

Core FHIR Resource

[Bundle](http://hl7.org/fhir/R4/bundle.html)

Reference Policy

`literal`,
`logical`

Interaction summary

* **SHALL** support 
`read`

Read allows maintainers of the Bundles to get the logical definitions of the Bundle

`search-type`

Search allows maintainers of the Bundles to find the logical definition of a Bundle


* **MAY** support `history-instance`, `history-type`.

Supported Profiles
[Risk Adjustment Coding Gap Report Bundle](StructureDefinition-ra-measurereport-bundle.md)



## Resource Content

```json
{
  "resourceType" : "CapabilityStatement",
  "id" : "ra-reporting-client",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-ra/ImplementationGuide/davinci-ra"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-ra/ImplementationGuide/davinci-ra"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-ra/CapabilityStatement/ra-reporting-client",
  "version" : "2.1.0",
  "name" : "RAClientCapabilityStatement",
  "title" : "Risk Adjustment Reporting Client Capability Statement",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-20T19:49:53+00:00",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "This profile defines the expected capabilities of a Da Vinci Risk Adjustment Reporting Client when conforming to the Da Vinci Risk Adjustment Implementation Guide for interactions between Reporting Clients and Reporting Servers. Clients are the actors making the request for Risk Adjustment Coding Gap Reports for patient(s) and for Risk Adjustmenet Models that are available on the Server. This CapabilityStatement resource includes the complete list of the *recommended* Da Vinci Risk Adjustment profiles and RESTful operations that a Risk Adjustment Reporting Client could support. Clients have the option of choosing from this list based on their local use cases and other contextual requirements.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 International, all rights reserved Creative Commons License",
  "kind" : "requirements",
  "fhirVersion" : "4.0.1",
  "format" : ["xml", "json"],
  "patchFormat" : ["application/json-patch+json"],
  "implementationGuide" : [
    "http://hl7.org/fhir/us/davinci-ra/ImplementationGuide/hl7.fhir.us.davinci-ra"
  ],
  "rest" : [
    {
      "mode" : "client",
      "documentation" : "Da Vinci Risk Adjustment Reporting Client **SHALL** support the operation and profiles specified in this implementation guide.",
      "security" : {
        "description" : "For general security consideration refer to the [Security and Privacy Considerations](http://hl7.org/fhir/R4/secpriv-module.html)."
      },
      "resource" : [
        {
          "type" : "MeasureReport",
          "supportedProfile" : [
            "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-measurereport"
          ],
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read",
              "documentation" : "Read allows maintainers of the MeasureReports to get the logical definitions of the MeasureReports"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "history-instance"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "history-type"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "search-type",
              "documentation" : "Search allows maintainers of the MeasureReports to find the logical definition of a MeasureReport"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "update",
              "documentation" : "Update allows maintainers of the MeasureReports to update the logical definitions of a MeasureReport by its id or create a new one if it is new"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "patch",
              "documentation" : "Patch allows maintainers of the MeasureReports to update the logical definition of a MeasureReport by posting a set of changes to it"
            }
          ],
          "referencePolicy" : ["literal", "logical"],
          "searchInclude" : ["MeasureReport:evaluatedResources"],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "date",
              "definition" : "http://hl7.org/fhir/SearchParameter/MeasureReport-date",
              "type" : "date"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "evaluatedResource",
              "definition" : "http://hl7.org/fhir/SearchParameter/MeasureReport-evaluated-resource",
              "type" : "reference"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "identifier",
              "definition" : "http://hl7.org/fhir/SearchParameter/MeasureReport-identifier",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "measure",
              "definition" : "http://hl7.org/fhir/SearchParameter/MeasureReport-measure",
              "type" : "reference"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "patient",
              "definition" : "http://hl7.org/fhir/SearchParameter/MeasureReport-patient",
              "type" : "reference"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "period",
              "definition" : "http://hl7.org/fhir/SearchParameter/MeasureReport-period",
              "type" : "date"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "reporter",
              "definition" : "http://hl7.org/fhir/SearchParameter/MeasureReport-reporter",
              "type" : "reference"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "status",
              "definition" : "http://hl7.org/fhir/SearchParameter/MeasureReport-status",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "subject",
              "definition" : "http://hl7.org/fhir/SearchParameter/MeasureReport-subject",
              "type" : "reference"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "measurereport-category",
              "definition" : "http://hl7.org/fhir/us/davinci-ra/SearchParameter/measurereport-category",
              "type" : "token"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "MAY"
            }
          ],
          "type" : "Bundle",
          "supportedProfile" : [
            "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-measurereport-bundle"
          ],
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read",
              "documentation" : "Read allows maintainers of the Bundles to get the logical definitions of the Bundle"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "history-instance"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "history-type"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "search-type",
              "documentation" : "Search allows maintainers of the Bundles to find the logical definition of a Bundle"
            }
          ],
          "referencePolicy" : ["literal", "logical"]
        }
      ],
      "interaction" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHOULD"
            }
          ],
          "code" : "batch"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "MAY"
            }
          ],
          "code" : "transaction"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "MAY"
            }
          ],
          "code" : "search-system"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "MAY"
            }
          ],
          "code" : "history-system"
        }
      ]
    }
  ]
}

```
