# Risk Adjustment MeasureReport Bundle example, MeasureReport01: Patient01 - Da Vinci Risk Adjustment Implementation Guide v2.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Risk Adjustment MeasureReport Bundle example, MeasureReport01: Patient01**

## Example Bundle: Risk Adjustment MeasureReport Bundle example, MeasureReport01: Patient01

Profile: [Risk Adjustment Coding Gap Report Bundle](StructureDefinition-ra-measurereport-bundle.md)

Bundle ra-bundle01 of type collection

-------

Entry 1 - fullUrl = http://example.org/fhir/MeasureReport/ra-measurereport01

Resource MeasureReport:

> 

Profile: [Risk Adjustment Coding Gap MeasureReport](StructureDefinition-ra-measurereport.md)

**Measure Report Category**:Risk Adjustment**Clinical Data Collection Deadline Extension**: 2022-03-31**status**: Complete**type**: Individual**measure**:[Risk Adjustment Model Version 24 - CMS Hierarchical Category Condition (CMS-HCC)](Measure-RAModelExample01.md)**subject**:[Eve Everywoman (official) Female, DoB: 1975-01-16 ( Medical record number: 12345 (use: usual, ))](Patient-ra-patient01.md)**date**: 2021-10-18**reporter**:[Organization ABC Payer](Organization-ra-payer01.md)**period**: 2021-01-01 --> 2021-09-30
> **group**
> **id**group-001
**Condition Category Type Extension**:Historic Condition Category Gap**Evidence Status Extension**:Closed Condition Category Gap**Evidence Status Date Extension**: 2021-04-01**Hierarchical Status Extension**:Hierarchies applied and Condition Category is not superseded**code**:HCC 18: Diabetes with Chronic Complications

> **group**
> **id**group-002
**Condition Category Type Extension**:Historic Condition Category Gap**Evidence Status Extension**:Pending Condition Category Gap**Evidence Status Date Extension**: 2021-09-29**Hierarchical Status Extension**:Hierarchies applied and Condition Category is not superseded**code**:HCC 111: Chronic Obstructive Pulmonary Disease

> **group**
> **id**group-003
**Condition Category Type Extension**:Historic Condition Category Gap**Evidence Status Extension**:Open Condition Category Gap**Evidence Status Date Extension**: 2020-07-15**Hierarchical Status Extension**:Hierarchies applied and Condition Category is not superseded**code**:HCC 59: Major Depressive, Bipolar, and Paranoid Disorders

> **group**
> **id**group-004
**Condition Category Type Extension**:Historic Condition Category Gap**Evidence Status Extension**:Closed Condition Category Gap**Evidence Status Date Extension**: 2021-04-27**Hierarchical Status Extension**:Hierarchies applied and Condition Category is superseded**code**:HCC 112: Fibrosis of lung and other chronic lung disorders

> **group**
> **id**group-005
**Condition Category Type Extension**:Historic Condition Category Gap**Evidence Status Extension**:Pending Condition Category Gap**Evidence Status Date Extension**: 2021-09-27**Hierarchical Status Extension**:Hierarchies applied and Condition Category is superseded**code**:HCC 19: Diabetes without Complications

> **group**
> **id**group-006
**Condition Category Type Extension**:Historic Condition Category Gap**Evidence Status Extension**:Open Condition Category Gap**Evidence Status Date Extension**: 2020-12-15**Hierarchical Status Extension**:Hierarchies applied and Condition Category is superseded**code**:HCC 84: Cardio-Respiratory Failure and Shock

> **group**
> **id**group-007
**Condition Category Type Extension**:Suspected Condition Category Gap**Evidence Status Extension**:Closed Condition Category Gap**Evidence Status Date Extension**: 2021-03-15**Hierarchical Status Extension**:Hierarchies applied and Condition Category is not superseded**code**:HCC 22: Morbid Obesity

> **group**
> **id**group-008
**Condition Category Type Extension**:Suspected Condition Category Gap**Evidence Status Extension**:Pending Condition Category Gap**Evidence Status Date Extension**: 2021-09-27**Hierarchical Status Extension**:Hierarchies applied and Condition Category is not superseded**code**:HCC 96: Specified Heart Arrhythmias

> **group**
> **id**group-009
**Condition Category Type Extension**:Suspected Condition Category Gap**Evidence Status Extension**:Open Condition Category Gap**Evidence Status Date Extension**: 2020-07-15**Hierarchical Status Extension**:Hierarchies applied and Condition Category is not superseded**code**:HCC 110: Cystic Fibrosis

> **group**
> **id**group-010
**Condition Category Type Extension**:Net-New Condition Category**Evidence Status Extension**:Pending Condition Category Gap**Evidence Status Date Extension**: 2021-09-28**Hierarchical Status Extension**:Hierarchies applied and Condition Category is not superseded**code**:HCC 110: Cystic Fibrosis
**evaluatedResource**:
* [Condition Diabetes mellitus due to underlying condition with other diabetic kidney complication](Condition-ra-condition02pat01.md)
* [Condition Chronic obstructive pulmonary disease with (acute) exacerbation](Condition-ra-condition03pat01.md)
* [Condition Bipolar disorder, current episode mixed, mild](Condition-ra-condition08pat01.md)
* [Condition Allergic bronchopulmonary aspergillosis](Condition-ra-condition09pat01.md)
* [Condition Long term (current) use of insulin](Condition-ra-condition10pat01.md)
* [Condition Acute pulmonary edema](Condition-ra-condition11pat01.md)
* [Condition Body mass index [BMI] 45.0-49.9, adult](Condition-ra-condition17pat01.md)
* [Condition Longstanding persistent atrial fibrillation](Condition-ra-condition18pat01.md)
* [Condition Respiratory arrest](Condition-ra-condition33pat01.md)
* [Condition Diabetes mellitus due to underlying condition with other diabetic kidney complication](Condition-ra-condition43pat01.md)
* [Condition Allergic bronchopulmonary aspergillosis](Condition-ra-condition44pat01.md)
* [Encounter: status = finished; class = ambulatory (ActCode#AMB); type = Office or other outpatient visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using time for code selection, 40-54 minutes of total time is spent on the date of the encounter.; period = 2021-01-31 --> 2021-01-31](Encounter-ra-encounter02pat01.md)
* [Encounter: status = finished; class = ambulatory (ActCode#AMB); type = Office or other outpatient visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using time for code selection, 40-54 minutes of total time is spent on the date of the encounter.; period = 2021-09-26 --> 2021-09-26](Encounter-ra-encounter03pat01.md)
* [Encounter: status = finished; class = ambulatory (ActCode#AMB); type = Office or other outpatient visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using time for code selection, 40-54 minutes of total time is spent on the date of the encounter.; period = 2017-02-03 --> 2017-02-03](Encounter-ra-encounter08pat01.md)
* [Encounter: status = finished; class = ambulatory (ActCode#AMB); type = Office or other outpatient visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using time for code selection, 40-54 minutes of total time is spent on the date of the encounter.; period = 2021-03-27 --> 2021-03-27](Encounter-ra-encounter09pat01.md)
* [Encounter: status = finished; class = ambulatory (ActCode#AMB); type = Office or other outpatient visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using time for code selection, 40-54 minutes of total time is spent on the date of the encounter.; period = 2020-11-02 --> 2020-11-02](Encounter-ra-encounter11pat01.md)
* [Encounter: status = finished; class = ambulatory (ActCode#AMB); type = Office or other outpatient visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using time for code selection, 40-54 minutes of total time is spent on the date of the encounter.; period = 2019-02-10 --> 2019-02-10](Encounter-ra-encounter43pat01.md)
* [Encounter: status = finished; class = ambulatory (ActCode#AMB); type = Office or other outpatient visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using time for code selection, 40-54 minutes of total time is spent on the date of the encounter.; period = 2017-01-18 --> 2017-01-18](Encounter-ra-encounter44pat01.md)
* [Observation Trypsin [Mass/volume] in Serum or Plasma](Observation-ra-obs21pat01.md)

-------

Entry 2 - fullUrl = http://example.org/fhir/Condition/ra-condition33pat01

Resource Condition:

> 

Profile: [US Core Condition Encounter Diagnosis Profileversion: null7.0.0)](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-condition-encounter-diagnosis.html)

**clinicalStatus**:Active**verificationStatus**:Confirmed**category**:Problem**code**:R09.2: Respiratory arrest**subject**:[Eve Everywoman (official) Female, DoB: 1975-01-16 ( Medical record number: 12345 (use: usual, ))](Patient-ra-patient01.md)**onset**: 2021-09-26

-------

Entry 3 - fullUrl = http://example.org/fhir/Patient/ra-patient01

Resource Patient:

> 

Eve
**EVERYWOMAN**

| | |
| :--- | :--- |
| Identifier | 12345 |
| Address | 2222 Home StreetAnn ArborMIUSA |
| Date of birth | 16 January 1975 |


-------

Entry 4 - fullUrl = http://example.org/fhir/Condition/ra-condition10pat01

Resource Condition:

> 

Profile: [US Core Condition Encounter Diagnosis Profileversion: null7.0.0)](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-condition-encounter-diagnosis.html)

**clinicalStatus**:Active**verificationStatus**:Confirmed**category**:Problem**code**:J44.1: Chronic obstructive pulmonary disease with (acute) exacerbation**subject**:[Eve Everywoman (official) Female, DoB: 1975-01-16 ( Medical record number: 12345 (use: usual, ))](Patient-ra-patient01.md)**onset**: 2021-09-26

-------

Entry 5 - fullUrl = http://example.org/fhir/Encounter/ra-encounter03pat01

Resource Encounter:

> 

Profile: [US Core Encounter Profileversion: null7.0.0)](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-encounter.html)

**status**: completed**class**:ambulatory**type**:Office Visit, High Complexity**subject**:[Eve Everywoman (official) Female, DoB: 1975-01-16 ( Medical record number: 12345 (use: usual, ))](Patient-ra-patient01.md)**serviceProvider**:[Organization Community Urgent Care](Organization-ra-org01pat01.md)
> **participant**

> **diagnosis****condition**: No display for Encounter.diagnosis.condition (reference: ->Condition Chronic obstructive pulmonary disease with (acute) exacerbation)

> **diagnosis****condition**: No display for Encounter.diagnosis.condition (reference: ->Condition Long term (current) use of insulin)

> **diagnosis****condition**: No display for Encounter.diagnosis.condition (reference: ->Condition Longstanding persistent atrial fibrillation)

> **diagnosis****condition**: No display for Encounter.diagnosis.condition (reference: ->Condition Respiratory arrest)

-------

Entry 6 - fullUrl = http://example.org/fhir/Condition/ra-condition09pat01

Resource Condition:

> 

Profile: [US Core Condition Encounter Diagnosis Profileversion: null7.0.0)](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-condition-encounter-diagnosis.html)

**clinicalStatus**:Active**verificationStatus**:Confirmed**category**:Problem**code**:B44.81: Allergic bronchopulmonary aspergillosis**subject**:[Eve Everywoman (official) Female, DoB: 1975-01-16 ( Medical record number: 12345 (use: usual, ))](Patient-ra-patient01.md)**onset**: 2021-03-27

-------

Entry 7 - fullUrl = http://example.org/fhir/Condition/ra-condition02pat01

Resource Condition:

> 

Profile: [US Core Condition Encounter Diagnosis Profileversion: null7.0.0)](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-condition-encounter-diagnosis.html)

**clinicalStatus**:Active**verificationStatus**:Confirmed**category**:Problem**code**:E08.29: Diabetes mellitus due to underlying condition with other diabetic kidney complication**subject**:[Eve Everywoman (official) Female, DoB: 1975-01-16 ( Medical record number: 12345 (use: usual, ))](Patient-ra-patient01.md)**onset**: 2021-01-31

-------

Entry 8 - fullUrl = http://example.org/fhir/Encounter/ra-encounter11pat01

Resource Encounter:

> 

Profile: [US Core Encounter Profileversion: null7.0.0)](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-encounter.html)

**status**: completed**class**:ambulatory**type**:Office Visit, High Complexity**subject**:[Eve Everywoman (official) Female, DoB: 1975-01-16 ( Medical record number: 12345 (use: usual, ))](Patient-ra-patient01.md)**serviceProvider**:[Organization Community Urgent Care](Organization-ra-org01pat01.md)
> **participant**

### Diagnoses

| | |
| :--- | :--- |
| - | **Condition** |
| * | No display for Encounter.diagnosis.condition (reference: ->Condition Acute pulmonary edema) |


-------

Entry 9 - fullUrl = http://example.org/fhir/Observation/ra-obs21pat01

Resource Observation:

> 

Profile: [US Core Laboratory Result Observation Profileversion: null7.0.0)](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-observation-lab.html)

**status**: Final**category**:Laboratory**code**:Trypsin [Mass/volume] in Serum or Plasma**subject**:[Eve Everywoman](Patient-ra-patient01.md)**effective**: 2019-06-17**performer**:[XYZ Laboratory](Organization-ra-laboratory01.md)**value**: 770 ng/mL

### ReferenceRanges

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Low** | **High** | **Type** |
| * | 169 ng/mL(Details: UCUM codeng/mL = 'ng/mL') | 773 ng/mL(Details: UCUM codemg/dL = 'mg/dL') | Normal Range |


-------

Entry 10 - fullUrl = http://example.org/fhir/Condition/ra-condition18pat01

Resource Condition:

> 

Profile: [US Core Condition Encounter Diagnosis Profileversion: null7.0.0)](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-condition-encounter-diagnosis.html)

**clinicalStatus**:Active**verificationStatus**:Confirmed**category**:Problem**code**:I48.11: Longstanding persistent atrial fibrillation**subject**:[Eve Everywoman (official) Female, DoB: 1975-01-16 ( Medical record number: 12345 (use: usual, ))](Patient-ra-patient01.md)**onset**: 2021-09-26

-------

Entry 11 - fullUrl = http://example.org/fhir/Encounter/ra-encounter08pat01

Resource Encounter:

> 

Profile: [US Core Encounter Profileversion: null7.0.0)](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-encounter.html)

**status**: completed**class**:ambulatory**type**:Office Visit, High Complexity**subject**:[Eve Everywoman (official) Female, DoB: 1975-01-16 ( Medical record number: 12345 (use: usual, ))](Patient-ra-patient01.md)**serviceProvider**:[Organization Community Urgent Care](Organization-ra-org01pat01.md)
> **participant**

### Diagnoses

| | |
| :--- | :--- |
| - | **Condition** |
| * | No display for Encounter.diagnosis.condition (reference: ->Condition Bipolar disorder, current episode mixed, mild) |


-------

Entry 12 - fullUrl = http://example.org/fhir/Condition/ra-condition44pat01

Resource Condition:

> 

Profile: [US Core Condition Encounter Diagnosis Profileversion: null7.0.0)](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-condition-encounter-diagnosis.html)

**clinicalStatus**:Active**verificationStatus**:Confirmed**category**:Problem**code**:B44.81: Allergic bronchopulmonary aspergillosis**subject**:[Eve Everywoman (official) Female, DoB: 1975-01-16 ( Medical record number: 12345 (use: usual, ))](Patient-ra-patient01.md)**onset**: 2017-01-18

-------

Entry 13 - fullUrl = http://example.org/fhir/Encounter/ra-encounter02pat01

Resource Encounter:

> 

Profile: [US Core Encounter Profileversion: null7.0.0)](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-encounter.html)

**status**: completed**class**:ambulatory**type**:Office Visit, High Complexity**subject**:[Eve Everywoman (official) Female, DoB: 1975-01-16 ( Medical record number: 12345 (use: usual, ))](Patient-ra-patient01.md)**serviceProvider**:[Organization Community Urgent Care](Organization-ra-org01pat01.md)
> **participant**

> **diagnosis****condition**: No display for Encounter.diagnosis.condition (reference: ->Condition Diabetes mellitus due to underlying condition with other diabetic kidney complication)

> **diagnosis****condition**: No display for Encounter.diagnosis.condition (reference: ->Condition Body mass index [BMI] 45.0-49.9, adult)

-------

Entry 14 - fullUrl = http://example.org/fhir/Encounter/ra-encounter44pat01

Resource Encounter:

> 

Profile: [US Core Encounter Profileversion: null7.0.0)](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-encounter.html)

**status**: completed**class**:ambulatory**type**:Office Visit, High Complexity**subject**:[Eve Everywoman (official) Female, DoB: 1975-01-16 ( Medical record number: 12345 (use: usual, ))](Patient-ra-patient01.md)**serviceProvider**:[Organization Community Urgent Care](Organization-ra-org01pat01.md)
> **participant**

### Diagnoses

| | |
| :--- | :--- |
| - | **Condition** |
| * | No display for Encounter.diagnosis.condition (reference: ->Condition Allergic bronchopulmonary aspergillosis) |


-------

Entry 15 - fullUrl = http://example.org/fhir/Condition/ra-condition08pat01

Resource Condition:

> 

Profile: [US Core Condition Encounter Diagnosis Profileversion: null7.0.0)](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-condition-encounter-diagnosis.html)

**clinicalStatus**:Active**verificationStatus**:Confirmed**category**:Problem**code**:Bipolar disorder, current episode mixed, mild**subject**:[Eve Everywoman (official) Female, DoB: 1975-01-16 ( Medical record number: 12345 (use: usual, ))](Patient-ra-patient01.md)**onset**: 2017-02-03

-------

Entry 16 - fullUrl = http://example.org/fhir/Condition/ra-condition43pat01

Resource Condition:

> 

Profile: [US Core Condition Encounter Diagnosis Profileversion: null7.0.0)](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-condition-encounter-diagnosis.html)

**clinicalStatus**:Active**verificationStatus**:Confirmed**category**:Problem**code**:E08.29: Diabetes mellitus due to underlying condition with other diabetic kidney complication**subject**:[Eve Everywoman (official) Female, DoB: 1975-01-16 ( Medical record number: 12345 (use: usual, ))](Patient-ra-patient01.md)**onset**: 2019-02-10

-------

Entry 17 - fullUrl = http://example.org/fhir/Condition/ra-condition03pat01

Resource Condition:

> 

Profile: [US Core Condition Encounter Diagnosis Profileversion: null7.0.0)](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-condition-encounter-diagnosis.html)

**clinicalStatus**:Active**verificationStatus**:Confirmed**category**:Problem**code**:J44.1: Chronic obstructive pulmonary disease with (acute) exacerbation**subject**:[Eve Everywoman (official) Female, DoB: 1975-01-16 ( Medical record number: 12345 (use: usual, ))](Patient-ra-patient01.md)**onset**: 2021-09-26

-------

Entry 18 - fullUrl = http://example.org/fhir/Condition/ra-condition11pat01

Resource Condition:

> 

Profile: [US Core Condition Encounter Diagnosis Profileversion: null7.0.0)](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-condition-encounter-diagnosis.html)

**clinicalStatus**:Active**verificationStatus**:Confirmed**category**:Problem**code**:J81.0: Acute pulmonary edema**subject**:[Eve Everywoman (official) Female, DoB: 1975-01-16 ( Medical record number: 12345 (use: usual, ))](Patient-ra-patient01.md)**onset**: 2020-11-02

-------

Entry 19 - fullUrl = http://example.org/fhir/Encounter/ra-encounter43pat01

Resource Encounter:

> 

Profile: [US Core Encounter Profileversion: null7.0.0)](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-encounter.html)

**status**: completed**class**:ambulatory**type**:Office Visit, High Complexity**subject**:[Eve Everywoman (official) Female, DoB: 1975-01-16 ( Medical record number: 12345 (use: usual, ))](Patient-ra-patient01.md)**serviceProvider**:[Organization Community Urgent Care](Organization-ra-org01pat01.md)
> **participant**

### Diagnoses

| | |
| :--- | :--- |
| - | **Condition** |
| * | No display for Encounter.diagnosis.condition (reference: ->Condition Diabetes mellitus due to underlying condition with other diabetic kidney complication) |


-------

Entry 20 - fullUrl = http://example.org/fhir/Encounter/ra-encounter09pat01

Resource Encounter:

> 

Profile: [US Core Encounter Profileversion: null7.0.0)](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-encounter.html)

**status**: completed**class**:ambulatory**type**:Office Visit, High Complexity**subject**:[Eve Everywoman (official) Female, DoB: 1975-01-16 ( Medical record number: 12345 (use: usual, ))](Patient-ra-patient01.md)**serviceProvider**:[Organization Community Urgent Care](Organization-ra-org01pat01.md)
> **participant**

### Diagnoses

| | |
| :--- | :--- |
| - | **Condition** |
| * | No display for Encounter.diagnosis.condition (reference: ->Condition Allergic bronchopulmonary aspergillosis) |


-------

Entry 21 - fullUrl = http://example.org/fhir/Condition/ra-condition17pat01

Resource Condition:

> 

Profile: [US Core Condition Encounter Diagnosis Profileversion: null7.0.0)](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-condition-encounter-diagnosis.html)

**clinicalStatus**:Active**verificationStatus**:Confirmed**category**:Problem**code**:Z68.42: Body mass index [BMI] 45.0-49.9, adult**subject**:[Eve Everywoman (official) Female, DoB: 1975-01-16 ( Medical record number: 12345 (use: usual, ))](Patient-ra-patient01.md)**onset**: 2021-01-31



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "ra-bundle01",
  "meta" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/instance-name",
        "valueString" : "Risk Adjustment MeasureReport Bundle example, MeasureReport01: Patient01"
      },
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/instance-description",
        "valueMarkdown" : "This is an Risk Adjustment MeasureReport Bundle example includes MeasureReport01 for Patient01."
      }
    ],
    "profile" : [
      "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-measurereport-bundle"
    ]
  },
  "identifier" : {
    "system" : "urn:ietf:rfc:3986",
    "value" : "urn:uuid:8d3e72d9-9d74-4cbb-b797-a1cab0d13492"
  },
  "type" : "collection",
  "timestamp" : "2021-11-16T06:17:58.172+00:00",
  "entry" : [
    {
      "fullUrl" : "http://example.org/fhir/MeasureReport/ra-measurereport01",
      "resource" : {
        "resourceType" : "MeasureReport",
        "id" : "ra-measurereport01",
        "meta" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/instance-name",
              "valueString" : "RA MeasureReport Example01"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/instance-description",
              "valueMarkdown" : "This is an example for the Risk Adjustment MeasureReport profile. This example report uses the CMS-HCC version 24 as the Risk Adjustment Model and the example patient used is Eve Everywoman."
            }
          ],
          "profile" : [
            "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-measurereport"
          ]
        },
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MeasureReport_ra-measurereport01\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MeasureReport ra-measurereport01</b></p><a name=\"ra-measurereport01\"> </a><a name=\"hcra-measurereport01\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-ra-measurereport.html\">Risk Adjustment Coding Gap MeasureReport</a></p></div><p><b>Measure Report Category</b>: <span title=\"Codes:{http://hl7.org/fhir/CodeSystem/measurereport-category ra}\">Risk Adjustment</span></p><p><b>Clinical Data Collection Deadline Extension</b>: 2022-03-31</p><p><b>status</b>: Complete</p><p><b>type</b>: Individual</p><p><b>measure</b>: <a href=\"Measure-RAModelExample01.html\">Risk Adjustment Model Version 24 - CMS Hierarchical Category Condition (CMS-HCC)</a></p><p><b>subject</b>: <a href=\"Patient-ra-patient01.html\">Eve Everywoman (official) Female, DoB: 1975-01-16 ( Medical record number: 12345 (use: usual, ))</a></p><p><b>date</b>: 2021-10-18</p><p><b>reporter</b>: <a href=\"Organization-ra-payer01.html\">Organization ABC Payer</a></p><p><b>period</b>: 2021-01-01 --&gt; 2021-09-30</p><blockquote><p><b>group</b></p><blockquote><p><b>id</b></p>group-001</blockquote><p><b>Condition Category Type Extension</b>: <span title=\"Codes:{http://hl7.org/fhir/us/davinci-ra/CodeSystem/cc-type historic}\">Historic Condition Category Gap</span></p><p><b>Evidence Status Extension</b>: <span title=\"Codes:{http://hl7.org/fhir/us/davinci-ra/CodeSystem/evidence-status closed-gap}\">Closed Condition Category Gap</span></p><p><b>Evidence Status Date Extension</b>: 2021-04-01</p><p><b>Hierarchical Status Extension</b>: <span title=\"Codes:{http://hl7.org/fhir/us/davinci-ra/CodeSystem/hierarchical-status applied-not-superseded}\">Hierarchies applied and Condition Category is not superseded</span></p><p><b>code</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/cmshcc 18}\">HCC 18: Diabetes with Chronic Complications</span></p></blockquote><blockquote><p><b>group</b></p><blockquote><p><b>id</b></p>group-002</blockquote><p><b>Condition Category Type Extension</b>: <span title=\"Codes:{http://hl7.org/fhir/us/davinci-ra/CodeSystem/cc-type historic}\">Historic Condition Category Gap</span></p><p><b>Evidence Status Extension</b>: <span title=\"Codes:{http://hl7.org/fhir/us/davinci-ra/CodeSystem/evidence-status pending}\">Pending Condition Category Gap</span></p><p><b>Evidence Status Date Extension</b>: 2021-09-29</p><p><b>Hierarchical Status Extension</b>: <span title=\"Codes:{http://hl7.org/fhir/us/davinci-ra/CodeSystem/hierarchical-status applied-not-superseded}\">Hierarchies applied and Condition Category is not superseded</span></p><p><b>code</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/cmshcc 111}\">HCC 111: Chronic Obstructive Pulmonary Disease</span></p></blockquote><blockquote><p><b>group</b></p><blockquote><p><b>id</b></p>group-003</blockquote><p><b>Condition Category Type Extension</b>: <span title=\"Codes:{http://hl7.org/fhir/us/davinci-ra/CodeSystem/cc-type historic}\">Historic Condition Category Gap</span></p><p><b>Evidence Status Extension</b>: <span title=\"Codes:{http://hl7.org/fhir/us/davinci-ra/CodeSystem/evidence-status open-gap}\">Open Condition Category Gap</span></p><p><b>Evidence Status Date Extension</b>: 2020-07-15</p><p><b>Hierarchical Status Extension</b>: <span title=\"Codes:{http://hl7.org/fhir/us/davinci-ra/CodeSystem/hierarchical-status applied-not-superseded}\">Hierarchies applied and Condition Category is not superseded</span></p><p><b>code</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/cmshcc 59}\">HCC 59: Major Depressive, Bipolar, and Paranoid Disorders</span></p></blockquote><blockquote><p><b>group</b></p><blockquote><p><b>id</b></p>group-004</blockquote><p><b>Condition Category Type Extension</b>: <span title=\"Codes:{http://hl7.org/fhir/us/davinci-ra/CodeSystem/cc-type historic}\">Historic Condition Category Gap</span></p><p><b>Evidence Status Extension</b>: <span title=\"Codes:{http://hl7.org/fhir/us/davinci-ra/CodeSystem/evidence-status closed-gap}\">Closed Condition Category Gap</span></p><p><b>Evidence Status Date Extension</b>: 2021-04-27</p><p><b>Hierarchical Status Extension</b>: <span title=\"Codes:{http://hl7.org/fhir/us/davinci-ra/CodeSystem/hierarchical-status applied-superseded}\">Hierarchies applied and Condition Category is superseded</span></p><p><b>code</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/cmshcc 112}\">HCC 112: Fibrosis of lung and other chronic lung disorders</span></p></blockquote><blockquote><p><b>group</b></p><blockquote><p><b>id</b></p>group-005</blockquote><p><b>Condition Category Type Extension</b>: <span title=\"Codes:{http://hl7.org/fhir/us/davinci-ra/CodeSystem/cc-type historic}\">Historic Condition Category Gap</span></p><p><b>Evidence Status Extension</b>: <span title=\"Codes:{http://hl7.org/fhir/us/davinci-ra/CodeSystem/evidence-status pending}\">Pending Condition Category Gap</span></p><p><b>Evidence Status Date Extension</b>: 2021-09-27</p><p><b>Hierarchical Status Extension</b>: <span title=\"Codes:{http://hl7.org/fhir/us/davinci-ra/CodeSystem/hierarchical-status applied-superseded}\">Hierarchies applied and Condition Category is superseded</span></p><p><b>code</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/cmshcc 19}\">HCC 19: Diabetes without Complications</span></p></blockquote><blockquote><p><b>group</b></p><blockquote><p><b>id</b></p>group-006</blockquote><p><b>Condition Category Type Extension</b>: <span title=\"Codes:{http://hl7.org/fhir/us/davinci-ra/CodeSystem/cc-type historic}\">Historic Condition Category Gap</span></p><p><b>Evidence Status Extension</b>: <span title=\"Codes:{http://hl7.org/fhir/us/davinci-ra/CodeSystem/evidence-status open-gap}\">Open Condition Category Gap</span></p><p><b>Evidence Status Date Extension</b>: 2020-12-15</p><p><b>Hierarchical Status Extension</b>: <span title=\"Codes:{http://hl7.org/fhir/us/davinci-ra/CodeSystem/hierarchical-status applied-superseded}\">Hierarchies applied and Condition Category is superseded</span></p><p><b>code</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/cmshcc 84}\">HCC 84: Cardio-Respiratory Failure and Shock</span></p></blockquote><blockquote><p><b>group</b></p><blockquote><p><b>id</b></p>group-007</blockquote><p><b>Condition Category Type Extension</b>: <span title=\"Codes:{http://hl7.org/fhir/us/davinci-ra/CodeSystem/cc-type suspected}\">Suspected Condition Category Gap</span></p><p><b>Evidence Status Extension</b>: <span title=\"Codes:{http://hl7.org/fhir/us/davinci-ra/CodeSystem/evidence-status closed-gap}\">Closed Condition Category Gap</span></p><p><b>Evidence Status Date Extension</b>: 2021-03-15</p><p><b>Hierarchical Status Extension</b>: <span title=\"Codes:{http://hl7.org/fhir/us/davinci-ra/CodeSystem/hierarchical-status applied-not-superseded}\">Hierarchies applied and Condition Category is not superseded</span></p><p><b>code</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/cmshcc 22}\">HCC 22: Morbid Obesity</span></p></blockquote><blockquote><p><b>group</b></p><blockquote><p><b>id</b></p>group-008</blockquote><p><b>Condition Category Type Extension</b>: <span title=\"Codes:{http://hl7.org/fhir/us/davinci-ra/CodeSystem/cc-type suspected}\">Suspected Condition Category Gap</span></p><p><b>Evidence Status Extension</b>: <span title=\"Codes:{http://hl7.org/fhir/us/davinci-ra/CodeSystem/evidence-status pending}\">Pending Condition Category Gap</span></p><p><b>Evidence Status Date Extension</b>: 2021-09-27</p><p><b>Hierarchical Status Extension</b>: <span title=\"Codes:{http://hl7.org/fhir/us/davinci-ra/CodeSystem/hierarchical-status applied-not-superseded}\">Hierarchies applied and Condition Category is not superseded</span></p><p><b>code</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/cmshcc 96}\">HCC 96: Specified Heart Arrhythmias</span></p></blockquote><blockquote><p><b>group</b></p><blockquote><p><b>id</b></p>group-009</blockquote><p><b>Condition Category Type Extension</b>: <span title=\"Codes:{http://hl7.org/fhir/us/davinci-ra/CodeSystem/cc-type suspected}\">Suspected Condition Category Gap</span></p><p><b>Evidence Status Extension</b>: <span title=\"Codes:{http://hl7.org/fhir/us/davinci-ra/CodeSystem/evidence-status open-gap}\">Open Condition Category Gap</span></p><p><b>Evidence Status Date Extension</b>: 2020-07-15</p><p><b>Hierarchical Status Extension</b>: <span title=\"Codes:{http://hl7.org/fhir/us/davinci-ra/CodeSystem/hierarchical-status applied-not-superseded}\">Hierarchies applied and Condition Category is not superseded</span></p><p><b>code</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/cmshcc 110}\">HCC 110: Cystic Fibrosis</span></p></blockquote><blockquote><p><b>group</b></p><blockquote><p><b>id</b></p>group-010</blockquote><p><b>Condition Category Type Extension</b>: <span title=\"Codes:{http://hl7.org/fhir/us/davinci-ra/CodeSystem/cc-type net-new}\">Net-New Condition Category</span></p><p><b>Evidence Status Extension</b>: <span title=\"Codes:{http://hl7.org/fhir/us/davinci-ra/CodeSystem/evidence-status pending}\">Pending Condition Category Gap</span></p><p><b>Evidence Status Date Extension</b>: 2021-09-28</p><p><b>Hierarchical Status Extension</b>: <span title=\"Codes:{http://hl7.org/fhir/us/davinci-ra/CodeSystem/hierarchical-status applied-not-superseded}\">Hierarchies applied and Condition Category is not superseded</span></p><p><b>code</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/cmshcc 83}\">HCC 110: Cystic Fibrosis</span></p></blockquote><p><b>evaluatedResource</b>: </p><ul><li><a href=\"Condition-ra-condition02pat01.html\">Condition Diabetes mellitus due to underlying condition with other diabetic kidney complication</a></li><li><a href=\"Condition-ra-condition03pat01.html\">Condition Chronic obstructive pulmonary disease with (acute) exacerbation</a></li><li><a href=\"Condition-ra-condition08pat01.html\">Condition Bipolar disorder, current episode mixed, mild</a></li><li><a href=\"Condition-ra-condition09pat01.html\">Condition Allergic bronchopulmonary aspergillosis</a></li><li><a href=\"Condition-ra-condition10pat01.html\">Condition Long term (current) use of insulin</a></li><li><a href=\"Condition-ra-condition11pat01.html\">Condition Acute pulmonary edema</a></li><li><a href=\"Condition-ra-condition17pat01.html\">Condition Body mass index [BMI] 45.0-49.9, adult</a></li><li><a href=\"Condition-ra-condition18pat01.html\">Condition Longstanding persistent atrial fibrillation</a></li><li><a href=\"Condition-ra-condition33pat01.html\">Condition Respiratory arrest</a></li><li><a href=\"Condition-ra-condition43pat01.html\">Condition Diabetes mellitus due to underlying condition with other diabetic kidney complication</a></li><li><a href=\"Condition-ra-condition44pat01.html\">Condition Allergic bronchopulmonary aspergillosis</a></li><li><a href=\"Encounter-ra-encounter02pat01.html\">Encounter: status = finished; class = ambulatory (ActCode#AMB); type = Office or other outpatient visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using time for code selection, 40-54 minutes of total time is spent on the date of the encounter.; period = 2021-01-31 --&gt; 2021-01-31</a></li><li><a href=\"Encounter-ra-encounter03pat01.html\">Encounter: status = finished; class = ambulatory (ActCode#AMB); type = Office or other outpatient visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using time for code selection, 40-54 minutes of total time is spent on the date of the encounter.; period = 2021-09-26 --&gt; 2021-09-26</a></li><li><a href=\"Encounter-ra-encounter08pat01.html\">Encounter: status = finished; class = ambulatory (ActCode#AMB); type = Office or other outpatient visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using time for code selection, 40-54 minutes of total time is spent on the date of the encounter.; period = 2017-02-03 --&gt; 2017-02-03</a></li><li><a href=\"Encounter-ra-encounter09pat01.html\">Encounter: status = finished; class = ambulatory (ActCode#AMB); type = Office or other outpatient visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using time for code selection, 40-54 minutes of total time is spent on the date of the encounter.; period = 2021-03-27 --&gt; 2021-03-27</a></li><li><a href=\"Encounter-ra-encounter11pat01.html\">Encounter: status = finished; class = ambulatory (ActCode#AMB); type = Office or other outpatient visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using time for code selection, 40-54 minutes of total time is spent on the date of the encounter.; period = 2020-11-02 --&gt; 2020-11-02</a></li><li><a href=\"Encounter-ra-encounter43pat01.html\">Encounter: status = finished; class = ambulatory (ActCode#AMB); type = Office or other outpatient visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using time for code selection, 40-54 minutes of total time is spent on the date of the encounter.; period = 2019-02-10 --&gt; 2019-02-10</a></li><li><a href=\"Encounter-ra-encounter44pat01.html\">Encounter: status = finished; class = ambulatory (ActCode#AMB); type = Office or other outpatient visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using time for code selection, 40-54 minutes of total time is spent on the date of the encounter.; period = 2017-01-18 --&gt; 2017-01-18</a></li><li><a href=\"Observation-ra-obs21pat01.html\">Observation Trypsin [Mass/volume] in Serum or Plasma</a></li></ul></div>"
        },
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/measurereport-category",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/CodeSystem/measurereport-category",
                  "code" : "ra"
                }
              ]
            }
          },
          {
            "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-clinicalDataCollectionDeadline",
            "valueDate" : "2022-03-31"
          }
        ],
        "status" : "complete",
        "type" : "individual",
        "measure" : "http://hl7.org/fhir/us/davinci-ra/Measure/RAModelExample01",
        "subject" : {
          "reference" : "Patient/ra-patient01"
        },
        "date" : "2021-10-18",
        "reporter" : {
          "reference" : "Organization/ra-payer01"
        },
        "period" : {
          "start" : "2021-01-01",
          "end" : "2021-09-30"
        },
        "group" : [
          {
            "id" : "group-001",
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-ccType",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "http://hl7.org/fhir/us/davinci-ra/CodeSystem/cc-type",
                      "code" : "historic"
                    }
                  ]
                }
              },
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-evidenceStatus",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "http://hl7.org/fhir/us/davinci-ra/CodeSystem/evidence-status",
                      "code" : "closed-gap"
                    }
                  ]
                }
              },
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-evidenceStatusDate",
                "valueDate" : "2021-04-01"
              },
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-hierarchicalStatus",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "http://hl7.org/fhir/us/davinci-ra/CodeSystem/hierarchical-status",
                      "code" : "applied-not-superseded"
                    }
                  ]
                }
              }
            ],
            "code" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/cmshcc",
                  "version" : "24",
                  "code" : "18",
                  "display" : "Diabetes with Chronic Complications"
                }
              ],
              "text" : "HCC 18: Diabetes with Chronic Complications"
            }
          },
          {
            "id" : "group-002",
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-ccType",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "http://hl7.org/fhir/us/davinci-ra/CodeSystem/cc-type",
                      "code" : "historic"
                    }
                  ]
                }
              },
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-evidenceStatus",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "http://hl7.org/fhir/us/davinci-ra/CodeSystem/evidence-status",
                      "code" : "pending"
                    }
                  ]
                }
              },
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-evidenceStatusDate",
                "valueDate" : "2021-09-29"
              },
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-hierarchicalStatus",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "http://hl7.org/fhir/us/davinci-ra/CodeSystem/hierarchical-status",
                      "code" : "applied-not-superseded"
                    }
                  ]
                }
              }
            ],
            "code" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/cmshcc",
                  "version" : "24",
                  "code" : "111",
                  "display" : "Chronic Obstructive Pulmonary Disease"
                }
              ],
              "text" : "HCC 111: Chronic Obstructive Pulmonary Disease"
            }
          },
          {
            "id" : "group-003",
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-ccType",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "http://hl7.org/fhir/us/davinci-ra/CodeSystem/cc-type",
                      "code" : "historic"
                    }
                  ]
                }
              },
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-evidenceStatus",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "http://hl7.org/fhir/us/davinci-ra/CodeSystem/evidence-status",
                      "code" : "open-gap"
                    }
                  ]
                }
              },
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-evidenceStatusDate",
                "valueDate" : "2020-07-15"
              },
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-hierarchicalStatus",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "http://hl7.org/fhir/us/davinci-ra/CodeSystem/hierarchical-status",
                      "code" : "applied-not-superseded"
                    }
                  ]
                }
              }
            ],
            "code" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/cmshcc",
                  "version" : "24",
                  "code" : "59",
                  "display" : "Major Depressive, Bipolar, and Paranoid Disorders"
                }
              ],
              "text" : "HCC 59: Major Depressive, Bipolar, and Paranoid Disorders"
            }
          },
          {
            "id" : "group-004",
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-ccType",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "http://hl7.org/fhir/us/davinci-ra/CodeSystem/cc-type",
                      "code" : "historic"
                    }
                  ]
                }
              },
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-evidenceStatus",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "http://hl7.org/fhir/us/davinci-ra/CodeSystem/evidence-status",
                      "code" : "closed-gap"
                    }
                  ]
                }
              },
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-evidenceStatusDate",
                "valueDate" : "2021-04-27"
              },
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-hierarchicalStatus",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "http://hl7.org/fhir/us/davinci-ra/CodeSystem/hierarchical-status",
                      "code" : "applied-superseded"
                    }
                  ]
                }
              }
            ],
            "code" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/cmshcc",
                  "version" : "24",
                  "code" : "112",
                  "display" : "Fibrosis of lung and other chronic lung disorders"
                }
              ],
              "text" : "HCC 112: Fibrosis of lung and other chronic lung disorders"
            }
          },
          {
            "id" : "group-005",
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-ccType",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "http://hl7.org/fhir/us/davinci-ra/CodeSystem/cc-type",
                      "code" : "historic"
                    }
                  ]
                }
              },
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-evidenceStatus",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "http://hl7.org/fhir/us/davinci-ra/CodeSystem/evidence-status",
                      "code" : "pending"
                    }
                  ]
                }
              },
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-evidenceStatusDate",
                "valueDate" : "2021-09-27"
              },
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-hierarchicalStatus",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "http://hl7.org/fhir/us/davinci-ra/CodeSystem/hierarchical-status",
                      "code" : "applied-superseded"
                    }
                  ]
                }
              }
            ],
            "code" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/cmshcc",
                  "version" : "24",
                  "code" : "19",
                  "display" : "Diabetes without Complications"
                }
              ],
              "text" : "HCC 19: Diabetes without Complications"
            }
          },
          {
            "id" : "group-006",
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-ccType",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "http://hl7.org/fhir/us/davinci-ra/CodeSystem/cc-type",
                      "code" : "historic"
                    }
                  ]
                }
              },
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-evidenceStatus",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "http://hl7.org/fhir/us/davinci-ra/CodeSystem/evidence-status",
                      "code" : "open-gap"
                    }
                  ]
                }
              },
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-evidenceStatusDate",
                "valueDate" : "2020-12-15"
              },
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-hierarchicalStatus",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "http://hl7.org/fhir/us/davinci-ra/CodeSystem/hierarchical-status",
                      "code" : "applied-superseded"
                    }
                  ]
                }
              }
            ],
            "code" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/cmshcc",
                  "version" : "24",
                  "code" : "84",
                  "display" : "Cardio-Respiratory Failure and Shock"
                }
              ],
              "text" : "HCC 84: Cardio-Respiratory Failure and Shock"
            }
          },
          {
            "id" : "group-007",
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-ccType",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "http://hl7.org/fhir/us/davinci-ra/CodeSystem/cc-type",
                      "code" : "suspected"
                    }
                  ]
                }
              },
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-evidenceStatus",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "http://hl7.org/fhir/us/davinci-ra/CodeSystem/evidence-status",
                      "code" : "closed-gap"
                    }
                  ]
                }
              },
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-evidenceStatusDate",
                "valueDate" : "2021-03-15"
              },
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-hierarchicalStatus",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "http://hl7.org/fhir/us/davinci-ra/CodeSystem/hierarchical-status",
                      "code" : "applied-not-superseded"
                    }
                  ]
                }
              }
            ],
            "code" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/cmshcc",
                  "version" : "24",
                  "code" : "22",
                  "display" : "Morbid Obesity"
                }
              ],
              "text" : "HCC 22: Morbid Obesity"
            }
          },
          {
            "id" : "group-008",
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-ccType",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "http://hl7.org/fhir/us/davinci-ra/CodeSystem/cc-type",
                      "code" : "suspected"
                    }
                  ]
                }
              },
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-evidenceStatus",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "http://hl7.org/fhir/us/davinci-ra/CodeSystem/evidence-status",
                      "code" : "pending"
                    }
                  ]
                }
              },
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-evidenceStatusDate",
                "valueDate" : "2021-09-27"
              },
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-hierarchicalStatus",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "http://hl7.org/fhir/us/davinci-ra/CodeSystem/hierarchical-status",
                      "code" : "applied-not-superseded"
                    }
                  ]
                }
              }
            ],
            "code" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/cmshcc",
                  "version" : "24",
                  "code" : "96",
                  "display" : "Specified Heart Arrhythmias"
                }
              ],
              "text" : "HCC 96: Specified Heart Arrhythmias"
            }
          },
          {
            "id" : "group-009",
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-ccType",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "http://hl7.org/fhir/us/davinci-ra/CodeSystem/cc-type",
                      "code" : "suspected"
                    }
                  ]
                }
              },
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-evidenceStatus",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "http://hl7.org/fhir/us/davinci-ra/CodeSystem/evidence-status",
                      "code" : "open-gap"
                    }
                  ]
                }
              },
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-evidenceStatusDate",
                "valueDate" : "2020-07-15"
              },
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-hierarchicalStatus",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "http://hl7.org/fhir/us/davinci-ra/CodeSystem/hierarchical-status",
                      "code" : "applied-not-superseded"
                    }
                  ]
                }
              }
            ],
            "code" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/cmshcc",
                  "version" : "24",
                  "code" : "110",
                  "display" : "Cystic Fibrosis"
                }
              ],
              "text" : "HCC 110: Cystic Fibrosis"
            }
          },
          {
            "id" : "group-010",
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-ccType",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "http://hl7.org/fhir/us/davinci-ra/CodeSystem/cc-type",
                      "code" : "net-new"
                    }
                  ]
                }
              },
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-evidenceStatus",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "http://hl7.org/fhir/us/davinci-ra/CodeSystem/evidence-status",
                      "code" : "pending"
                    }
                  ]
                }
              },
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-evidenceStatusDate",
                "valueDate" : "2021-09-28"
              },
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-hierarchicalStatus",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "http://hl7.org/fhir/us/davinci-ra/CodeSystem/hierarchical-status",
                      "code" : "applied-not-superseded"
                    }
                  ]
                }
              }
            ],
            "code" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/cmshcc",
                  "version" : "24",
                  "code" : "83",
                  "display" : "Respiratory Arrest"
                }
              ],
              "text" : "HCC 110: Cystic Fibrosis"
            }
          }
        ],
        "evaluatedResource" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-groupReference",
                "valueString" : "group-001"
              }
            ],
            "reference" : "Condition/ra-condition02pat01"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-groupReference",
                "valueString" : "group-002"
              }
            ],
            "reference" : "Condition/ra-condition03pat01"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-groupReference",
                "valueString" : "group-003"
              }
            ],
            "reference" : "Condition/ra-condition08pat01"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-groupReference",
                "valueString" : "group-004"
              }
            ],
            "reference" : "Condition/ra-condition09pat01"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-groupReference",
                "valueString" : "group-005"
              }
            ],
            "reference" : "Condition/ra-condition10pat01"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-groupReference",
                "valueString" : "group-006"
              }
            ],
            "reference" : "Condition/ra-condition11pat01"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-groupReference",
                "valueString" : "group-007"
              }
            ],
            "reference" : "Condition/ra-condition17pat01"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-groupReference",
                "valueString" : "group-008"
              }
            ],
            "reference" : "Condition/ra-condition18pat01"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-groupReference",
                "valueString" : "group-010"
              }
            ],
            "reference" : "Condition/ra-condition33pat01"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-groupReference",
                "valueString" : "group-001"
              }
            ],
            "reference" : "Condition/ra-condition43pat01"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-groupReference",
                "valueString" : "group-004"
              }
            ],
            "reference" : "Condition/ra-condition44pat01"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-groupReference",
                "valueString" : "group-001"
              },
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-groupReference",
                "valueString" : "group-007"
              }
            ],
            "reference" : "Encounter/ra-encounter02pat01"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-groupReference",
                "valueString" : "group-002"
              },
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-groupReference",
                "valueString" : "group-005"
              },
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-groupReference",
                "valueString" : "group-008"
              },
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-groupReference",
                "valueString" : "group-010"
              }
            ],
            "reference" : "Encounter/ra-encounter03pat01"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-groupReference",
                "valueString" : "group-003"
              }
            ],
            "reference" : "Encounter/ra-encounter08pat01"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-groupReference",
                "valueString" : "group-004"
              }
            ],
            "reference" : "Encounter/ra-encounter09pat01"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-groupReference",
                "valueString" : "group-006"
              }
            ],
            "reference" : "Encounter/ra-encounter11pat01"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-groupReference",
                "valueString" : "group-001"
              }
            ],
            "reference" : "Encounter/ra-encounter43pat01"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-groupReference",
                "valueString" : "group-004"
              }
            ],
            "reference" : "Encounter/ra-encounter44pat01"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-groupReference",
                "valueString" : "group-009"
              }
            ],
            "reference" : "Observation/ra-obs21pat01"
          }
        ]
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Condition/ra-condition33pat01",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "ra-condition33pat01",
        "meta" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/instance-name",
              "valueString" : "Condition33Pat01 Example"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/instance-description",
              "valueMarkdown" : "This is a Condition example with code R09.2: Respiratory arrest."
            }
          ],
          "profile" : [
            "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-encounter-diagnosis|7.0.0"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_ra-condition33pat01\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition ra-condition33pat01</b></p><a name=\"ra-condition33pat01\"> </a><a name=\"hcra-condition33pat01\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-condition-encounter-diagnosis.html\">US Core Condition Encounter Diagnosis Profileversion: null7.0.0)</a></p></div><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>verificationStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-ver-status confirmed}\">Confirmed</span></p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-category encounter-diagnosis}\">Problem</span></p><p><b>code</b>: <span title=\"Codes:{http://hl7.org/fhir/sid/icd-10-cm R09.2}\">R09.2: Respiratory arrest</span></p><p><b>subject</b>: <a href=\"Patient-ra-patient01.html\">Eve Everywoman (official) Female, DoB: 1975-01-16 ( Medical record number: 12345 (use: usual, ))</a></p><p><b>onset</b>: 2021-09-26</p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active",
              "display" : "Active"
            }
          ],
          "text" : "Active"
        },
        "verificationStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-ver-status",
              "code" : "confirmed",
              "display" : "Confirmed"
            }
          ],
          "text" : "Confirmed"
        },
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/condition-category",
                "code" : "encounter-diagnosis",
                "display" : "Encounter Diagnosis"
              }
            ],
            "text" : "Problem"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/sid/icd-10-cm",
              "code" : "R09.2",
              "display" : "Respiratory arrest"
            }
          ],
          "text" : "R09.2: Respiratory arrest"
        },
        "subject" : {
          "reference" : "Patient/ra-patient01"
        },
        "onsetDateTime" : "2021-09-26"
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Patient/ra-patient01",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "ra-patient01",
        "meta" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/instance-name",
              "valueString" : "Patient Example01"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/instance-description",
              "valueMarkdown" : "This is an example patient that uses the US Core Patient profile. The example patient name is Eve Everywoman."
            }
          ],
          "profile" : [
            "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient|7.0.0"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><div class=\"hapiHeaderText\"><a name=\"Patient_ra-patient01\"> </a>Eve <b>EVERYWOMAN </b></div><table class=\"hapiPropertyTable\"><tbody><tr><td>Identifier</td><td>12345</td></tr><tr><td>Address</td><td><span>2222 Home Street </span><br/><span>Ann Arbor </span><span>MI </span><span>USA </span></td></tr><tr><td>Date of birth</td><td><span>16 January 1975</span></td></tr></tbody></table></div>"
        },
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-birthsex",
            "valueCode" : "F"
          },
          {
            "extension" : [
              {
                "url" : "ombCategory",
                "valueCoding" : {
                  "system" : "urn:oid:2.16.840.1.113883.6.238",
                  "code" : "2106-3",
                  "display" : "White"
                }
              },
              {
                "url" : "text",
                "valueString" : "White"
              }
            ],
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-race"
          },
          {
            "extension" : [
              {
                "url" : "ombCategory",
                "valueCoding" : {
                  "system" : "urn:oid:2.16.840.1.113883.6.238",
                  "code" : "2186-5",
                  "display" : "Not Hispanic or Latino"
                }
              },
              {
                "url" : "text",
                "valueString" : "Not Hispanic or Latino"
              }
            ],
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-ethnicity"
          }
        ],
        "identifier" : [
          {
            "use" : "usual",
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                  "code" : "MR",
                  "display" : "Medical record number"
                }
              ]
            },
            "system" : "http://example.org/hospital-davinci",
            "value" : "12345"
          }
        ],
        "active" : true,
        "name" : [
          {
            "use" : "official",
            "family" : "Everywoman",
            "given" : ["Eve"]
          }
        ],
        "gender" : "female",
        "birthDate" : "1975-01-16",
        "deceasedBoolean" : false,
        "address" : [
          {
            "use" : "home",
            "line" : ["2222 Home Street"],
            "city" : "Ann Arbor",
            "state" : "MI",
            "postalCode" : "99999",
            "country" : "USA"
          }
        ],
        "maritalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-MaritalStatus",
              "code" : "M",
              "display" : "Married"
            }
          ]
        },
        "communication" : [
          {
            "language" : {
              "coding" : [
                {
                  "system" : "urn:ietf:bcp:47",
                  "code" : "en-US",
                  "display" : "English (United States)"
                }
              ]
            },
            "preferred" : true
          }
        ]
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Condition/ra-condition10pat01",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "ra-condition10pat01",
        "meta" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/instance-name",
              "valueString" : "Condition10Pat01 Example"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/instance-description",
              "valueMarkdown" : "This is a Condition example with code Z79.4: Long term (current) use of insulin."
            }
          ],
          "profile" : [
            "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-encounter-diagnosis|7.0.0"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_ra-condition10pat01\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition ra-condition10pat01</b></p><a name=\"ra-condition10pat01\"> </a><a name=\"hcra-condition10pat01\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-condition-encounter-diagnosis.html\">US Core Condition Encounter Diagnosis Profileversion: null7.0.0)</a></p></div><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>verificationStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-ver-status confirmed}\">Confirmed</span></p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-category encounter-diagnosis}\">Problem</span></p><p><b>code</b>: <span title=\"Codes:{http://hl7.org/fhir/sid/icd-10-cm J44.1}\">J44.1: Chronic obstructive pulmonary disease with (acute) exacerbation</span></p><p><b>subject</b>: <a href=\"Patient-ra-patient01.html\">Eve Everywoman (official) Female, DoB: 1975-01-16 ( Medical record number: 12345 (use: usual, ))</a></p><p><b>onset</b>: 2021-09-26</p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active",
              "display" : "Active"
            }
          ],
          "text" : "Active"
        },
        "verificationStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-ver-status",
              "code" : "confirmed",
              "display" : "Confirmed"
            }
          ],
          "text" : "Confirmed"
        },
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/condition-category",
                "code" : "encounter-diagnosis",
                "display" : "Encounter Diagnosis"
              }
            ],
            "text" : "Problem"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/sid/icd-10-cm",
              "code" : "J44.1",
              "display" : "Chronic obstructive pulmonary disease with (acute) exacerbation"
            }
          ],
          "text" : "J44.1: Chronic obstructive pulmonary disease with (acute) exacerbation"
        },
        "subject" : {
          "reference" : "Patient/ra-patient01"
        },
        "onsetDateTime" : "2021-09-26"
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Encounter/ra-encounter03pat01",
      "resource" : {
        "resourceType" : "Encounter",
        "id" : "ra-encounter03pat01",
        "meta" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/instance-name",
              "valueString" : "Encounter with Dr Howell on 20210714 for Patient 03"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/instance-description",
              "valueMarkdown" : "This is Encounter with Dr Howell on 20210714 for Patient 03."
            }
          ],
          "profile" : [
            "http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter|7.0.0"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Encounter_ra-encounter03pat01\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Encounter ra-encounter03pat01</b></p><a name=\"ra-encounter03pat01\"> </a><a name=\"hcra-encounter03pat01\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-encounter.html\">US Core Encounter Profileversion: null7.0.0)</a></p></div><p><b>status</b>: Finished</p><p><b>class</b>: <a href=\"http://terminology.hl7.org/7.0.0/CodeSystem-v3-ActCode.html#v3-ActCode-AMB\">ActCode: AMB</a> (ambulatory)</p><p><b>type</b>: <span title=\"Codes:{http://www.ama-assn.org/go/cpt 99215}\">Office Visit, High Complexity</span></p><p><b>subject</b>: <a href=\"Patient-ra-patient01.html\">Eve Everywoman (official) Female, DoB: 1975-01-16 ( Medical record number: 12345 (use: usual, ))</a></p><h3>Participants</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Individual</b></td></tr><tr><td style=\"display: none\">*</td><td><a href=\"Practitioner-ra-prac01pat01.html\">Practitioner Harold Hippocrates </a></td></tr></table><p><b>period</b>: 2021-09-26 --&gt; 2021-09-26</p><blockquote><p><b>diagnosis</b></p><p><b>condition</b>: <a href=\"Condition-ra-condition03pat01.html\">Condition Chronic obstructive pulmonary disease with (acute) exacerbation</a></p></blockquote><blockquote><p><b>diagnosis</b></p><p><b>condition</b>: <a href=\"Condition-ra-condition10pat01.html\">Condition Long term (current) use of insulin</a></p></blockquote><blockquote><p><b>diagnosis</b></p><p><b>condition</b>: <a href=\"Condition-ra-condition18pat01.html\">Condition Longstanding persistent atrial fibrillation</a></p></blockquote><blockquote><p><b>diagnosis</b></p><p><b>condition</b>: <a href=\"Condition-ra-condition33pat01.html\">Condition Respiratory arrest</a></p></blockquote><p><b>serviceProvider</b>: <a href=\"Organization-ra-org01pat01.html\">Organization Community Urgent Care</a></p></div>"
        },
        "status" : "finished",
        "class" : {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
          "code" : "AMB",
          "display" : "ambulatory"
        },
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://www.ama-assn.org/go/cpt",
                "code" : "99215"
              }
            ],
            "text" : "Office Visit, High Complexity"
          }
        ],
        "subject" : {
          "reference" : "Patient/ra-patient01"
        },
        "participant" : [
          {
            "individual" : {
              "reference" : "Practitioner/ra-prac01pat01"
            }
          }
        ],
        "period" : {
          "start" : "2021-09-26",
          "end" : "2021-09-26"
        },
        "diagnosis" : [
          {
            "condition" : {
              "reference" : "Condition/ra-condition03pat01"
            }
          },
          {
            "condition" : {
              "reference" : "Condition/ra-condition10pat01"
            }
          },
          {
            "condition" : {
              "reference" : "Condition/ra-condition18pat01"
            }
          },
          {
            "condition" : {
              "reference" : "Condition/ra-condition33pat01"
            }
          }
        ],
        "serviceProvider" : {
          "reference" : "Organization/ra-org01pat01"
        }
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Condition/ra-condition09pat01",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "ra-condition09pat01",
        "meta" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/instance-name",
              "valueString" : "Condition09Pat01 Example"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/instance-description",
              "valueMarkdown" : "This is a Condition example with code B44.81: Allergic bronchopulmonary aspergillosis."
            }
          ],
          "profile" : [
            "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-encounter-diagnosis|7.0.0"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_ra-condition09pat01\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition ra-condition09pat01</b></p><a name=\"ra-condition09pat01\"> </a><a name=\"hcra-condition09pat01\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-condition-encounter-diagnosis.html\">US Core Condition Encounter Diagnosis Profileversion: null7.0.0)</a></p></div><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>verificationStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-ver-status confirmed}\">Confirmed</span></p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-category encounter-diagnosis}\">Problem</span></p><p><b>code</b>: <span title=\"Codes:{http://hl7.org/fhir/sid/icd-10-cm B44.81}\">B44.81: Allergic bronchopulmonary aspergillosis</span></p><p><b>subject</b>: <a href=\"Patient-ra-patient01.html\">Eve Everywoman (official) Female, DoB: 1975-01-16 ( Medical record number: 12345 (use: usual, ))</a></p><p><b>onset</b>: 2021-03-27</p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active",
              "display" : "Active"
            }
          ],
          "text" : "Active"
        },
        "verificationStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-ver-status",
              "code" : "confirmed",
              "display" : "Confirmed"
            }
          ],
          "text" : "Confirmed"
        },
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/condition-category",
                "code" : "encounter-diagnosis",
                "display" : "Encounter Diagnosis"
              }
            ],
            "text" : "Problem"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/sid/icd-10-cm",
              "code" : "B44.81",
              "display" : "Allergic bronchopulmonary aspergillosis"
            }
          ],
          "text" : "B44.81: Allergic bronchopulmonary aspergillosis"
        },
        "subject" : {
          "reference" : "Patient/ra-patient01"
        },
        "onsetDateTime" : "2021-03-27"
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Condition/ra-condition02pat01",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "ra-condition02pat01",
        "meta" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/instance-name",
              "valueString" : "Condition02Pat02 Example"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/instance-description",
              "valueMarkdown" : "This is a Condition example with code E08.29: Diabetes mellitus due to underlying condition with other diabetic kidney complication."
            }
          ],
          "profile" : [
            "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-encounter-diagnosis|7.0.0"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_ra-condition02pat01\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition ra-condition02pat01</b></p><a name=\"ra-condition02pat01\"> </a><a name=\"hcra-condition02pat01\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-condition-encounter-diagnosis.html\">US Core Condition Encounter Diagnosis Profileversion: null7.0.0)</a></p></div><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>verificationStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-ver-status confirmed}\">Confirmed</span></p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-category encounter-diagnosis}\">Problem</span></p><p><b>code</b>: <span title=\"Codes:{http://hl7.org/fhir/sid/icd-10-cm E08.29}\">E08.29: Diabetes mellitus due to underlying condition with other diabetic kidney complication</span></p><p><b>subject</b>: <a href=\"Patient-ra-patient01.html\">Eve Everywoman (official) Female, DoB: 1975-01-16 ( Medical record number: 12345 (use: usual, ))</a></p><p><b>onset</b>: 2021-01-31</p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active",
              "display" : "Active"
            }
          ],
          "text" : "Active"
        },
        "verificationStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-ver-status",
              "code" : "confirmed",
              "display" : "Confirmed"
            }
          ],
          "text" : "Confirmed"
        },
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/condition-category",
                "code" : "encounter-diagnosis",
                "display" : "Encounter Diagnosis"
              }
            ],
            "text" : "Problem"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/sid/icd-10-cm",
              "code" : "E08.29",
              "display" : "Diabetes mellitus due to underlying condition with other diabetic kidney complication"
            }
          ],
          "text" : "E08.29: Diabetes mellitus due to underlying condition with other diabetic kidney complication"
        },
        "subject" : {
          "reference" : "Patient/ra-patient01"
        },
        "onsetDateTime" : "2021-01-31"
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Encounter/ra-encounter11pat01",
      "resource" : {
        "resourceType" : "Encounter",
        "id" : "ra-encounter11pat01",
        "meta" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/instance-name",
              "valueString" : "Encounter with Dr Howell on 20210714 for Patient 03"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/instance-description",
              "valueMarkdown" : "This is Encounter with Dr Howell on 20210714 for Patient 03."
            }
          ],
          "profile" : [
            "http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter|7.0.0"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Encounter_ra-encounter11pat01\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Encounter ra-encounter11pat01</b></p><a name=\"ra-encounter11pat01\"> </a><a name=\"hcra-encounter11pat01\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-encounter.html\">US Core Encounter Profileversion: null7.0.0)</a></p></div><p><b>status</b>: Finished</p><p><b>class</b>: <a href=\"http://terminology.hl7.org/7.0.0/CodeSystem-v3-ActCode.html#v3-ActCode-AMB\">ActCode: AMB</a> (ambulatory)</p><p><b>type</b>: <span title=\"Codes:{http://www.ama-assn.org/go/cpt 99215}\">Office Visit, High Complexity</span></p><p><b>subject</b>: <a href=\"Patient-ra-patient01.html\">Eve Everywoman (official) Female, DoB: 1975-01-16 ( Medical record number: 12345 (use: usual, ))</a></p><h3>Participants</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Individual</b></td></tr><tr><td style=\"display: none\">*</td><td><a href=\"Practitioner-ra-prac01pat01.html\">Practitioner Harold Hippocrates </a></td></tr></table><p><b>period</b>: 2020-11-02 --&gt; 2020-11-02</p><h3>Diagnoses</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Condition</b></td></tr><tr><td style=\"display: none\">*</td><td><a href=\"Condition-ra-condition11pat01.html\">Condition Acute pulmonary edema</a></td></tr></table><p><b>serviceProvider</b>: <a href=\"Organization-ra-org01pat01.html\">Organization Community Urgent Care</a></p></div>"
        },
        "status" : "finished",
        "class" : {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
          "code" : "AMB",
          "display" : "ambulatory"
        },
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://www.ama-assn.org/go/cpt",
                "code" : "99215"
              }
            ],
            "text" : "Office Visit, High Complexity"
          }
        ],
        "subject" : {
          "reference" : "Patient/ra-patient01"
        },
        "participant" : [
          {
            "individual" : {
              "reference" : "Practitioner/ra-prac01pat01"
            }
          }
        ],
        "period" : {
          "start" : "2020-11-02",
          "end" : "2020-11-02"
        },
        "diagnosis" : [
          {
            "condition" : {
              "reference" : "Condition/ra-condition11pat01"
            }
          }
        ],
        "serviceProvider" : {
          "reference" : "Organization/ra-org01pat01"
        }
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Observation/ra-obs21pat01",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "ra-obs21pat01",
        "meta" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/instance-name",
              "valueString" : "Trypsin [Mass/volume] in Serum or Plasma for Pat01"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/instance-description",
              "valueMarkdown" : "Trypsin [Mass/volume] in Serum or Plasma for Pat01*."
            }
          ],
          "profile" : [
            "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-lab|7.0.0"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_ra-obs21pat01\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation ra-obs21pat01</b></p><a name=\"ra-obs21pat01\"> </a><a name=\"hcra-obs21pat01\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-observation-lab.html\">US Core Laboratory Result Observation Profileversion: null7.0.0)</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 33325-2}\">Trypsin [Mass/volume] in Serum or Plasma</span></p><p><b>subject</b>: <a href=\"Patient-ra-patient01.html\">Eve Everywoman</a></p><p><b>effective</b>: 2019-06-17</p><p><b>performer</b>: <a href=\"Organization-ra-laboratory01.html\">XYZ Laboratory</a></p><p><b>value</b>: 770 ng/mL</p><h3>ReferenceRanges</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Low</b></td><td><b>High</b></td><td><b>Type</b></td></tr><tr><td style=\"display: none\">*</td><td>169 ng/mL<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codeng/mL = 'ng/mL')</span></td><td>773 ng/mL<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg/dL = 'mg/dL')</span></td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/referencerange-meaning normal}\">Normal Range</span></td></tr></table></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory",
                "display" : "Laboratory"
              }
            ],
            "text" : "Laboratory"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "33325-2",
              "display" : "Trypsin [Mass/volume] in Serum or Plasma"
            }
          ],
          "text" : "Trypsin [Mass/volume] in Serum or Plasma"
        },
        "subject" : {
          "reference" : "Patient/ra-patient01",
          "display" : "Eve Everywoman"
        },
        "effectiveDateTime" : "2019-06-17",
        "performer" : [
          {
            "reference" : "Organization/ra-laboratory01",
            "display" : "XYZ Laboratory"
          }
        ],
        "valueQuantity" : {
          "value" : 770,
          "unit" : "ng/mL",
          "system" : "http://unitsofmeasure.org"
        },
        "referenceRange" : [
          {
            "low" : {
              "value" : 169,
              "unit" : "ng/mL",
              "system" : "http://unitsofmeasure.org",
              "code" : "ng/mL"
            },
            "high" : {
              "value" : 773,
              "unit" : "ng/mL",
              "system" : "http://unitsofmeasure.org",
              "code" : "mg/dL"
            },
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/referencerange-meaning",
                  "code" : "normal",
                  "display" : "Normal Range"
                }
              ],
              "text" : "Normal Range"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Condition/ra-condition18pat01",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "ra-condition18pat01",
        "meta" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/instance-name",
              "valueString" : "Condition18Pat01 Example"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/instance-description",
              "valueMarkdown" : "This is a Condition example with code I48.11: Longstanding persistent atrial fibrillation."
            }
          ],
          "profile" : [
            "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-encounter-diagnosis|7.0.0"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_ra-condition18pat01\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition ra-condition18pat01</b></p><a name=\"ra-condition18pat01\"> </a><a name=\"hcra-condition18pat01\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-condition-encounter-diagnosis.html\">US Core Condition Encounter Diagnosis Profileversion: null7.0.0)</a></p></div><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>verificationStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-ver-status confirmed}\">Confirmed</span></p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-category encounter-diagnosis}\">Problem</span></p><p><b>code</b>: <span title=\"Codes:{http://hl7.org/fhir/sid/icd-10-cm I48.11}\">I48.11: Longstanding persistent atrial fibrillation</span></p><p><b>subject</b>: <a href=\"Patient-ra-patient01.html\">Eve Everywoman (official) Female, DoB: 1975-01-16 ( Medical record number: 12345 (use: usual, ))</a></p><p><b>onset</b>: 2021-09-26</p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active",
              "display" : "Active"
            }
          ],
          "text" : "Active"
        },
        "verificationStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-ver-status",
              "code" : "confirmed",
              "display" : "Confirmed"
            }
          ],
          "text" : "Confirmed"
        },
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/condition-category",
                "code" : "encounter-diagnosis",
                "display" : "Encounter Diagnosis"
              }
            ],
            "text" : "Problem"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/sid/icd-10-cm",
              "code" : "I48.11",
              "display" : "Longstanding persistent atrial fibrillation"
            }
          ],
          "text" : "I48.11: Longstanding persistent atrial fibrillation"
        },
        "subject" : {
          "reference" : "Patient/ra-patient01"
        },
        "onsetDateTime" : "2021-09-26"
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Encounter/ra-encounter08pat01",
      "resource" : {
        "resourceType" : "Encounter",
        "id" : "ra-encounter08pat01",
        "meta" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/instance-name",
              "valueString" : "Encounter with Dr Howell on 20210714 for Patient 03"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/instance-description",
              "valueMarkdown" : "This is Encounter with Dr Howell on 20210714 for Patient 03."
            }
          ],
          "profile" : [
            "http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter|7.0.0"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Encounter_ra-encounter08pat01\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Encounter ra-encounter08pat01</b></p><a name=\"ra-encounter08pat01\"> </a><a name=\"hcra-encounter08pat01\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-encounter.html\">US Core Encounter Profileversion: null7.0.0)</a></p></div><p><b>status</b>: Finished</p><p><b>class</b>: <a href=\"http://terminology.hl7.org/7.0.0/CodeSystem-v3-ActCode.html#v3-ActCode-AMB\">ActCode: AMB</a> (ambulatory)</p><p><b>type</b>: <span title=\"Codes:{http://www.ama-assn.org/go/cpt 99215}\">Office Visit, High Complexity</span></p><p><b>subject</b>: <a href=\"Patient-ra-patient01.html\">Eve Everywoman (official) Female, DoB: 1975-01-16 ( Medical record number: 12345 (use: usual, ))</a></p><h3>Participants</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Individual</b></td></tr><tr><td style=\"display: none\">*</td><td><a href=\"Practitioner-ra-prac01pat01.html\">Practitioner Harold Hippocrates </a></td></tr></table><p><b>period</b>: 2017-02-03 --&gt; 2017-02-03</p><h3>Diagnoses</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Condition</b></td></tr><tr><td style=\"display: none\">*</td><td><a href=\"Condition-ra-condition08pat01.html\">Condition Bipolar disorder, current episode mixed, mild</a></td></tr></table><p><b>serviceProvider</b>: <a href=\"Organization-ra-org01pat01.html\">Organization Community Urgent Care</a></p></div>"
        },
        "status" : "finished",
        "class" : {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
          "code" : "AMB",
          "display" : "ambulatory"
        },
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://www.ama-assn.org/go/cpt",
                "code" : "99215"
              }
            ],
            "text" : "Office Visit, High Complexity"
          }
        ],
        "subject" : {
          "reference" : "Patient/ra-patient01"
        },
        "participant" : [
          {
            "individual" : {
              "reference" : "Practitioner/ra-prac01pat01"
            }
          }
        ],
        "period" : {
          "start" : "2017-02-03",
          "end" : "2017-02-03"
        },
        "diagnosis" : [
          {
            "condition" : {
              "reference" : "Condition/ra-condition08pat01"
            }
          }
        ],
        "serviceProvider" : {
          "reference" : "Organization/ra-org01pat01"
        }
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Condition/ra-condition44pat01",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "ra-condition44pat01",
        "meta" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/instance-name",
              "valueString" : "Condition44Pat01 Example"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/instance-description",
              "valueMarkdown" : "This is a Condition example with code B44.81: Allergic bronchopulmonary aspergillosis."
            }
          ],
          "profile" : [
            "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-encounter-diagnosis|7.0.0"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_ra-condition44pat01\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition ra-condition44pat01</b></p><a name=\"ra-condition44pat01\"> </a><a name=\"hcra-condition44pat01\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-condition-encounter-diagnosis.html\">US Core Condition Encounter Diagnosis Profileversion: null7.0.0)</a></p></div><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>verificationStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-ver-status confirmed}\">Confirmed</span></p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-category encounter-diagnosis}\">Problem</span></p><p><b>code</b>: <span title=\"Codes:{http://hl7.org/fhir/sid/icd-10-cm B44.81}\">B44.81: Allergic bronchopulmonary aspergillosis</span></p><p><b>subject</b>: <a href=\"Patient-ra-patient01.html\">Eve Everywoman (official) Female, DoB: 1975-01-16 ( Medical record number: 12345 (use: usual, ))</a></p><p><b>onset</b>: 2017-01-18</p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active",
              "display" : "Active"
            }
          ],
          "text" : "Active"
        },
        "verificationStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-ver-status",
              "code" : "confirmed",
              "display" : "Confirmed"
            }
          ],
          "text" : "Confirmed"
        },
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/condition-category",
                "code" : "encounter-diagnosis",
                "display" : "Encounter Diagnosis"
              }
            ],
            "text" : "Problem"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/sid/icd-10-cm",
              "code" : "B44.81",
              "display" : "Allergic bronchopulmonary aspergillosis"
            }
          ],
          "text" : "B44.81: Allergic bronchopulmonary aspergillosis"
        },
        "subject" : {
          "reference" : "Patient/ra-patient01"
        },
        "onsetDateTime" : "2017-01-18"
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Encounter/ra-encounter02pat01",
      "resource" : {
        "resourceType" : "Encounter",
        "id" : "ra-encounter02pat01",
        "meta" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/instance-name",
              "valueString" : "Encounter with Dr Howell on 20210714 for Patient 03"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/instance-description",
              "valueMarkdown" : "This is Encounter with Dr Howell on 20210714 for Patient 03."
            }
          ],
          "profile" : [
            "http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter|7.0.0"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Encounter_ra-encounter02pat01\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Encounter ra-encounter02pat01</b></p><a name=\"ra-encounter02pat01\"> </a><a name=\"hcra-encounter02pat01\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-encounter.html\">US Core Encounter Profileversion: null7.0.0)</a></p></div><p><b>status</b>: Finished</p><p><b>class</b>: <a href=\"http://terminology.hl7.org/7.0.0/CodeSystem-v3-ActCode.html#v3-ActCode-AMB\">ActCode: AMB</a> (ambulatory)</p><p><b>type</b>: <span title=\"Codes:{http://www.ama-assn.org/go/cpt 99215}\">Office Visit, High Complexity</span></p><p><b>subject</b>: <a href=\"Patient-ra-patient01.html\">Eve Everywoman (official) Female, DoB: 1975-01-16 ( Medical record number: 12345 (use: usual, ))</a></p><h3>Participants</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Individual</b></td></tr><tr><td style=\"display: none\">*</td><td><a href=\"Practitioner-ra-prac01pat01.html\">Practitioner Harold Hippocrates </a></td></tr></table><p><b>period</b>: 2021-01-31 --&gt; 2021-01-31</p><blockquote><p><b>diagnosis</b></p><p><b>condition</b>: <a href=\"Condition-ra-condition02pat01.html\">Condition Diabetes mellitus due to underlying condition with other diabetic kidney complication</a></p></blockquote><blockquote><p><b>diagnosis</b></p><p><b>condition</b>: <a href=\"Condition-ra-condition17pat01.html\">Condition Body mass index [BMI] 45.0-49.9, adult</a></p></blockquote><p><b>serviceProvider</b>: <a href=\"Organization-ra-org01pat01.html\">Organization Community Urgent Care</a></p></div>"
        },
        "status" : "finished",
        "class" : {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
          "code" : "AMB",
          "display" : "ambulatory"
        },
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://www.ama-assn.org/go/cpt",
                "code" : "99215"
              }
            ],
            "text" : "Office Visit, High Complexity"
          }
        ],
        "subject" : {
          "reference" : "Patient/ra-patient01"
        },
        "participant" : [
          {
            "individual" : {
              "reference" : "Practitioner/ra-prac01pat01"
            }
          }
        ],
        "period" : {
          "start" : "2021-01-31",
          "end" : "2021-01-31"
        },
        "diagnosis" : [
          {
            "condition" : {
              "reference" : "Condition/ra-condition02pat01"
            }
          },
          {
            "condition" : {
              "reference" : "Condition/ra-condition17pat01"
            }
          }
        ],
        "serviceProvider" : {
          "reference" : "Organization/ra-org01pat01"
        }
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Encounter/ra-encounter44pat01",
      "resource" : {
        "resourceType" : "Encounter",
        "id" : "ra-encounter44pat01",
        "meta" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/instance-name",
              "valueString" : "Encounter with Dr Howell on 20210714 for Patient 03"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/instance-description",
              "valueMarkdown" : "This is Encounter with Dr Howell on 20210714 for Patient 03."
            }
          ],
          "profile" : [
            "http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter|7.0.0"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Encounter_ra-encounter44pat01\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Encounter ra-encounter44pat01</b></p><a name=\"ra-encounter44pat01\"> </a><a name=\"hcra-encounter44pat01\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-encounter.html\">US Core Encounter Profileversion: null7.0.0)</a></p></div><p><b>status</b>: Finished</p><p><b>class</b>: <a href=\"http://terminology.hl7.org/7.0.0/CodeSystem-v3-ActCode.html#v3-ActCode-AMB\">ActCode: AMB</a> (ambulatory)</p><p><b>type</b>: <span title=\"Codes:{http://www.ama-assn.org/go/cpt 99215}\">Office Visit, High Complexity</span></p><p><b>subject</b>: <a href=\"Patient-ra-patient01.html\">Eve Everywoman (official) Female, DoB: 1975-01-16 ( Medical record number: 12345 (use: usual, ))</a></p><h3>Participants</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Individual</b></td></tr><tr><td style=\"display: none\">*</td><td><a href=\"Practitioner-ra-prac01pat01.html\">Practitioner Harold Hippocrates </a></td></tr></table><p><b>period</b>: 2017-01-18 --&gt; 2017-01-18</p><h3>Diagnoses</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Condition</b></td></tr><tr><td style=\"display: none\">*</td><td><a href=\"Condition-ra-condition44pat01.html\">Condition Allergic bronchopulmonary aspergillosis</a></td></tr></table><p><b>serviceProvider</b>: <a href=\"Organization-ra-org01pat01.html\">Organization Community Urgent Care</a></p></div>"
        },
        "status" : "finished",
        "class" : {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
          "code" : "AMB",
          "display" : "ambulatory"
        },
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://www.ama-assn.org/go/cpt",
                "code" : "99215"
              }
            ],
            "text" : "Office Visit, High Complexity"
          }
        ],
        "subject" : {
          "reference" : "Patient/ra-patient01"
        },
        "participant" : [
          {
            "individual" : {
              "reference" : "Practitioner/ra-prac01pat01"
            }
          }
        ],
        "period" : {
          "start" : "2017-01-18",
          "end" : "2017-01-18"
        },
        "diagnosis" : [
          {
            "condition" : {
              "reference" : "Condition/ra-condition44pat01"
            }
          }
        ],
        "serviceProvider" : {
          "reference" : "Organization/ra-org01pat01"
        }
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Condition/ra-condition08pat01",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "ra-condition08pat01",
        "meta" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/instance-name",
              "valueString" : "Condition08Pat01 Example"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/instance-description",
              "valueMarkdown" : "This is a Condition example with code F31.61: Bipolar disorder, current episode mixed, mild."
            }
          ],
          "profile" : [
            "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-encounter-diagnosis|7.0.0"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_ra-condition08pat01\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition ra-condition08pat01</b></p><a name=\"ra-condition08pat01\"> </a><a name=\"hcra-condition08pat01\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-condition-encounter-diagnosis.html\">US Core Condition Encounter Diagnosis Profileversion: null7.0.0)</a></p></div><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>verificationStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-ver-status confirmed}\">Confirmed</span></p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-category encounter-diagnosis}\">Problem</span></p><p><b>code</b>: <span title=\"Codes:{http://hl7.org/fhir/sid/icd-10-cm F31.61}\">Bipolar disorder, current episode mixed, mild</span></p><p><b>subject</b>: <a href=\"Patient-ra-patient01.html\">Eve Everywoman (official) Female, DoB: 1975-01-16 ( Medical record number: 12345 (use: usual, ))</a></p><p><b>onset</b>: 2017-02-03</p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active",
              "display" : "Active"
            }
          ],
          "text" : "Active"
        },
        "verificationStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-ver-status",
              "code" : "confirmed",
              "display" : "Confirmed"
            }
          ],
          "text" : "Confirmed"
        },
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/condition-category",
                "code" : "encounter-diagnosis",
                "display" : "Encounter Diagnosis"
              }
            ],
            "text" : "Problem"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/sid/icd-10-cm",
              "code" : "F31.61",
              "display" : "Bipolar disorder, current episode mixed, mild"
            }
          ],
          "text" : "Bipolar disorder, current episode mixed, mild"
        },
        "subject" : {
          "reference" : "Patient/ra-patient01"
        },
        "onsetDateTime" : "2017-02-03"
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Condition/ra-condition43pat01",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "ra-condition43pat01",
        "meta" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/instance-name",
              "valueString" : "Condition43Pat01 Example"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/instance-description",
              "valueMarkdown" : "This is a Condition example with code E08.29: Diabetes mellitus due to underlying condition with other diabetic kidney complication."
            }
          ],
          "profile" : [
            "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-encounter-diagnosis|7.0.0"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_ra-condition43pat01\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition ra-condition43pat01</b></p><a name=\"ra-condition43pat01\"> </a><a name=\"hcra-condition43pat01\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-condition-encounter-diagnosis.html\">US Core Condition Encounter Diagnosis Profileversion: null7.0.0)</a></p></div><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>verificationStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-ver-status confirmed}\">Confirmed</span></p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-category encounter-diagnosis}\">Problem</span></p><p><b>code</b>: <span title=\"Codes:{http://hl7.org/fhir/sid/icd-10-cm E08.29}\">E08.29: Diabetes mellitus due to underlying condition with other diabetic kidney complication</span></p><p><b>subject</b>: <a href=\"Patient-ra-patient01.html\">Eve Everywoman (official) Female, DoB: 1975-01-16 ( Medical record number: 12345 (use: usual, ))</a></p><p><b>onset</b>: 2019-02-10</p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active",
              "display" : "Active"
            }
          ],
          "text" : "Active"
        },
        "verificationStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-ver-status",
              "code" : "confirmed",
              "display" : "Confirmed"
            }
          ],
          "text" : "Confirmed"
        },
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/condition-category",
                "code" : "encounter-diagnosis",
                "display" : "Encounter Diagnosis"
              }
            ],
            "text" : "Problem"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/sid/icd-10-cm",
              "code" : "E08.29",
              "display" : "Diabetes mellitus due to underlying condition with other diabetic kidney complication"
            }
          ],
          "text" : "E08.29: Diabetes mellitus due to underlying condition with other diabetic kidney complication"
        },
        "subject" : {
          "reference" : "Patient/ra-patient01"
        },
        "onsetDateTime" : "2019-02-10"
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Condition/ra-condition03pat01",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "ra-condition03pat01",
        "meta" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/instance-name",
              "valueString" : "Condition03Pat01 Example"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/instance-description",
              "valueMarkdown" : "This is a Condition example with code J44.1: Chronic obstructive pulmonary disease with (acute) exacerbation."
            }
          ],
          "profile" : [
            "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-encounter-diagnosis|7.0.0"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_ra-condition03pat01\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition ra-condition03pat01</b></p><a name=\"ra-condition03pat01\"> </a><a name=\"hcra-condition03pat01\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-condition-encounter-diagnosis.html\">US Core Condition Encounter Diagnosis Profileversion: null7.0.0)</a></p></div><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>verificationStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-ver-status confirmed}\">Confirmed</span></p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-category encounter-diagnosis}\">Problem</span></p><p><b>code</b>: <span title=\"Codes:{http://hl7.org/fhir/sid/icd-10-cm J44.1}\">J44.1: Chronic obstructive pulmonary disease with (acute) exacerbation</span></p><p><b>subject</b>: <a href=\"Patient-ra-patient01.html\">Eve Everywoman (official) Female, DoB: 1975-01-16 ( Medical record number: 12345 (use: usual, ))</a></p><p><b>onset</b>: 2021-09-26</p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active",
              "display" : "Active"
            }
          ],
          "text" : "Active"
        },
        "verificationStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-ver-status",
              "code" : "confirmed",
              "display" : "Confirmed"
            }
          ],
          "text" : "Confirmed"
        },
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/condition-category",
                "code" : "encounter-diagnosis",
                "display" : "Encounter Diagnosis"
              }
            ],
            "text" : "Problem"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/sid/icd-10-cm",
              "code" : "J44.1",
              "display" : "Chronic obstructive pulmonary disease with (acute) exacerbation"
            }
          ],
          "text" : "J44.1: Chronic obstructive pulmonary disease with (acute) exacerbation"
        },
        "subject" : {
          "reference" : "Patient/ra-patient01"
        },
        "onsetDateTime" : "2021-09-26"
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Condition/ra-condition11pat01",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "ra-condition11pat01",
        "meta" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/instance-name",
              "valueString" : "Condition11Pat01 Example"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/instance-description",
              "valueMarkdown" : "This is a Condition example with code J81.0: Acute pulmonary edema."
            }
          ],
          "profile" : [
            "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-encounter-diagnosis|7.0.0"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_ra-condition11pat01\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition ra-condition11pat01</b></p><a name=\"ra-condition11pat01\"> </a><a name=\"hcra-condition11pat01\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-condition-encounter-diagnosis.html\">US Core Condition Encounter Diagnosis Profileversion: null7.0.0)</a></p></div><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>verificationStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-ver-status confirmed}\">Confirmed</span></p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-category encounter-diagnosis}\">Problem</span></p><p><b>code</b>: <span title=\"Codes:{http://hl7.org/fhir/sid/icd-10-cm J81.0}\">J81.0: Acute pulmonary edema</span></p><p><b>subject</b>: <a href=\"Patient-ra-patient01.html\">Eve Everywoman (official) Female, DoB: 1975-01-16 ( Medical record number: 12345 (use: usual, ))</a></p><p><b>onset</b>: 2020-11-02</p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active",
              "display" : "Active"
            }
          ],
          "text" : "Active"
        },
        "verificationStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-ver-status",
              "code" : "confirmed",
              "display" : "Confirmed"
            }
          ],
          "text" : "Confirmed"
        },
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/condition-category",
                "code" : "encounter-diagnosis",
                "display" : "Encounter Diagnosis"
              }
            ],
            "text" : "Problem"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/sid/icd-10-cm",
              "code" : "J81.0",
              "display" : "Acute pulmonary edema"
            }
          ],
          "text" : "J81.0: Acute pulmonary edema"
        },
        "subject" : {
          "reference" : "Patient/ra-patient01"
        },
        "onsetDateTime" : "2020-11-02"
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Encounter/ra-encounter43pat01",
      "resource" : {
        "resourceType" : "Encounter",
        "id" : "ra-encounter43pat01",
        "meta" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/instance-name",
              "valueString" : "Encounter with Dr Howell on 20210714 for Patient 03"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/instance-description",
              "valueMarkdown" : "This is Encounter with Dr Howell on 20210714 for Patient 03."
            }
          ],
          "profile" : [
            "http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter|7.0.0"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Encounter_ra-encounter43pat01\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Encounter ra-encounter43pat01</b></p><a name=\"ra-encounter43pat01\"> </a><a name=\"hcra-encounter43pat01\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-encounter.html\">US Core Encounter Profileversion: null7.0.0)</a></p></div><p><b>status</b>: Finished</p><p><b>class</b>: <a href=\"http://terminology.hl7.org/7.0.0/CodeSystem-v3-ActCode.html#v3-ActCode-AMB\">ActCode: AMB</a> (ambulatory)</p><p><b>type</b>: <span title=\"Codes:{http://www.ama-assn.org/go/cpt 99215}\">Office Visit, High Complexity</span></p><p><b>subject</b>: <a href=\"Patient-ra-patient01.html\">Eve Everywoman (official) Female, DoB: 1975-01-16 ( Medical record number: 12345 (use: usual, ))</a></p><h3>Participants</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Individual</b></td></tr><tr><td style=\"display: none\">*</td><td><a href=\"Practitioner-ra-prac01pat01.html\">Practitioner Harold Hippocrates </a></td></tr></table><p><b>period</b>: 2019-02-10 --&gt; 2019-02-10</p><h3>Diagnoses</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Condition</b></td></tr><tr><td style=\"display: none\">*</td><td><a href=\"Condition-ra-condition43pat01.html\">Condition Diabetes mellitus due to underlying condition with other diabetic kidney complication</a></td></tr></table><p><b>serviceProvider</b>: <a href=\"Organization-ra-org01pat01.html\">Organization Community Urgent Care</a></p></div>"
        },
        "status" : "finished",
        "class" : {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
          "code" : "AMB",
          "display" : "ambulatory"
        },
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://www.ama-assn.org/go/cpt",
                "code" : "99215"
              }
            ],
            "text" : "Office Visit, High Complexity"
          }
        ],
        "subject" : {
          "reference" : "Patient/ra-patient01"
        },
        "participant" : [
          {
            "individual" : {
              "reference" : "Practitioner/ra-prac01pat01"
            }
          }
        ],
        "period" : {
          "start" : "2019-02-10",
          "end" : "2019-02-10"
        },
        "diagnosis" : [
          {
            "condition" : {
              "reference" : "Condition/ra-condition43pat01"
            }
          }
        ],
        "serviceProvider" : {
          "reference" : "Organization/ra-org01pat01"
        }
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Encounter/ra-encounter09pat01",
      "resource" : {
        "resourceType" : "Encounter",
        "id" : "ra-encounter09pat01",
        "meta" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/instance-name",
              "valueString" : "Encounter with Dr Howell on 20210714 for Patient 03"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/instance-description",
              "valueMarkdown" : "This is Encounter with Dr Howell on 20210714 for Patient 03."
            }
          ],
          "profile" : [
            "http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter|7.0.0"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Encounter_ra-encounter09pat01\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Encounter ra-encounter09pat01</b></p><a name=\"ra-encounter09pat01\"> </a><a name=\"hcra-encounter09pat01\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-encounter.html\">US Core Encounter Profileversion: null7.0.0)</a></p></div><p><b>status</b>: Finished</p><p><b>class</b>: <a href=\"http://terminology.hl7.org/7.0.0/CodeSystem-v3-ActCode.html#v3-ActCode-AMB\">ActCode: AMB</a> (ambulatory)</p><p><b>type</b>: <span title=\"Codes:{http://www.ama-assn.org/go/cpt 99215}\">Office Visit, High Complexity</span></p><p><b>subject</b>: <a href=\"Patient-ra-patient01.html\">Eve Everywoman (official) Female, DoB: 1975-01-16 ( Medical record number: 12345 (use: usual, ))</a></p><h3>Participants</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Individual</b></td></tr><tr><td style=\"display: none\">*</td><td><a href=\"Practitioner-ra-prac01pat01.html\">Practitioner Harold Hippocrates </a></td></tr></table><p><b>period</b>: 2021-03-27 --&gt; 2021-03-27</p><h3>Diagnoses</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Condition</b></td></tr><tr><td style=\"display: none\">*</td><td><a href=\"Condition-ra-condition09pat01.html\">Condition Allergic bronchopulmonary aspergillosis</a></td></tr></table><p><b>serviceProvider</b>: <a href=\"Organization-ra-org01pat01.html\">Organization Community Urgent Care</a></p></div>"
        },
        "status" : "finished",
        "class" : {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
          "code" : "AMB",
          "display" : "ambulatory"
        },
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://www.ama-assn.org/go/cpt",
                "code" : "99215"
              }
            ],
            "text" : "Office Visit, High Complexity"
          }
        ],
        "subject" : {
          "reference" : "Patient/ra-patient01"
        },
        "participant" : [
          {
            "individual" : {
              "reference" : "Practitioner/ra-prac01pat01"
            }
          }
        ],
        "period" : {
          "start" : "2021-03-27",
          "end" : "2021-03-27"
        },
        "diagnosis" : [
          {
            "condition" : {
              "reference" : "Condition/ra-condition09pat01"
            }
          }
        ],
        "serviceProvider" : {
          "reference" : "Organization/ra-org01pat01"
        }
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Condition/ra-condition17pat01",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "ra-condition17pat01",
        "meta" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/instance-name",
              "valueString" : "Condition17Pat01 Example"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/instance-description",
              "valueMarkdown" : "This is a Condition example with code Z68.42: Body mass index [BMI] 45.0-49.9, adult."
            }
          ],
          "profile" : [
            "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-encounter-diagnosis|7.0.0"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_ra-condition17pat01\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition ra-condition17pat01</b></p><a name=\"ra-condition17pat01\"> </a><a name=\"hcra-condition17pat01\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-condition-encounter-diagnosis.html\">US Core Condition Encounter Diagnosis Profileversion: null7.0.0)</a></p></div><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>verificationStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-ver-status confirmed}\">Confirmed</span></p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-category encounter-diagnosis}\">Problem</span></p><p><b>code</b>: <span title=\"Codes:{http://hl7.org/fhir/sid/icd-10-cm Z68.42}\">Z68.42: Body mass index [BMI] 45.0-49.9, adult</span></p><p><b>subject</b>: <a href=\"Patient-ra-patient01.html\">Eve Everywoman (official) Female, DoB: 1975-01-16 ( Medical record number: 12345 (use: usual, ))</a></p><p><b>onset</b>: 2021-01-31</p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active",
              "display" : "Active"
            }
          ],
          "text" : "Active"
        },
        "verificationStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-ver-status",
              "code" : "confirmed",
              "display" : "Confirmed"
            }
          ],
          "text" : "Confirmed"
        },
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/condition-category",
                "code" : "encounter-diagnosis",
                "display" : "Encounter Diagnosis"
              }
            ],
            "text" : "Problem"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/sid/icd-10-cm",
              "code" : "Z68.42",
              "display" : "Body mass index [BMI] 45.0-49.9, adult"
            }
          ],
          "text" : "Z68.42: Body mass index [BMI] 45.0-49.9, adult"
        },
        "subject" : {
          "reference" : "Patient/ra-patient01"
        },
        "onsetDateTime" : "2021-01-31"
      }
    }
  ]
}

```
