# Security, Privacy, and Safety - Da Vinci Risk Adjustment Implementation Guide v2.1.0

* [**Table of Contents**](toc.md)
* **Security, Privacy, and Safety**

## Security, Privacy, and Safety

| |
| :--- |
| *Page standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) |

Although the exact mechanisms for securing these exchanges are not specified as part of this IG:

* Exchanges are limited to mutually agreed upon (i.e., between the Server and the Client) patient lists or population.
* Systems should use standard authentication and authorization approaches. The [SMART App Launch](https://hl7.org/fhir/smart-app-launch/) and [SMART backend services](https://hl7.org/fhir/uv/bulkdata/authorization.html) authentication/authorization approach are recommended models.
* This implementation guide inherits all of the mandatory requirements and recommendations defined in the [Security and Privacy](https://hl7.org/fhir/us/davinci-hrex/security.html) section of the Da Vinci Health Record Exchange [(HRex)](https://hl7.org/fhir/us/davinci-hrex/index.html) implementaion guide. Implementers **SHALL** read and adhere to the guidance for the following topics: 
* Statutes, Regulations
* FHIR Clinical Safy, Security and Implementation Guidance
* Security/Privacy Related Technologies, Including Explicit Consent and Security Labels
* Exchange Security
* Additionally Protected Information
* Security Contexts for Da Vinci IGs
 

