# hl7.fhir.us.davinci-ra#2.1.0: Da Vinci Risk Adjustment Implementation Guide

## Pages

* [Home](index.md)
* [Extensions](extensions.md)
* [Add Remark to Condition Category](cc-remark.md)
* [Security, Privacy, and Safety](security.md)
* [Terminology](terminology.md)
* [Report Generation](report-generation.md)
* [Tooling and Support](tools.md)
* [General Guidance](general-guidance.md)
* [Glossary](glossary.md)
* [Profiles](profiles.md)
* [Capability Statements](capabilities.md)
* [Change Log](change-log.md)
* [Submit Data To Payer](submit-data-to-payer.md)
* [Digital Condition Category (dCC)](dcc.md)
* [Operation](operations.md)
* [Downloads](downloads.md)
* [Reading this IG - FHIR Introduction](fhir.md)
* [Examples](examples.md)
* [Projects and Participants](credits.md)
* [Background](background.md)
* [Artifacts Summary](artifacts.md)
* [Report Query](report-query.md)
* [Search Parameters](search-parameters.md)

## Resources

### CodeSystems

* [Risk Adjustment Condition Category Type Codes](CodeSystem-cc-type.md)
* [Coding Gap Remark Codes](CodeSystem-coding-gap-remark.md)
* [Risk Adjustment Evidence Status Codes](CodeSystem-evidence-status.md)
* [Risk Adjustment Hierarchical Status Codes](CodeSystem-hierarchical-status.md)
* [Remark Reason Codes](CodeSystem-remark-reason.md)

### ValueSets

* [Condition Category Type](ValueSet-cc-type.md)
* [Coding Gap Remark](ValueSet-coding-gap-remark.md)
* [RA Confidence Scale](ValueSet-confidence-scale.md)
* [Evidence Status](ValueSet-evidence-status.md)
* [Hierarchical Status](ValueSet-hierarchical-status.md)
* [Remark Reason](ValueSet-remark-reason.md)
* [Sample CMS Hierarchical Condition Category](ValueSet-sample-cmshcc.md)

### Resource Profiles

* [Risk Adjustment Data Exchange MeasureReport](StructureDefinition-ra-datax-measurereport.md)
* [Risk Adjustment Coding Gap Report Bundle](StructureDefinition-ra-measurereport-bundle.md)
* [Risk Adjustment MeasureReport With Remark Bundle](StructureDefinition-ra-measurereport-remark-bundle.md)
* [Risk Adjustment Coding Gap MeasureReport with Remark](StructureDefinition-ra-measurereport-with-remark.md)
* [Risk Adjustment Coding Gap MeasureReport](StructureDefinition-ra-measurereport.md)
* [Risk Adjustment Model Measure](StructureDefinition-ra-model-measure.md)
* [RA Parameters ccRemark Patch Profile](StructureDefinition-ra-parameters-cc-remark-patch.md)
* [Patient Group](StructureDefinition-ra-patient-group.md)

### Extensions

* [Condition Category Remark Extension](StructureDefinition-ra-ccRemark.md)
* [Condition Category Type Extension](StructureDefinition-ra-ccType.md)
* [Clinical Data Collection Deadline Extension](StructureDefinition-ra-clinicalDataCollectionDeadline.md)
* [Confidence Scale Extension](StructureDefinition-ra-confidenceScale.md)
* [Context Id Extension](StructureDefinition-ra-contextId.md)
* [Diagnosis Code Extension](StructureDefinition-ra-dxCode.md)
* [Evidence Status Extension](StructureDefinition-ra-evidenceStatus.md)
* [Evidence Status Date Extension](StructureDefinition-ra-evidenceStatusDate.md)
* [Group Reference Extension](StructureDefinition-ra-groupReference.md)
* [Hierarchical Status Extension](StructureDefinition-ra-hierarchicalStatus.md)
* [Payer Coding Gap Report Id Extension](StructureDefinition-ra-payerCodingGapReportId.md)
* [QualifyingCode Extension](StructureDefinition-ra-qualifyingDxCode.md)
* [Reporting Vendor Extension](StructureDefinition-ra-reportingVendor.md)

### CapabilityStatements

* [Risk Adjustment Data Submission Client Capability Statement](CapabilityStatement-ra-data-submission-client.md)
* [Risk Adjustment Data Submission Server Capability Statement](CapabilityStatement-ra-data-submission-server.md)
* [Risk Adjustment Reporting Client Capability Statement](CapabilityStatement-ra-reporting-client.md)
* [Risk Adjustment Reporting Server Capability Statement](CapabilityStatement-ra-reporting-server.md)

### ImplementationGuides

* [Da Vinci Risk Adjustment Implementation Guide](index.md)

### OperationDefinitions

* [Evaluate Measure](OperationDefinition-ra.evaluate-measure.md)
* [Risk Gap](OperationDefinition-risk-gap.md)
* [Submit Remark Data](OperationDefinition-submit-remark-data.md)

### SearchParameters

* [MeasureReportCategory](SearchParameter-measurereport-category.md)

### Examples

* [ra-bundle01 (Bundle)](Bundle-ra-bundle01.md)
* [ra-condition01pat03 (Condition)](Condition-ra-condition01pat03.md)
* [ra-condition02pat01 (Condition)](Condition-ra-condition02pat01.md)
* [ra-condition03pat01 (Condition)](Condition-ra-condition03pat01.md)
* [ra-condition04pat03 (Condition)](Condition-ra-condition04pat03.md)
* [ra-condition05pat03 (Condition)](Condition-ra-condition05pat03.md)
* [ra-condition06pat03 (Condition)](Condition-ra-condition06pat03.md)
* [ra-condition07pat03 (Condition)](Condition-ra-condition07pat03.md)
* [ra-condition08pat01 (Condition)](Condition-ra-condition08pat01.md)
* [ra-condition09pat01 (Condition)](Condition-ra-condition09pat01.md)
* [ra-condition10pat01 (Condition)](Condition-ra-condition10pat01.md)
* [ra-condition11pat01 (Condition)](Condition-ra-condition11pat01.md)
* [ra-condition12pat01 (Condition)](Condition-ra-condition12pat01.md)
* [ra-condition15pat03 (Condition)](Condition-ra-condition15pat03.md)
* [ra-condition16pat03 (Condition)](Condition-ra-condition16pat03.md)
* [ra-condition17pat01 (Condition)](Condition-ra-condition17pat01.md)
* [ra-condition18pat01 (Condition)](Condition-ra-condition18pat01.md)
* [ra-condition21pat03 (Condition)](Condition-ra-condition21pat03.md)
* [ra-condition22pat03 (Condition)](Condition-ra-condition22pat03.md)
* [ra-condition23pat03 (Condition)](Condition-ra-condition23pat03.md)
* [ra-condition31pat02 (Condition)](Condition-ra-condition31pat02.md)
* [ra-condition32pat03 (Condition)](Condition-ra-condition32pat03.md)
* [ra-condition33pat01 (Condition)](Condition-ra-condition33pat01.md)
* [ra-condition35pat03 (Condition)](Condition-ra-condition35pat03.md)
* [ra-condition42pat03 (Condition)](Condition-ra-condition42pat03.md)
* [ra-condition43pat01 (Condition)](Condition-ra-condition43pat01.md)
* [ra-condition44pat01 (Condition)](Condition-ra-condition44pat01.md)
* [ra-conditionR01pat01 (Condition)](Condition-ra-conditionR01pat01.md)
* [ra-documentreference01pat01 (DocumentReference)](DocumentReference-ra-documentreference01pat01.md)
* [ra-encounter01pat03 (Encounter)](Encounter-ra-encounter01pat03.md)
* [ra-encounter02pat01 (Encounter)](Encounter-ra-encounter02pat01.md)
* [ra-encounter03pat01 (Encounter)](Encounter-ra-encounter03pat01.md)
* [ra-encounter04pat03 (Encounter)](Encounter-ra-encounter04pat03.md)
* [ra-encounter05pat03 (Encounter)](Encounter-ra-encounter05pat03.md)
* [ra-encounter06pat03 (Encounter)](Encounter-ra-encounter06pat03.md)
* [ra-encounter07pat03 (Encounter)](Encounter-ra-encounter07pat03.md)
* [ra-encounter08pat01 (Encounter)](Encounter-ra-encounter08pat01.md)
* [ra-encounter09pat01 (Encounter)](Encounter-ra-encounter09pat01.md)
* [ra-encounter11pat01 (Encounter)](Encounter-ra-encounter11pat01.md)
* [ra-encounter15pat03 (Encounter)](Encounter-ra-encounter15pat03.md)
* [ra-encounter16pat03 (Encounter)](Encounter-ra-encounter16pat03.md)
* [ra-encounter19pat03 (Encounter)](Encounter-ra-encounter19pat03.md)
* [ra-encounter21pat03 (Encounter)](Encounter-ra-encounter21pat03.md)
* [ra-encounter22pat03 (Encounter)](Encounter-ra-encounter22pat03.md)
* [ra-encounter31pat02 (Encounter)](Encounter-ra-encounter31pat02.md)
* [ra-encounter35pat03 (Encounter)](Encounter-ra-encounter35pat03.md)
* [ra-encounter42pat03 (Encounter)](Encounter-ra-encounter42pat03.md)
* [ra-encounter43pat01 (Encounter)](Encounter-ra-encounter43pat01.md)
* [ra-encounter44pat01 (Encounter)](Encounter-ra-encounter44pat01.md)
* [ra-encounter45pat01 (Encounter)](Encounter-ra-encounter45pat01.md)
* [ra-encounter46pat01 (Encounter)](Encounter-ra-encounter46pat01.md)
* [ra-group01 (Group)](Group-ra-group01.md)
* [ra-group02 (Group)](Group-ra-group02.md)
* [Risk Adjustment Model Version 24 - CMS Hierarchical Category Condition (CMS-HCC) (Measure)](Measure-RAModelExample01.md)
* [Risk Adjustment Model Version 21 - CMS Hierarchical Category Condition (CMS-HCC) (Measure)](Measure-RAModelExample02.md)
* [Risk Adjustment Model Version 5 - CMS Prescribing Drug Hierarchical Category Condition (CMS-RxHCC) (Measure)](Measure-RAModelExample03.md)
* [ra-datax-measurereport01 (MeasureReport)](MeasureReport-ra-datax-measurereport01.md)
* [ra-measurereport01-with-remark (MeasureReport)](MeasureReport-ra-measurereport01-with-remark.md)
* [ra-measurereport01 (MeasureReport)](MeasureReport-ra-measurereport01.md)
* [ra-measurereport02 (MeasureReport)](MeasureReport-ra-measurereport02.md)
* [ra-measurereport03 (MeasureReport)](MeasureReport-ra-measurereport03.md)
* [ra-measurereport04 (MeasureReport)](MeasureReport-ra-measurereport04.md)
* [ra-measurereport05 (MeasureReport)](MeasureReport-ra-measurereport05.md)
* [ra-measurereport06 (MeasureReport)](MeasureReport-ra-measurereport06.md)
* [ra-obs01pat02 (Observation)](Observation-ra-obs01pat02.md)
* [ra-obs01pat03 (Observation)](Observation-ra-obs01pat03.md)
* [ra-obs02pat03 (Observation)](Observation-ra-obs02pat03.md)
* [ra-obs21pat01 (Observation)](Observation-ra-obs21pat01.md)
* [XYZ Laboratory (Organization)](Organization-ra-laboratory01.md)
* [Risk Adjustment Author (Organization)](Organization-ra-org-author.md)
* [Community Urgent Care (Organization)](Organization-ra-org01pat01.md)
* [GHH Outpatient Clinic (Organization)](Organization-ra-org02pat02.md)
* [Community HealthCenter (Organization)](Organization-ra-org03pat03.md)
* [ABC Payer (Organization)](Organization-ra-payer01.md)
* [Best RA Vendor (Organization)](Organization-ra-vendor01.md)
* [ra-measurereport01-patch-mult (Parameters)](Parameters-ra-measurereport01-patch-mult.md)
* [ra-measurereport01-patch (Parameters)](Parameters-ra-measurereport01-patch.md)
* [ra-submit-data (Parameters)](Parameters-ra-submit-data.md)
* [ra-patient01 (Patient)](Patient-ra-patient01.md)
* [ra-patient02 (Patient)](Patient-ra-patient02.md)
* [ra-patient03 (Patient)](Patient-ra-patient03.md)
* [ra-prac01pat01 (Practitioner)](Practitioner-ra-prac01pat01.md)
* [ra-prac02pat02 (Practitioner)](Practitioner-ra-prac02pat02.md)
* [ra-prac03pat03 (Practitioner)](Practitioner-ra-prac03pat03.md)
