# Home - Da Vinci Risk Adjustment Implementation Guide v2.1.0

* [**Table of Contents**](toc.md)
* **Home**

## Home

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-ra/ImplementationGuide/hl7.fhir.us.davinci-ra | *Version*:2.1.0 | |
| *IG Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:RiskAdjustment |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.29 | | |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License | | |

* New [operations](operations.md) under development since the STU 2.1 publication

### Summary

The Da Vinci Fast Healthcare Interoperability Resource (FHIR) Risk Adjustment Implementation Guide (IG) describes exchanging risk adjustment coding gaps between payers and providers. Risk adjusted premium calculations are important to government managed care. To better inform providers of opportunities to address risk adjusted conditions, better enable payers to communicate risk adjustment information, and enhance government sponsors' ability to allocate funding accurately, payers and providers need a standard protocol to share and receive clinical data related to risk adjustment and a standard methodology to communicate risk based coding, documentation and submission status of chronic conditions. The first Standard for Trial Use (STU) version of this implementation guide focused on the standard exchange format of risk adjustment coding gaps from payers to providers, it offers potential for reducing the administrative burden experienced by providers by standardizing the reporting they receive from all payers.

This version of the implementation guide focuses primarily on the communication from providers back to payers. It focuses on two forms of communication:

* Allowing the provider, a risk adjustment coder or the provider's EMR to add a Condition Category Remark to the Risk Adjustment Coding Gap Report. Providers and risk adjustment coders may indicate that a gap was closed, invalidated, not appropriate at this time, etc. It also allows for the EMR to notify the payer when the content could not be processed. Note that where appropriate, the payer or an entity acting on behalf of the payer can also add a remark to the Risk Adjustment Coding Gap Report.
* A Risk Adjustment Data Exchange MeasureReport was added to allow the provider to return data to the payer to potentially close the Condition Category code gaps. We anticipate this could be used to submit Consolidated Clinical Document Architecture documents such as the Continuity of Care Document (CCD), Progress Notes, etc. It can also be used to submit specific FHIR data if appropriate.

This version also introduces the draft content for digital Condition Category (dCC). It describes how to specify dCCs, using Clinical Quality Language (CQL), through an example which would allow for a more automated process of generating risk adjustment coding gap reports by evaluating dCCs against clinical data.

This implementation guide is supported by the Da Vinci initiative which is a private effort to accelerate the adoption of Health Level Seven International Fast Healthcare Interoperability Resources (HL7® FHIR®) as the standard to support and integrate value-based care (VBC) data exchange across communities. Like all Da Vinci Implementation Guides, it follows the [HL7 Da Vinci Guiding Principles](https://confluence.hl7.org/display/DVP/Da+Vinci+Clinical+Advisory+Council+Members?preview=/66940155/66942916/Guiding%20Principles%20for%20Da%20Vinci%20Implementation%20Guides.pdf) for the exchange of patient health information. As an HL7 FHIR Implementation Guide, changes to this specification are managed by the sponsoring [Clinical Quality Information (CQI) Work Group](http://www.hl7.org/Special/committees/cqi/overview.cfm) and are incorporated as part of the standard balloting process.

### Content and Organization

The main menu shown at the top of each page is categorized into several primary topics with several sub-topics:

* **[Home](index.md)**: The home page provides a high-level summary of this IG and background information about risk adjustment for revenue normalization.
* **Background**: These pages provide background information to this IG. 
* [FHIR Introduction](fhir.md) highlights the key sections of the FHIR core specification that Da Vinci implementers should be familiar with.
* [Background - Risk Adjustment](background.md) provides background information about risk adjustment for revenue normalization, risk adjustment models, scope of this IG, and etc.
* [Participants and Credits](credits.md) provides thanks to key contributors to the creation of this guide.
* [Glossary](glossary.md) lists glossary and acronyms for this guide.
 
* **Specification**: These pages provide guidance on the resource profiles and operation defined in this IG. 
* [General Guidance](general-guidance.md) provides guidance that applies to all functionalities in this IG.
* [Report Generation](report-generation.md) describes how generating a Risk Adjustment Coding Gap Report is accomplished.
* [Report Query](report-query.md) provides guidance on using query to return a Risk Adjustment Coding Gap Report(s) and their evaluated resources.
* [Submit Data to Payer](submit-data-to-payer.md) provides guidance on submitting clinical evaluation evidence to Payer for the purpose of evaluating risk adjustment coding gaps using [$submit-data](https://www.hl7.org/fhir/measure-operation-submit-data.html) and [Risk Adjustment Data Exchange MeasureReport](StructureDefinition-ra-datax-measurereport.md).
* [Add Remark to Condition Category](cc-remark.md) describes how providers can add remarks to Condition Categories on the Risk Adjustment Coding Gap Report to note that they took actions while seeing the patient.
* [Digital Condition Category (dCC)](dcc.md) includes draft content describing how a Condition Category can be structured as a proportion measure and be specified using CQL as a digital Condition Category in a similar fashion to electronic quality measures through an example.
* [Security, Privacy, and Safety](security.md) provides general expectations to ensure security and privacy of exchanges
 
* **FHIR Artifacts**: These pages list FHIR artifacts specified in this IG. 
* [Artifacts Summary](artifacts.md) shows a complete list of FHIR artifacts defined in this IG.
* [Profiles](profiles.md) lists the set of Profiles that are defined in this IG to exchange risk adjustment coding gaps.
* [Extensions](extensions.md) lists the set of Extensions that are defined in this IG to exchange risk adjustment coding gaps.
* [Search Parameters](search-parameters.md) lists Search Parameter defined in this IG.
* [Operations](operations.md) lists operations defined in this IG.
* [Terminology](terminology.md) lists code systems and value sets defined in this IG.
* [Capability statements](capabilities.md) describes the expected FHIR capabilities of the risk adjustment actors of this IG.
* [Examples](examples.md) lists all the examples used in this IG.
 
* **Base Specs** includes links to the FHIR core specification as well as the US Core specs that underlie this IG.
* **Support** includes various links for support and guidance, as well as [Downloads](downloads.md) links for this IG and guidance on tools and support for Da Vinci implementers.

### Dependencies

At present, the Risk Adjustment IG is based on [FHIR R4](http://hl7.org/fhir/R4/). In addition, this guide also relies on a number of parent implementation guides:

This implementation guide defines additional constraints and usage expectations above and beyond the information found in these base specifications.

As seen in the above table, this implementation guide is dependent on the [US Core 3.1 (FHIR R4)](http://hl7.org/fhir/us/core/STU3.1.1), [US Core 6.1 (FHIR R4)](http://hl7.org/fhir/us/core/STU6.1) and [US Core 7.0 (FHIR R4)](http://hl7.org/fhir/us/core/STU7) implementation guides. The first is supported for those systems limited to [United States Core Data for Interoperability (USCDI) v1](https://www.healthit.gov/isp/united-states-core-data-interoperability-uscdi) capabilities, the second is for upcoming regulatory requirements mandating support for [USCDI v3](https://www.healthit.gov/isp/united-states-core-data-interoperability-uscdi#uscdi-v3), and the last is to enable support for proposed regulations mandating support for [USCDI v4](https://www.healthit.gov/isp/united-states-core-data-interoperability-uscdi#uscdi-v4). Wherever possible, Da Vinci profiles strive to comply with all three releases, simplifying implementation for those who will need to support varying regulatory expectations over time.

### Intellectual Property Considerations

This implementation guide and the underlying FHIR specification are licensed as public domain under the [FHIR license](http://hl7.org/fhir/R4/license.html#license). The license page also describes rules for the use of the FHIR name and logo.

This publication includes IP covered under the following statements.

* ISO maintains the copyright on the country codes, and controls its use carefully. For further details see the ISO 3166 web page: [https://www.iso.org/iso-3166-country-codes.html](https://www.iso.org/iso-3166-country-codes.html)

* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](http://terminology.hl7.org/5.5.0/CodeSystem-ISO3166Part1.html): [CCRemarkPatchParameters](StructureDefinition-ra-parameters-cc-remark-patch.md), [CCType](StructureDefinition-ra-ccType.md)...Show 36 more,[CodingGapRemark](ValueSet-coding-gap-remark.md),[ConditionCategoryRemark](StructureDefinition-ra-ccRemark.md),[ConfidenceScale](ValueSet-confidence-scale.md),[ContextId](StructureDefinition-ra-contextId.md),[DxCode](StructureDefinition-ra-dxCode.md),[EvidenceStatus](StructureDefinition-ra-evidenceStatus.md),[GroupReference](StructureDefinition-ra-groupReference.md),[HierarchicalStatus](StructureDefinition-ra-hierarchicalStatus.md),[MeasureReportCategory](SearchParameter-measurereport-category.md),[PatientGroup](StructureDefinition-ra-patient-group.md),[PayerCodingGapReportId](StructureDefinition-ra-payerCodingGapReportId.md),[QualifyingCode](StructureDefinition-ra-qualifyingDxCode.md),[RAClientCapabilityStatement](CapabilityStatement-ra-reporting-client.md),[RAClinicalDataCollectionDeadline](StructureDefinition-ra-clinicalDataCollectionDeadline.md),[RAClinicalEvidenceStatusDate](StructureDefinition-ra-evidenceStatusDate.md),[RADataSubmissionClientCapabilityStatement](CapabilityStatement-ra-data-submission-client.md),[RADataSubmissionServerCapabilityStatement](CapabilityStatement-ra-data-submission-server.md),[RAEvaluateMeasure](OperationDefinition-ra.evaluate-measure.md),[RAMeasureReportBundle](StructureDefinition-ra-measurereport-bundle.md),[RAModelExample01](Measure-RAModelExample01.md),[RAModelExample02](Measure-RAModelExample02.md),[RAModelExample03](Measure-RAModelExample03.md),[RAServerCapabilityStatement](CapabilityStatement-ra-reporting-server.md),[RemarkReason](ValueSet-remark-reason.md),[ReportingVendor](StructureDefinition-ra-reportingVendor.md),[RiskAdjustment](index.md),[RiskAdjustmentCodingGapMeasureReport](StructureDefinition-ra-measurereport.md),[RiskAdjustmentConditionCategoryType](ValueSet-cc-type.md),[RiskAdjustmentDataExchangeMeasureReport](StructureDefinition-ra-datax-measurereport.md),[RiskAdjustmentEvidenceStatus](ValueSet-evidence-status.md),[RiskAdjustmentMeasureReportRemarkBundle](StructureDefinition-ra-measurereport-remark-bundle.md),[RiskAdjustmentModelMeasure](StructureDefinition-ra-model-measure.md),[RiskAdjustmenthierarchicalStatus](ValueSet-hierarchical-status.md),[RiskGap](OperationDefinition-risk-gap.md),[SampleCMSHCC](ValueSet-sample-cmshcc.md)and[SubmitRemarkData](OperationDefinition-submit-remark-data.md)


* The UCUM codes, UCUM table (regardless of format), and UCUM Specification are copyright 1999-2009, Regenstrief Institute, Inc. and the Unified Codes for Units of Measures (UCUM) Organization. All rights reserved. [https://ucum.org/trac/wiki/TermsOfUse](https://ucum.org/trac/wiki/TermsOfUse)

* [Unified Code for Units of Measure (UCUM)](http://terminology.hl7.org/5.5.0/CodeSystem-v3-ucum.html): [Bundle/ra-bundle01](Bundle-ra-bundle01.md), [Observation/ra-obs01pat02](Observation-ra-obs01pat02.md), [Observation/ra-obs01pat03](Observation-ra-obs01pat03.md) and [Observation/ra-obs21pat01](Observation-ra-obs21pat01.md)


* This material contains content from [LOINC](http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the [license](http://loinc.org/license). LOINC® is a registered United States trademark of Regenstrief Institute, Inc.

* [LOINC](http://terminology.hl7.org/5.5.0/CodeSystem-v3-loinc.html): [Bundle/ra-bundle01](Bundle-ra-bundle01.md), [DocumentReference/ra-documentreference01pat01](DocumentReference-ra-documentreference01pat01.md)...Show 5 more,[Observation/ra-obs01pat02](Observation-ra-obs01pat02.md),[Observation/ra-obs01pat03](Observation-ra-obs01pat03.md),[Observation/ra-obs02pat03](Observation-ra-obs02pat03.md),[Observation/ra-obs21pat01](Observation-ra-obs21pat01.md)and[Parameters/ra-submit-data](Parameters-ra-submit-data.md)


* This material contains content that is copyright of SNOMED International. Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information contact [https://www.snomed.org/get-snomed](https://www.snomed.org/get-snomed) or [info@snomed.org](mailto:info@snomed.org).

* [SNOMED Clinical Terms&reg; (SNOMED CT&reg;)](http://hl7.org/fhir/R4/codesystem-snomedct.html): [ConfidenceScale](ValueSet-confidence-scale.md), [DxCode](StructureDefinition-ra-dxCode.md), [MeasureReport/ra-measurereport01](MeasureReport-ra-measurereport01.md) and [MeasureReport/ra-measurereport01-with-remark](MeasureReport-ra-measurereport01-with-remark.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [Condition Category Codes](http://terminology.hl7.org/7.0.0/CodeSystem-condition-category.html): [Bundle/ra-bundle01](Bundle-ra-bundle01.md), [Condition/ra-condition01pat03](Condition-ra-condition01pat03.md)...Show 26 more,[Condition/ra-condition02pat01](Condition-ra-condition02pat01.md),[Condition/ra-condition03pat01](Condition-ra-condition03pat01.md),[Condition/ra-condition04pat03](Condition-ra-condition04pat03.md),[Condition/ra-condition05pat03](Condition-ra-condition05pat03.md),[Condition/ra-condition06pat03](Condition-ra-condition06pat03.md),[Condition/ra-condition07pat03](Condition-ra-condition07pat03.md),[Condition/ra-condition08pat01](Condition-ra-condition08pat01.md),[Condition/ra-condition09pat01](Condition-ra-condition09pat01.md),[Condition/ra-condition10pat01](Condition-ra-condition10pat01.md),[Condition/ra-condition11pat01](Condition-ra-condition11pat01.md),[Condition/ra-condition12pat01](Condition-ra-condition12pat01.md),[Condition/ra-condition15pat03](Condition-ra-condition15pat03.md),[Condition/ra-condition16pat03](Condition-ra-condition16pat03.md),[Condition/ra-condition17pat01](Condition-ra-condition17pat01.md),[Condition/ra-condition18pat01](Condition-ra-condition18pat01.md),[Condition/ra-condition21pat03](Condition-ra-condition21pat03.md),[Condition/ra-condition22pat03](Condition-ra-condition22pat03.md),[Condition/ra-condition23pat03](Condition-ra-condition23pat03.md),[Condition/ra-condition31pat02](Condition-ra-condition31pat02.md),[Condition/ra-condition32pat03](Condition-ra-condition32pat03.md),[Condition/ra-condition33pat01](Condition-ra-condition33pat01.md),[Condition/ra-condition35pat03](Condition-ra-condition35pat03.md),[Condition/ra-condition42pat03](Condition-ra-condition42pat03.md),[Condition/ra-condition43pat01](Condition-ra-condition43pat01.md),[Condition/ra-condition44pat01](Condition-ra-condition44pat01.md)and[Condition/ra-conditionR01pat01](Condition-ra-conditionR01pat01.md)
* [Condition Clinical Status Codes](http://terminology.hl7.org/7.0.0/CodeSystem-condition-clinical.html): [Bundle/ra-bundle01](Bundle-ra-bundle01.md), [Condition/ra-condition01pat03](Condition-ra-condition01pat03.md)...Show 26 more,[Condition/ra-condition02pat01](Condition-ra-condition02pat01.md),[Condition/ra-condition03pat01](Condition-ra-condition03pat01.md),[Condition/ra-condition04pat03](Condition-ra-condition04pat03.md),[Condition/ra-condition05pat03](Condition-ra-condition05pat03.md),[Condition/ra-condition06pat03](Condition-ra-condition06pat03.md),[Condition/ra-condition07pat03](Condition-ra-condition07pat03.md),[Condition/ra-condition08pat01](Condition-ra-condition08pat01.md),[Condition/ra-condition09pat01](Condition-ra-condition09pat01.md),[Condition/ra-condition10pat01](Condition-ra-condition10pat01.md),[Condition/ra-condition11pat01](Condition-ra-condition11pat01.md),[Condition/ra-condition12pat01](Condition-ra-condition12pat01.md),[Condition/ra-condition15pat03](Condition-ra-condition15pat03.md),[Condition/ra-condition16pat03](Condition-ra-condition16pat03.md),[Condition/ra-condition17pat01](Condition-ra-condition17pat01.md),[Condition/ra-condition18pat01](Condition-ra-condition18pat01.md),[Condition/ra-condition21pat03](Condition-ra-condition21pat03.md),[Condition/ra-condition22pat03](Condition-ra-condition22pat03.md),[Condition/ra-condition23pat03](Condition-ra-condition23pat03.md),[Condition/ra-condition31pat02](Condition-ra-condition31pat02.md),[Condition/ra-condition32pat03](Condition-ra-condition32pat03.md),[Condition/ra-condition33pat01](Condition-ra-condition33pat01.md),[Condition/ra-condition35pat03](Condition-ra-condition35pat03.md),[Condition/ra-condition42pat03](Condition-ra-condition42pat03.md),[Condition/ra-condition43pat01](Condition-ra-condition43pat01.md),[Condition/ra-condition44pat01](Condition-ra-condition44pat01.md)and[Condition/ra-conditionR01pat01](Condition-ra-conditionR01pat01.md)
* [ConditionVerificationStatus](http://terminology.hl7.org/7.0.0/CodeSystem-condition-ver-status.html): [Bundle/ra-bundle01](Bundle-ra-bundle01.md), [Condition/ra-condition01pat03](Condition-ra-condition01pat03.md)...Show 26 more,[Condition/ra-condition02pat01](Condition-ra-condition02pat01.md),[Condition/ra-condition03pat01](Condition-ra-condition03pat01.md),[Condition/ra-condition04pat03](Condition-ra-condition04pat03.md),[Condition/ra-condition05pat03](Condition-ra-condition05pat03.md),[Condition/ra-condition06pat03](Condition-ra-condition06pat03.md),[Condition/ra-condition07pat03](Condition-ra-condition07pat03.md),[Condition/ra-condition08pat01](Condition-ra-condition08pat01.md),[Condition/ra-condition09pat01](Condition-ra-condition09pat01.md),[Condition/ra-condition10pat01](Condition-ra-condition10pat01.md),[Condition/ra-condition11pat01](Condition-ra-condition11pat01.md),[Condition/ra-condition12pat01](Condition-ra-condition12pat01.md),[Condition/ra-condition15pat03](Condition-ra-condition15pat03.md),[Condition/ra-condition16pat03](Condition-ra-condition16pat03.md),[Condition/ra-condition17pat01](Condition-ra-condition17pat01.md),[Condition/ra-condition18pat01](Condition-ra-condition18pat01.md),[Condition/ra-condition21pat03](Condition-ra-condition21pat03.md),[Condition/ra-condition22pat03](Condition-ra-condition22pat03.md),[Condition/ra-condition23pat03](Condition-ra-condition23pat03.md),[Condition/ra-condition31pat02](Condition-ra-condition31pat02.md),[Condition/ra-condition32pat03](Condition-ra-condition32pat03.md),[Condition/ra-condition33pat01](Condition-ra-condition33pat01.md),[Condition/ra-condition35pat03](Condition-ra-condition35pat03.md),[Condition/ra-condition42pat03](Condition-ra-condition42pat03.md),[Condition/ra-condition43pat01](Condition-ra-condition43pat01.md),[Condition/ra-condition44pat01](Condition-ra-condition44pat01.md)and[Condition/ra-conditionR01pat01](Condition-ra-conditionR01pat01.md)
* [Observation Category Codes](http://terminology.hl7.org/7.0.0/CodeSystem-observation-category.html): [Bundle/ra-bundle01](Bundle-ra-bundle01.md), [Observation/ra-obs01pat02](Observation-ra-obs01pat02.md), [Observation/ra-obs01pat03](Observation-ra-obs01pat03.md), [Observation/ra-obs02pat03](Observation-ra-obs02pat03.md) and [Observation/ra-obs21pat01](Observation-ra-obs21pat01.md)
* [Organization type](http://terminology.hl7.org/7.0.0/CodeSystem-organization-type.html): [ABC Payer](Organization-ra-payer01.md), [Best RA Vendor](Organization-ra-vendor01.md)...Show 5 more,[Community HealthCenter](Organization-ra-org03pat03.md),[Community Urgent Care](Organization-ra-org01pat01.md),[GHH Outpatient Clinic](Organization-ra-org02pat02.md),[Risk Adjustment Author](Organization-ra-org-author.md)and[XYZ Laboratory](Organization-ra-laboratory01.md)
* [Observation Reference Range Meaning Codes](http://terminology.hl7.org/7.0.0/CodeSystem-referencerange-meaning.html): [Bundle/ra-bundle01](Bundle-ra-bundle01.md), [Observation/ra-obs01pat02](Observation-ra-obs01pat02.md), [Observation/ra-obs01pat03](Observation-ra-obs01pat03.md) and [Observation/ra-obs21pat01](Observation-ra-obs21pat01.md)
* [identifierType](http://terminology.hl7.org/7.0.0/CodeSystem-v2-0203.html): [Bundle/ra-bundle01](Bundle-ra-bundle01.md), [Parameters/ra-submit-data](Parameters-ra-submit-data.md), [Patient/ra-patient01](Patient-ra-patient01.md), [Patient/ra-patient02](Patient-ra-patient02.md) and [Patient/ra-patient03](Patient-ra-patient03.md)
* [ActCode](http://terminology.hl7.org/7.0.0/CodeSystem-v3-ActCode.html): [Bundle/ra-bundle01](Bundle-ra-bundle01.md), [Encounter/ra-encounter01pat03](Encounter-ra-encounter01pat03.md)...Show 21 more,[Encounter/ra-encounter02pat01](Encounter-ra-encounter02pat01.md),[Encounter/ra-encounter03pat01](Encounter-ra-encounter03pat01.md),[Encounter/ra-encounter04pat03](Encounter-ra-encounter04pat03.md),[Encounter/ra-encounter05pat03](Encounter-ra-encounter05pat03.md),[Encounter/ra-encounter06pat03](Encounter-ra-encounter06pat03.md),[Encounter/ra-encounter07pat03](Encounter-ra-encounter07pat03.md),[Encounter/ra-encounter08pat01](Encounter-ra-encounter08pat01.md),[Encounter/ra-encounter09pat01](Encounter-ra-encounter09pat01.md),[Encounter/ra-encounter11pat01](Encounter-ra-encounter11pat01.md),[Encounter/ra-encounter15pat03](Encounter-ra-encounter15pat03.md),[Encounter/ra-encounter16pat03](Encounter-ra-encounter16pat03.md),[Encounter/ra-encounter19pat03](Encounter-ra-encounter19pat03.md),[Encounter/ra-encounter21pat03](Encounter-ra-encounter21pat03.md),[Encounter/ra-encounter22pat03](Encounter-ra-encounter22pat03.md),[Encounter/ra-encounter31pat02](Encounter-ra-encounter31pat02.md),[Encounter/ra-encounter35pat03](Encounter-ra-encounter35pat03.md),[Encounter/ra-encounter42pat03](Encounter-ra-encounter42pat03.md),[Encounter/ra-encounter43pat01](Encounter-ra-encounter43pat01.md),[Encounter/ra-encounter44pat01](Encounter-ra-encounter44pat01.md),[Encounter/ra-encounter45pat01](Encounter-ra-encounter45pat01.md)and[Encounter/ra-encounter46pat01](Encounter-ra-encounter46pat01.md)
* [MaritalStatus](http://terminology.hl7.org/7.0.0/CodeSystem-v3-MaritalStatus.html): [Bundle/ra-bundle01](Bundle-ra-bundle01.md), [Parameters/ra-submit-data](Parameters-ra-submit-data.md), [Patient/ra-patient01](Patient-ra-patient01.md), [Patient/ra-patient02](Patient-ra-patient02.md) and [Patient/ra-patient03](Patient-ra-patient03.md)


* Used by permission of HL7 International, all rights reserved Creative Commons License

* [US Core DocumentReferences Category Codes](http://hl7.org/fhir/us/core/STU7/CodeSystem-us-core-documentreference-category.html): [DocumentReference/ra-documentreference01pat01](DocumentReference-ra-documentreference01pat01.md) and [Parameters/ra-submit-data](Parameters-ra-submit-data.md)
* [Risk Adjustment Condition Category Type Codes](CodeSystem-cc-type.md): [Bundle/ra-bundle01](Bundle-ra-bundle01.md), [CCType](StructureDefinition-ra-ccType.md)...Show 9 more,[MeasureReport/ra-measurereport01](MeasureReport-ra-measurereport01.md),[MeasureReport/ra-measurereport01-with-remark](MeasureReport-ra-measurereport01-with-remark.md),[MeasureReport/ra-measurereport02](MeasureReport-ra-measurereport02.md),[MeasureReport/ra-measurereport03](MeasureReport-ra-measurereport03.md),[MeasureReport/ra-measurereport04](MeasureReport-ra-measurereport04.md),[MeasureReport/ra-measurereport05](MeasureReport-ra-measurereport05.md),[MeasureReport/ra-measurereport06](MeasureReport-ra-measurereport06.md),[RiskAdjustmentConditionCategoryType](ValueSet-cc-type.md)and[RiskGap](OperationDefinition-risk-gap.md)
* [Coding Gap Remark Codes](CodeSystem-coding-gap-remark.md): [CodingGapRemark](ValueSet-coding-gap-remark.md), [ConditionCategoryRemark](StructureDefinition-ra-ccRemark.md) and [MeasureReport/ra-measurereport01-with-remark](MeasureReport-ra-measurereport01-with-remark.md)
* [Risk Adjustment Evidence Status Codes](CodeSystem-evidence-status.md): [Bundle/ra-bundle01](Bundle-ra-bundle01.md), [EvidenceStatus](StructureDefinition-ra-evidenceStatus.md)...Show 9 more,[MeasureReport/ra-measurereport01](MeasureReport-ra-measurereport01.md),[MeasureReport/ra-measurereport01-with-remark](MeasureReport-ra-measurereport01-with-remark.md),[MeasureReport/ra-measurereport02](MeasureReport-ra-measurereport02.md),[MeasureReport/ra-measurereport03](MeasureReport-ra-measurereport03.md),[MeasureReport/ra-measurereport04](MeasureReport-ra-measurereport04.md),[MeasureReport/ra-measurereport05](MeasureReport-ra-measurereport05.md),[MeasureReport/ra-measurereport06](MeasureReport-ra-measurereport06.md),[RiskAdjustmentEvidenceStatus](ValueSet-evidence-status.md)and[RiskGap](OperationDefinition-risk-gap.md)
* [Risk Adjustment Hierarchical Status Codes](CodeSystem-hierarchical-status.md): [Bundle/ra-bundle01](Bundle-ra-bundle01.md), [HierarchicalStatus](StructureDefinition-ra-hierarchicalStatus.md)...Show 8 more,[MeasureReport/ra-measurereport01](MeasureReport-ra-measurereport01.md),[MeasureReport/ra-measurereport01-with-remark](MeasureReport-ra-measurereport01-with-remark.md),[MeasureReport/ra-measurereport02](MeasureReport-ra-measurereport02.md),[MeasureReport/ra-measurereport03](MeasureReport-ra-measurereport03.md),[MeasureReport/ra-measurereport04](MeasureReport-ra-measurereport04.md),[MeasureReport/ra-measurereport05](MeasureReport-ra-measurereport05.md),[MeasureReport/ra-measurereport06](MeasureReport-ra-measurereport06.md)and[RiskAdjustmenthierarchicalStatus](ValueSet-hierarchical-status.md)
* [Remark Reason Codes](CodeSystem-remark-reason.md): [ConditionCategoryRemark](StructureDefinition-ra-ccRemark.md) and [RemarkReason](ValueSet-remark-reason.md)


-------

