# Capability Statements - Da Vinci Risk Adjustment Implementation Guide v2.1.0

* [**Table of Contents**](toc.md)
* **Capability Statements**

## Capability Statements

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

* [Risk Adjustment Reporting Client Capability Statement](CapabilityStatement-ra-reporting-client.md)

This profile defines the expected capabilities of a Da Vinci Risk Adjustment Reporting Client when conforming to the Da Vinci Risk Adjustment Implementation Guide for interactions between Reporting Clients and Reporting Servers. Clients are the actors making the request for Risk Adjustment Coding Gap Reports for patient(s) and for Risk Adjustment Models that are available on the Server.

* [Risk Adjustment Reporting Server Capability Statement](CapabilityStatement-ra-reporting-server.md)

This profile defines the expected capabilities of a Da Vinci Risk Adjustment Reporting Server when conforming to the Da Vinci Risk Adjustment Implementation Guide for interactions between Reporting Clients and Reporting Servers. Servers are the actors receiving the request for Risk Adjustment Coding Gap Reports for patient(s) and for Risk Adjustment Models that are available on the Server.

* [Risk Adjustment Data Submission Client Capability Statement](CapabilityStatement-ra-data-submission-client.md)

This profile defines the expected capabilities of a Da Vinci Risk Adjustment Data Submission Client when conforming to the Da Vinci Risk Adjustment Implementation Guide for interactions between Data Submission Clients and Data Submission Servers. Clients are the actors creating and submitting the Risk Adjustment Data Exchange Measure Reports using the $submit-data operation to the Server.

* [Risk Adjustment Data Submission Server Capability Statement](CapabilityStatement-ra-data-submission-server.md)

This profile defines the expected capabilities of a Da Vinci Risk Adjustment Data Submission Server when conforming to the Da Vinci Risk Adjustment Implementation Guide for interactions between Clients and Servers. Servers are the actors receiving and processing the Risk Adjustment Data Exchange MeasureReports submitted by the Client.

