# Artifacts Summary - Da Vinci Risk Adjustment Implementation Guide v2.1.0

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

## Artifacts Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Behavior: Capability Statements 

The following artifacts define the specific capabilities that different types of systems are expected to have in order to comply with this implementation guide. Systems conforming to this implementation guide are expected to declare conformance to one or more of the following capability statements.

| | |
| :--- | :--- |
| [Risk Adjustment Data Submission Client Capability Statement](CapabilityStatement-ra-data-submission-client.md) | This profile defines the expected capabilities of a Da Vinci Risk Adjustment Data Submission Client when conforming to the Da Vinci Risk Adjustment Implementation Guide for interactions between Data Submission Clients and Data Submission Servers. Clients are the actors creating and submitting the Risk Adjustment Data Exchange Measure Reports using the $submit-data operation to the Server. |
| [Risk Adjustment Data Submission Server Capability Statement](CapabilityStatement-ra-data-submission-server.md) | This profile defines the expected capabilities of a Da Vinci Risk Adjustment Data Submission Server when conforming to the Da Vinci Risk Adjustment Implementation Guide for interactions between Clients and Servers. Servers are the actors receiving and processing the Risk Adjustment Data Exchange MeasureReports submitted by the Client. |
| [Risk Adjustment Reporting Client Capability Statement](CapabilityStatement-ra-reporting-client.md) | This profile defines the expected capabilities of a Da Vinci Risk Adjustment Reporting Client when conforming to the Da Vinci Risk Adjustment Implementation Guide for interactions between Reporting Clients and Reporting Servers. Clients are the actors making the request for Risk Adjustment Coding Gap Reports for patient(s) and for Risk Adjustmenet Models that are available on the Server. This CapabilityStatement resource includes the complete list of the**recommended**Da Vinci Risk Adjustment profiles and RESTful operations that a Risk Adjustment Reporting Client could support. Clients have the option of choosing from this list based on their local use cases and other contextual requirements. |
| [Risk Adjustment Reporting Server Capability Statement](CapabilityStatement-ra-reporting-server.md) | This profile defines the expected capabilities of a Da Vinci Risk Adjustment Reporting Server when conforming to the Da Vinci Risk Adjustment Implementation Guide for interactions between Reporting Clients and Reporting Servers. Servers are the actors receiving the request for Risk Adjustment Coding Gap Reports for patient(s) and for Risk Adjustmenet Models that are available on the Server. This CapabilityStatement resource includes the complete list of the**recommended**Da Vinci Risk Adjustment profiles and RESTful operations that a Risk Adjustment Reporting Server could support. Servers have the option of choosing from this list based on their local use cases and other contextual requirements. |

### Behavior: Operation Definitions 

These are custom operations that can be supported by and/or invoked by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Evaluate Measure](OperationDefinition-ra.evaluate-measure.md) | The ra.evaluate-measure operation is used to evaluate Digital Condition Category and obtain the results. |
| [Risk Gap](OperationDefinition-risk-gap.md) | The risk-gap operation is used to determine condition Category (CC) gaps for a patient/member. |
| [Submit Remark Data](OperationDefinition-submit-remark-data.md) | A[Condition Category Remark](StructureDefinition-ra-ccRemark.md)may reference resources such as Pracitioner and Condition, using Patch to submit the remark may not be feasible. This operation is used to submit a Risk Adjustment Coding Gap Report with one or more ccRemarks on at least one of the Condition Categories, along with the relevant resources referenced by the ccRemark(s). |

### Behavior: Search Parameters 

These define the properties by which a RESTful server can be searched. They can also be used for sorting and including related resources.

| | |
| :--- | :--- |
| [MeasureReportCategory](SearchParameter-measurereport-category.md) | Search based on the measurereport-category extension |

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Patient Group](StructureDefinition-ra-patient-group.md) | The Patient Group Profile describes a group consisting of one or more patients. It can be used a) when generating risk adjustment gap reports using Bulk FHIR or b) for the evaluated-approach for generating reports as defined on the dCC page. |
| [RA Parameters ccRemark Patch Profile](StructureDefinition-ra-parameters-cc-remark-patch.md) | A Parameters profile that defines structures of multi-part Parameters to be used for sending[Condition Category Remarks](StructureDefinition-ra-ccRemark.md)to a[Risk Adjustment Coding Gap Report](StructureDefinition-ra-measurereport.md)using the[PATCH](https://www.hl7.org/fhir/http.html#patch)operation. |
| [Risk Adjustment Coding Gap MeasureReport](StructureDefinition-ra-measurereport.md) | This profile is based on the[MeasureReport](http://hl7.org/fhir/R4/measurereport.html)to represent a risk adjustment coding gap report. Payer runs risk adjustment engine and uses this profile to represent the risk adjustment Condition Category (CC) coding gaps and their detailed information for a patient. |
| [Risk Adjustment Coding Gap MeasureReport with Remark](StructureDefinition-ra-measurereport-with-remark.md) | This profile represents a risk adjustment coding gap report with condition categories and at least one of the condition category has one or more condition category remark(s). |
| [Risk Adjustment Coding Gap Report Bundle](StructureDefinition-ra-measurereport-bundle.md) | The Risk Adjustment Coding Gap Report Bundle Profile describes a collection bundle returned by the[$ra.evaluate-measure](OperationDefinition-ra.evaluate-measure.md)operation. This bundle is a collection of Risk Adjustment Coding Gap Reports. |
| [Risk Adjustment Data Exchange MeasureReport](StructureDefinition-ra-datax-measurereport.md) | This profile is based on the[MeasureReport](http://hl7.org/fhir/R4/measurereport.html). It is used for Provider to submit data such as clinical evaluation evidence to Payer. |
| [Risk Adjustment MeasureReport With Remark Bundle](StructureDefinition-ra-measurereport-remark-bundle.md) | This bundle contains a Risk Adjustment Coding Gap MeasureReport that has Condition Category Remark (ccRemark) present on at least one of the Condition Categories. It also contains the relevant resources referenced by the ccRemark. |
| [Risk Adjustment Model Measure](StructureDefinition-ra-model-measure.md) | This risk adjustment model measure profile is based on the[Measure](http://hl7.org/fhir/R4/measure.html)resource to represent a risk adjustment model and its version, such as CMS-HCC version 24, CMS-HCC version 28. |

### Structures: Extension Definitions 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Clinical Data Collection Deadline Extension](StructureDefinition-ra-clinicalDataCollectionDeadline.md) | Indicates the deadline for collecting data to close Condition Category (CC) coding gaps for a risk adjustment model of a measurement period. |
| [Condition Category Remark Extension](StructureDefinition-ra-ccRemark.md) | The Condition Category Remark extension allows a coded and/or narrative remark be added to a Condition Category (CC) coding gap that is on a Payer generated risk adjustment coding gap report by a provider, an organization, or a software. |
| [Condition Category Type Extension](StructureDefinition-ra-ccType.md) | Indicates whether the Condition Category (CC) gap is historic or suspected. This extension is also used to indicate if a Condition Category (CC) is net-new. |
| [Confidence Scale Extension](StructureDefinition-ra-confidenceScale.md) | A coded confidence scale, the degree of certainty, for a Condition Category (CC) coding gap presented in a Payer generated risk adjustment coding gap report. |
| [Context Id Extension](StructureDefinition-ra-contextId.md) | The contextId is intended to be used for 'non-standard' identifiers provided as part of the $risk-gap operation API call, for example, some systems may have an internally defined gap-request-id. |
| [Diagnosis Code Extension](StructureDefinition-ra-dxCode.md) | Diganosis code(s) of the condition, such as ICD-10 codes. |
| [Evidence Status Date Extension](StructureDefinition-ra-evidenceStatusDate.md) | Risk adjustment evidence status date |
| [Evidence Status Extension](StructureDefinition-ra-evidenceStatus.md) | Indicates whether a Condition Category (CC) coding gap is closed-gap, open-gap, invalid-gap, or pending based on the clinical evidence available for risk adjustment. |
| [Group Reference Extension](StructureDefinition-ra-groupReference.md) | This extension identifies which Condition Category (CC) the supporting evidence (represented by`MeasureReport.evaluatedResource`) is for. |
| [Hierarchical Status Extension](StructureDefinition-ra-hierarchicalStatus.md) | Indicates how hiearchies were applied to a Condition Category (CC), and if applied, whether the Condition Category (CC) is superseded. |
| [Payer Coding Gap Report Id Extension](StructureDefinition-ra-payerCodingGapReportId.md) | Unique id of the original payer generated coding gap report. This is the MeasureReport.id from the Risk Adjustment Coding Gap Report profile. |
| [QualifyingCode Extension](StructureDefinition-ra-qualifyingDxCode.md) | Diagnosis code(s) classified under a Condition Category, as defined by the risk adjustment model. This usually comes into play in the scenario where proprietary risk models are used and the mappings of ICD-10 codes to Condition Categories are not readily available. Note that whether qualifying codes may be included in a report depending may depend on individual Risk Adjustment model licensing agreement. |
| [Reporting Vendor Extension](StructureDefinition-ra-reportingVendor.md) | A reference to the vendor who generated the report. The 'reporting vendor' is intended to represent the submitting entity when it is not the same as the reporting entity. This extension is used when the Receiver is interested in getting vendor information in the report. |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Coding Gap Remark](ValueSet-coding-gap-remark.md) | Coded remark for a coding gap. |
| [Condition Category Type](ValueSet-cc-type.md) | Type of value-based performance reporting performance metric. |
| [Evidence Status](ValueSet-evidence-status.md) | Codes that indicate whether a coding gap is an open-gap, invalid-gap, closed-gap, or pending. |
| [Hierarchical Status](ValueSet-hierarchical-status.md) | Codes that indicate how hierarchies were applied to a Condition Category (CC), and if applied, whether the Condition Category (CC) is superseded. |
| [RA Confidence Scale](ValueSet-confidence-scale.md) | Codes that describe the confidence scale of a risk adjustment Condition Category (CC). |
| [Remark Reason](ValueSet-remark-reason.md) | Reason for the remark |
| [Sample CMS Hierarchical Condition Category](ValueSet-sample-cmshcc.md) | This is a sample of the concepts that can be found in the CMS Hierarchical Condition Categories (CMS-HCC) code system version 24. The source of the codes included in this example was published at https://www.cms.gov/Medicare/Health-Plans/MedicareAdvtgSpecRateStats/Downloads/Announcement2020.pdf. The CMS-HCC model uses more than 9,000 ICD-10-CM codes, which are mapped to condition categories (CCs) that predict costs well. The condition categories (CCs) are based on diagnoses clinically related to one another and with similar predicted cost implications. Hierarchies are imposed on the Condition Categories (CCs) to capture the most costly diagnoses. Hierarchy logic is imposed on certain Condition Categories (CCs) to account for different hierarchical costs, thus, the term Hierarchical Condition Category, or HCC. |

### Terminology: Code Systems 

These define new code systems used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Coding Gap Remark Codes](CodeSystem-coding-gap-remark.md) | Code sytstem that indicates coded remark for a coding gap. |
| [Remark Reason Codes](CodeSystem-remark-reason.md) | Reason codes for remark |
| [Risk Adjustment Condition Category Type Codes](CodeSystem-cc-type.md) | Code sytstem that indicates whether it is a suspected Condition Category (CC) gap, a historic Condition Category (CC) gap, or a net-new Condition Category (CC). Historic, suspected, and net-new are mutually exclusive. |
| [Risk Adjustment Evidence Status Codes](CodeSystem-evidence-status.md) | Code System that indicates whether a coding gap is an open-gap, invalid-gap, closed-gap or pending |
| [Risk Adjustment Hierarchical Status Codes](CodeSystem-hierarchical-status.md) | Code system that indicates how hierarchies were applied to a Condition Category (CC), and if applied, whether the Condition Category (CC) is superseded. |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [Condition01Pat03: Other artificial openings of gastrointestinal tract status](Condition-ra-condition01pat03.md) | This is a Condition example with code Z93.4: Other artificial openings of gastrointestinal tract status. |
| [Condition02Pat02: Diabetes mellitus due to underlying condition with other diabetic kidney complication](Condition-ra-condition02pat01.md) | This is a Condition example with code E08.29: Diabetes mellitus due to underlying condition with other diabetic kidney complication. |
| [Condition03Pat01: Chronic obstructive pulmonary disease with (acute) exacerbation](Condition-ra-condition03pat01.md) | This is a Condition example with code J44.1: Chronic obstructive pulmonary disease with (acute) exacerbation. |
| [Condition04Pat03: Chronic obstructive pulmonary disease with (acute) exacerbation](Condition-ra-condition04pat03.md) | This is a Condition example with code J44.1: Chronic obstructive pulmonary disease with (acute) exacerbation. |
| [Condition05Pat03: Unspecified protein-calorie malnutrition](Condition-ra-condition05pat03.md) | This is a Condition example with code E46: Unspecified protein-calorie malnutrition. |
| [Condition06Pat03: Crohn’s disease of large intestine with unspecified complications](Condition-ra-condition06pat03.md) | This is a Condition example with code K50.119: Crohn's disease of large intestine with unspecified complications. |
| [Condition07Pat03: Other persistent atrial fibrillation](Condition-ra-condition07pat03.md) | This is a Condition example with code I48.19: Other persistent atrial fibrillation. |
| [Condition08Pat01: Bipolar disorder, current episode mixed, mild](Condition-ra-condition08pat01.md) | This is a Condition example with code F31.61: Bipolar disorder, current episode mixed, mild. |
| [Condition09Pat01: Allergic bronchopulmonary aspergillosis](Condition-ra-condition09pat01.md) | This is a Condition example with code B44.81: Allergic bronchopulmonary aspergillosis. |
| [Condition10Pat01: Long term (current) use of insulin](Condition-ra-condition10pat01.md) | This is a Condition example with code Z79.4: Long term (current) use of insulin. |
| [Condition11Pat01: Acute pulmonary edema](Condition-ra-condition11pat01.md) | This is a Condition example with code J81.0: Acute pulmonary edema. |
| [Condition12Pat01: Manic episode, unspecified](Condition-ra-condition12pat01.md) | This is a Condition example with code F30.9: Manic episode, unspecified. |
| [Condition15Pat03: Diabetes mellitus due to underlying condition with diabetic chronic kidney disease](Condition-ra-condition15pat03.md) | This is a Condition example with code E08.22: Diabetes mellitus due to underlying condition with diabetic chronic kidney disease. |
| [Condition16Pat03: Dependence on renal dialysis](Condition-ra-condition16pat03.md) | This is a Condition example with code Z99.2: Dependence on renal dialysis. |
| [Condition17Pat01: Body mass index (BMI) 45.0-49.9, adult](Condition-ra-condition17pat01.md) | This is a Condition example with code Z68.42: Body mass index [BMI] 45.0-49.9, adult. |
| [Condition18Pat01: Longstanding persistent atrial fibrillation](Condition-ra-condition18pat01.md) | This is a Condition example with code I48.11: Longstanding persistent atrial fibrillation. |
| [Condition21Pat03: Type 2 diabetes mellitus without complications](Condition-ra-condition21pat03.md) | This is a Condition example with code E11.9: Type 2 diabetes mellitus without complications. |
| [Condition22Pat03: Other acute kidney failure](Condition-ra-condition22pat03.md) | This is a Condition example with code N17.8: Other acute kidney failure. |
| [Condition23Pat03: Chronic kidney disease, stage 5](Condition-ra-condition23pat03.md) | This is a Condition example with code N18.5: Chronic kidney disease, stage 5. |
| [Condition31Pat02: Typical atrial flutter](Condition-ra-condition31pat02.md) | This is a Condition example with code I48.3: Typical atrial flutter. |
| [Condition32Pat03: Chronic pulmonary embolism](Condition-ra-condition32pat03.md) | This is a Condition example with code I27.82: Chronic pulmonary embolism. |
| [Condition33Pat01: Respiratory arrest](Condition-ra-condition33pat01.md) | This is a Condition example with code R09.2: Respiratory arrest. |
| [Condition35Pat03: Type 2 diabetes mellitus with diabetic peripheral angiopathy without gangrene](Condition-ra-condition35pat03.md) | This is a Condition example with code E11.51: Type 2 diabetes mellitus with diabetic peripheral angiopathy without gangrene. |
| [Condition42Pat03: Other artificial openings of gastrointestinal tract status](Condition-ra-condition42pat03.md) | This is a Condition example with code Z93.4: Other artificial openings of gastrointestinal tract status. |
| [Condition43Pat01: Diabetes mellitus due to underlying condition with other diabetic kidney](Condition-ra-condition43pat01.md) | This is a Condition example with code E08.29: Diabetes mellitus due to underlying condition with other diabetic kidney complication. |
| [Condition44Pat01: Allergic bronchopulmonary aspergillosis](Condition-ra-condition44pat01.md) | This is a Condition example with code B44.81: Allergic bronchopulmonary aspergillosis. |
| [ConditionR01Pat01: Cystic fibrosis with other intestinal manifestations](Condition-ra-conditionR01pat01.md) | This is a Condition example with code E84.19: Cystic fibrosis with other intestinal manifestations. |
| [Data Exchange MeasureReport Example01](MeasureReport-ra-datax-measurereport01.md) | This is an example for the Risk Adjustment Data Exchange MeasureReport profile. It evaluatedResource references an example C-CDA document that is being submitted. |
| [Encounter with Dr Hippocrates on 2017-01-18 for Patient 01](Encounter-ra-encounter44pat01.md) | This is an Encounter example for encounter with Dr Hippocrates on 2017-01-18 for Patient 01. |
| [Encounter with Dr Hippocrates on 2017-02-03 for Patient 03](Encounter-ra-encounter08pat01.md) | This is an Encounter example for encounter with Dr Hippocrates on 2017-02-03 for Patient 03. |
| [Encounter with Dr Hippocrates on 2018-07-21 for Patient 01](Encounter-ra-encounter45pat01.md) | This is an Encounter example for encounter with Dr Hippocrates on 2018-07-21 for Patient 01. |
| [Encounter with Dr Hippocrates on 2019-02-10 for Patient 01](Encounter-ra-encounter43pat01.md) | This is an Encounter example for encounter with Dr Hippocrates on 2019-02-10 for Patient 01. |
| [Encounter with Dr Hippocrates on 2020-11-02 for Patient 03](Encounter-ra-encounter11pat01.md) | This is an Encounter example for encounter with Dr Hippocrates on 2020-11-02 for Patient 03. |
| [Encounter with Dr Hippocrates on 2021-01-31 for Patient 03](Encounter-ra-encounter02pat01.md) | This is an Encounter example for encounter with Dr Hippocrates on 2021-01-31 for Patient 03. |
| [Encounter with Dr Hippocrates on 2021-03-27 for Patient 03](Encounter-ra-encounter09pat01.md) | This is an Encounter example for encounter with Dr Hippocrates on 2021-03-27 for Patient 03. |
| [Encounter with Dr Hippocrates on 2021-09-26 for Patient 03](Encounter-ra-encounter03pat01.md) | This is an Encounter example for encounter with Dr Hippocrates on 2021-09-26 for Patient 03. |
| [Encounter with Dr Hippocrates on 2021-10-15 for Patient 01](Encounter-ra-encounter46pat01.md) | This is an Encounter example for encounter with Dr Hippocrates on 2021-10-15 for Patient 01. |
| [Encounter with Dr Osler on 2019-02-07 for Patient 03](Encounter-ra-encounter07pat03.md) | This is an Encounter example for encounter with Dr Osler on 2019-02-07 for Patient 03. |
| [Encounter with Dr Osler on 2019-08-23 for Patient 03](Encounter-ra-encounter19pat03.md) | This is an Encounter example for encounter with Dr Osler on 2019-08-23 for Patient 03. |
| [Encounter with Dr Osler on 2020-02-10 for Patient 03](Encounter-ra-encounter42pat03.md) | This is an Encounter example for encounter with Dr Osler on 2020-02-10 for Patient 03. |
| [Encounter with Dr Osler on 2020-03-03 for Patient 03](Encounter-ra-encounter05pat03.md) | This is an Encounter example for encounter with Dr Osler on 2020-03-03 for Patient 03. |
| [Encounter with Dr Osler on 2020-09-17 for Patient 03](Encounter-ra-encounter06pat03.md) | This is an Encounter example for encounter with Dr Osler on 2020-09-17 for Patient 03. |
| [Encounter with Dr Osler on 2020-12-18 for Patient 03](Encounter-ra-encounter04pat03.md) | This is an Encounter example for encounter with Dr Osler on 2020-12-18 for Patient 03. |
| [Encounter with Dr Osler on 2021-01-30 for Patient 03](Encounter-ra-encounter21pat03.md) | This is an Encounter example for encounter with Dr Osler on 2021-01-30 for Patient 03. |
| [Encounter with Dr Osler on 2021-02-12 for Patient 03](Encounter-ra-encounter35pat03.md) | This is an Encounter example for encounter with Dr Osler on 2021-02-12 for Patient 03. |
| [Encounter with Dr Osler on 2021-07-01 for Patient 03](Encounter-ra-encounter22pat03.md) | This is an Encounter example for encounter with Dr Osler on 2021-07-01 for Patient 03. |
| [Encounter with Dr Osler on 2021-07-14 for Patient 03](Encounter-ra-encounter01pat03.md) | This is an Encounter example for encounter with Dr Osler on 2021-07-14 for Patient 03. |
| [Encounter with Dr Osler on 2021-07-27 for Patient 03](Encounter-ra-encounter16pat03.md) | This is an Encounter example for encounter with Dr Osler on 2021-07-27 for Patient 03. |
| [Encounter with Dr Osler on 2021-08-08 for Patient 03](Encounter-ra-encounter15pat03.md) | This is an Encounter example for encounter with Dr Osler on 2021-08-08 for Patient 03. |
| [Encounter with Dr Pump on 2021-08-06 for Patient 02](Encounter-ra-encounter31pat02.md) | This is an Encounter example for encounter with Dr Pump on 2021-08-06 for Patient 02. |
| [Organization Example: XYZ Laboratory](Organization-ra-laboratory01.md) | Laboratory that created lab observations |
| [Organization: ABC Payer](Organization-ra-payer01.md) | ABC Payer is an Organization example that generated Risk Adjustment Coding Gap Report. |
| [Organization: Best RA Vendor](Organization-ra-vendor01.md) | Best RA Vendor is an Organization example that generated Risk Adjustment Data Exchange MeasureReport. |
| [Organization: Community HealthCenter](Organization-ra-org03pat03.md) | Community HealthCenter is an Organization example, which is used for example Patient 03 data. |
| [Organization: Community Urgent Care](Organization-ra-org01pat01.md) | Community Urgent Care is an Organization example, which is used for example Patient 01 data. |
| [Organization: GHH Outpatient Clinic](Organization-ra-org02pat02.md) | GHH Outpatient Clinic is an Organization example, which is used for example Patient 02 data. |
| [Organization: Risk Adjustment Author](Organization-ra-org-author.md) | This is an example Organization that is the author of the RA report |
| [Outpatient Note for Patient01 Eve Everywoman](DocumentReference-ra-documentreference01pat01.md) | This is an outpatient note example for the**US Core DocumentReference Profile**. |
| [PHQ9 Total Score for Patient 03](Observation-ra-obs02pat03.md) | This is a PHQ9 Total Score for Patient 03. |
| [Patch Example01 with multiple value (ra-measurereport01)](Parameters-ra-measurereport01-patch-mult.md) | This is an example using the patch operation to send a Condition Category Remark with data for two Condition Categories (group-001, group-002) and one with multiple attributes: authorDatetime, text. |
| [Patch Example02 (ra-measurereport01)](Parameters-ra-measurereport01-patch.md) | This is an example using the patch operation to send a Condition Category Remark for one Condition Category (group-001) with one attribute: authorDatetime. |
| [Patient Group Example 1](Group-ra-group01.md) | This is an example for the Patient Group profile. This example patient group has one member. |
| [Patient Group Example 2](Group-ra-group02.md) | This is an example for the Patient Group profile. This example patient group has two members. |
| [Patient01: Eve Everywoman](Patient-ra-patient01.md) | This is an example patient that uses the USCore profile. The example patient name is Eve Everywoman. |
| [Patient02: Adam Everyman](Patient-ra-patient02.md) | This is an example patient that uses the US Core Patient profile. The example patient name is Adam Everyman. |
| [Patient03: Nelda Nuclear](Patient-ra-patient03.md) | This is an example patient that uses the US Core Patient profile. The example patient name is Nelda Nuclear. |
| [Practitioner01: Harold Hippocrates](Practitioner-ra-prac01pat01.md) | This is an example practitioner that uses the US Core Practitioner profile. The example practitioner is an individual practitioner: Harold Hippocrates. |
| [Practitioner02: Patrick Pump](Practitioner-ra-prac02pat02.md) | This is an example practitioner that uses the US Core Practitioner profile. The example practitioner is an organization: GHH Outpatient Clinic. |
| [Practitioner03: Otto Osler](Practitioner-ra-prac03pat03.md) | This is an example practitioner that uses the US Core Practitioner profile. The example practitioner is an organization: Community HealthCenter. |
| [RA Coding Gap MeasureReport Example01 with RA Model CMS-HCC V24 for Patient01 Eve Everywoman](MeasureReport-ra-measurereport01.md) | This is an example for the Risk Adjustment Coding Gap MeasureReport profile. This example report uses the CMS-HCC version 24 as the Risk Adjustment Model and the example patient used is Eve Everywoman. |
| [RA Coding Gap MeasureReport Example02 with RA Model CMS-RxHCC V5 for Patient01 Eve Everywoman](MeasureReport-ra-measurereport02.md) | This is an example for the Risk Adjustment Coding Gap MeasureReport profile. This example report uses the CMS-RxHCC version 5 as the Risk Adjustment Model and the example patient used is Eve Everywoman. |
| [RA Coding Gap MeasureReport Example03 with RA Model CMS-HCC V24 for Patient02 Adam Everyman](MeasureReport-ra-measurereport03.md) | This is an example for the Risk Adjustment Coding Gap MeasureReport profile. This example report uses the CMS-HCC version 24 as the Risk Adjustment Model and the example patient used is Eve Everywoman. |
| [RA Coding Gap MeasureReport Example04 with RA Model CMS-HCC V21 for Patient03 Nelda Nuclear](MeasureReport-ra-measurereport04.md) | This is an example for the Risk Adjustment Coding Gap MeasureReport profile. This example report uses the CMS-HCC version 21 as the Risk Adjustment Model and the example patient used is Eve Everywoman. |
| [RA Coding Gap MeasureReport Example05 with RA Model CMS-RxHCC V5 for Patient03 Nelda Nuclear](MeasureReport-ra-measurereport05.md) | This is an example for the Risk Adjustment Coding Gap MeasureReport profile. This example report uses the CMS-RxHCC version 5 as the Risk Adjustment Model and the example patient used is Eve Everywoman. |
| [RA Coding Gap MeasureReport Example06 with RA Model CMS-RxHCC V5 for Patient02 Adam Everyman](MeasureReport-ra-measurereport06.md) | This is an example for the Risk Adjustment Coding Gap MeasureReport profile. This example report uses the CMS-RxHCC version 5 as the Risk Adjustment Model and the example patient used is Eve Everywoman. |
| [RA MeasureReport with Remark Example (ra-measurereport01-with-remark)](MeasureReport-ra-measurereport01-with-remark.md) | This is an example for the Risk Adjustment Coding Gap MeasureReport profile that shows using the Condition Category Remark extension. The remark is added to MeasureReport. |
| [RA Model Example01 CMS-HCC version 24](Measure-RAModelExample01.md) | This is an example for the Risk Adjustment Model Measure profile. The example uses the CMS-HCC version 24 as the example Risk Adjustment Model. |
| [RA Model Example02 CMS-HCC version 21](Measure-RAModelExample02.md) | This is an example for the Risk Adjustment Model Measure profile. The example uses the CMS-HCC version 21 as the example Risk Adjustment Model. |
| [RA Model Example03 CMS-RxHCC version 5](Measure-RAModelExample03.md) | This is an example for the Risk Adjustment Model Measure profile. The example uses the CMS-RxHCC version 5 as the example Risk Adjustment Model. |
| [Risk Adjustment MeasureReport Bundle example, MeasureReport01: Patient01](Bundle-ra-bundle01.md) | This is an Risk Adjustment MeasureReport Bundle example includes MeasureReport01 for Patient01. |
| [Serum Creatinine for Patient 03](Observation-ra-obs01pat03.md) | This is an example for Observation. Serum Creatinine for Patient 03 Nelda Nuclear performed at XYZ Laboratory. |
| [Submit Data example for sending a C-CDA document](Parameters-ra-submit-data.md) | This is an example for using $submit-data oepration to send a C-CDA document as supporting evidence using the RA Data Exchange MeasureReport. |
| [Trypsin [Mass/volume] in Serum or Plasma for Patient 01](Observation-ra-obs21pat01.md) | Trypsin [Mass/volume] in Serum or Plasma for Patient 01. |
| [Trypsin [Mass/volume] in Serum or Plasma for Patient 02](Observation-ra-obs01pat02.md) | This is an example for Observation profile. Trypsin [Mass/volume] in Serum or Plasma for Patient 02 Adam Everyman performed at XYZ Laboratory. |

