# MeasureReportCategory - Da Vinci Risk Adjustment Implementation Guide v2.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **MeasureReportCategory**

## SearchParameter: MeasureReportCategory 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-ra/SearchParameter/measurereport-category | *Version*:2.1.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:MeasureReportCategory |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.29.40.1 | | |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License | | |

 
Search based on the measurereport-category extension 

## MeasureReportCategory TU

Parameter `category`:`token`

Search based on the measurereport-category extension

| | |
| :--- | :--- |
| Resource | [MeasureReport](http://hl7.org/fhir/R4/measurereport.html) |
| Expression | `MeasureReport.extension('http://hl7.org/fhir/StructureDefinition/measurereport-category').value` |
| Processing Mode | Normal |
| Multiples | * multipleAnd: It's up to the server whether the parameter may repeat in order to specify multiple values that must all be true
* multipleOr: It's up to the server whether the parameter can have multiple values (separated by comma) where at least one must be true
 |



## Resource Content

```json
{
  "resourceType" : "SearchParameter",
  "id" : "measurereport-category",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-ra/SearchParameter/measurereport-category",
  "version" : "2.1.0",
  "name" : "MeasureReportCategory",
  "status" : "active",
  "date" : "2025-11-20T19:49:53+00:00",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "Search based on the measurereport-category extension",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "code" : "category",
  "base" : ["MeasureReport"],
  "type" : "token",
  "expression" : "MeasureReport.extension('http://hl7.org/fhir/StructureDefinition/measurereport-category').value",
  "xpathUsage" : "normal"
}

```
