# Submit Remark Data - Da Vinci Risk Adjustment Implementation Guide v2.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Submit Remark Data**

## OperationDefinition: Submit Remark Data 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-ra/OperationDefinition/submit-remark-data | *Version*:2.1.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:SubmitRemarkData |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.29.33.3 | | |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License | | |

 
A[Condition Category Remark](StructureDefinition-ra-ccRemark.md)may reference resources such as Pracitioner and Condition, using Patch to submit the remark may not be feasible. This operation is used to submit a Risk Adjustment Coding Gap Report with one or more ccRemarks on at least one of the Condition Categories, along with the relevant resources referenced by the ccRemark(s). 

URL: [base]/Measure/$submit-remark-data

URL: [base]/Measure/[id]/$submit-remark-data

### Parameters

* **Use**: IN
  * **Name**: bundle
  * **Scope**: 
  * **Cardinality**: 1..*
  * **Type**: [Bundle](http://hl7.org/fhir/R4/bundle.html)([Risk Adjustment MeasureReport With Remark Bundle](StructureDefinition-ra-measurereport-remark-bundle.md))
  * **Binding**: 
  * **Documentation**: A Bundle that contains a Risk Adjustment Coding Gap Report with ccRemark(s) on at least one of the Condition Categories and the ccRemark referenced resources



## Resource Content

```json
{
  "resourceType" : "OperationDefinition",
  "id" : "submit-remark-data",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-ra/OperationDefinition/submit-remark-data",
  "version" : "2.1.0",
  "name" : "SubmitRemarkData",
  "title" : "Submit Remark Data",
  "status" : "active",
  "kind" : "operation",
  "date" : "2025-11-20T19:49:53+00:00",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "A [Condition Category Remark](StructureDefinition-ra-ccRemark.html) may reference resources such as Pracitioner and Condition, using Patch to submit the remark may not be feasible. This operation is used to submit a Risk Adjustment Coding Gap Report with one or more ccRemarks on at least one of the Condition Categories, along with the relevant resources referenced by the ccRemark(s).",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "code" : "submit-remark-data",
  "resource" : ["Measure"],
  "system" : false,
  "type" : true,
  "instance" : true,
  "parameter" : [
    {
      "name" : "bundle",
      "use" : "in",
      "min" : 1,
      "max" : "*",
      "documentation" : "A Bundle that contains a Risk Adjustment Coding Gap Report with ccRemark(s) on at least one of the Condition Categories and the ccRemark referenced resources",
      "type" : "Bundle",
      "targetProfile" : [
        "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-measurereport-remark-bundle"
      ]
    }
  ]
}

```
