# RA Coding Gap MeasureReport Example05 with RA Model CMS-RxHCC V5 for Patient03 Nelda Nuclear - Da Vinci Risk Adjustment Implementation Guide v2.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **RA Coding Gap MeasureReport Example05 with RA Model CMS-RxHCC V5 for Patient03 Nelda Nuclear**

## Example MeasureReport: RA Coding Gap MeasureReport Example05 with RA Model CMS-RxHCC V5 for Patient03 Nelda Nuclear

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [Risk Adjustment Coding Gap MeasureReport](StructureDefinition-ra-measurereport.md)

**Measure Report Category**: Risk Adjustment

**Clinical Data Collection Deadline Extension**: 2022-03-31

**status**: Complete

**type**: Individual

**measure**: [Risk Adjustment Model Version 5 - CMS Prescribing Drug Hierarchical Category Condition (CMS-RxHCC)](Measure-RAModelExample03.md)

**subject**: [Nelda Nuclear (official) Female, DoB: 1965-07-26 ( Medical record number: 34567 (use: usual, ))](Patient-ra-patient03.md)

**date**: 2021-10-18

**reporter**: [Organization ABC Payer](Organization-ra-payer01.md)

**period**: 2021-01-01 --> 2021-09-30

> **group**
> **id**group-001
**Condition Category Type Extension**:Historic Condition Category Gap**Evidence Status Extension**:Pending Condition Category Gap**Hierarchical Status Extension**:Hierarchies not applied**code**:CMS-RxHCC 226: Chronic Obstructive Pulmonary Disease and Asthma

> **group**
> **id**group-002
**Condition Category Type Extension**:Suspected Condition Category Gap**Evidence Status Extension**:Closed Condition Category Gap**Hierarchical Status Extension**:Hierarchies not applied**code**:CMS-RxHCC 31: Diabetes without Complication

> **group**
> **id**group-003
**Condition Category Type Extension**:Suspected Condition Category Gap**Evidence Status Extension**:Closed Condition Category Gap**Hierarchical Status Extension**:Hierarchies not applied**code**:CMS-RxHCC 30: Diabetes with Complications

> **group**
> **id**group-004
**Condition Category Type Extension**:Suspected Condition Category Gap**Evidence Status Extension**:Closed Condition Category Gap**Hierarchical Status Extension**:Hierarchies not applied**code**:CMS-RxHCC 261: Dialysis Status

> **group**
> **id**group-005
**Condition Category Type Extension**:Suspected Condition Category Gap**Evidence Status Extension**:Open Condition Category Gap**Hierarchical Status Extension**:Hierarchies not applied**code**:CMS-RxHCC 262: Chronic Kidney Disease Stage 5

> **group**
> **id**group-006
**Condition Category Type Extension**:Net-New Condition Category**Evidence Status Extension**:Closed Condition Category Gap**Hierarchical Status Extension**:Hierarchies not applied**code**:CMS-RxHCC 216: Peripheral Vascular Disease

**evaluatedResource**: 

* [Condition Chronic obstructive pulmonary disease with (acute) exacerbation](Condition-ra-condition04pat03.md)
* [Condition Type 2 diabetes mellitus without complications](Condition-ra-condition21pat03.md)
* [Condition Diabetes mellitus due to underlying condition with diabetic chronic kidney disease](Condition-ra-condition15pat03.md)
* [Condition Dependence on renal dialysis](Condition-ra-condition16pat03.md)
* [Condition Type 2 diabetes mellitus with diabetic peripheral angiopathy without gangrene](Condition-ra-condition35pat03.md)
* [Encounter: status = finished; class = ambulatory (ActCode#AMB); type = Office or other outpatient visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using time for code selection, 40-54 minutes of total time is spent on the date of the encounter.; period = 2020-12-18 --> 2020-12-18](Encounter-ra-encounter04pat03.md)
* [Encounter: status = finished; class = ambulatory (ActCode#AMB); type = Office or other outpatient visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using time for code selection, 40-54 minutes of total time is spent on the date of the encounter.; period = 2021-01-30 --> 2021-01-30](Encounter-ra-encounter21pat03.md)
* [Encounter: status = finished; class = ambulatory (ActCode#AMB); type = Office or other outpatient visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using time for code selection, 40-54 minutes of total time is spent on the date of the encounter.; period = 2021-08-08 --> 2021-08-08](Encounter-ra-encounter15pat03.md)
* [Encounter: status = finished; class = ambulatory (ActCode#AMB); type = Office or other outpatient visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using time for code selection, 40-54 minutes of total time is spent on the date of the encounter.; period = 2021-07-27 --> 2021-07-27](Encounter-ra-encounter16pat03.md)
* [Encounter: status = finished; class = ambulatory (ActCode#AMB); type = Office or other outpatient visit for the evaluation and management of an established patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using time for code selection, 40-54 minutes of total time is spent on the date of the encounter.; period = 2021-02-12 --> 2021-02-12](Encounter-ra-encounter35pat03.md)
* [Observation Creat SerPl-mCnc](Observation-ra-obs01pat03.md)



## Resource Content

```json
{
  "resourceType" : "MeasureReport",
  "id" : "ra-measurereport05",
  "meta" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/instance-name",
        "valueString" : "RA Coding Gap MeasureReport Example05 with RA Model CMS-RxHCC V5 for Patient03 Nelda Nuclear"
      },
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/instance-description",
        "valueMarkdown" : "This is an example for the Risk Adjustment Coding Gap MeasureReport profile. This example report uses the CMS-RxHCC version 5 as the Risk Adjustment Model and the example patient used is Eve Everywoman."
      }
    ],
    "profile" : [
      "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-measurereport"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/measurereport-category",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/CodeSystem/measurereport-category",
            "code" : "ra"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-clinicalDataCollectionDeadline",
      "valueDate" : "2022-03-31"
    }
  ],
  "status" : "complete",
  "type" : "individual",
  "measure" : "http://hl7.org/fhir/us/davinci-ra/Measure/RAModelExample03",
  "subject" : {
    "reference" : "Patient/ra-patient03"
  },
  "date" : "2021-10-18",
  "reporter" : {
    "reference" : "Organization/ra-payer01"
  },
  "period" : {
    "start" : "2021-01-01",
    "end" : "2021-09-30"
  },
  "group" : [
    {
      "id" : "group-001",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-ccType",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-ra/CodeSystem/cc-type",
                "code" : "historic"
              }
            ]
          }
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-evidenceStatus",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-ra/CodeSystem/evidence-status",
                "code" : "pending"
              }
            ]
          }
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-hierarchicalStatus",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-ra/CodeSystem/hierarchical-status",
                "code" : "not-applied"
              }
            ]
          }
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/cmsrxhcc",
            "version" : "5",
            "code" : "226",
            "display" : "Chronic Obstructive Pulmonary Disease and Asthma"
          }
        ],
        "text" : "CMS-RxHCC 226: Chronic Obstructive Pulmonary Disease and Asthma"
      }
    },
    {
      "id" : "group-002",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-ccType",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-ra/CodeSystem/cc-type",
                "code" : "suspected"
              }
            ]
          }
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-evidenceStatus",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-ra/CodeSystem/evidence-status",
                "code" : "closed-gap"
              }
            ]
          }
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-hierarchicalStatus",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-ra/CodeSystem/hierarchical-status",
                "code" : "not-applied"
              }
            ]
          }
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/cmsrxhcc",
            "version" : "5",
            "code" : "31",
            "display" : "Diabetes without Complication"
          }
        ],
        "text" : "CMS-RxHCC 31: Diabetes without Complication"
      }
    },
    {
      "id" : "group-003",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-ccType",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-ra/CodeSystem/cc-type",
                "code" : "suspected"
              }
            ]
          }
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-evidenceStatus",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-ra/CodeSystem/evidence-status",
                "code" : "closed-gap"
              }
            ]
          }
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-hierarchicalStatus",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-ra/CodeSystem/hierarchical-status",
                "code" : "not-applied"
              }
            ]
          }
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/cmsrxhcc",
            "version" : "5",
            "code" : "30",
            "display" : "Diabetes with Complications"
          }
        ],
        "text" : "CMS-RxHCC 30: Diabetes with Complications"
      }
    },
    {
      "id" : "group-004",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-ccType",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-ra/CodeSystem/cc-type",
                "code" : "suspected"
              }
            ]
          }
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-evidenceStatus",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-ra/CodeSystem/evidence-status",
                "code" : "closed-gap"
              }
            ]
          }
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-hierarchicalStatus",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-ra/CodeSystem/hierarchical-status",
                "code" : "not-applied"
              }
            ]
          }
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/cmsrxhcc",
            "version" : "5",
            "code" : "261",
            "display" : "Dialysis Status"
          }
        ],
        "text" : "CMS-RxHCC 261: Dialysis Status"
      }
    },
    {
      "id" : "group-005",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-ccType",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-ra/CodeSystem/cc-type",
                "code" : "suspected"
              }
            ]
          }
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-evidenceStatus",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-ra/CodeSystem/evidence-status",
                "code" : "open-gap"
              }
            ]
          }
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-hierarchicalStatus",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-ra/CodeSystem/hierarchical-status",
                "code" : "not-applied"
              }
            ]
          }
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/cmsrxhcc",
            "version" : "5",
            "code" : "262",
            "display" : "Chronic Kidney Disease Stage 5"
          }
        ],
        "text" : "CMS-RxHCC 262: Chronic Kidney Disease Stage 5"
      }
    },
    {
      "id" : "group-006",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-ccType",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-ra/CodeSystem/cc-type",
                "code" : "net-new"
              }
            ]
          }
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-evidenceStatus",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-ra/CodeSystem/evidence-status",
                "code" : "closed-gap"
              }
            ]
          }
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-hierarchicalStatus",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-ra/CodeSystem/hierarchical-status",
                "code" : "not-applied"
              }
            ]
          }
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/cmsrxhcc",
            "version" : "5",
            "code" : "216",
            "display" : "Peripheral Vascular Disease"
          }
        ],
        "text" : "CMS-RxHCC 216: Peripheral Vascular Disease"
      }
    }
  ],
  "evaluatedResource" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-groupReference",
          "valueString" : "group-001"
        }
      ],
      "reference" : "Condition/ra-condition04pat03"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-groupReference",
          "valueString" : "group-002"
        }
      ],
      "reference" : "Condition/ra-condition21pat03"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-groupReference",
          "valueString" : "group-003"
        }
      ],
      "reference" : "Condition/ra-condition15pat03"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-groupReference",
          "valueString" : "group-004"
        }
      ],
      "reference" : "Condition/ra-condition16pat03"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-groupReference",
          "valueString" : "group-006"
        }
      ],
      "reference" : "Condition/ra-condition35pat03"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-groupReference",
          "valueString" : "group-001"
        }
      ],
      "reference" : "Encounter/ra-encounter04pat03"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-groupReference",
          "valueString" : "group-002"
        }
      ],
      "reference" : "Encounter/ra-encounter21pat03"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-groupReference",
          "valueString" : "group-003"
        }
      ],
      "reference" : "Encounter/ra-encounter15pat03"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-groupReference",
          "valueString" : "group-004"
        }
      ],
      "reference" : "Encounter/ra-encounter16pat03"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-groupReference",
          "valueString" : "group-006"
        }
      ],
      "reference" : "Encounter/ra-encounter35pat03"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-groupReference",
          "valueString" : "group-005"
        }
      ],
      "reference" : "Observation/ra-obs01pat03"
    }
  ]
}

```
