# Risk Adjustment Data Submission Server Capability Statement - Da Vinci Risk Adjustment Implementation Guide v2.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Risk Adjustment Data Submission Server Capability Statement**

## CapabilityStatement: Risk Adjustment Data Submission Server Capability Statement 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-ra/CapabilityStatement/ra-data-submission-server | *Version*:2.1.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:RADataSubmissionServerCapabilityStatement |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.29.13.2 | | |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License | | |

 
This profile defines the expected capabilities of a Da Vinci Risk Adjustment Data Submission Server when conforming to the Da Vinci Risk Adjustment Implementation Guide for interactions between Clients and Servers. Servers are the actors receiving and processing the Risk Adjustment Data Exchange MeasureReports submitted by the Client. 

 [Raw OpenAPI-Swagger Definition file](ra-data-submission-server.openapi.json) | [Download](ra-data-submission-server.openapi.json) 

## Risk Adjustment Data Submission Server Capability Statement

* Implementation Guide Version: 2.1.0 
* FHIR Version: 4.0.1 
* Supported Formats: `xml`, `json`
* Supported Patch Formats: `application/json-patch+json`
* Published on: 2025-11-20 19:49:53+0000 
* Published by: HL7 International / Clinical Quality Information 

> **Note to Implementers: FHIR Capabilities**Any FHIR capability may be 'allowed' by the system unless explicitly marked as 'SHALL NOT'. A few items are marked as MAY in the Implementation Guide to highlight their potential relevance to the use case.

### SHALL Support the Following Implementation Guides

* [http://hl7.org/fhir/us/davinci-ra/ImplementationGuide/hl7.fhir.us.davinci-ra](index.md)

## FHIR RESTful Capabilities

### Mode: server

Da Vinci Risk Adjustment Data Submission Server **SHALL** support the risk adjustment data submission transaction and profiles specified in the Methodology Section of this implementation guide and the base FHIR $submit-data operation., as specified in this capability statement

**Security**

> 

For general security consideration refer to the [Security and Privacy Considerations](http://hl7.org/fhir/R4/secpriv-module.html).


**Summary of System-wide Interactions**

* **SHOULD**support the `batch`interaction.
* **MAY**support the `transaction`interaction.
* **MAY**support the `search-system`interaction.
* **MAY**support the `history-system`interaction.

### Capabilities by Resource/Profile

#### Summary

The summary table lists the resources that are part of this configuration, and for each resource it lists:

* The relevant profiles (if any)
* The interactions supported by each resource (**R**ead, **S**earch, **U**pdate, and **C**reate, are always shown, while **VR**ead, **P**atch, **D**elete, **H**istory on **I**nstance, or **H**istory on **T**ype are only present if at least one of the resources has support for them.
* The required, recommended, and some optional search parameters (if any).
* The linked resources enabled for `_include`
* The other resources enabled for `_revinclude`
* The operations on the resource (if any)

| | | | | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| [MeasureReport](#MeasureReport1-1) | Supported Profiles  [Risk Adjustment Data Exchange MeasureReport](StructureDefinition-ra-datax-measurereport.md) | **Y** | **Y** | **Y** | **Y** |  |  |  |  |  |

-------

#### Resource Conformance: SHALL MeasureReport

Core FHIR Resource

[MeasureReport](http://hl7.org/fhir/R4/measurereport.html)

Reference Policy

`literal`,
`logical`

Interaction summary

* **SHALL** support 
`read`

Read allows maintainers of the Risk Adjustment Data Exchange MeasureReports to read the logical definition of a Risk Adjustment Data Exchange MeasureReport.

`update`

Update allows maintainers of the Risk Adjustment Data Exchange MeasureReports to update the logical definitions of a MeasureReport by its id

`patch`

Patch allows maintainers of the Risk Adjustment Data Exchange MeasureReports to update the logical definition of a MeasureReport by posting a set of changes to it

`search-type`

Search allows maintainers of the Risk Adjustment Data Exchange MeasureReports to find the logical definition of a MeasureReport


Supported Profiles
[Risk Adjustment Data Exchange MeasureReport](StructureDefinition-ra-datax-measurereport.md)



## Resource Content

```json
{
  "resourceType" : "CapabilityStatement",
  "id" : "ra-data-submission-server",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-ra/ImplementationGuide/davinci-ra"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-ra/ImplementationGuide/davinci-ra"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-ra/CapabilityStatement/ra-data-submission-server",
  "version" : "2.1.0",
  "name" : "RADataSubmissionServerCapabilityStatement",
  "title" : "Risk Adjustment Data Submission Server Capability Statement",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-20T19:49:53+00:00",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "This profile defines the expected capabilities of a Da Vinci Risk Adjustment Data Submission Server when conforming to the Da Vinci Risk Adjustment Implementation Guide for interactions between Clients and Servers. Servers are the actors receiving and processing the Risk Adjustment Data Exchange MeasureReports submitted by the Client.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 International, all rights reserved Creative Commons License",
  "kind" : "requirements",
  "fhirVersion" : "4.0.1",
  "format" : ["xml", "json"],
  "patchFormat" : ["application/json-patch+json"],
  "implementationGuide" : [
    "http://hl7.org/fhir/us/davinci-ra/ImplementationGuide/hl7.fhir.us.davinci-ra"
  ],
  "rest" : [
    {
      "mode" : "server",
      "documentation" : "Da Vinci Risk Adjustment Data Submission Server **SHALL** support the risk adjustment data submission transaction and profiles specified in the Methodology Section of this implementation guide and the base FHIR $submit-data operation., as specified in this capability statement",
      "security" : {
        "description" : "For general security consideration refer to the [Security and Privacy Considerations](http://hl7.org/fhir/R4/secpriv-module.html)."
      },
      "resource" : [
        {
          "type" : "MeasureReport",
          "supportedProfile" : [
            "http://hl7.org/fhir/us/davinci-ra/StructureDefinition/ra-datax-measurereport"
          ],
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read",
              "documentation" : "Read allows maintainers of the Risk Adjustment Data Exchange MeasureReports to read the logical definition of a Risk Adjustment Data Exchange MeasureReport."
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "update",
              "documentation" : "Update allows maintainers of the Risk Adjustment Data Exchange MeasureReports to update the logical definitions of a MeasureReport by its id"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "patch",
              "documentation" : "Patch allows maintainers of the Risk Adjustment Data Exchange MeasureReports to update the logical definition of a MeasureReport by posting a set of changes to it"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "search-type",
              "documentation" : "Search allows maintainers of the Risk Adjustment Data Exchange MeasureReports to find the logical definition of a MeasureReport"
            }
          ],
          "conditionalUpdate" : true,
          "referencePolicy" : ["literal", "logical"]
        }
      ],
      "interaction" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHOULD"
            }
          ],
          "code" : "batch"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "MAY"
            }
          ],
          "code" : "transaction"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "MAY"
            }
          ],
          "code" : "search-system"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "MAY"
            }
          ],
          "code" : "history-system"
        }
      ]
    }
  ]
}

```
