# Patient Cost Transparency Implementation Guide Home Page - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* **Patient Cost Transparency Implementation Guide Home Page**

## Patient Cost Transparency Implementation Guide Home Page

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-pct/ImplementationGuide/hl7.fhir.us.davinci-pct | *Version*:2.0.0 | |
| *IG Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:PatientCostTransparency |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.4 | | |

> This specification is a Standard for Trial Use. It is expected to continue to evolve and improve through HL7® FHIR® Connectathon testing and feedback from early adopters.This IG has two workflows that can be sequenced together. The first is focused on a payer receiving a good faith estimate (GFE) from a provider and returning an Advanced Explanation of Benefits (AEOB) to a patient. With STU2, this specification includes guidance on how multiple providers can work together to provide one collective GFE for easier patient understanding of their overall estimated cost for a planned service including all related services or items that may be billed by a different provider. See[Change Log](change_log.md)for additional information. The IG STU2 content relating to the GFE Coordination is marked as DRAFT throughout this guide. The Da Vinci PCT open community of providers, payers, health IT including EHRs, revenue cycle experts, billing specialists, cost estimator experts, clearinghouse experts, and others that have provided requirements and vetted design decisions, recognize that the GFE coordination process is new. Testing this content provides the opportunity to gain feedback broadly and enable better insights as the business process evolves to advance a standard for trial use.Feedback is welcome and may be submitted through the[FHIR change tracker](http://hl7.org/fhir-issues)indicating "US Da Vinci Patient Cost Transparency (PCT)(FHIR)" as the specification.This implementation guide (IG) is dependent on other specifications. Please submit any comments you have on these base specifications as follows:
* Feedback on the FHIR core specification should be submitted to the [FHIR change tracker](http://hl7.org/fhir-issues) with "FHIR Core" as the specification. 
* Feedback on the US core profiles should be submitted to the [FHIR change tracker](http://hl7.org/fhir-issues) with "US Core" as the specification. 
Individuals interested in participating in the Patient Cost Transparency project or other HL7 Da Vinci projects can find information about Da Vinci[here](http://www.hl7.org/about/davinci).

### Overview

This IG provides detailed guidance to support providers and payers exchanging financial information for specific items and services using FHIR-based standards. This exchange involves a provider or group of providers submitting a Good Faith Estimate (GFE) to a patient (if self-pay or uninsured) or a payer. A payer can then generate an Advanced Explanation of Benefits (AEOB) for a patient (and optionally be returned to the submitting provider). The AEOB from the payer, will also include the GFE used to inform the AEOB generation.

When there are multiple providers involved in a patient’s service, these providers may need to coordinate in order to produce one comprehensive GFE. This IG provides guidance on how this collaborative GFE creation process can leverage FHIR. Information about the cost of healthcare items or services may enable better decision making by the patient in consultation with the provider.

The trigger for PCT is at the time of a patient “request” for an estimate or a “scheduled service”.

This IG will reference where possible the “standards” defined by US Core, the Health Record exchange ([HRex](https://hl7.org/fhir/us/davinci-hrex/)) Library/Framework IG, other FHIR IGs, and other industry standards where applicable.

This IG is informed by the [No Surprises Act (see Division BB, Title I, Sections 111 and 112)](https://www.ftc.gov/legal-library/browse/statutes/no-surprises-act-2021-consolidated-appropriations-act), which was enacted as part of the Consolidated Appropriations Act, 2021. The No Surprises Act specifically requires that a provider or providers share a GFE with a patient when the patient is self-pay/uninsured or with a payer for insured patients when the patient schedules a service or requests an estimate. When the payer receives a GFE, the payer must make an AEOB available to a patient in advance of the service.

Understanding the need for multiple providers to be able to work together to produce a single GFE in support of the law, this IG provides guidance on how to create this GFE using FHIR. This IG introduces a GFE coordination workflow that leverages a Coordinating Platform. The Coordinating Platform could be any number of systems - a practice management system, an EHR, a portal, a third party system, etc. When a patient contacts a provider to schedule a service or request an estimate for a service, the provider or facility who schedules the service or receives the request is the convening provider or convening facility per current CMS regulation for uninsured/self-pay patients.

> NOTE: At this time, the Departments have exercised enforcement discretion allowing providers to send separate GFEs to a patient or payer. Further federal regulation on this is anticipated. If the GFE Coordination Workflow is not an option for gathering all of the GFE Bundles from the contributing providers, this Implementation Guide provides a means for separate individual GFE Packet submissions to be linked for a payer to assemble. Helping patients get the best, most usable information to make informed decisions about their care is the objective. If specific guidance is issued that requires adjustments to this IG, the IG will be updated.

The IG supports different methods of information sharing between payers and providers and payers and patients. In this way, the IG can support providers and payers as they work to meet the legislative and future regulatory requirement as well as enable information sharing valuable to supporting patient care. Since the law does not require an API to share these data, the method used to share the required information – an API, a portal, email, etc. – is the decision of the parties engaged in the process. Should future rulemaking mandate a specific scenario, this IG can be revised accordingly.

By using the FHIR standard and implementing this guide, providers and payers can enhance their existing technologies, where applicable, for estimating patient costs securely and efficiently using common open web technologies. The anticipated benefit of using FHIR APIs is to streamline the process of creating a single comprehensive GFE for self-pay/uninsured patients and a single AEOB for insured and to enable applications of the patients’ choice to give greater transparency into patient-specific estimated costs of expected healthcare items and services.

FHIR is being used for consumer access to healthcare related data at significant scale today, and there are regulatory requirements in the form of the CMS Patient Access API for FHIR support for the related use case of post adjudicated claims, namely CARIN for Blue Button®. Use of an industry standard would keep the barrier to stakeholder adoption relatively low.

> Note: The scope of this guide does not include coordination of benefits or more than one coverage. This does not serve as a replacement for eligibility, scheduling, prior authorization or other financial and administrative use cases.

Acronyms used in this IG can be found [here](#terms-and-concepts). The reader of this IG should become familiar with these before reading this IG.

### General Workflow

This guide breaks the process into two main parts in support of the patient cost transparency use case:

1. [GFE Coordination Workflow (Multi-Provider) ](gfe_coordination_overview.md)- Supports the ability for a provider to notify, request, and collect one or more GFEs from other providers that may participate in a set of procedures related to patient’s period of care for which a GFE is required, either to provide to the patient and/or to submit to a payer.
1. [GFE Submission and AEOB Workflow](gfe_submission_and_aeob_overview.md)- Supports the ability for a provider to submit GFE Packets to a payer for them to process and produce an[AEOB Packet](StructureDefinition-davinci-pct-aeob-packet.md)to the patient and optionally to the provider. This submission may include GFEs from multiple providers gathered using FHIR separately or a consolidated GFE is gathered in the[GFE Coordination Workflow](gfe_coordination_overview.md).

**Good Faith Estimate and Advanced Explanation of Benefit High Level Workflow** ![](PCT_HighLevelWorkflow.png)

**Figure 1: PCT High Level Workflow Diagram**

#### GFE Submit Workflow

**AEOB Interaction Diagram Steps (High Level View)**

1. A patient schedules a service or requests an estimate for a service which triggers the composition of a GFE.
1. If multiple providers are involved, the Providers involved in the service coordinate on their individual charges and services for the Good Faith Estimate through the[GFE Coordination Workflow](gfe_coordination_overview.md). For self-pay or uninsured patients, the GFE can be made available to the patient at this step.
1. For insured patients, one or more GFEs in a FHIR Bundle resource ([GFE Packet](StructureDefinition-davinci-pct-gfe-packet.md)) is submitted (via the[gfe-submit operation](OperationDefinition-GFE-submit.md)) to the payer’s endpoint for AEOB creation.
1. The payer would then process, applying contracts and benefits, and produce the[AEOB Packet](StructureDefinition-davinci-pct-aeob-packet.md).
1. The patient and provider may receive a subscription notification of availability of the AEOB Packet and can retrieve the[AEOB Packet](StructureDefinition-davinci-pct-aeob-packet.md)via FHIR query.

> Note: Communication to the patient could be direct from the provider or the payer or through a third-party app via an API.

### Content and Organization

This implementation guide (and the menu for it) is organized into the following sections:

* **Background** - Supporting informative pages that covers the use cases and actors, but does not set conformance expectations 
* [Reading this IG](reading_this_ig.md) points to key pages in the FHIR spec and other source specifications that must be understood to understand this guide
* [Use Cases and Actors](use_cases.md) describes the intent of the implementation guide, gives examples of its use, and provides a high-level overview of expected process flow as well as a description of the business and technical actors involved.
* [GFE Coordination Overview](gfe_coordination_overview.md) describes the use case and workflow of the Good Faith Estimate (GFE) multiple provider coordination use case that describes how providers using varying technologies can coordinate to gather their constituent GFEs to pull together into a single GFE Packet.
* [GFE Submission and AEOB Overview](gfe_submission_and_aeob_overview.md) describes the use case and workflow for a provider to submit a GFE Packet to a payer to request an Advanced Explanation of Benefits (AEOB) for their patient and making that AEOB available.
* [Project and Participants](projects_and_participants.md) gives a high-level overview of Da Vinci and identifies the individuals and organizations involved in developing this implementation guide
 
* **Specification** - Pages that set conformance expectations 
* [Conformance Expectations](formal_specification.md) defines base language and expectations for declaring conformance with the guide
* [GFE Coordination Specification](gfe_coordination_specification.md) describes the conformance requirements for implementers of the multiple provider using varying technologies can coordinate to the creation of a single a single GFE Packet.
* [GFE Submission and AEOB Specification](gfe_submission_and_aeob_specification.md) describes the conformance requirements for a provider submitting a GFE Packet for an insured patient to a payer for an AEOB to be created and made available.
* [Privacy, Safety, and Security](security.md) covers considerations around data access, protection, and similar concepts that apply to all implementations
 
* **FHIR Artifacts** 
* [Artifacts Overview](artifacts.md) introduces and provides links to the profiles, search parameters and other FHIR artifacts used in this implementation guide
 
* **Base Specs** - Quick links to the various specifications this guide derives from
* **Support** - Links to help with use of this guide 
* **Discussion Forum** is a place to ask questions about the guide, discuss potential issues, and search through prior discussions
* **Project Page** includes information about project calls, agendas, past minutes, and instructions for how to participate
* **Implementer Support** provides information about reference implementations, resources for testing, known errata, regulatory considerations, and practical implementation pathways
* **Specification Dashboard** shows new and historical issues that have been logged against the specification, proposed dispositions, unapplied changes, etc.
* **Propose a Change** allows formal submission of requests for change to the specification. (Consider raising the issue on the discussion forum first.)
* [Downloads](downloads.md) allows downloading this and other specifications, as well as other useful files
 

### Terms and Concepts

| | |
| :--- | :--- |
| AEOB | The Consolidated Appropriations Act includes provisions whereby group health plans and health insurance issuers, based on charges, billing and diagnostic codes provided by the provider(s), provide an Advanced Explanation of Benefits for scheduled services or upon request to give patients transparency into their estimated healthcare costs. AEOBs need to include which providers are expected to provide treatment, the network status of providers, good faith estimates of cost, cost-sharing and progress towards meeting deductibles and out-of-pocket maximums, as well as whether a service is subject to medical management and relevant disclaimers of estimates; for example, the disclaimer might state that the information provided in the notification is only an estimate based on the items and services reasonably expected, at the time of scheduling (or requesting) and is subject to change. For a complete breakdown of what needs to be included in the AEOB see 42 U.S. Code 300gg-111(f)(1)(A) through (H). |
| CAAConsolidated Appropriations Act | Also called["H.R. 133".](https://www.ftc.gov/legal-library/browse/statutes/no-surprises-act-2021-consolidated-appropriations-act)The CARES (Coronavirus Aid, Relief, and Economic Security) Act implemented a variety of programs to address issues related to the onset of the COVID-19 pandemic.The Consolidated Appropriations Act continued many of these programs by adding new phases, new allocations, and new guidance to address issues related to the continuation of the COVID-19 pandemic. Title I (the No Surprises Act) of Division BB of the Consolidated Appropriations Act, 2021 establishes new protections from surprise billing and excessive cost sharing for consumers receiving healthcare items/services.The Consolidated Appropriations Act (2021) was passed by Congress on December 21, 2020 and signed into law on December 27, 2020. |
| GFE | The Good Faith Estimate is a notification of reasonably expected charges and billing codes for a scheduled or requested item or service. For a complete breakdown of what needs to be included in the GFE see[42 U.S. Code 300gg-136](https://www.law.cornell.edu/uscode/text/42/300gg-136) |
| HIPAA | The Health Insurance Portability and Accountability Act of 1996 (HIPAA) is a federal law that requires the creation of national standards to protect sensitive patient health information from being disclosed without the patient’s consent or knowledge. The US Department of Health and Human Services (HHS) issued the HIPAA Privacy Rule to implement the requirements of HIPAA. The HIPAA Security Rule protects a subset of information covered by the Privacy Rule. |

### Dependencies

This guide is based on the [FHIR R4](http://hl7.org/fhir/R4/) specification that is mandated for use in the U.S.

In addition, this guide also relies on several ancestor implementation guides:

| | | |
| :--- | :--- | :--- |
| [Da Vinci Health Record Exchange (HRex)](http://hl7.org/fhir/us/davinci-hrex/STU1.1) | [1.1.0](https://simplifier.net/packages/hl7.fhir.us.davinci-hrex/1.1.0) |  |
| [FHIR Extensions Pack](http://hl7.org/fhir/extensions/5.2.0) | [5.2.0](https://simplifier.net/packages/hl7.fhir.uv.extensions.r4/5.2.0) | Automatically added as a dependency - all IGs depend on the HL7 Extension Pack |
| [5.1.0](https://simplifier.net/packages/hl7.fhir.uv.extensions.r4/5.1.0) | Imported by Da Vinci Health Record Exchange (HRex) (and potentially others) | |
| [FHIR R4 package : Core](http://hl7.org/fhir/R4) | [4.0.1](https://simplifier.net/packages/hl7.fhir.r4.core/4.0.1) | Imported by FHIR Extensions Pack (and potentially others) |
| [HL7 Terminology (THO)](http://terminology.hl7.org/5.5.0) | [6.5.0](https://simplifier.net/packages/hl7.terminology.r4/6.5.0) |  |
| [6.1.0](https://simplifier.net/packages/hl7.terminology.r4/6.1.0) | Imported by Da Vinci Health Record Exchange (HRex) (and potentially others) | |
| [5.5.0](https://simplifier.net/packages/hl7.terminology.r4/5.5.0) | Imported by US Core (and potentially others) | |
| [5.0.0](https://simplifier.net/packages/hl7.terminology.r4/5.0.0) | Imported by Subscriptions R5 Backport (and potentially others) | |
| [Public Health Information Network Vocabulary Access and Distribution System (PHIN VADS)](http://fhir.org/packages/us.cdc.phinvads) | [0.12.0](https://simplifier.net/packages/us.cdc.phinvads/0.12.0) | Imported by US Core (and potentially others) |
| [SMART App Launch](http://hl7.org/fhir/smart-app-launch/STU2) | [2.0.0](https://simplifier.net/packages/hl7.fhir.uv.smart-app-launch/2.0.0) | Imported by US Core (and potentially others) |
| [Structured Data Capture](http://hl7.org/fhir/uv/sdc/STU3) | [3.0.0](https://simplifier.net/packages/hl7.fhir.uv.sdc/3.0.0) | Imported by US Core (and potentially others) |
| [Subscriptions R5 Backport](http://hl7.org/fhir/uv/subscriptions-backport/STU1.1) | [1.1.0](https://simplifier.net/packages/hl7.fhir.uv.subscriptions-backport.r4/1.1.0) |  |
| [US Core](http://hl7.org/fhir/us/core/STU7) | [7.0.0](https://simplifier.net/packages/hl7.fhir.us.core/7.0.0) | Needed for systems supporting USCDI v4 |
| [6.1.0](https://simplifier.net/packages/hl7.fhir.us.core/6.1.0) | Needed for systems supporting USCDI v3 | |
| [3.1.1](https://simplifier.net/packages/hl7.fhir.us.core/3.1.1) | Needed for systems supporting USCDI v1 | |
| [Value Set Authority Center (VSAC)](http://fhir.org/packages/us.nlm.vsac) | [0.19.0](https://simplifier.net/packages/us.nlm.vsac/0.19.0) | Imported by Da Vinci Health Record Exchange (HRex) (and potentially others) |
| [0.18.0](https://simplifier.net/packages/us.nlm.vsac/0.18.0) | Imported by US Core (and potentially others) | |

This implementation guide defines additional constraints and usage expectations above and beyond the information found in these base specifications.

### Intellectual Property Considerations

This implementation guide and the underlying FHIR specification are licensed as public domain under the [FHIR license](http://hl7.org/fhir/R4/license.html#license). The license page also describes rules for the use of the FHIR name and logo.

This publication includes IP covered under the following statements.

* © Copyright 2022 American Medical Association

* [NUCC Provider Taxonomy](http://tx.fhir.org/r4/ValueSet/nucc-provider-taxonomy): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [Bundle/PCT-GFE-Bundle-Inst-1](Bundle-PCT-GFE-Bundle-Inst-1.md)...Show 11 more,[Bundle/PCT-GFE-Bundle-Prof-1](Bundle-PCT-GFE-Bundle-Prof-1.md),[Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md),[Bundle/PCT-GFE-Packet-Prof-1](Bundle-PCT-GFE-Packet-Prof-1.md),[Claim/PCT-GFE-Institutional-1](Claim-PCT-GFE-Institutional-1.md),[Claim/PCT-GFE-Institutional-MRI](Claim-PCT-GFE-Institutional-MRI.md),[Claim/PCT-GFE-Professional-MRI](Claim-PCT-GFE-Professional-MRI.md),[PCTGFEInstitutional](StructureDefinition-davinci-pct-gfe-institutional.md),[PCTGFEProfessional](StructureDefinition-davinci-pct-gfe-professional.md),[PCTGFESummary](StructureDefinition-davinci-pct-gfe-summary.md),[PCTPractitioner](StructureDefinition-davinci-pct-practitioner.md)and[ProviderTaxonomy](StructureDefinition-providerTaxonomy.md)


* All X12 products are subject to this IP policy, including published and draft works.X12 is the only organization authorized to grant permission for use of X12 products. Users of all X12 products should make sure that they understand the permissible uses, as well as the limitations on such usage, as outlined below.Additional IP information can be found [here](https://x12.org/products/ip-use) Send an email to ip@x12.org to request permission to reproduce X12 IP. Include your name, organization, title, address, city, state, zip, email, a detailed description of the Submitted Artifact, including the underlying or cited X12 Product, and a detailed description of the intended audience and planned distribution method for the Artifact.Additional information on X12 licensing program can be found [here](https://x12.org/products/licensing-program) To purchase code list subscriptions call (425) 562-2245 or email admin@wpc-edi.com.

* [X12 Claim Adjustment Reason Codes](http://terminology.hl7.org/6.5.0/CodeSystem-X12ClaimAdjustmentReasonCodes.html): [PCTAdjustmentReasonVS](ValueSet-PCTAdjustmentReasonVS.md) and [PCTAdvancedEOB](StructureDefinition-davinci-pct-aeob.md)


* All X12 work products are copyrighted. Any use of any X12 work product must be compliant with US Copyright laws and X12 Intellectual Property policies.Please see [[https://x12.org/products/licensing-program](https://x12.org/products/licensing-program)](https://x12.org/products/licensing-program) 

* [X12 Service Type Codes](http://terminology.hl7.org/6.5.0/CodeSystem-X12ServiceTypeCodes.html): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [ExplanationOfBenefit/PCT-AEOB-1](ExplanationOfBenefit-PCT-AEOB-1.md)...Show 4 more,[ExplanationOfBenefit/PCT-AEOB-Summary-1](ExplanationOfBenefit-PCT-AEOB-Summary-1.md),[PCTAdvancedEOB](StructureDefinition-davinci-pct-aeob.md),[PCTAdvancedEOBSummary](StructureDefinition-davinci-pct-aeob-summary.md)and[PCTBenefitBalanceCategoryVS](ValueSet-PCTBenefitBalanceCategoryVS.md)


* CMS maintains HIPPS. There are no known constraints on the use of HIPPS.

* [Health Insurance Prospective Payment System (HIPPS)](http://terminology.hl7.org/6.5.0/CodeSystem-HIPPS.html): [EstimateProcedureOrService](StructureDefinition-estimateProcedureOrService.md), [PCTAdvancedEOB](StructureDefinition-davinci-pct-aeob.md)...Show 4 more,[PCTGFEInstitutional](StructureDefinition-davinci-pct-gfe-institutional.md),[PCTGFEProfessional](StructureDefinition-davinci-pct-gfe-professional.md),[PCTServiceRequest](StructureDefinition-davinci-pct-servicerequest.md)and[USClaimMedicalProductOrServiceCodes](ValueSet-USClaimMedicalProductOrServiceCodes.md)


* ISO maintains the copyright on the country codes, and controls its use carefully. For further details see the ISO 3166 web page: [https://www.iso.org/iso-3166-country-codes.html](https://www.iso.org/iso-3166-country-codes.html)

* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](http://terminology.hl7.org/6.5.0/CodeSystem-ISO3166Part1.html): [AEOBAdjudicationError](StructureDefinition-davinci-pct-aeob-adjudication-error.md), [AEOBComplete](StructureDefinition-davinci-pct-aeob-complete.md)...Show 120 more,[AEOBDateOfService](SearchParameter-aeob-date-of-service.md),[AHANUBCPointOfOriginVS](ValueSet-AHANUBCPointOfOriginVS.md),[AHANUBCPriorityTypeOfAdmissionOrVisitVS](ValueSet-AHANUBCPriorityTypeOfAdmissionOrVisitVS.md),[CoordinationPlatformPatientCostTransparencyCapabilityStatement](CapabilityStatement-davinci-pct-coordination-platform.md),[CoordinationRequesterPatientCostTransparencyCapabilityStatement](CapabilityStatement-davinci-pct-gfe-provider.md),[DocumentReferenceDocStatus](SearchParameter-DocumentReference-doc-status.md),[EstimateCondition](StructureDefinition-estimateCondition.md),[EstimateProcedureOrService](StructureDefinition-estimateProcedureOrService.md),[GFEBillingProviderLineItemCtrlNum](StructureDefinition-gfeBillingProviderLineItemCtrlNum.md),[GFEConsentForBalanceBilling](StructureDefinition-gfeConsentForBalanceBilling.md),[GFEContributorPatientCostTransparencyCapabilityStatement](CapabilityStatement-davinci-pct-gfe-contributor.md),[GFECoordinationRequest](OperationDefinition-GFE-coordination-request.md),[GFEDisclaimer](StructureDefinition-gfeDisclaimer.md),[GFEReference](StructureDefinition-gfeReference.md),[GFERelatedTask](StructureDefinition-gfeRelatedTask.md),[GFERetrieve](OperationDefinition-GFE-retrieve.md),[GFEServiceLinkingInfo](StructureDefinition-gfeServiceLinkingInfo.md),[GFESubmit](OperationDefinition-GFE-submit.md),[GFEValidationError](StructureDefinition-davinci-pct-gfe-validation-error.md),[ICD10ProcedureCodes](ValueSet-ICD10ProcedureCodes.md),[OutOfNetworkProviderInfo](StructureDefinition-inNetworkProviderOptionsLink.md),[PCTAEOBAvailableAuthorSubscription](StructureDefinition-davinci-pct-aeob-available-author-subscription.md),[PCTAEOBAvailableAuthorSubscriptionTopic](SubscriptionTopic-davinci-pct-aeob-available-author-notification.md),[PCTAEOBAvailableSubjectSubscription](StructureDefinition-davinci-pct-aeob-available-subject-subscription.md),[PCTAEOBAvailableSubjectSubscriptionTopic](SubscriptionTopic-davinci-pct-aeob-available-subject-notification.md),[PCTAEOBPacket](StructureDefinition-davinci-pct-aeob-packet.md),[PCTAEOBProcessNoteCS](CodeSystem-PCTAEOBProcessNoteCS.md),[PCTAEOBProcessNoteVS](ValueSet-PCTAEOBProcessNoteVS.md),[PCTAdjudication](CodeSystem-PCTAdjudication.md),[PCTAdjudicationCategoryCS](CodeSystem-PCTAdjudicationCategoryCS.md),[PCTAdjudicationCategoryVS](ValueSet-PCTAdjudicationCategoryVS.md),[PCTAdjudicationVS](ValueSet-PCTAdjudicationVS.md),[PCTAdjustmentReasonVS](ValueSet-PCTAdjustmentReasonVS.md),[PCTAdvancedEOB](StructureDefinition-davinci-pct-aeob.md),[PCTAdvancedEOBComposition](StructureDefinition-davinci-pct-aeob-composition.md),[PCTAdvancedEOBDocumentReference](StructureDefinition-davinci-pct-aeob-documentreference.md),[PCTAdvancedEOBSummary](StructureDefinition-davinci-pct-aeob-summary.md),[PCTBenefitBalanceCategoryVS](ValueSet-PCTBenefitBalanceCategoryVS.md),[PCTCareTeamRoleVS](ValueSet-PCTCareTeamRoleVS.md),[PCTContributorTaskStatusCodes](ValueSet-PCTContributorTaskStatusCodes.md),[PCTContributorTaskStatusReasonCodes](ValueSet-PCTContributorTaskStatusReasonCodes.md),[PCTCoordinationTaskStatusCodes](ValueSet-PCTCoordinationTaskStatusCodes.md),[PCTCoordinationTaskStatusReasonCodes](ValueSet-PCTCoordinationTaskStatusReasonCodes.md),[PCTCoverage](StructureDefinition-davinci-pct-coverage.md),[PCTDeviceRequest](StructureDefinition-davinci-pct-devicerequest.md),[PCTDiagnosticCodes](ValueSet-PCTDiagnosticCodes.md),[PCTDocumentSection](CodeSystem-PCTDocumentSection.md),[PCTDocumentTypeTemporaryTrialUse](CodeSystem-PCTDocumentTypeTemporaryTrialUse.md),[PCTEstimateTypeSummaryCSTemporaryTrialUse](CodeSystem-PCTEstimateTypeSummaryCSTemporaryTrialUse.md),[PCTFinancialType](CodeSystem-PCTFinancialType.md),[PCTFinancialTypeVS](ValueSet-PCTFinancialTypeVS.md),[PCTGFEAvailableAuthorSubscription](StructureDefinition-davinci-pct-gfe-available-author-subscription.md),[PCTGFEAvailableAuthorSubscriptionTopic](SubscriptionTopic-davinci-pct-gfe-available-author-notification.md),[PCTGFEAvailableSubjectSubscription](StructureDefinition-davinci-pct-gfe-available-subject-subscription.md),[PCTGFEAvailableSubjectSubscriptionTopic](SubscriptionTopic-davinci-pct-gfe-available-subject-notification.md),[PCTGFEBundle](StructureDefinition-davinci-pct-gfe-bundle.md),[PCTGFECMSPOS](ValueSet-PCTGFECMSPOS.md),[PCTGFEComposition](StructureDefinition-davinci-pct-gfe-composition.md),[PCTGFEContributorTask](StructureDefinition-davinci-pct-gfe-contributor-task.md),[PCTGFECoordinationBundle](StructureDefinition-davinci-pct-gfe-coordination-bundle.md),[PCTGFECoordinationTask](StructureDefinition-davinci-pct-gfe-coordination-task.md),[PCTGFECoordinationTaskSubscriptionTopic](SubscriptionTopic-davinci-pct-gfe-coordination-task-notification.md),[PCTGFEDocumentReference](StructureDefinition-davinci-pct-gfe-documentreference.md),[PCTGFEInformationBundle](StructureDefinition-davinci-pct-gfe-information-bundle.md),[PCTGFEInstitutional](StructureDefinition-davinci-pct-gfe-institutional.md),[PCTGFEItemCptHcpcsVS](ValueSet-PCTGFEItemCptHcpcsVS.md),[PCTGFEItemNDCVS](ValueSet-PCTGFEItemNDCVS.md),[PCTGFEItemRevenueVS](ValueSet-PCTGFEItemRevenueVS.md),[PCTGFEMissingBundle](StructureDefinition-davinci-pct-gfe-missing-bundle.md),[PCTGFEPacket](StructureDefinition-davinci-pct-gfe-packet.md),[PCTGFEProfessional](StructureDefinition-davinci-pct-gfe-professional.md),[PCTGFERequestTypeCSTemporaryTrialUse](CodeSystem-PCTGFERequestTypeCSTemporaryTrialUse.md),[PCTGFERequestTypeVS](ValueSet-PCTGFERequestTypeVS.md),[PCTGFESummary](StructureDefinition-davinci-pct-gfe-summary.md),[PCTGFETaskRelationship](ValueSet-PCTGFETaskRelationship.md),[PCTGFETaskUpdateSubscription](StructureDefinition-davinci-pct-gfe-task-update-subscription.md),[PCTGFETypeOfBillVS](ValueSet-PCTGFETypeOfBillVS.md),[PCTMedicationRequest](StructureDefinition-davinci-pct-medicationrequest.md),[PCTNetworkStatusCS](CodeSystem-PCTNetworkStatusCS.md),[PCTOrgContactPurposeType](CodeSystem-PCTOrgContactPurposeType.md),[PCTOrgContactPurposeTypeVS](ValueSet-PCTOrgContactPurposeTypeVS.md),[PCTOrganization](StructureDefinition-davinci-pct-organization.md),[PCTOrganizationTypeVS](ValueSet-PCTOrganizationTypeVS.md),[PCTPayerBenefitPaymentStatusVS](ValueSet-PCTPayerBenefitPaymentStatusVS.md),[PCTPayerProviderNetworkStatusVS](ValueSet-PCTPayerProviderNetworkStatusVS.md),[PCTPractitioner](StructureDefinition-davinci-pct-practitioner.md),[PCTProcedureSurgicalCodes](ValueSet-PCTProcedureSurgicalCodes.md),[PCTProcedureType](CodeSystem-PCTProcedureType.md),[PCTProcedureTypeVS](ValueSet-PCTProcedureTypeVS.md),[PCTServiceLocation](StructureDefinition-davinci-pct-service-location.md),[PCTServiceRequest](StructureDefinition-davinci-pct-servicerequest.md),[PCTSupportingInfoType](CodeSystem-PCTSupportingInfoType.md),[PCTSupportingInfoTypeVS](ValueSet-PCTSupportingInfoTypeVS.md),[PCTTaskAttachmentContentType](ValueSet-PCTTaskAttachmentContentType.md),[PCTTaskBusinessStatusCSTemporaryTrialUse](CodeSystem-PCTTaskBusinessStatusCSTemporaryTrialUse.md),[PCTTaskBusinessStatusCodes](ValueSet-PCTTaskBusinessStatusCodes.md),[PCTTaskStatusReasonCSTemporaryTrialUse](CodeSystem-PCTTaskStatusReasonCSTemporaryTrialUse.md),[PCTTotal](ValueSet-PCTTotal.md),[PacketCondition](SearchParameter-packet-condition.md),[PacketLinkingIdentifier](SearchParameter-packet-linking-identifier.md),[PacketPlannedPeriodOfService](SearchParameter-packet-PlannedPeriodOfService.md),[PacketProcedureOrService](SearchParameter-packet-procedure-or-service.md),[PacketRequestInitiationTime](SearchParameter-packet-request-initiation-time.md),[PatientCostTransparency](index.md),[PatientCostTransparencyCapabilityStatement](CapabilityStatement-davinci-pct.md),[PlannedServicePeriod](StructureDefinition-plannedServicePeriod.md),[ProcessNoteClass](StructureDefinition-processNoteClass.md),[ProviderEventMethodology](StructureDefinition-providerEventMethodology.md),[ProviderTaxonomy](StructureDefinition-providerTaxonomy.md),[ReferralNumber](StructureDefinition-referralNumber.md),[RelatedTask](SearchParameter-related-task.md),[RemainingBenefit](StructureDefinition-remaining-benefit.md),[RequestInitiationTime](StructureDefinition-requestInitiationTime.md),[RequestOriginationType](StructureDefinition-requestOriginationType.md),[SelfPayDeclared](StructureDefinition-selfPayDeclared.md),[ServiceDescription](StructureDefinition-serviceDescription.md),[SubjectToMedicalMgmt](StructureDefinition-subjectToMedicalMgmt.md),[TaskRequestedPeriod](SearchParameter-task-requested-period.md),[USClaimDRGCodes](ValueSet-USClaimDRGCodes.md)and[USClaimMedicalProductOrServiceCodes](ValueSet-USClaimMedicalProductOrServiceCodes.md)


* Licensing information can be found [here](https://www.nubc.org/license) These codes are listed within the UB-04 Data Specifications Manual. The Official UB-04 Data Specifications Manual, copyrighted by the American Hospital Association, is the only official source of UB-04 billing information adopted by the National Uniform Billing Committee. No other publication—governmental or private/commercial—can be considered authoritative. The AHA wants to make you aware that the use of codes, descriptions, or any other content contained in the manual to be used in a software application, publication, or any other derivative work must be properly licensed by the AHA. If your organization uses or intends to use any of the codes or other related content from the manual in this manner, please contact the AHA’s licensing manager, Tim Carlson, at 312.893.6816 or tcarlson@aha.org

* [AHA NUBC Revenue Codes](http://terminology.hl7.org/6.5.0/CodeSystem-AHANUBCRevenueCodes.html): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [Bundle/PCT-GFE-Bundle-Inst-1](Bundle-PCT-GFE-Bundle-Inst-1.md)...Show 7 more,[Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md),[Claim/PCT-GFE-Institutional-1](Claim-PCT-GFE-Institutional-1.md),[Claim/PCT-GFE-Institutional-MRI](Claim-PCT-GFE-Institutional-MRI.md),[ExplanationOfBenefit/PCT-AEOB-1](ExplanationOfBenefit-PCT-AEOB-1.md),[PCTAdvancedEOB](StructureDefinition-davinci-pct-aeob.md),[PCTGFEInstitutional](StructureDefinition-davinci-pct-gfe-institutional.md)and[PCTGFEItemRevenueVS](ValueSet-PCTGFEItemRevenueVS.md)
* [AHA NUBC Type Of Bill Codes](http://terminology.hl7.org/6.5.0/CodeSystem-AHANUBCTypeOfBill.html): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [Bundle/PCT-GFE-Bundle-Inst-1](Bundle-PCT-GFE-Bundle-Inst-1.md)...Show 6 more,[Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md),[Claim/PCT-GFE-Institutional-1](Claim-PCT-GFE-Institutional-1.md),[Claim/PCT-GFE-Institutional-MRI](Claim-PCT-GFE-Institutional-MRI.md),[PCTGFEInstitutional](StructureDefinition-davinci-pct-gfe-institutional.md),[PCTGFEProfessional](StructureDefinition-davinci-pct-gfe-professional.md)and[PCTGFETypeOfBillVS](ValueSet-PCTGFETypeOfBillVS.md)


* The Centers for Medicare & Medicaid Services (CMS) maintain MS-DRGs used throughout the US health care industry. The CMS MS-DRGs are free to use without restriction.

* [Medicare Severity Diagnosis Related Groups (MS-DRGs)](http://terminology.hl7.org/6.5.0/CodeSystem-MSDRG.html): [PCTGFEInstitutional](StructureDefinition-davinci-pct-gfe-institutional.md) and [USClaimDRGCodes](ValueSet-USClaimDRGCodes.md)


* This CodeSystem is not copyrighted.

* [PCT AEOB Process Note Code System](CodeSystem-PCTAEOBProcessNoteCS.md): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [ExplanationOfBenefit/PCT-AEOB-1](ExplanationOfBenefit-PCT-AEOB-1.md), [ExplanationOfBenefit/PCT-AEOB-Summary-1](ExplanationOfBenefit-PCT-AEOB-Summary-1.md), [PCTAEOBProcessNoteVS](ValueSet-PCTAEOBProcessNoteVS.md) and [ProcessNoteClass](StructureDefinition-processNoteClass.md)
* [PCT Adjudication Code System](CodeSystem-PCTAdjudication.md): [PCTAdjudicationVS](ValueSet-PCTAdjudicationVS.md), [PCTAdvancedEOB](StructureDefinition-davinci-pct-aeob.md) and [PCTAdvancedEOBSummary](StructureDefinition-davinci-pct-aeob-summary.md)
* [PCT Packet Section Codes](CodeSystem-PCTDocumentSection.md): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md), [Bundle/PCT-GFE-Packet-Prof-1](Bundle-PCT-GFE-Packet-Prof-1.md), [PCTAdvancedEOBComposition](StructureDefinition-davinci-pct-aeob-composition.md) and [PCTGFEComposition](StructureDefinition-davinci-pct-gfe-composition.md)
* [PCT Document Types](CodeSystem-PCTDocumentTypeTemporaryTrialUse.md): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [Bundle/PCT-GFE-Coordination-Bundle-1](Bundle-PCT-GFE-Coordination-Bundle-1.md)...Show 13 more,[Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md),[Bundle/PCT-GFE-Packet-Prof-1](Bundle-PCT-GFE-Packet-Prof-1.md),[DocumentReference/PCT-AEOB-DocumentReference-1](DocumentReference-PCT-AEOB-DocumentReference-1.md),[DocumentReference/PCT-GFE-DocumentReference-Inst-1](DocumentReference-PCT-GFE-DocumentReference-Inst-1.md),[DocumentReference/PCT-GFE-DocumentReference-Prof-1](DocumentReference-PCT-GFE-DocumentReference-Prof-1.md),[PCTAdvancedEOBComposition](StructureDefinition-davinci-pct-aeob-composition.md),[PCTAdvancedEOBDocumentReference](StructureDefinition-davinci-pct-aeob-documentreference.md),[PCTGFEComposition](StructureDefinition-davinci-pct-gfe-composition.md),[PCTGFEContributorTask](StructureDefinition-davinci-pct-gfe-contributor-task.md),[PCTGFECoordinationTask](StructureDefinition-davinci-pct-gfe-coordination-task.md),[PCTGFEDocumentReference](StructureDefinition-davinci-pct-gfe-documentreference.md),[Task/PCT-GFE-Coordination-Replacement-Task-1](Task-PCT-GFE-Coordination-Replacement-Task-1.md)and[Task/PCT-GFE-Coordination-Task-1](Task-PCT-GFE-Coordination-Task-1.md)
* [PCT Estimate Type Code System](CodeSystem-PCTEstimateTypeSummaryCSTemporaryTrialUse.md): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [Bundle/PCT-GFE-Bundle-Inst-1](Bundle-PCT-GFE-Bundle-Inst-1.md)...Show 8 more,[Bundle/PCT-GFE-Bundle-Prof-1](Bundle-PCT-GFE-Bundle-Prof-1.md),[Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md),[Bundle/PCT-GFE-Packet-Prof-1](Bundle-PCT-GFE-Packet-Prof-1.md),[Claim/PCT-GFE-Summary-1](Claim-PCT-GFE-Summary-1.md),[Claim/PCT-GFE-Summary-MRI](Claim-PCT-GFE-Summary-MRI.md),[ExplanationOfBenefit/PCT-AEOB-Summary-1](ExplanationOfBenefit-PCT-AEOB-Summary-1.md),[PCTAdvancedEOBSummary](StructureDefinition-davinci-pct-aeob-summary.md)and[PCTGFESummary](StructureDefinition-davinci-pct-gfe-summary.md)
* [PCT Financial Type Code System](CodeSystem-PCTFinancialType.md): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [ExplanationOfBenefit/PCT-AEOB-1](ExplanationOfBenefit-PCT-AEOB-1.md)...Show 4 more,[ExplanationOfBenefit/PCT-AEOB-Summary-1](ExplanationOfBenefit-PCT-AEOB-Summary-1.md),[PCTAdvancedEOB](StructureDefinition-davinci-pct-aeob.md),[PCTAdvancedEOBSummary](StructureDefinition-davinci-pct-aeob-summary.md)and[PCTFinancialTypeVS](ValueSet-PCTFinancialTypeVS.md)
* [PCT GFE Request Type Codes Code System](CodeSystem-PCTGFERequestTypeCSTemporaryTrialUse.md): [Bundle/PCT-GFE-Coordination-Bundle-1](Bundle-PCT-GFE-Coordination-Bundle-1.md), [Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md)...Show 11 more,[Bundle/PCT-GFE-Packet-Prof-1](Bundle-PCT-GFE-Packet-Prof-1.md),[PCTGFEContributorTask](StructureDefinition-davinci-pct-gfe-contributor-task.md),[PCTGFECoordinationTask](StructureDefinition-davinci-pct-gfe-coordination-task.md),[PCTGFERequestTypeVS](ValueSet-PCTGFERequestTypeVS.md),[RequestOriginationType](StructureDefinition-requestOriginationType.md),[Task/PCT-GFE-Contributor-Replacement-Task-1](Task-PCT-GFE-Contributor-Replacement-Task-1.md),[Task/PCT-GFE-Contributor-Replacement-Task-2](Task-PCT-GFE-Contributor-Replacement-Task-2.md),[Task/PCT-GFE-Contributor-Task-1](Task-PCT-GFE-Contributor-Task-1.md),[Task/PCT-GFE-Contributor-Task-2](Task-PCT-GFE-Contributor-Task-2.md),[Task/PCT-GFE-Coordination-Replacement-Task-1](Task-PCT-GFE-Coordination-Replacement-Task-1.md)and[Task/PCT-GFE-Coordination-Task-1](Task-PCT-GFE-Coordination-Task-1.md)
* [PCT Network Status](CodeSystem-PCTNetworkStatusCS.md): [PCTAdvancedEOB](StructureDefinition-davinci-pct-aeob.md), [PCTAdvancedEOBSummary](StructureDefinition-davinci-pct-aeob-summary.md), [PCTPayerBenefitPaymentStatusVS](ValueSet-PCTPayerBenefitPaymentStatusVS.md), [PCTPayerProviderNetworkStatusVS](ValueSet-PCTPayerProviderNetworkStatusVS.md) and [PCTTotal](ValueSet-PCTTotal.md)
* [PCT Organization Contact Purpose Type Code System](CodeSystem-PCTOrgContactPurposeType.md): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [Bundle/PCT-GFE-Bundle-Inst-1](Bundle-PCT-GFE-Bundle-Inst-1.md)...Show 4 more,[Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md),[GFE Service Help INC.](Organization-Submitter-Org-1.md),[PCTOrgContactPurposeTypeVS](ValueSet-PCTOrgContactPurposeTypeVS.md)and[PCTOrganization](StructureDefinition-davinci-pct-organization.md)
* [PCT Procedure Type](CodeSystem-PCTProcedureType.md): [PCTGFEInstitutional](StructureDefinition-davinci-pct-gfe-institutional.md), [PCTGFEProfessional](StructureDefinition-davinci-pct-gfe-professional.md), [PCTGFESummary](StructureDefinition-davinci-pct-gfe-summary.md) and [PCTProcedureTypeVS](ValueSet-PCTProcedureTypeVS.md)
* [PCT GFE Supporting Info Type Code System](CodeSystem-PCTSupportingInfoType.md): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [Bundle/PCT-GFE-Bundle-Inst-1](Bundle-PCT-GFE-Bundle-Inst-1.md)...Show 6 more,[Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md),[Claim/PCT-GFE-Institutional-1](Claim-PCT-GFE-Institutional-1.md),[Claim/PCT-GFE-Institutional-MRI](Claim-PCT-GFE-Institutional-MRI.md),[PCTGFEInstitutional](StructureDefinition-davinci-pct-gfe-institutional.md),[PCTGFEProfessional](StructureDefinition-davinci-pct-gfe-professional.md)and[PCTSupportingInfoTypeVS](ValueSet-PCTSupportingInfoTypeVS.md)
* [PCT GFE Request Task Business Status Code System](CodeSystem-PCTTaskBusinessStatusCSTemporaryTrialUse.md): [PCTGFEContributorTask](StructureDefinition-davinci-pct-gfe-contributor-task.md), [PCTGFECoordinationTask](StructureDefinition-davinci-pct-gfe-coordination-task.md) and [PCTTaskBusinessStatusCodes](ValueSet-PCTTaskBusinessStatusCodes.md)
* [PCT GFE Request Task Status Reason Code Code System](CodeSystem-PCTTaskStatusReasonCSTemporaryTrialUse.md): [PCTContributorTaskStatusReasonCodes](ValueSet-PCTContributorTaskStatusReasonCodes.md), [PCTCoordinationTaskStatusReasonCodes](ValueSet-PCTCoordinationTaskStatusReasonCodes.md), [PCTGFEContributorTask](StructureDefinition-davinci-pct-gfe-contributor-task.md) and [PCTGFECoordinationTask](StructureDefinition-davinci-pct-gfe-coordination-task.md)


* This material contains content from [LOINC](http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the [license](http://loinc.org/license). LOINC® is a registered United States trademark of Regenstrief Institute, Inc.

* [LOINC](http://terminology.hl7.org/6.5.0/CodeSystem-v3-loinc.html): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md)...Show 9 more,[Bundle/PCT-GFE-Packet-Prof-1](Bundle-PCT-GFE-Packet-Prof-1.md),[DocumentReference/PCT-AEOB-DocumentReference-1](DocumentReference-PCT-AEOB-DocumentReference-1.md),[DocumentReference/PCT-GFE-DocumentReference-Inst-1](DocumentReference-PCT-GFE-DocumentReference-Inst-1.md),[DocumentReference/PCT-GFE-DocumentReference-Prof-1](DocumentReference-PCT-GFE-DocumentReference-Prof-1.md),[PCTAdvancedEOBComposition](StructureDefinition-davinci-pct-aeob-composition.md),[PCTAdvancedEOBDocumentReference](StructureDefinition-davinci-pct-aeob-documentreference.md),[PCTGFEComposition](StructureDefinition-davinci-pct-gfe-composition.md),[PCTGFECoordinationTask](StructureDefinition-davinci-pct-gfe-coordination-task.md)and[PCTGFEDocumentReference](StructureDefinition-davinci-pct-gfe-documentreference.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [Adjudication Value Codes](http://terminology.hl7.org/6.5.0/CodeSystem-adjudication.html): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [ExplanationOfBenefit/PCT-AEOB-1](ExplanationOfBenefit-PCT-AEOB-1.md)...Show 5 more,[ExplanationOfBenefit/PCT-AEOB-Summary-1](ExplanationOfBenefit-PCT-AEOB-Summary-1.md),[PCTAdjudicationCategoryVS](ValueSet-PCTAdjudicationCategoryVS.md),[PCTAdjudicationVS](ValueSet-PCTAdjudicationVS.md),[PCTAdvancedEOB](StructureDefinition-davinci-pct-aeob.md)and[PCTAdvancedEOBSummary](StructureDefinition-davinci-pct-aeob-summary.md)
* [Benefit Term Codes](http://terminology.hl7.org/6.5.0/CodeSystem-benefit-term.html): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [ExplanationOfBenefit/PCT-AEOB-1](ExplanationOfBenefit-PCT-AEOB-1.md), [ExplanationOfBenefit/PCT-AEOB-Summary-1](ExplanationOfBenefit-PCT-AEOB-Summary-1.md), [PCTAdvancedEOB](StructureDefinition-davinci-pct-aeob.md) and [PCTAdvancedEOBSummary](StructureDefinition-davinci-pct-aeob-summary.md)
* [Unit Type Codes](http://terminology.hl7.org/6.5.0/CodeSystem-benefit-unit.html): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [ExplanationOfBenefit/PCT-AEOB-1](ExplanationOfBenefit-PCT-AEOB-1.md), [ExplanationOfBenefit/PCT-AEOB-Summary-1](ExplanationOfBenefit-PCT-AEOB-Summary-1.md), [PCTAdvancedEOB](StructureDefinition-davinci-pct-aeob.md) and [PCTAdvancedEOBSummary](StructureDefinition-davinci-pct-aeob-summary.md)
* [Claim Type Codes](http://terminology.hl7.org/6.5.0/CodeSystem-claim-type.html): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [Bundle/PCT-GFE-Bundle-Inst-1](Bundle-PCT-GFE-Bundle-Inst-1.md)...Show 10 more,[Bundle/PCT-GFE-Bundle-Prof-1](Bundle-PCT-GFE-Bundle-Prof-1.md),[Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md),[Bundle/PCT-GFE-Packet-Prof-1](Bundle-PCT-GFE-Packet-Prof-1.md),[Claim/PCT-GFE-Institutional-1](Claim-PCT-GFE-Institutional-1.md),[Claim/PCT-GFE-Institutional-MRI](Claim-PCT-GFE-Institutional-MRI.md),[Claim/PCT-GFE-Professional-MRI](Claim-PCT-GFE-Professional-MRI.md),[ExplanationOfBenefit/PCT-AEOB-1](ExplanationOfBenefit-PCT-AEOB-1.md),[PCTAdvancedEOB](StructureDefinition-davinci-pct-aeob.md),[PCTGFEInstitutional](StructureDefinition-davinci-pct-gfe-institutional.md)and[PCTGFEProfessional](StructureDefinition-davinci-pct-gfe-professional.md)
* [Claim Care Team Role Codes](http://terminology.hl7.org/6.5.0/CodeSystem-claimcareteamrole.html): [PCTCareTeamRoleVS](ValueSet-PCTCareTeamRoleVS.md), [PCTGFEInstitutional](StructureDefinition-davinci-pct-gfe-institutional.md), [PCTGFEProfessional](StructureDefinition-davinci-pct-gfe-professional.md) and [PCTGFESummary](StructureDefinition-davinci-pct-gfe-summary.md)
* [Contact entity type](http://terminology.hl7.org/6.5.0/CodeSystem-contactentity-type.html): [PCTOrgContactPurposeTypeVS](ValueSet-PCTOrgContactPurposeTypeVS.md) and [PCTOrganization](StructureDefinition-davinci-pct-organization.md)
* [Coverage Class Codes](http://terminology.hl7.org/6.5.0/CodeSystem-coverage-class.html): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [Bundle/PCT-GFE-Bundle-Inst-1](Bundle-PCT-GFE-Bundle-Inst-1.md)...Show 7 more,[Bundle/PCT-GFE-Bundle-Prof-1](Bundle-PCT-GFE-Bundle-Prof-1.md),[Bundle/PCT-GFE-Information-Bundle-1](Bundle-PCT-GFE-Information-Bundle-1.md),[Bundle/PCT-GFE-Missing-Bundle-1](Bundle-PCT-GFE-Missing-Bundle-1.md),[Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md),[Bundle/PCT-GFE-Packet-Prof-1](Bundle-PCT-GFE-Packet-Prof-1.md),[Coverage/coverage1001](Coverage-coverage1001.md)and[PCTCoverage](StructureDefinition-davinci-pct-coverage.md)
* [Coverage Copay Type Codes](http://terminology.hl7.org/6.5.0/CodeSystem-coverage-copay-type.html): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [Bundle/PCT-GFE-Bundle-Inst-1](Bundle-PCT-GFE-Bundle-Inst-1.md)...Show 7 more,[Bundle/PCT-GFE-Bundle-Prof-1](Bundle-PCT-GFE-Bundle-Prof-1.md),[Bundle/PCT-GFE-Information-Bundle-1](Bundle-PCT-GFE-Information-Bundle-1.md),[Bundle/PCT-GFE-Missing-Bundle-1](Bundle-PCT-GFE-Missing-Bundle-1.md),[Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md),[Bundle/PCT-GFE-Packet-Prof-1](Bundle-PCT-GFE-Packet-Prof-1.md),[Coverage/coverage1001](Coverage-coverage1001.md)and[PCTCoverage](StructureDefinition-davinci-pct-coverage.md)
* [DataAbsentReason](http://terminology.hl7.org/6.5.0/CodeSystem-data-absent-reason.html): [EstimateProcedureOrService](StructureDefinition-estimateProcedureOrService.md), [PCTAdvancedEOB](StructureDefinition-davinci-pct-aeob.md)...Show 4 more,[PCTGFEInstitutional](StructureDefinition-davinci-pct-gfe-institutional.md),[PCTGFEProfessional](StructureDefinition-davinci-pct-gfe-professional.md),[PCTServiceRequest](StructureDefinition-davinci-pct-servicerequest.md)and[USClaimMedicalProductOrServiceCodes](ValueSet-USClaimMedicalProductOrServiceCodes.md)
* [Diagnosis Type Codes](http://terminology.hl7.org/6.5.0/CodeSystem-diagnosistype.html): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [Bundle/PCT-GFE-Bundle-Inst-1](Bundle-PCT-GFE-Bundle-Inst-1.md)...Show 11 more,[Bundle/PCT-GFE-Bundle-Prof-1](Bundle-PCT-GFE-Bundle-Prof-1.md),[Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md),[Bundle/PCT-GFE-Packet-Prof-1](Bundle-PCT-GFE-Packet-Prof-1.md),[Claim/PCT-GFE-Institutional-1](Claim-PCT-GFE-Institutional-1.md),[Claim/PCT-GFE-Institutional-MRI](Claim-PCT-GFE-Institutional-MRI.md),[Claim/PCT-GFE-Professional-MRI](Claim-PCT-GFE-Professional-MRI.md),[Claim/PCT-GFE-Summary-1](Claim-PCT-GFE-Summary-1.md),[Claim/PCT-GFE-Summary-MRI](Claim-PCT-GFE-Summary-MRI.md),[PCTGFEInstitutional](StructureDefinition-davinci-pct-gfe-institutional.md),[PCTGFEProfessional](StructureDefinition-davinci-pct-gfe-professional.md)and[PCTGFESummary](StructureDefinition-davinci-pct-gfe-summary.md)
* [Example Diagnosis Related Group Codes](http://terminology.hl7.org/6.5.0/CodeSystem-ex-diagnosisrelatedgroup.html): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [Bundle/PCT-GFE-Bundle-Inst-1](Bundle-PCT-GFE-Bundle-Inst-1.md)...Show 8 more,[Bundle/PCT-GFE-Bundle-Prof-1](Bundle-PCT-GFE-Bundle-Prof-1.md),[Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md),[Bundle/PCT-GFE-Packet-Prof-1](Bundle-PCT-GFE-Packet-Prof-1.md),[Claim/PCT-GFE-Institutional-1](Claim-PCT-GFE-Institutional-1.md),[Claim/PCT-GFE-Institutional-MRI](Claim-PCT-GFE-Institutional-MRI.md),[Claim/PCT-GFE-Professional-MRI](Claim-PCT-GFE-Professional-MRI.md),[Claim/PCT-GFE-Summary-1](Claim-PCT-GFE-Summary-1.md)and[Claim/PCT-GFE-Summary-MRI](Claim-PCT-GFE-Summary-MRI.md)
* [Example Procedure Type Codes](http://terminology.hl7.org/6.5.0/CodeSystem-ex-procedure-type.html): [PCTGFEInstitutional](StructureDefinition-davinci-pct-gfe-institutional.md), [PCTGFEProfessional](StructureDefinition-davinci-pct-gfe-professional.md), [PCTGFESummary](StructureDefinition-davinci-pct-gfe-summary.md) and [PCTProcedureTypeVS](ValueSet-PCTProcedureTypeVS.md)
* [Medical Management Type](http://terminology.hl7.org/6.5.0/CodeSystem-medical-management-type.html): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [ExplanationOfBenefit/PCT-AEOB-1](ExplanationOfBenefit-PCT-AEOB-1.md) and [SubjectToMedicalMgmt](StructureDefinition-subjectToMedicalMgmt.md)
* [Organization type](http://terminology.hl7.org/6.5.0/CodeSystem-organization-type.html): [Boston Radiology Center](Organization-org1002.md), [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md)...Show 8 more,[Bundle/PCT-GFE-Bundle-Inst-1](Bundle-PCT-GFE-Bundle-Inst-1.md),[Bundle/PCT-GFE-Bundle-Prof-1](Bundle-PCT-GFE-Bundle-Prof-1.md),[Bundle/PCT-GFE-Information-Bundle-1](Bundle-PCT-GFE-Information-Bundle-1.md),[Bundle/PCT-GFE-Missing-Bundle-1](Bundle-PCT-GFE-Missing-Bundle-1.md),[Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md),[Bundle/PCT-GFE-Packet-Prof-1](Bundle-PCT-GFE-Packet-Prof-1.md),[GFE Service Help INC.](Organization-Submitter-Org-1.md)and[Umbrella Insurance Company](Organization-org1001.md)
* [Payee Type Codes](http://terminology.hl7.org/6.5.0/CodeSystem-payeetype.html): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [Bundle/PCT-GFE-Bundle-Inst-1](Bundle-PCT-GFE-Bundle-Inst-1.md)...Show 6 more,[Bundle/PCT-GFE-Bundle-Prof-1](Bundle-PCT-GFE-Bundle-Prof-1.md),[Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md),[Bundle/PCT-GFE-Packet-Prof-1](Bundle-PCT-GFE-Packet-Prof-1.md),[Claim/PCT-GFE-Institutional-1](Claim-PCT-GFE-Institutional-1.md),[Claim/PCT-GFE-Institutional-MRI](Claim-PCT-GFE-Institutional-MRI.md)and[Claim/PCT-GFE-Professional-MRI](Claim-PCT-GFE-Professional-MRI.md)
* [Process Priority Codes](http://terminology.hl7.org/6.5.0/CodeSystem-processpriority.html): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [Bundle/PCT-GFE-Bundle-Inst-1](Bundle-PCT-GFE-Bundle-Inst-1.md)...Show 14 more,[Bundle/PCT-GFE-Bundle-Prof-1](Bundle-PCT-GFE-Bundle-Prof-1.md),[Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md),[Bundle/PCT-GFE-Packet-Prof-1](Bundle-PCT-GFE-Packet-Prof-1.md),[Claim/PCT-GFE-Institutional-1](Claim-PCT-GFE-Institutional-1.md),[Claim/PCT-GFE-Institutional-MRI](Claim-PCT-GFE-Institutional-MRI.md),[Claim/PCT-GFE-Professional-MRI](Claim-PCT-GFE-Professional-MRI.md),[Claim/PCT-GFE-Summary-1](Claim-PCT-GFE-Summary-1.md),[Claim/PCT-GFE-Summary-MRI](Claim-PCT-GFE-Summary-MRI.md),[ExplanationOfBenefit/PCT-AEOB-1](ExplanationOfBenefit-PCT-AEOB-1.md),[PCTAdvancedEOB](StructureDefinition-davinci-pct-aeob.md),[PCTAdvancedEOBSummary](StructureDefinition-davinci-pct-aeob-summary.md),[PCTGFEInstitutional](StructureDefinition-davinci-pct-gfe-institutional.md),[PCTGFEProfessional](StructureDefinition-davinci-pct-gfe-professional.md)and[PCTGFESummary](StructureDefinition-davinci-pct-gfe-summary.md)
* [SubscriberPolicyholder Relationship Codes](http://terminology.hl7.org/6.5.0/CodeSystem-subscriber-relationship.html): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [Bundle/PCT-GFE-Bundle-Inst-1](Bundle-PCT-GFE-Bundle-Inst-1.md)...Show 7 more,[Bundle/PCT-GFE-Bundle-Prof-1](Bundle-PCT-GFE-Bundle-Prof-1.md),[Bundle/PCT-GFE-Information-Bundle-1](Bundle-PCT-GFE-Information-Bundle-1.md),[Bundle/PCT-GFE-Missing-Bundle-1](Bundle-PCT-GFE-Missing-Bundle-1.md),[Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md),[Bundle/PCT-GFE-Packet-Prof-1](Bundle-PCT-GFE-Packet-Prof-1.md),[Coverage/coverage1001](Coverage-coverage1001.md)and[Coverage/selfpaycoverage2001](Coverage-selfpaycoverage2001.md)
* [identifierType](http://terminology.hl7.org/6.5.0/CodeSystem-v2-0203.html): [Boston Radiology Center](Organization-org1002.md), [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md)...Show 21 more,[Bundle/PCT-GFE-Bundle-Inst-1](Bundle-PCT-GFE-Bundle-Inst-1.md),[Bundle/PCT-GFE-Bundle-Prof-1](Bundle-PCT-GFE-Bundle-Prof-1.md),[Bundle/PCT-GFE-Information-Bundle-1](Bundle-PCT-GFE-Information-Bundle-1.md),[Bundle/PCT-GFE-Missing-Bundle-1](Bundle-PCT-GFE-Missing-Bundle-1.md),[Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md),[Bundle/PCT-GFE-Packet-Prof-1](Bundle-PCT-GFE-Packet-Prof-1.md),[Claim/PCT-GFE-Institutional-1](Claim-PCT-GFE-Institutional-1.md),[Claim/PCT-GFE-Institutional-MRI](Claim-PCT-GFE-Institutional-MRI.md),[Claim/PCT-GFE-Professional-MRI](Claim-PCT-GFE-Professional-MRI.md),[ExplanationOfBenefit/PCT-AEOB-1](ExplanationOfBenefit-PCT-AEOB-1.md),[GFE Service Help INC.](Organization-Submitter-Org-1.md),[PCTAdvancedEOB](StructureDefinition-davinci-pct-aeob.md),[PCTCoverage](StructureDefinition-davinci-pct-coverage.md),[PCTGFEContributorTask](StructureDefinition-davinci-pct-gfe-contributor-task.md),[PCTGFECoordinationTask](StructureDefinition-davinci-pct-gfe-coordination-task.md),[PCTGFEInstitutional](StructureDefinition-davinci-pct-gfe-institutional.md),[PCTGFEProfessional](StructureDefinition-davinci-pct-gfe-professional.md),[PCTOrganization](StructureDefinition-davinci-pct-organization.md),[PCTPractitioner](StructureDefinition-davinci-pct-practitioner.md),[Practitioner/Submitter-Practitioner-1](Practitioner-Submitter-Practitioner-1.md)and[Umbrella Insurance Company](Organization-org1001.md)
* [ActRelationshipType](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActRelationshipType.html): [GFERelatedTask](StructureDefinition-gfeRelatedTask.md), [PCTGFETaskRelationship](ValueSet-PCTGFETaskRelationship.md), [Task/PCT-GFE-Contributor-Replacement-Task-1](Task-PCT-GFE-Contributor-Replacement-Task-1.md), [Task/PCT-GFE-Contributor-Replacement-Task-2](Task-PCT-GFE-Contributor-Replacement-Task-2.md) and [Task/PCT-GFE-Coordination-Replacement-Task-1](Task-PCT-GFE-Coordination-Replacement-Task-1.md)
* [MaritalStatus](http://terminology.hl7.org/6.5.0/CodeSystem-v3-MaritalStatus.html): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [Bundle/PCT-GFE-Bundle-Inst-1](Bundle-PCT-GFE-Bundle-Inst-1.md)...Show 6 more,[Bundle/PCT-GFE-Bundle-Prof-1](Bundle-PCT-GFE-Bundle-Prof-1.md),[Bundle/PCT-GFE-Information-Bundle-1](Bundle-PCT-GFE-Information-Bundle-1.md),[Bundle/PCT-GFE-Missing-Bundle-1](Bundle-PCT-GFE-Missing-Bundle-1.md),[Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md),[Bundle/PCT-GFE-Packet-Prof-1](Bundle-PCT-GFE-Packet-Prof-1.md)and[Patient/patient1001](Patient-patient1001.md)
* [RoleCode](http://terminology.hl7.org/6.5.0/CodeSystem-v3-RoleCode.html): [Bundle/PCT-GFE-Information-Bundle-1](Bundle-PCT-GFE-Information-Bundle-1.md) and [Hospital](Location-PCT-ServiceLocation-1.md)


* Using RxNorm codes of type SAB=RXNORM as this specification describes does not require a UMLS license. Access to the full set of RxNorm definitions, and/or additional use of other RxNorm structures and information requires a UMLS license. The use of RxNorm in this specification is pursuant to HL7's status as a licensee of the NLM UMLS. HL7's license does not convey the right to use RxNorm to any users of this specification; implementers must acquire a license to use RxNorm in their own right.

* [RxNorm](http://terminology.hl7.org/6.5.0/CodeSystem-v3-rxNorm.html): [MedicationRequest/PCT-MedicationRequest-1](MedicationRequest-PCT-MedicationRequest-1.md)




## Resource Content

```json
{
  "resourceType" : "ImplementationGuide",
  "id" : "hl7.fhir.us.davinci-pct",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-pct/ImplementationGuide/hl7.fhir.us.davinci-pct",
  "version" : "2.0.0",
  "name" : "PatientCostTransparency",
  "title" : "Patient Cost Transparency Implementation Guide",
  "status" : "active",
  "date" : "2025-11-26T16:21:43+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "name" : "HL7 International / Financial Management",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        },
        {
          "system" : "email",
          "value" : "fmlists@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "To support the request for cost information for specific items and services from the payer and return them in near real-time to allow effective decision making by the patient in consultation with the 'ordering' provider.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "packageId" : "hl7.fhir.us.davinci-pct",
  "license" : "CC0-1.0",
  "fhirVersion" : ["4.0.1"],
  "dependsOn" : [
    {
      "id" : "hl7ext",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on the HL7 Extension Pack"
        }
      ],
      "uri" : "http://hl7.org/fhir/extensions/ImplementationGuide/hl7.fhir.uv.extensions",
      "packageId" : "hl7.fhir.uv.extensions.r4",
      "version" : "5.2.0"
    },
    {
      "id" : "uscore",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ImplementationGuide.dependsOn.reason",
          "valueMarkdown" : "Needed for systems supporting USCDI v4\n"
        }
      ],
      "uri" : "http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core",
      "packageId" : "hl7.fhir.us.core",
      "version" : "7.0.0"
    },
    {
      "id" : "uscore6",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ImplementationGuide.dependsOn.reason",
          "valueMarkdown" : "Needed for systems supporting USCDI v3\n"
        }
      ],
      "uri" : "http://hl7.org/fhir/us/core/v610/ImplementationGuide/hl7.fhir.us.core.v610",
      "packageId" : "hl7.fhir.us.core.v610",
      "version" : "6.1.0"
    },
    {
      "id" : "uscore3",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ImplementationGuide.dependsOn.reason",
          "valueMarkdown" : "Needed for systems supporting USCDI v1\n"
        }
      ],
      "uri" : "http://hl7.org/fhir/us/core/v311/ImplementationGuide/hl7.fhir.us.core.v311",
      "packageId" : "hl7.fhir.us.core.v311",
      "version" : "3.1.1"
    },
    {
      "id" : "hrex",
      "uri" : "http://hl7.org/fhir/us/davinci-hrex/ImplementationGuide/hl7.fhir.us.davinci-hrex",
      "packageId" : "hl7.fhir.us.davinci-hrex",
      "version" : "1.1.0"
    },
    {
      "id" : "tho",
      "uri" : "http://terminology.hl7.org/ImplementationGuide/hl7.terminology",
      "packageId" : "hl7.terminology.r4",
      "version" : "6.5.0"
    },
    {
      "id" : "subs",
      "uri" : "http://hl7.org/fhir/uv/subscriptions-backport/ImplementationGuide/hl7.fhir.uv.subscriptions-backport",
      "packageId" : "hl7.fhir.uv.subscriptions-backport.r4",
      "version" : "1.1.0"
    }
  ],
  "definition" : {
    "extension" : [
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2025+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "STU 2"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-expansion-params"
          },
          {
            "url" : "value",
            "valueString" : "../../input/exp-params.json"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "show-inherited-invariants"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "pin-canonicals"
          },
          {
            "url" : "value",
            "valueString" : "pin-multiples"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "auto-oid-root"
          },
          {
            "url" : "value",
            "valueString" : "2.16.840.1.113883.4.642.40.4"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "version-comparison-master"
          },
          {
            "url" : "value",
            "valueString" : "1.1.0"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "version-comparison"
          },
          {
            "url" : "value",
            "valueString" : "1.0.0"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "version-comparison"
          },
          {
            "url" : "value",
            "valueString" : "1.1.0"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/us/davinci-pct/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "shownav"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/expansion-parameters",
        "valueReference" : {
          "reference" : "Parameters/expansion-parameters"
        }
      },
      {
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-internal-dependency",
        "valueCode" : "hl7.fhir.uv.tools.r4#0.8.0"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2025+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "STU 2"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-expansion-params"
          },
          {
            "url" : "value",
            "valueString" : "../../input/exp-params.json"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "show-inherited-invariants"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "pin-canonicals"
          },
          {
            "url" : "value",
            "valueString" : "pin-multiples"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "auto-oid-root"
          },
          {
            "url" : "value",
            "valueString" : "2.16.840.1.113883.4.642.40.4"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "version-comparison-master"
          },
          {
            "url" : "value",
            "valueString" : "1.1.0"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "version-comparison"
          },
          {
            "url" : "value",
            "valueString" : "1.0.0"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "version-comparison"
          },
          {
            "url" : "value",
            "valueString" : "1.1.0"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/us/davinci-pct/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "shownav"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      }
    ],
    "grouping" : [
      {
        "id" : "CapabilityStatements",
        "name" : "Behavior: Capability Statements",
        "description" : "The following artifacts define the specific capabilities that different types of systems are expected to have in order to comply with this implementation guide. Systems conforming to this implementation guide are expected to declare conformance to one or more of the following capability statements."
      },
      {
        "id" : "Operations",
        "name" : "Behavior: Operation Definitions",
        "description" : "These are custom operations that can be supported by and/or invoked by systems conforming to this implementation guide."
      },
      {
        "id" : "SearchParameters",
        "name" : "Behavior: Search Parameters",
        "description" : "These define the properties by which a RESTful server can be searched. They can also be used for sorting and including related resources."
      },
      {
        "id" : "General",
        "name" : "Structures: General Resource Profiles",
        "description" : "These define constraints on FHIR resources for systems conforming to this implementation guide."
      },
      {
        "id" : "GFE",
        "name" : "Structures: GFE Resource Profiles",
        "description" : "These define constraints on GFE and GFE Coordination Request related FHIR resources for systems conforming to this implementation guide."
      },
      {
        "id" : "AEOB",
        "name" : "Structures: AEOB Resource Profiles",
        "description" : "These define constraints on AEOB and GFE Submit related FHIR resources for systems conforming to this implementation guide."
      },
      {
        "id" : "Subscriptions",
        "name" : "Subscriptions",
        "description" : "These define provide definitions for subscriptions including R4B based SubscriptionTopic and subscription profiles."
      }
    ],
    "resource" : [
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/aeob-date-of-service"
        },
        "name" : "aeob-date-of-service",
        "description" : "Select planned date of service",
        "exampleBoolean" : false,
        "groupingId" : "SearchParameters"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/remaining-benefit"
        },
        "name" : "Benefit Remaining",
        "description" : "The quantity of the benefit remaining to date.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/USClaimMedicalProductOrServiceCodes"
        },
        "name" : "Claim Medical Product or Service Value Set",
        "description" : "CPT - HCPCS - HIPPS - CDT codes to report medical procedures and services under public and private health insurance programs",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Coverage"
          }
        ],
        "reference" : {
          "reference" : "Coverage/coverage1001"
        },
        "name" : "coverage1001",
        "description" : "An instance of PCTCoverage",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-coverage"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/DocumentReference-doc-status"
        },
        "name" : "DocumentReference docStatus",
        "description" : "The status of the underlying document.",
        "exampleBoolean" : false,
        "groupingId" : "SearchParameters"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Subscription"
          }
        ],
        "reference" : {
          "reference" : "Subscription/example-aeob-available-author-subscription-full"
        },
        "name" : "example-aeob-available-author-subscription-full",
        "description" : "An example instance of the davinci-pct-aeob-available-author-subscription Profile returning the full DocumentReference resource",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-aeob-available-author-subscription"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Subscription"
          }
        ],
        "reference" : {
          "reference" : "Subscription/example-aeob-available-author-subscription-id-only"
        },
        "name" : "example-aeob-available-author-subscription-id-only",
        "description" : "An example instance of the davinci-pct-aeob-available-author-subscription Profile returning only the id of the DocumentReference resource",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-aeob-available-author-subscription"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Subscription"
          }
        ],
        "reference" : {
          "reference" : "Subscription/example-aeob-available-subject-subscription"
        },
        "name" : "example-aeob-available-subject-subscription",
        "description" : "An example instance of the davinci-pct-aeob-available-subject-subscription Profile returning the full DocumentReference resource",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-aeob-available-subject-subscription"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Subscription"
          }
        ],
        "reference" : {
          "reference" : "Subscription/example-gfe-available-author-subscription-full"
        },
        "name" : "example-gfe-available-author-subscription-full",
        "description" : "An example instance of the davinci-pct-gfe-available-author-subscription Profile returning the full DocumentReference resource",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-available-author-subscription"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Subscription"
          }
        ],
        "reference" : {
          "reference" : "Subscription/example-gfe-available-author-subscription-id-only"
        },
        "name" : "example-gfe-available-author-subscription-id-only",
        "description" : "An example instance of the davinci-pct-gfe-available-author-subscription Profile returning only the id of the DocumentReference resource",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-available-author-subscription"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Subscription"
          }
        ],
        "reference" : {
          "reference" : "Subscription/example-gfe-available-subject-subscription-full"
        },
        "name" : "example-gfe-available-subject-subscription-full",
        "description" : "An example instance of the davinci-pct-gfe-available-subject-subscription Profile returning the full DocumentReference resource",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-available-subject-subscription"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Subscription"
          }
        ],
        "reference" : {
          "reference" : "Subscription/example-gfe-task-subscription"
        },
        "name" : "example-gfe-task-subscription",
        "description" : "An example instance of the davinci-pct-gfe-task-update-subscription Profile",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-task-update-subscription"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Subscription"
          }
        ],
        "reference" : {
          "reference" : "Subscription/example-gfe-task-subscription-partof"
        },
        "name" : "example-gfe-task-subscription-partof",
        "description" : "An example instance of the davinci-pct-gfe-task-update-subscription Profile",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-task-update-subscription"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/PCTCoordinationTaskStatusCodes"
        },
        "name" : "GFE Coordination Task Status Codes",
        "description" : "Codes allowed for a GFE Coordination Task status",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/gfeReference"
        },
        "name" : "GFE Reference",
        "description" : "This extension is used to reference the GFE submitted by an entity that started the process for obtaining an Advanced EOB.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/gfeBillingProviderLineItemCtrlNum"
        },
        "name" : "GFEBillingProviderLineItemCtrlNum",
        "description" : "This extension is used by the provider to assign a unique identifier to this item. The intent of this element is to allow the provider to assign something other than 'line number' for their purposes (e.g. tracking and troubleshooting).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/gfeConsentForBalanceBilling"
        },
        "name" : "GFEConsentForBalanceBilling",
        "description" : "If the provider has received a written consent form indicating a patient has agreed to waive their protections and pay up to the full cost for the out-of-network item or service, this will be “true”. If the provider has not received written consent, this will be “false”. This is an attestation only. The billing provider is legally required to maintain the written notice and consent form.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/gfeDisclaimer"
        },
        "name" : "GFEDisclaimer",
        "description" : "Disclaimers the patient should be made aware of regarding the providers estimate (e.g. application of sliding scale for self-pay/uninsured patients) including any additional assumptions and requirements.  Noting that that the information provided is only an estimate based on the items and services reasonably expected, at the time of scheduling (or requesting) the item or service, to be furnished and is subject to change.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/gfeRelatedTask"
        },
        "name" : "GFERelatedTask",
        "description" : "A relationship that the source Task has with the referenced GFE Task has with the source GFE Task. This may be used for cases when a new GFE is needed or a Task needs to be replaced for some reason and the requester and owner, where present, are the same between the referenced and source Task respectively.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/gfeServiceLinkingInfo"
        },
        "name" : "GFEServiceLinkingInfo",
        "description" : "This extension is used to provide the GFE Service Linking Information. This allows implementers to have the same identifier on multiple GFEs that are part of one period of care's services. This would be needed for some of the workflow options that businesses may decide to use.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationDefinition"
          }
        ],
        "reference" : {
          "reference" : "OperationDefinition/GFE-coordination-request"
        },
        "name" : "Good Faith Estimate Coordination Request",
        "description" : "This operation is used by an entity to submit one or multiple GFEs as a Bundle containing the GFE(s) and other referenced resources for processing. The only input parameter is the single Bundle resource with one or multiple GFE(s) - each of which is based on the Claim resource (along with other referenced resources). The only output is a url for subsequent polling per [async pattern](https://hl7.org/fhir/R5/async-bundle.html). If after polling the response is complete, then the result will either be a single Bundle with the AEOB - which is based on the ExplanationOfBenefit resource, (and other referenced resources) or an OperationOutcome resource indicating the AEOB will be sent directly to the patient and not to the provider.",
        "exampleBoolean" : false,
        "groupingId" : "Operations"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/ICD10ProcedureCodes"
        },
        "name" : "ICD-10 Procedure Codes",
        "description" : "Procedure Codes from https://www.cms.gov/Medicare/Coding/ICD10",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/inNetworkProviderOptionsLink"
        },
        "name" : "In Network Provider Options Link",
        "description" : "This extension provides a payer link to information enabling the patient to find providers that are in network for the requested services.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/AHANUBCPointOfOriginVS"
        },
        "name" : "NUBC Point Of Origin",
        "description" : "The UB-04 Data File contains the complete set of NUBC codes. Every code in the range of possible codes is accounted for sequentially. \n\nThere are no gaps because all used and unused codes are identified. This value set consists of the following: \n* FL 15 - Point of Origin for Admission or Visit for Non-newborn\n* FL 15 - Point of Origin for Admission or Visit for Newborn\n\nThese codes are used to convey the patient point of origin for an admission or visit and are the property of the American Hospital Association.\n\nTo obtain the underlying code systems, please see information [here](https://www.nubc.org/subscription-information)\nStatement of Understanding between AHA and HL7 can be found [here](http://www.hl7.org/documentcenter/public/mou/AHA%20HL7%20SOU%202020%20AHA%20Fully%20Executed.pdf). In particular see sections 4.1d and 4.2.\n\nThe UB-04 Manual has a 12-month subscription period from June 30 through July 1.\n\nFor frequently asked questions, see here [here](https://www.nubc.org/nubc-faqs)",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/AHANUBCPriorityTypeOfAdmissionOrVisitVS"
        },
        "name" : "NUBC Priority (Type) of Admission or Visit",
        "description" : "The UB-04 Data File contains the complete set of NUBC codes. Every code in the range of possible codes is accounted for sequentially. There are no gaps because all used and unused codes are identified.\n\nThis value set consists of the following:\n\n* FL 14 - Priority (Type) of Admission or Visit\n\nThese codes are used to convey the priority of an admission or visit and are the property of the American Hospital Association.\n\nTo obtain the underlying code systems, please see information [here](https://www.nubc.org/subscription-information)\n\nStatement of Understanding between AHA and HL7 can be found [here](http://www.hl7.org/documentcenter/public/mou/AHA%20HL7%20SOU%202020%20AHA%20Fully%20Executed.pdf). In particular see sections 4.1d and 4.2.\n\nThe UB-04 Manual has a 12-month subscription period from June 30 through July 1.\n\nFor frequently asked questions, see here [here](https://www.nubc.org/nubc-faqs)\n\nThis Code system is referenced in the content logical definition of the following value sets:\n\nThis CodeSystem is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)\n\nThis code system https://www.nubc.org/CodeSystem/PriorityTypeOfAdmitOrVisit defines many codes, but they are not represented here",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/org1001"
        },
        "name" : "org1001",
        "description" : "An instance of PCTOrganization as a payer",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-organization"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/org1002"
        },
        "name" : "org1002",
        "description" : "An instance of PCTOrganization as a healthcare provider",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-organization"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/packet-condition"
        },
        "name" : "Packet Condition",
        "description" : "Significant condition involved in an estimate.",
        "exampleBoolean" : false,
        "groupingId" : "SearchParameters"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/packet-request-initiation-time"
        },
        "name" : "Packet Estimate Request Initiation Time",
        "description" : "Instant from which the request originating request was being initiated.",
        "exampleBoolean" : false,
        "groupingId" : "SearchParameters"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/packet-linking-identifier"
        },
        "name" : "Packet Linking Identifier",
        "description" : "An identifier assigned to a particular service or series of services to enabling linking.",
        "exampleBoolean" : false,
        "groupingId" : "SearchParameters"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/packet-PlannedPeriodOfService"
        },
        "name" : "Packet Planned Period Of Service",
        "description" : "Planned date(s) of a particular admission/service or a series of admissions/services.",
        "exampleBoolean" : false,
        "groupingId" : "SearchParameters"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/packet-procedure-or-service"
        },
        "name" : "Packet Procedure or Service",
        "description" : "Significant Procedures and/or products involved in an estimate.",
        "exampleBoolean" : false,
        "groupingId" : "SearchParameters"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CapabilityStatement"
          }
        ],
        "reference" : {
          "reference" : "CapabilityStatement/davinci-pct-coordination-platform"
        },
        "name" : "Patient Cost Transparency Implementation Guide Coordination Platform Capability Statement",
        "description" : "Coordination Platform Capability Statement for the Da Vinci Patient Cost Transparency Implementation Guide",
        "exampleBoolean" : false,
        "groupingId" : "CapabilityStatements"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CapabilityStatement"
          }
        ],
        "reference" : {
          "reference" : "CapabilityStatement/davinci-pct-coordination-requester"
        },
        "name" : "Patient Cost Transparency Implementation Guide Coordination Requester Capability Statement",
        "description" : "Coordination Requester Capability Statement for the Da Vinci Patient Cost Transparency Implementation Guide",
        "exampleBoolean" : false,
        "groupingId" : "CapabilityStatements"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CapabilityStatement"
          }
        ],
        "reference" : {
          "reference" : "CapabilityStatement/davinci-pct-gfe-contributor"
        },
        "name" : "Patient Cost Transparency Implementation Guide GFE Contributor Capability Statement",
        "description" : "GFE Contributor Capability Statement for the Da Vinci Patient Cost Transparency Implementation Guide",
        "exampleBoolean" : false,
        "groupingId" : "CapabilityStatements"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CapabilityStatement"
          }
        ],
        "reference" : {
          "reference" : "CapabilityStatement/davinci-pct"
        },
        "name" : "Patient Cost Transparency Implementation Guide Payer Capability Statement",
        "description" : "Payer capability statement for the Da Vinci Patient Cost Transparency Implementation Guide",
        "exampleBoolean" : false,
        "groupingId" : "CapabilityStatements"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CapabilityStatement"
          }
        ],
        "reference" : {
          "reference" : "CapabilityStatement/davinci-pct-gfe-provider"
        },
        "name" : "Patient Cost Transparency Implementation Guide Provider Capability Statement",
        "description" : "Provider Capability Statement for the Da Vinci Patient Cost Transparency Implementation Guide, for sharing Good Faith Documents",
        "exampleBoolean" : false,
        "groupingId" : "CapabilityStatements"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/patient1001"
        },
        "name" : "patient1001",
        "description" : "An instance of Patient",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/PCTAdjudicationCategoryCS"
        },
        "name" : "PCT Adjudication Category CodeSystem",
        "description" : "Codes indicating the type of adjudication information provided. This CodeSystem is currently defined by this IG, but is anticipated to be temporary. The concepts within are expected to be moved in a future version to a more central terminology specification such as THO, which will result in a code system url change and possibly modified codes and definitions.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/PCTAdjudication"
        },
        "name" : "PCT Adjudication Code System",
        "description" : "Describes the various amount fields used when payers receive and adjudicate a claim.  It complements the values defined in http://terminology.hl7.org/CodeSystem/adjudication. This CodeSystem is currently defined by this IG, but is anticipated to be temporary. The concepts within are expected to be moved in a future version to a more central terminology specification such as THO, which will result in a code system url change and possibly modified codes and definitions.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/PCTAdjudicationVS"
        },
        "name" : "PCT Adjudication Value Set",
        "description" : "Describes the various amount fields used when payers receive and adjudicate a claim.  It includes the values \ndefined in http://terminology.hl7.org/CodeSystem/adjudication, as well as those defined in the C4BB Adjudication CodeSystem.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/PCTAdjustmentReasonVS"
        },
        "name" : "PCT Adjustment Reason",
        "description" : "Codes indicating reasons why a claim or line item is adjusted.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/davinci-pct-aeob"
        },
        "name" : "PCT Advanced EOB",
        "description" : "The No Surprises Act requires that group health plans and insurers provide advance cost estimates, called advanced explanations of benefits (advanced EOBs), for scheduled services. This profile is used for exchanging the Advanced EOB data.",
        "exampleBoolean" : false,
        "groupingId" : "AEOB"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/davinci-pct-aeob-summary"
        },
        "name" : "PCT Advanced EOB Summary",
        "description" : "This profile is used for exchanging a summary of Advanced Explanation of Benefit (AEOB) information, including costs and benefits, of all of the Advanced EOB data contained within an AEOB Packet.",
        "exampleBoolean" : false,
        "groupingId" : "AEOB"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/davinci-pct-aeob-adjudication-error"
        },
        "name" : "PCT AEOB Adjudication Error",
        "description" : "OperationOutcome returned from the gfeSubmit operation when there are adjudication errors during AEOB processing",
        "exampleBoolean" : false,
        "groupingId" : "AEOB"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/davinci-pct-aeob-complete"
        },
        "name" : "PCT AEOB Complete",
        "description" : "OperationOutcome returned from the gfeSubmit operation when the AEOB process is complete but no AEOB will be returned to the submitter (i.e. it was sent only to the patient)",
        "exampleBoolean" : false,
        "groupingId" : "AEOB"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/davinci-pct-aeob-composition"
        },
        "name" : "PCT AEOB Composition",
        "description" : "PCT AEOB Composition that assembles the contents of an AEOB (represented by one or more individual AEOB resources) into a single logical package. A Composition for the document type Bundle that enables versioning, signing and being referenced by a DocumentReference for searching and subscription notifications.",
        "exampleBoolean" : false,
        "groupingId" : "AEOB"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/davinci-pct-aeob-packet"
        },
        "name" : "PCT AEOB Packet",
        "description" : "PCT AEOB Packet that contains necessary resources for one or more an AEOBs.  Organizations for both the payer and provider SHALL be included.   An AEOB Summary SHALL be included and reflect the total estimate for the patient, including all AEOB resources within the Bundle. This version of the Bundle is a document type that will enable versioning, signing and being referenced by a DocumentReference for searching and subscription notifications.",
        "exampleBoolean" : false,
        "groupingId" : "AEOB"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/davinci-pct-aeob-documentreference"
        },
        "name" : "PCT AEOB Packet Document Reference",
        "description" : "PCT AEOB Packet Document Reference that enables searching and subscriptions for AEOB Packets.",
        "exampleBoolean" : false,
        "groupingId" : "AEOB"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/PCTAEOBProcessNoteCS"
        },
        "name" : "PCT AEOB Process Note Code System",
        "description" : "Defining codes for process notes.  This CodeSystem is currently defined by this IG, but is anticipated to be temporary. The concepts within are expected to be moved in a future version to a more central terminology specification such as THO, which will result in a code system url change and possibly modified codes and definitions.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/PCTAEOBProcessNoteVS"
        },
        "name" : "PCT AEOB Process Note Types",
        "description" : "Indicates the type of .processNote for AEOB.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/PCTBenefitBalanceCategoryVS"
        },
        "name" : "PCT benefitBalance.category codes",
        "description" : "Category codes for PCT benefitBalance.category from X12 service type.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/PCTCareTeamRoleVS"
        },
        "name" : "PCT Care Team Role Value Set",
        "description" : "Codes to specify the the functional roles of the care team members.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/PCTProcedureSurgicalCodes"
        },
        "name" : "PCT CMS HCPCS and AMA CPT Procedure Surgical Codes",
        "description" : "Combination of CMS HCPCS and AMA CPT codes to specify the type of surgical procedure",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/davinci-pct-coverage"
        },
        "name" : "PCT Coverage",
        "description" : "PCT Coverage is a profile for capturing data that reflect a payer's coverage that was effective as of the proposed date of service or the date of admission of the GFE.",
        "exampleBoolean" : false,
        "groupingId" : "General"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/PCTDocumentTypeTemporaryTrialUse"
        },
        "name" : "PCT Document Types",
        "description" : "Defining codes for types and categories of documents and collections used for Patient Cost Transparency estimates. This CodeSystem is currently defined by this IG, but is anticipated to be temporary. The concepts within are expected to be moved in a future version to a more central terminology specification such as LOINC, which will result in a code system url change and possibly modified codes and definitions.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/PCTEstimateTypeSummaryCSTemporaryTrialUse"
        },
        "name" : "PCT Estimate Type Code System",
        "description" : "Defining the code for a estimate (GFE or AEOB) type summary.  This CodeSystem is currently defined by this IG, but is anticipated to be temporary. The concepts within are expected to be moved in a future version to a more central terminology specification such as THO, which will result in a code system url change and possibly modified codes and definitions.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/PCTFinancialType"
        },
        "name" : "PCT Financial Type Code System",
        "description" : "Financial Type codes for benefitBalance.financial.type. This CodeSystem is currently defined by this IG, but is anticipated to be temporary. The concepts within are expected to be moved in a future version to a more central terminology specification such as THO, which will result in a code system url change and possibly modified codes and definitions.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/PCTFinancialTypeVS"
        },
        "name" : "PCT Financial Type Value Set",
        "description" : "Financial Type codes for benefitBalance.financial.type.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/davinci-pct-gfe-bundle"
        },
        "name" : "PCT GFE Bundle",
        "description" : "PCT GFE Bundle that contains all resources for a Good faith estimate submitted by a single GFE contributing provider. Organizations for both the provider and payer MAY be included. This single contributing provider GFE Bundle may be included in a set of GFE bundles from other providers in a GFE Packet that can then be made available to the patient or sent to a payer for insurance estimation. The scope of this guide does not include coordination of benefits for more than one coverage. This does not serve as a replacement for eligibility, prior authorization or other financial and administrative use cases.",
        "exampleBoolean" : false,
        "groupingId" : "GFE"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/PCTGFECMSPOS"
        },
        "name" : "PCT GFE CMS Place of Service Value Set",
        "description" : "CMS Place of Service codes",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/davinci-pct-gfe-composition"
        },
        "name" : "PCT GFE Composition",
        "description" : "PCT GFE Composition that assembles the contents of a GFE (represented by one or more individual GFE Bundles) into a single logical package. A Composition for the document type Bundle that enables versioning, signing and being referenced by a DocumentReference for searching and subscription notifications.",
        "exampleBoolean" : false,
        "groupingId" : "GFE"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/davinci-pct-gfe-contributor-task"
        },
        "name" : "PCT GFE Contributor Task",
        "description" : "The PCT GFE Contributor Task is used by a GFE coordinator   to assign a GFE contributor task to a specific provider and may include information specific to that patient’s expected service",
        "exampleBoolean" : false,
        "groupingId" : "GFE"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/PCTContributorTaskStatusReasonCodes"
        },
        "name" : "PCT GFE Contributor Task Status Reason Codes ValueSet",
        "description" : "Defining codes for defining GFE request GFE contributor task status reason types.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/davinci-pct-gfe-coordination-bundle"
        },
        "name" : "PCT GFE Coordination Bundle",
        "description" : "PCT GFE Request Bundle that contains necessary resources for GFE  to request GFEs from one or multiple GFE contributing providers.",
        "exampleBoolean" : false,
        "groupingId" : "GFE"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/davinci-pct-gfe-coordination-task"
        },
        "name" : "PCT GFE Coordination Task",
        "description" : "The Good Faith Estimate (GFE) Coordination Task is used to organize a GFE across providers  for a single period of care for which all GFE Contributor Task resources will be linked. The task includes the general inputs that are shared across all of the GFE contributor tasks. These inputs may include a ‘primary’ service and relevant conditions.",
        "exampleBoolean" : false,
        "groupingId" : "GFE"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/davinci-pct-devicerequest"
        },
        "name" : "PCT GFE DeviceRequest",
        "description" : "The PCT DeviceRequest including details about a device for which a GFE is being requested.",
        "exampleBoolean" : false,
        "groupingId" : "GFE"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/davinci-pct-gfe-information-bundle"
        },
        "name" : "PCT GFE Information Bundle",
        "description" : "PCT GFE Information Bundle that contains the information necessary for GFE contributors to create their estimates. This bundle may for all GFE Contributors or  specific to a single contributor and may include, but is not limited to, the Patient Resource, request resources (such as ServiceRequest, MedicationRequest, and DeviceRequest), Service location information, Coverage and Payer Organization resources (if applicable).",
        "exampleBoolean" : false,
        "groupingId" : "GFE"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/PCTAdjudicationCategoryVS"
        },
        "name" : "PCT GFE Item Adjudication Value Set",
        "description" : "Value Set containing codes for the type of adjudication information provided.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/PCTGFEItemCptHcpcsVS"
        },
        "name" : "PCT GFE Item CPT - HCPCS Value Set",
        "description" : "CPT - HCPCS codes to report medical procedures and services under public and private health insurance programs",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/PCTGFEItemNDCVS"
        },
        "name" : "PCT GFE Item NDC Value Set",
        "description" : "The FDA published list of NDC codes for finished drug products",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/davinci-pct-medicationrequest"
        },
        "name" : "PCT GFE MedicationRequest",
        "description" : "The PCT MedicationRequest including details about a medication for which a GFE is being requested.",
        "exampleBoolean" : false,
        "groupingId" : "GFE"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/davinci-pct-gfe-missing-bundle"
        },
        "name" : "PCT GFE Missing Bundle",
        "description" : "PCT GFE Missing Bundle is used to indicate when a GFE Contributor task request was made, but no GFE Bundle was submitted (attached to the ContributorTask).",
        "exampleBoolean" : false,
        "groupingId" : "GFE"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/PCTGFEItemRevenueVS"
        },
        "name" : "PCT GFE NUBC Revenue Value Set",
        "description" : "NUBC UB-04 Revenue codes",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/PCTGFETypeOfBillVS"
        },
        "name" : "PCT GFE NUBC Uniform Billing (UB-04) Type of Bill Value Set",
        "description" : "NUBC Uniform Billing (UB-04) codes to indicate the specific Type of Bill (TOB), e.g., hospital inpatient, outpatient, replacements, voids, etc. The first digit is a leading zero*. The fourth digit defines the frequency of the bill for the institutional and electronic professional claim.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/davinci-pct-gfe-packet"
        },
        "name" : "PCT GFE Packet",
        "description" : "PCT GFE Packet that contains GFE Bundles from GFE contributors. This document type bundle of GFE Bundles from GFE contributors that can then be made available to the patient or sent to a payer for insurance estimation. The scope of this guide does not include coordination of benefits or more than one coverage. This does not serve as a replacement for eligibility, prior authorization or other financial and administrative use cases.",
        "exampleBoolean" : false,
        "groupingId" : "GFE"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/davinci-pct-gfe-documentreference"
        },
        "name" : "PCT GFE Packet Document Reference",
        "description" : "PCT GFE Packet Document Reference that enables searching and subscriptions for GFE Packets.",
        "exampleBoolean" : false,
        "groupingId" : "GFE"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/PCTCoordinationTaskStatusReasonCodes"
        },
        "name" : "PCT GFE Request Coordination Task Status Reason Codes ValueSet",
        "description" : "Defining codes for GFE Coordination Task status reason types.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/PCTTaskBusinessStatusCSTemporaryTrialUse"
        },
        "name" : "PCT GFE Request Task Business Status Code System",
        "description" : "Codes for defining  GFE request task business status types. This CodeSystem is currently defined by this IG, but is anticipated to be temporary. The concepts within are expected to be moved in a future version to a more central terminology specification such as THO, which will result in a code system url change and possibly modified codes and definitions.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/PCTTaskBusinessStatusCodes"
        },
        "name" : "PCT GFE Request Task Business Status ValueSet",
        "description" : "Codes for defining  GFE request task business status types.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/PCTTaskStatusReasonCSTemporaryTrialUse"
        },
        "name" : "PCT GFE Request Task Status Reason Code Code System",
        "description" : "Codes for defining GFE request task status reason types. This CodeSystem is currently defined by this IG, but is anticipated to be temporary. The concepts within are expected to be moved in a future version to a more central terminology specification such as THO, which will result in a code system url change and possibly modified codes and definitions.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/PCTGFERequestTypeCSTemporaryTrialUse"
        },
        "name" : "PCT GFE Request Type Codes Code System",
        "description" : "Codes for defining GFE request types. This CodeSystem is currently defined by this IG, but is anticipated to be temporary. The concepts within are expected to be moved in a future version to a more central terminology specification such as THO, which will result in a code system url change and possibly modified codes and definitions.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/PCTGFERequestTypeVS"
        },
        "name" : "PCT GFE Request Type Codes ValueSet",
        "description" : "Codes for the Good Faith Estimate (GFE) request origination types.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/davinci-pct-servicerequest"
        },
        "name" : "PCT GFE ServiceRequest",
        "description" : "The PCT ServiceRequest including details about a service for which a GFE is being requested.",
        "exampleBoolean" : false,
        "groupingId" : "GFE"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/PCTSupportingInfoType"
        },
        "name" : "PCT GFE Supporting Info Type Code System",
        "description" : "Defining codes for the classification of the supplied supporting information. This CodeSystem is currently defined by this IG, but is anticipated to be temporary. The concepts within are expected to be moved in a future version to a more central terminology specification such as THO, which will result in a code system url change and possibly modified codes and definitions.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/PCTGFETaskRelationship"
        },
        "name" : "PCT GFE Task Relationship",
        "description" : "Code expressing a relationship that the source Task has with the referenced GFE Task has with the source GFE Task.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/davinci-pct-gfe-validation-error"
        },
        "name" : "PCT GFE Validation Error",
        "description" : "OperationOutcome returned from the gfeSubmit operation when the GFE Bundle fails FHIR validation",
        "exampleBoolean" : false,
        "groupingId" : "AEOB"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/davinci-pct-gfe-summary"
        },
        "name" : "PCT Good Faith Estimate  Summary",
        "description" : "PCT Good Faith Estimate Summary is a profile for summarizing costs associated with a set of Good Faith Estimate Claims for a single Period of Care.",
        "exampleBoolean" : false,
        "groupingId" : "GFE"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/davinci-pct-gfe-institutional"
        },
        "name" : "PCT Good Faith Estimate Institutional",
        "description" : "PCT Good Faith Estimate Institutional is a profile for an institutional provider to capture estimation for  items and services for the patient or, optionally, to submit to a payer (for patients using insurance). If submitting to a payer, this includes the data needed for a payer to process and create an Advanced EOB. This profile is used for an institutional GFE submission.",
        "exampleBoolean" : false,
        "groupingId" : "GFE"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/davinci-pct-gfe-professional"
        },
        "name" : "PCT Good Faith Estimate Professional",
        "description" : "PCT Good Faith Estimate Professional is a profile for an professional provider to capture estimation for  items and services for the patient or, optionally, to submit to a payer (for patients using insurance). If submitting to a payer, this includes the data needed to be processed by a payer for the creation of an Advanced EOB. This profile is used for a professional GFE submission.",
        "exampleBoolean" : false,
        "groupingId" : "GFE"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/PCTDiagnosticCodes"
        },
        "name" : "PCT ICD-10 Diagnostic Codes",
        "description" : "ICD-10 Codes to specify the type of diagnosis",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/PCTNetworkStatusCS"
        },
        "name" : "PCT Network Status",
        "description" : "Defining codes for network status.  This CodeSystem is currently defined by this IG, but is anticipated to be temporary. The concepts within are expected to be moved in a future version to a more central terminology specification such as THO, which will result in a code system url change and possibly modified codes and definitions.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/davinci-pct-organization"
        },
        "name" : "PCT Organization",
        "description" : "The PCT Organization profile builds upon the US Core Organization profile. It is used to convey a payer, provider, payee, or service facility organization.",
        "exampleBoolean" : false,
        "groupingId" : "General"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/PCTOrgContactPurposeType"
        },
        "name" : "PCT Organization Contact Purpose Type Code System",
        "description" : "Organization Contact Purpose Type Code System. This CodeSystem is currently defined by this IG, but is anticipated to be temporary. The concepts within are expected to be moved in a future version to a more central terminology specification such as THO, which will result in a code system url change and possibly modified codes and definitions.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/PCTOrgContactPurposeTypeVS"
        },
        "name" : "PCT Organization Contact Purpose Value Set",
        "description" : "Codes for the classification of organization contact purposes. This ValueSet is currently locally defined; an external FHIR value set may be created through the HL7 Terminology (THO) process to replace this value set in a future version.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/PCTOrganizationTypeVS"
        },
        "name" : "PCT Organization Type Value Set",
        "description" : "Codes to specify the type of entity involved in the PCT GFE process. This ValueSet is currently locally defined; an external FHIR value set may be created through the HL7 Terminology (THO) process to replace this value set in a future version.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/PCTDocumentSection"
        },
        "name" : "PCT Packet Section Codes",
        "description" : "Defining codes for the sections found in packets (document bundles) used for Patient Cost Transparency estimates.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/PCTPayerBenefitPaymentStatusVS"
        },
        "name" : "PCT Payer Benefit Payment Status",
        "description" : "Indicates the in network or out of network payment status of the claim or line item.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/PCTPayerProviderNetworkStatusVS"
        },
        "name" : "PCT Payer Provider Network Status",
        "description" : "Indicates the Provider network status with the Payer as of the effective date of service or admission.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/davinci-pct-practitioner"
        },
        "name" : "PCT Practitioner",
        "description" : "The PCT Practitioner profile builds upon the US Core Practitioner profile. It is used to convey information about the practitioner who will be providing services to the patient as described on the GFE.",
        "exampleBoolean" : false,
        "groupingId" : "General"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/PCTProcedureType"
        },
        "name" : "PCT Procedure Type",
        "description" : "Defining codes for the classification of procedure types. This CodeSystem is currently defined by this IG, but is anticipated to be temporary. The concepts within are expected to be moved in a future version to a more central terminology specification such as THO, which will result in a code system url change and possibly modified codes and definitions.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/PCTProcedureTypeVS"
        },
        "name" : "PCT Procedure Type Value Set",
        "description" : "Codes to specify the type of procedure",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/davinci-pct-service-location"
        },
        "name" : "PCT Service Location",
        "description" : "The PCT Service Location provides information where the service is to be performed or the item delivered. This could be used to express an actual physical location or a facility type.",
        "exampleBoolean" : false,
        "groupingId" : "GFE"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/PCTSupportingInfoTypeVS"
        },
        "name" : "PCT Supporting Info Type Value Set",
        "description" : "Codes to specify the type of the supplied supporting information",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/PCTTaskAttachmentContentType"
        },
        "name" : "PCT Task Attachment Mime Types",
        "description" : "Patient Cost Transparency Task Attachment Mime Types",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/PCTTotal"
        },
        "name" : "PCT Total Value Set",
        "description" : "Describes the various amount fields used when payers receive and adjudicate a claim.  It includes the values \ndefined in http://terminology.hl7.org/CodeSystem/adjudication, as well as those defined in the Network Status.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ExplanationOfBenefit"
          }
        ],
        "reference" : {
          "reference" : "ExplanationOfBenefit/PCT-AEOB-1"
        },
        "name" : "PCT-AEOB-1",
        "description" : "An example instance of the PCTAdvancedEOB Profile",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-aeob"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationOutcome"
          }
        ],
        "reference" : {
          "reference" : "OperationOutcome/PCT-AEOB-Adjudication-Error-Example-1"
        },
        "name" : "PCT-AEOB-Adjudication-Error-Example-1",
        "description" : "PCT AEOB Adjudication Error Example 1",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-aeob-adjudication-error"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationOutcome"
          }
        ],
        "reference" : {
          "reference" : "OperationOutcome/PCT-AEOB-Complete-Example-1"
        },
        "name" : "PCT-AEOB-Complete-Example-1",
        "description" : "PCT AEOB Complete Example 1",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-aeob-complete"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "DocumentReference"
          }
        ],
        "reference" : {
          "reference" : "DocumentReference/PCT-AEOB-DocumentReference-1"
        },
        "name" : "PCT-AEOB-DocumentReference-1",
        "description" : "PCT AEOB DocumentReference Example 1",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-aeob-documentreference"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/PCT-AEOB-Packet-1"
        },
        "name" : "PCT-AEOB-Packet-1",
        "description" : "PCT AEOB Packet Example 1",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-aeob-packet"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ExplanationOfBenefit"
          }
        ],
        "reference" : {
          "reference" : "ExplanationOfBenefit/PCT-AEOB-Summary-1"
        },
        "name" : "PCT-AEOB-Summary-1",
        "description" : "An example instance of the PCTAdvancedEOBSummary Profile",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-aeob-summary"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "DeviceRequest"
          }
        ],
        "reference" : {
          "reference" : "DeviceRequest/PCT-DeviceRequest-1"
        },
        "name" : "PCT-DeviceRequest-1",
        "description" : "PCT DeviceRequest Example 1",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-devicerequest"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/PCT-GFE-Bundle-Inst-1"
        },
        "name" : "PCT-GFE-Bundle-Inst-1",
        "description" : "PCT GFE Bundle Institutional Example 1",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-bundle"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/PCT-GFE-Bundle-Prof-1"
        },
        "name" : "PCT-GFE-Bundle-Prof-1",
        "description" : "PCT GFE Bundle Professional Example 1",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-bundle"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Task"
          }
        ],
        "reference" : {
          "reference" : "Task/PCT-GFE-Contributor-Replacement-Task-1"
        },
        "name" : "PCT-GFE-Contributor-Replacement-Task-1",
        "description" : "PCT GFE Contributor Task replacement example 1",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-contributor-task"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Task"
          }
        ],
        "reference" : {
          "reference" : "Task/PCT-GFE-Contributor-Replacement-Task-2"
        },
        "name" : "PCT-GFE-Contributor-Replacement-Task-2",
        "description" : "PCT GFE Contributor Task replacement example 2",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-contributor-task"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Task"
          }
        ],
        "reference" : {
          "reference" : "Task/PCT-GFE-Contributor-Task-1"
        },
        "name" : "PCT-GFE-Contributor-Task-1",
        "description" : "PCT GFE Contributor Task example 1",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-contributor-task"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Task"
          }
        ],
        "reference" : {
          "reference" : "Task/PCT-GFE-Contributor-Task-2"
        },
        "name" : "PCT-GFE-Contributor-Task-2",
        "description" : "PCT GFE Contributor Task example 2",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-contributor-task"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/PCT-GFE-Coordination-Bundle-1"
        },
        "name" : "PCT-GFE-Coordination-Bundle-1",
        "description" : "PCT GFE Coordination Bundle Example 1",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-coordination-bundle"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Task"
          }
        ],
        "reference" : {
          "reference" : "Task/PCT-GFE-Coordination-Replacement-Task-1"
        },
        "name" : "PCT-GFE-Coordination-Replacement-Task-1",
        "description" : "PCT GFE Coordination Task replacement example 1",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-coordination-task"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Task"
          }
        ],
        "reference" : {
          "reference" : "Task/PCT-GFE-Coordination-Task-1"
        },
        "name" : "PCT-GFE-Coordination-Task-1",
        "description" : "PCT GFE Coordination Task example 1",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-coordination-task"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "DocumentReference"
          }
        ],
        "reference" : {
          "reference" : "DocumentReference/PCT-GFE-DocumentReference-Inst-1"
        },
        "name" : "PCT-GFE-DocumentReference-Inst-1",
        "description" : "PCT GFE DocumentReference Institutional Example 1",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-documentreference"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "DocumentReference"
          }
        ],
        "reference" : {
          "reference" : "DocumentReference/PCT-GFE-DocumentReference-Prof-1"
        },
        "name" : "PCT-GFE-DocumentReference-Prof-1",
        "description" : "PCT GFE DocumentReference Professional Example 1",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-documentreference"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/PCT-GFE-Information-Bundle-1"
        },
        "name" : "PCT-GFE-Information-Bundle-1",
        "description" : "PCT GFE Information Bundle Example 1",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-information-bundle"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Claim"
          }
        ],
        "reference" : {
          "reference" : "Claim/PCT-GFE-Institutional-1"
        },
        "name" : "PCT-GFE-Institutional-1",
        "description" : "PCT Institutional GFE Example 1",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-institutional"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Claim"
          }
        ],
        "reference" : {
          "reference" : "Claim/PCT-GFE-Institutional-MRI"
        },
        "name" : "PCT-GFE-Institutional-MRI",
        "description" : "PCT Institutional GFE for MRI",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-institutional"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/PCT-GFE-Missing-Bundle-1"
        },
        "name" : "PCT-GFE-Missing-Bundle-1",
        "description" : "PCT GFE Missing Bundle Example 1",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-missing-bundle"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/PCT-GFE-Packet-Inst-1"
        },
        "name" : "PCT-GFE-Packet-Inst-1",
        "description" : "PCT GFE Packet Institutional Example 1",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-packet"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/PCT-GFE-Packet-Prof-1"
        },
        "name" : "PCT-GFE-Packet-Prof-1",
        "description" : "PCT GFE Packet Professional Example 1",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-packet"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Claim"
          }
        ],
        "reference" : {
          "reference" : "Claim/PCT-GFE-Professional-MRI"
        },
        "name" : "PCT-GFE-Professional-MRI",
        "description" : "PCT Professional GFE Example 1",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-professional"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Claim"
          }
        ],
        "reference" : {
          "reference" : "Claim/PCT-GFE-Summary-1"
        },
        "name" : "PCT-GFE-Summary-1",
        "description" : "PCT Summary GFE Example 1",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-summary"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Claim"
          }
        ],
        "reference" : {
          "reference" : "Claim/PCT-GFE-Summary-MRI"
        },
        "name" : "PCT-GFE-Summary-MRI",
        "description" : "PCT Summary MRI GFE",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-summary"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationOutcome"
          }
        ],
        "reference" : {
          "reference" : "OperationOutcome/PCT-GFE-Validation-Error-Example-1"
        },
        "name" : "PCT-GFE-Validation-Error-Example-1",
        "description" : "PCT GFE Validation Error Example 1",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-validation-error"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/PCT-MedicationRequest-1"
        },
        "name" : "PCT-MedicationRequest-1",
        "description" : "PCT MedicationRequest Example 1",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-medicationrequest"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Location"
          }
        ],
        "reference" : {
          "reference" : "Location/PCT-ServiceLocation-1"
        },
        "name" : "PCT-ServiceLocation-1",
        "description" : "PCT ServiceLocation Example 1",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-service-location"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ServiceRequest"
          }
        ],
        "reference" : {
          "reference" : "ServiceRequest/PCT-ServiceRequest-1"
        },
        "name" : "PCT-ServiceRequest-1",
        "description" : "PCT ServiceRequest Example 1",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-servicerequest"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/plannedServicePeriod"
        },
        "name" : "Planned Service Period",
        "description" : "Planned period of service the request is about",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/prac001"
        },
        "name" : "prac001",
        "description" : "An instance of PCTPractitioner",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-practitioner"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/prac002"
        },
        "name" : "prac002",
        "description" : "An instance of PCTPractitioner",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-practitioner"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/processNoteClass"
        },
        "name" : "ProcessNote Class",
        "description" : "This extension is used to indicate a the class of AEOB Claim process notes",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/PCTContributorTaskStatusCodes"
        },
        "name" : "Provider GFE Contributor Task Status Codes",
        "description" : "Codes allowed for a GFE Contributor-specific service task status",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/providerEventMethodology"
        },
        "name" : "ProviderEventMethodology",
        "description" : "This extension is used for indicating the method a provider used to group services, and those providing such services, beyond what may be indicated through DRGs that the payer or patient may find helpful (e.g. grouping services by a standardized episode of care definition). This is provider generated text and should not be modified by the payer.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/providerTaxonomy"
        },
        "name" : "ProviderTaxonomy",
        "description" : "This extension is used to indicate the taxonomy code of the provider.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/referralNumber"
        },
        "name" : "ReferralNumber",
        "description" : "This extension is used to provide the Referral Number.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/related-task"
        },
        "name" : "RelatedTask",
        "description" : "Completed or terminated task(s) whose function is taken by this new task",
        "exampleBoolean" : false,
        "groupingId" : "SearchParameters"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/requestInitiationTime"
        },
        "name" : "Request Initiation Time",
        "description" : "Instant from which the request is being initiated.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/requestOriginationType"
        },
        "name" : "RequestOriginationType",
        "description" : "Indicator as to whether the request for estimate originated from a scheduled or unscheduled service.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationDefinition"
          }
        ],
        "reference" : {
          "reference" : "OperationDefinition/GFE-retrieve"
        },
        "name" : "Retrieve GFE Packet",
        "description" : "This operation is used by an entity to retrieve a GFE Packet containing the GFE Bundle(s) and other referenced resources based on a GFE Coordination Task. There are no input parameters and the only output is a GFE Packet. If the context task is to a Coordinating Task, this will return the GFE Packet. If the context task is for a GFE Contributor Task, it returns the GFE Bundle, if present. If a GFE Bundle does not exist for an associated Contributor Task, in place of a GFE Bundle, a GFE Missing Bundle is provided (either directly in a response if the referenced task was a Contributor Task or inside the GFE Packet if the referenced task was a Coordinating Task.). This operation will only return GFE Bundles for GFE Contributor Tasks that have an appropriately attached GFE Bundle and a status of `completed`. All other Contributor Tasks that otherwise do not have a status of `rejected` or `cancelled` will have a GFE Missing Bundle included instead.",
        "exampleBoolean" : false,
        "groupingId" : "Operations"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/selfPayDeclared"
        },
        "name" : "Self-Pay Declared",
        "description" : "Requester has explicitly declared self-pay.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Coverage"
          }
        ],
        "reference" : {
          "reference" : "Coverage/selfpaycoverage2001"
        },
        "name" : "selfpaycoverage2001",
        "description" : "An instance of PCTCoverage",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-coverage"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/serviceDescription"
        },
        "name" : "Service Description",
        "description" : "This extension is used to communicate a plain language description of the procedure, product, or service.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/estimateCondition"
        },
        "name" : "Significant condition involved",
        "description" : "Significant condition involved in an estimate.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/estimateProcedureOrService"
        },
        "name" : "Significant Procedures and/or products involved",
        "description" : "Significant Procedures and/or products involved in an estimate.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/subjectToMedicalMgmt"
        },
        "name" : "Subject To Medical Management",
        "description" : "This extension is used to provide a reason to explain how the estimate may change subject to medical management.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationDefinition"
          }
        ],
        "reference" : {
          "reference" : "OperationDefinition/GFE-submit"
        },
        "name" : "Submit a GFE resource for the creation of an AEOB",
        "description" : "This operation is used by an entity to submit one or multiple GFEs as a Bundle containing the GFE(s) and other referenced resources for processing. The only input parameter is the single Bundle resource with one or multiple GFE(s) - each of which is based on the Claim resource (along with other referenced resources). The only output is a url for subsequent polling per [async pattern](https://hl7.org/fhir/R5/async-bundle.html). If after polling the response is complete, then the result will either be a single Bundle with the AEOB - which is based on the ExplanationOfBenefit resource, (and other referenced resources) or an OperationOutcome resource indicating the AEOB will be sent directly to the patient and not to the provider.",
        "exampleBoolean" : false,
        "groupingId" : "Operations"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/Submitter-Org-1"
        },
        "name" : "Submitter-Org-1",
        "description" : "Institutional GFE Submitter 1",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-organization"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/Submitter-Practitioner-1"
        },
        "name" : "Submitter-Practitioner-1",
        "description" : "Professional GFE Submitter 1",
        "exampleCanonical" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-practitioner"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/davinci-pct-aeob-available-author-subscription"
        },
        "name" : "Subscription - AEOB Available for Author Notification",
        "description" : "An author focused Subscription when an Advanced Explanation of Benefit (AEOB) Packet DocumentReference is created or updated (for FHIR R4). This represents that an AEOB Bundle, either contained in or referred to by the DocumentReference has been newly created and is available or has been updated, should updates be made.",
        "exampleBoolean" : false,
        "groupingId" : "Subscriptions"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/davinci-pct-aeob-available-subject-subscription"
        },
        "name" : "Subscription - AEOB Available for Subject Notification",
        "description" : "A subject focused Subscription when an Advanced Explanation of Benefit (AEOB) Packet DocumentReference is created or updated (for FHIR R4). This represents that an AEOB Bundle, either contained in or referred to by the DocumentReference has been newly created and is available or has been updated, should updates be made.",
        "exampleBoolean" : false,
        "groupingId" : "Subscriptions"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/davinci-pct-gfe-available-author-subscription"
        },
        "name" : "Subscription - GFE Available for Author Notification",
        "description" : "An author focused Subscription when a Good Faith Estimate (GFE) Packet DocumentReference is created or updated (for FHIR R4). This represents that a GFE Bundle, either contained in or referred to by the DocumentReference has been newly created and is available or has been updated, should updates be made.",
        "exampleBoolean" : false,
        "groupingId" : "Subscriptions"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/davinci-pct-gfe-available-subject-subscription"
        },
        "name" : "Subscription - GFE Available for Subject Notification",
        "description" : "A subject focused Subscription when a Good Faith Estimate (GFE) Packet DocumentReference is created or updated (for FHIR R4). This represents that a GFE Bundle, either contained in or referred to by the DocumentReference has been newly created and is available or has been updated, should updates be made.",
        "exampleBoolean" : false,
        "groupingId" : "Subscriptions"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/davinci-pct-gfe-task-update-subscription"
        },
        "name" : "Subscription - GFE Coordination Task Update Notification",
        "description" : "Profile for a Subscription to provide a notification to an Provider involved in GFE Coordination effort (either as a GFE Coordination Requester or a GFE Contributor) whenever a Task is created, updated, or deleted (for FHIR R4). For the GFE Coordination requester this will trigger for a change on a Coordination or Contributor Task for which they are the requester. For a GFE Contributor this will trigger on a change to a Contributor Task for which they are the owner or on a change to an associated Coordination Task. This will be triggered on the creation, update, or deletion of Coordination (gfe-coordination-task) or Contributor Task (gfe-contributor-task) codes.",
        "exampleBoolean" : false,
        "groupingId" : "Subscriptions"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SubscriptionTopic"
          }
        ],
        "reference" : {
          "reference" : "SubscriptionTopic/davinci-pct-aeob-available-author-notification"
        },
        "name" : "SubscriptionTopic - AEOB Available for Author Notification",
        "description" : "Author focused Subscription Topic when an Advanced Explanation of Benefit (AEOB) Packet DocumentReference is created or updated (for FHIR R4). This represents that an AEOB Bundle, either contained in or referred to by the DocumentReference has been newly created and is available or has been updated, should updates be made.\n\r**Canonical URL:** http://hl7.org/fhir/us/davinci-pct/SubscriptionTopic/davinci-pct-aeob-available-author-notification",
        "exampleBoolean" : false,
        "groupingId" : "Subscriptions"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SubscriptionTopic"
          }
        ],
        "reference" : {
          "reference" : "SubscriptionTopic/davinci-pct-aeob-available-subject-notification"
        },
        "name" : "SubscriptionTopic - AEOB Available for Subject Notification",
        "description" : "Subject focused Subscription Topic for when an Advanced Explanation of Benefit DocumentReference is created or updated (for FHIR R4). This represents that an AEOB Packet, either contained in or referred to by the DocumentReference has been newly created and is available or has been updated, should updates be made.\n\r**Canonical URL:** http://hl7.org/fhir/us/davinci-pct/SubscriptionTopic/davinci-pct-aeob-available-subject-notification",
        "exampleBoolean" : false,
        "groupingId" : "Subscriptions"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SubscriptionTopic"
          }
        ],
        "reference" : {
          "reference" : "SubscriptionTopic/davinci-pct-gfe-available-author-notification"
        },
        "name" : "SubscriptionTopic - GFE Available for Author Notification",
        "description" : "Author focused Subscription Topic when a Good Faith Estimate (GFE) Packet DocumentReference is created or updated (for FHIR R4). This represents that an GFE Bundle, either contained in or referred to by the DocumentReference has been newly created and is available or has been updated, should updates be made.\n\r**Canonical URL:** http://hl7.org/fhir/us/davinci-pct/SubscriptionTopic/davinci-pct-gfe-available-author-notification",
        "exampleBoolean" : false,
        "groupingId" : "Subscriptions"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SubscriptionTopic"
          }
        ],
        "reference" : {
          "reference" : "SubscriptionTopic/davinci-pct-gfe-available-subject-notification"
        },
        "name" : "SubscriptionTopic - GFE Available for Subject Notification",
        "description" : "Subject focused Subscription Topic for when a Good Faith Estimate (GFE) Packet DocumentReference is created or updated (for FHIR R4). This represents that an GFE Packet, either contained in or referred to by the DocumentReference has been newly created and is available or has been updated, should updates be made.\n\r**Canonical URL:** http://hl7.org/fhir/us/davinci-pct/SubscriptionTopic/davinci-pct-gfe-available-subject-notification",
        "exampleBoolean" : false,
        "groupingId" : "Subscriptions"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SubscriptionTopic"
          }
        ],
        "reference" : {
          "reference" : "SubscriptionTopic/davinci-pct-gfe-coordination-task-notification"
        },
        "name" : "SubscriptionTopic - GFE Coordination Task Notification",
        "description" : "Subscription Topic to provide a notification to an Provider involved in GFE Coordination effort (either as a GFE Coordination Requester or a GFE Contributor) whenever a Task is created, updated, or deleted (for FHIR R4). For the GFE Coordination requester this will trigger for a change on a Coordination or Contributor Task for which they are the requester. For a GFE Contributor this will trigger on a change to a Contributor Task for which they are the owner or on a change to an associated Coordination Task. This will be triggered on the creation, update, or deletion of Coordination (gfe-coordination-task) or Contributor Task (gfe-contributor-task) codes.\n\r**Canonical URL:** http://hl7.org/fhir/us/davinci-pct/SubscriptionTopic/davinci-pct-gfe-coordination-task-notification",
        "exampleBoolean" : false,
        "groupingId" : "Subscriptions"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/task-requested-period"
        },
        "name" : "TaskRequestedPeriod",
        "description" : "Search for a task by when the task should be performed",
        "exampleBoolean" : false,
        "groupingId" : "SearchParameters"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/USClaimDRGCodes"
        },
        "name" : "US Claim DRG Codes",
        "description" : "US Claim Diagnosis Related Group Codes. All codes from MS-DRGs - AP-DRGs - APR-DRGs",
        "exampleBoolean" : false
      }
    ],
    "page" : {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
          "valueCode" : "informative"
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
          "valueUrl" : "toc.html"
        }
      ],
      "nameUrl" : "toc.html",
      "title" : "Table of Contents",
      "generation" : "html",
      "page" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "index.html"
            }
          ],
          "nameUrl" : "index.html",
          "title" : "Patient Cost Transparency Implementation Guide Home Page",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "reading_this_ig.html"
            }
          ],
          "nameUrl" : "reading_this_ig.html",
          "title" : "Reading This IG",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "use_cases.html"
            }
          ],
          "nameUrl" : "use_cases.html",
          "title" : "Use Case and Actors",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "draft"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "gfe_coordination_overview.html"
            }
          ],
          "nameUrl" : "gfe_coordination_overview.html",
          "title" : "Good Faith Estimate (GFE) Coordination Overview (Multi-Provider)",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "gfe_submission_and_aeob_overview.html"
            }
          ],
          "nameUrl" : "gfe_submission_and_aeob_overview.html",
          "title" : "Good Faith Estimate (GFE) Submission and AEOB Overview",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "patient_access_support.html"
            }
          ],
          "nameUrl" : "patient_access_support.html",
          "title" : "Patient Access to GFE and AEOB",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "trial-use"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "projects_and_participants.html"
            }
          ],
          "nameUrl" : "projects_and_participants.html",
          "title" : "Project and Participants",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "trial-use"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "formal_specification.html"
            }
          ],
          "nameUrl" : "formal_specification.html",
          "title" : "Formal Specification",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "draft"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "gfe_coordination_specification.html"
            }
          ],
          "nameUrl" : "gfe_coordination_specification.html",
          "title" : "Good Faith Estimate (GFE) Coordination Specification (Multi-Provider)",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "trial-use"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "gfe_submission_and_aeob_specification.html"
            }
          ],
          "nameUrl" : "gfe_submission_and_aeob_specification.html",
          "title" : "Good Faith Estimate (GFE) Submission and AEOB Specification",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "terminology_licensure.html"
            }
          ],
          "nameUrl" : "terminology_licensure.html",
          "title" : "Terminology Licensure",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "trial-use"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "security.html"
            }
          ],
          "nameUrl" : "security.html",
          "title" : "Security",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "downloads.html"
            }
          ],
          "nameUrl" : "downloads.html",
          "title" : "Downloads",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "change_log.html"
            }
          ],
          "nameUrl" : "change_log.html",
          "title" : "Change Log",
          "generation" : "markdown"
        }
      ]
    },
    "parameter" : [
      {
        "code" : "path-resource",
        "value" : "input/capabilities"
      },
      {
        "code" : "path-resource",
        "value" : "input/examples"
      },
      {
        "code" : "path-resource",
        "value" : "input/extensions"
      },
      {
        "code" : "path-resource",
        "value" : "input/models"
      },
      {
        "code" : "path-resource",
        "value" : "input/operations"
      },
      {
        "code" : "path-resource",
        "value" : "input/profiles"
      },
      {
        "code" : "path-resource",
        "value" : "input/resources"
      },
      {
        "code" : "path-resource",
        "value" : "input/vocabulary"
      },
      {
        "code" : "path-resource",
        "value" : "input/maps"
      },
      {
        "code" : "path-resource",
        "value" : "input/testing"
      },
      {
        "code" : "path-resource",
        "value" : "input/history"
      },
      {
        "code" : "path-resource",
        "value" : "fsh-generated/resources"
      },
      {
        "code" : "path-pages",
        "value" : "template/config"
      },
      {
        "code" : "path-pages",
        "value" : "input/images"
      },
      {
        "code" : "path-tx-cache",
        "value" : "input-cache/txcache"
      }
    ]
  }
}

```
