# Downloads - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* **Downloads**

## Downloads

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

### Downloads

* The full [FHIR PCT Implementation Guide](full-ig.zip)
* FHIR PCT Resource Definitions [(JSON)](definitions.json.zip) [(XML)](definitions.xml.zip) [(TTL)](definitions.ttl.zip)
* FHIR PCT IG Profile Examples [(JSON)](examples.json.zip) [(XML)](examples.xml.zip) [(TTL)](examples.ttl.zip)
* FHIR PCT IG [Validator Pack](validator-hl7.fhir.us.davinci-pct.pack)
* FHIR R4 Specification [Downloads](http://hl7.org/fhir/R4/downloads.html)
* FHIR R4 [Core Specification Text](http://hl7.org/fhir/R4/fhir-spec.zip)
* [Instructions for the FHIR Validator](https://confluence.hl7.org/display/FHIR/Using+the+FHIR+Validator)
* Current version of the [FHIR Validator](https://fhir.github.io/latest-ig-validator/org.hl7.fhir.validator.jar)

#### Package File

The following package file includes an NPM (Node Package Manager) package file used by many of the FHIR tools. It contains all the value sets, profiles, extensions, list of pages and URLs in the implementation guide (IG), etc. defined as part of this version of the IG. This file should be the first choice whenever generating any implementation artifacts since it contains all of the rules about what makes the profiles valid. Implementers will still need to be familiar with the content of the specification and profiles that apply to make a conformant implementation. See the overview on validating [FHIR profiles and resources](http://hl7.org/fhir/R4/validation.html):

* [Package](package.tgz)

#### Cross Version Analysis

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B systems. Packages for both [R4 (hl7.fhir.us.davinci-pct.r4)](package.r4.tgz) and [R4B (hl7.fhir.us.davinci-pct.r4b)](package.r4b.tgz) are available.

#### Dependency Table












#### Globals Table

*There are no Global profiles defined*

#### IP Statements

This publication includes IP covered under the following statements.

* © Copyright 2022 American Medical Association

* [NUCC Provider Taxonomy](http://tx.fhir.org/r4/ValueSet/nucc-provider-taxonomy): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [Bundle/PCT-GFE-Bundle-Inst-1](Bundle-PCT-GFE-Bundle-Inst-1.md)...Show 11 more,[Bundle/PCT-GFE-Bundle-Prof-1](Bundle-PCT-GFE-Bundle-Prof-1.md),[Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md),[Bundle/PCT-GFE-Packet-Prof-1](Bundle-PCT-GFE-Packet-Prof-1.md),[Claim/PCT-GFE-Institutional-1](Claim-PCT-GFE-Institutional-1.md),[Claim/PCT-GFE-Institutional-MRI](Claim-PCT-GFE-Institutional-MRI.md),[Claim/PCT-GFE-Professional-MRI](Claim-PCT-GFE-Professional-MRI.md),[PCTGFEInstitutional](StructureDefinition-davinci-pct-gfe-institutional.md),[PCTGFEProfessional](StructureDefinition-davinci-pct-gfe-professional.md),[PCTGFESummary](StructureDefinition-davinci-pct-gfe-summary.md),[PCTPractitioner](StructureDefinition-davinci-pct-practitioner.md)and[ProviderTaxonomy](StructureDefinition-providerTaxonomy.md)


* All X12 products are subject to this IP policy, including published and draft works.X12 is the only organization authorized to grant permission for use of X12 products. Users of all X12 products should make sure that they understand the permissible uses, as well as the limitations on such usage, as outlined below.Additional IP information can be found [here](https://x12.org/products/ip-use) Send an email to ip@x12.org to request permission to reproduce X12 IP. Include your name, organization, title, address, city, state, zip, email, a detailed description of the Submitted Artifact, including the underlying or cited X12 Product, and a detailed description of the intended audience and planned distribution method for the Artifact.Additional information on X12 licensing program can be found [here](https://x12.org/products/licensing-program) To purchase code list subscriptions call (425) 562-2245 or email admin@wpc-edi.com.

* [X12 Claim Adjustment Reason Codes](http://terminology.hl7.org/6.5.0/CodeSystem-X12ClaimAdjustmentReasonCodes.html): [PCTAdjustmentReasonVS](ValueSet-PCTAdjustmentReasonVS.md) and [PCTAdvancedEOB](StructureDefinition-davinci-pct-aeob.md)


* All X12 work products are copyrighted. Any use of any X12 work product must be compliant with US Copyright laws and X12 Intellectual Property policies.Please see [[https://x12.org/products/licensing-program](https://x12.org/products/licensing-program)](https://x12.org/products/licensing-program) 

* [X12 Service Type Codes](http://terminology.hl7.org/6.5.0/CodeSystem-X12ServiceTypeCodes.html): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [ExplanationOfBenefit/PCT-AEOB-1](ExplanationOfBenefit-PCT-AEOB-1.md)...Show 4 more,[ExplanationOfBenefit/PCT-AEOB-Summary-1](ExplanationOfBenefit-PCT-AEOB-Summary-1.md),[PCTAdvancedEOB](StructureDefinition-davinci-pct-aeob.md),[PCTAdvancedEOBSummary](StructureDefinition-davinci-pct-aeob-summary.md)and[PCTBenefitBalanceCategoryVS](ValueSet-PCTBenefitBalanceCategoryVS.md)


* CMS maintains HIPPS. There are no known constraints on the use of HIPPS.

* [Health Insurance Prospective Payment System (HIPPS)](http://terminology.hl7.org/6.5.0/CodeSystem-HIPPS.html): [EstimateProcedureOrService](StructureDefinition-estimateProcedureOrService.md), [PCTAdvancedEOB](StructureDefinition-davinci-pct-aeob.md)...Show 4 more,[PCTGFEInstitutional](StructureDefinition-davinci-pct-gfe-institutional.md),[PCTGFEProfessional](StructureDefinition-davinci-pct-gfe-professional.md),[PCTServiceRequest](StructureDefinition-davinci-pct-servicerequest.md)and[USClaimMedicalProductOrServiceCodes](ValueSet-USClaimMedicalProductOrServiceCodes.md)


* ISO maintains the copyright on the country codes, and controls its use carefully. For further details see the ISO 3166 web page: [https://www.iso.org/iso-3166-country-codes.html](https://www.iso.org/iso-3166-country-codes.html)

* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](http://terminology.hl7.org/6.5.0/CodeSystem-ISO3166Part1.html): [AEOBAdjudicationError](StructureDefinition-davinci-pct-aeob-adjudication-error.md), [AEOBComplete](StructureDefinition-davinci-pct-aeob-complete.md)...Show 120 more,[AEOBDateOfService](SearchParameter-aeob-date-of-service.md),[AHANUBCPointOfOriginVS](ValueSet-AHANUBCPointOfOriginVS.md),[AHANUBCPriorityTypeOfAdmissionOrVisitVS](ValueSet-AHANUBCPriorityTypeOfAdmissionOrVisitVS.md),[CoordinationPlatformPatientCostTransparencyCapabilityStatement](CapabilityStatement-davinci-pct-coordination-platform.md),[CoordinationRequesterPatientCostTransparencyCapabilityStatement](CapabilityStatement-davinci-pct-gfe-provider.md),[DocumentReferenceDocStatus](SearchParameter-DocumentReference-doc-status.md),[EstimateCondition](StructureDefinition-estimateCondition.md),[EstimateProcedureOrService](StructureDefinition-estimateProcedureOrService.md),[GFEBillingProviderLineItemCtrlNum](StructureDefinition-gfeBillingProviderLineItemCtrlNum.md),[GFEConsentForBalanceBilling](StructureDefinition-gfeConsentForBalanceBilling.md),[GFEContributorPatientCostTransparencyCapabilityStatement](CapabilityStatement-davinci-pct-gfe-contributor.md),[GFECoordinationRequest](OperationDefinition-GFE-coordination-request.md),[GFEDisclaimer](StructureDefinition-gfeDisclaimer.md),[GFEReference](StructureDefinition-gfeReference.md),[GFERelatedTask](StructureDefinition-gfeRelatedTask.md),[GFERetrieve](OperationDefinition-GFE-retrieve.md),[GFEServiceLinkingInfo](StructureDefinition-gfeServiceLinkingInfo.md),[GFESubmit](OperationDefinition-GFE-submit.md),[GFEValidationError](StructureDefinition-davinci-pct-gfe-validation-error.md),[ICD10ProcedureCodes](ValueSet-ICD10ProcedureCodes.md),[OutOfNetworkProviderInfo](StructureDefinition-inNetworkProviderOptionsLink.md),[PCTAEOBAvailableAuthorSubscription](StructureDefinition-davinci-pct-aeob-available-author-subscription.md),[PCTAEOBAvailableAuthorSubscriptionTopic](SubscriptionTopic-davinci-pct-aeob-available-author-notification.md),[PCTAEOBAvailableSubjectSubscription](StructureDefinition-davinci-pct-aeob-available-subject-subscription.md),[PCTAEOBAvailableSubjectSubscriptionTopic](SubscriptionTopic-davinci-pct-aeob-available-subject-notification.md),[PCTAEOBPacket](StructureDefinition-davinci-pct-aeob-packet.md),[PCTAEOBProcessNoteCS](CodeSystem-PCTAEOBProcessNoteCS.md),[PCTAEOBProcessNoteVS](ValueSet-PCTAEOBProcessNoteVS.md),[PCTAdjudication](CodeSystem-PCTAdjudication.md),[PCTAdjudicationCategoryCS](CodeSystem-PCTAdjudicationCategoryCS.md),[PCTAdjudicationCategoryVS](ValueSet-PCTAdjudicationCategoryVS.md),[PCTAdjudicationVS](ValueSet-PCTAdjudicationVS.md),[PCTAdjustmentReasonVS](ValueSet-PCTAdjustmentReasonVS.md),[PCTAdvancedEOB](StructureDefinition-davinci-pct-aeob.md),[PCTAdvancedEOBComposition](StructureDefinition-davinci-pct-aeob-composition.md),[PCTAdvancedEOBDocumentReference](StructureDefinition-davinci-pct-aeob-documentreference.md),[PCTAdvancedEOBSummary](StructureDefinition-davinci-pct-aeob-summary.md),[PCTBenefitBalanceCategoryVS](ValueSet-PCTBenefitBalanceCategoryVS.md),[PCTCareTeamRoleVS](ValueSet-PCTCareTeamRoleVS.md),[PCTContributorTaskStatusCodes](ValueSet-PCTContributorTaskStatusCodes.md),[PCTContributorTaskStatusReasonCodes](ValueSet-PCTContributorTaskStatusReasonCodes.md),[PCTCoordinationTaskStatusCodes](ValueSet-PCTCoordinationTaskStatusCodes.md),[PCTCoordinationTaskStatusReasonCodes](ValueSet-PCTCoordinationTaskStatusReasonCodes.md),[PCTCoverage](StructureDefinition-davinci-pct-coverage.md),[PCTDeviceRequest](StructureDefinition-davinci-pct-devicerequest.md),[PCTDiagnosticCodes](ValueSet-PCTDiagnosticCodes.md),[PCTDocumentSection](CodeSystem-PCTDocumentSection.md),[PCTDocumentTypeTemporaryTrialUse](CodeSystem-PCTDocumentTypeTemporaryTrialUse.md),[PCTEstimateTypeSummaryCSTemporaryTrialUse](CodeSystem-PCTEstimateTypeSummaryCSTemporaryTrialUse.md),[PCTFinancialType](CodeSystem-PCTFinancialType.md),[PCTFinancialTypeVS](ValueSet-PCTFinancialTypeVS.md),[PCTGFEAvailableAuthorSubscription](StructureDefinition-davinci-pct-gfe-available-author-subscription.md),[PCTGFEAvailableAuthorSubscriptionTopic](SubscriptionTopic-davinci-pct-gfe-available-author-notification.md),[PCTGFEAvailableSubjectSubscription](StructureDefinition-davinci-pct-gfe-available-subject-subscription.md),[PCTGFEAvailableSubjectSubscriptionTopic](SubscriptionTopic-davinci-pct-gfe-available-subject-notification.md),[PCTGFEBundle](StructureDefinition-davinci-pct-gfe-bundle.md),[PCTGFECMSPOS](ValueSet-PCTGFECMSPOS.md),[PCTGFEComposition](StructureDefinition-davinci-pct-gfe-composition.md),[PCTGFEContributorTask](StructureDefinition-davinci-pct-gfe-contributor-task.md),[PCTGFECoordinationBundle](StructureDefinition-davinci-pct-gfe-coordination-bundle.md),[PCTGFECoordinationTask](StructureDefinition-davinci-pct-gfe-coordination-task.md),[PCTGFECoordinationTaskSubscriptionTopic](SubscriptionTopic-davinci-pct-gfe-coordination-task-notification.md),[PCTGFEDocumentReference](StructureDefinition-davinci-pct-gfe-documentreference.md),[PCTGFEInformationBundle](StructureDefinition-davinci-pct-gfe-information-bundle.md),[PCTGFEInstitutional](StructureDefinition-davinci-pct-gfe-institutional.md),[PCTGFEItemCptHcpcsVS](ValueSet-PCTGFEItemCptHcpcsVS.md),[PCTGFEItemNDCVS](ValueSet-PCTGFEItemNDCVS.md),[PCTGFEItemRevenueVS](ValueSet-PCTGFEItemRevenueVS.md),[PCTGFEMissingBundle](StructureDefinition-davinci-pct-gfe-missing-bundle.md),[PCTGFEPacket](StructureDefinition-davinci-pct-gfe-packet.md),[PCTGFEProfessional](StructureDefinition-davinci-pct-gfe-professional.md),[PCTGFERequestTypeCSTemporaryTrialUse](CodeSystem-PCTGFERequestTypeCSTemporaryTrialUse.md),[PCTGFERequestTypeVS](ValueSet-PCTGFERequestTypeVS.md),[PCTGFESummary](StructureDefinition-davinci-pct-gfe-summary.md),[PCTGFETaskRelationship](ValueSet-PCTGFETaskRelationship.md),[PCTGFETaskUpdateSubscription](StructureDefinition-davinci-pct-gfe-task-update-subscription.md),[PCTGFETypeOfBillVS](ValueSet-PCTGFETypeOfBillVS.md),[PCTMedicationRequest](StructureDefinition-davinci-pct-medicationrequest.md),[PCTNetworkStatusCS](CodeSystem-PCTNetworkStatusCS.md),[PCTOrgContactPurposeType](CodeSystem-PCTOrgContactPurposeType.md),[PCTOrgContactPurposeTypeVS](ValueSet-PCTOrgContactPurposeTypeVS.md),[PCTOrganization](StructureDefinition-davinci-pct-organization.md),[PCTOrganizationTypeVS](ValueSet-PCTOrganizationTypeVS.md),[PCTPayerBenefitPaymentStatusVS](ValueSet-PCTPayerBenefitPaymentStatusVS.md),[PCTPayerProviderNetworkStatusVS](ValueSet-PCTPayerProviderNetworkStatusVS.md),[PCTPractitioner](StructureDefinition-davinci-pct-practitioner.md),[PCTProcedureSurgicalCodes](ValueSet-PCTProcedureSurgicalCodes.md),[PCTProcedureType](CodeSystem-PCTProcedureType.md),[PCTProcedureTypeVS](ValueSet-PCTProcedureTypeVS.md),[PCTServiceLocation](StructureDefinition-davinci-pct-service-location.md),[PCTServiceRequest](StructureDefinition-davinci-pct-servicerequest.md),[PCTSupportingInfoType](CodeSystem-PCTSupportingInfoType.md),[PCTSupportingInfoTypeVS](ValueSet-PCTSupportingInfoTypeVS.md),[PCTTaskAttachmentContentType](ValueSet-PCTTaskAttachmentContentType.md),[PCTTaskBusinessStatusCSTemporaryTrialUse](CodeSystem-PCTTaskBusinessStatusCSTemporaryTrialUse.md),[PCTTaskBusinessStatusCodes](ValueSet-PCTTaskBusinessStatusCodes.md),[PCTTaskStatusReasonCSTemporaryTrialUse](CodeSystem-PCTTaskStatusReasonCSTemporaryTrialUse.md),[PCTTotal](ValueSet-PCTTotal.md),[PacketCondition](SearchParameter-packet-condition.md),[PacketLinkingIdentifier](SearchParameter-packet-linking-identifier.md),[PacketPlannedPeriodOfService](SearchParameter-packet-PlannedPeriodOfService.md),[PacketProcedureOrService](SearchParameter-packet-procedure-or-service.md),[PacketRequestInitiationTime](SearchParameter-packet-request-initiation-time.md),[PatientCostTransparency](index.md),[PatientCostTransparencyCapabilityStatement](CapabilityStatement-davinci-pct.md),[PlannedServicePeriod](StructureDefinition-plannedServicePeriod.md),[ProcessNoteClass](StructureDefinition-processNoteClass.md),[ProviderEventMethodology](StructureDefinition-providerEventMethodology.md),[ProviderTaxonomy](StructureDefinition-providerTaxonomy.md),[ReferralNumber](StructureDefinition-referralNumber.md),[RelatedTask](SearchParameter-related-task.md),[RemainingBenefit](StructureDefinition-remaining-benefit.md),[RequestInitiationTime](StructureDefinition-requestInitiationTime.md),[RequestOriginationType](StructureDefinition-requestOriginationType.md),[SelfPayDeclared](StructureDefinition-selfPayDeclared.md),[ServiceDescription](StructureDefinition-serviceDescription.md),[SubjectToMedicalMgmt](StructureDefinition-subjectToMedicalMgmt.md),[TaskRequestedPeriod](SearchParameter-task-requested-period.md),[USClaimDRGCodes](ValueSet-USClaimDRGCodes.md)and[USClaimMedicalProductOrServiceCodes](ValueSet-USClaimMedicalProductOrServiceCodes.md)


* Licensing information can be found [here](https://www.nubc.org/license) These codes are listed within the UB-04 Data Specifications Manual. The Official UB-04 Data Specifications Manual, copyrighted by the American Hospital Association, is the only official source of UB-04 billing information adopted by the National Uniform Billing Committee. No other publication—governmental or private/commercial—can be considered authoritative. The AHA wants to make you aware that the use of codes, descriptions, or any other content contained in the manual to be used in a software application, publication, or any other derivative work must be properly licensed by the AHA. If your organization uses or intends to use any of the codes or other related content from the manual in this manner, please contact the AHA’s licensing manager, Tim Carlson, at 312.893.6816 or tcarlson@aha.org

* [AHA NUBC Revenue Codes](http://terminology.hl7.org/6.5.0/CodeSystem-AHANUBCRevenueCodes.html): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [Bundle/PCT-GFE-Bundle-Inst-1](Bundle-PCT-GFE-Bundle-Inst-1.md)...Show 7 more,[Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md),[Claim/PCT-GFE-Institutional-1](Claim-PCT-GFE-Institutional-1.md),[Claim/PCT-GFE-Institutional-MRI](Claim-PCT-GFE-Institutional-MRI.md),[ExplanationOfBenefit/PCT-AEOB-1](ExplanationOfBenefit-PCT-AEOB-1.md),[PCTAdvancedEOB](StructureDefinition-davinci-pct-aeob.md),[PCTGFEInstitutional](StructureDefinition-davinci-pct-gfe-institutional.md)and[PCTGFEItemRevenueVS](ValueSet-PCTGFEItemRevenueVS.md)
* [AHA NUBC Type Of Bill Codes](http://terminology.hl7.org/6.5.0/CodeSystem-AHANUBCTypeOfBill.html): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [Bundle/PCT-GFE-Bundle-Inst-1](Bundle-PCT-GFE-Bundle-Inst-1.md)...Show 6 more,[Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md),[Claim/PCT-GFE-Institutional-1](Claim-PCT-GFE-Institutional-1.md),[Claim/PCT-GFE-Institutional-MRI](Claim-PCT-GFE-Institutional-MRI.md),[PCTGFEInstitutional](StructureDefinition-davinci-pct-gfe-institutional.md),[PCTGFEProfessional](StructureDefinition-davinci-pct-gfe-professional.md)and[PCTGFETypeOfBillVS](ValueSet-PCTGFETypeOfBillVS.md)


* The Centers for Medicare & Medicaid Services (CMS) maintain MS-DRGs used throughout the US health care industry. The CMS MS-DRGs are free to use without restriction.

* [Medicare Severity Diagnosis Related Groups (MS-DRGs)](http://terminology.hl7.org/6.5.0/CodeSystem-MSDRG.html): [PCTGFEInstitutional](StructureDefinition-davinci-pct-gfe-institutional.md) and [USClaimDRGCodes](ValueSet-USClaimDRGCodes.md)


* This CodeSystem is not copyrighted.

* [PCT AEOB Process Note Code System](CodeSystem-PCTAEOBProcessNoteCS.md): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [ExplanationOfBenefit/PCT-AEOB-1](ExplanationOfBenefit-PCT-AEOB-1.md), [ExplanationOfBenefit/PCT-AEOB-Summary-1](ExplanationOfBenefit-PCT-AEOB-Summary-1.md), [PCTAEOBProcessNoteVS](ValueSet-PCTAEOBProcessNoteVS.md) and [ProcessNoteClass](StructureDefinition-processNoteClass.md)
* [PCT Adjudication Code System](CodeSystem-PCTAdjudication.md): [PCTAdjudicationVS](ValueSet-PCTAdjudicationVS.md), [PCTAdvancedEOB](StructureDefinition-davinci-pct-aeob.md) and [PCTAdvancedEOBSummary](StructureDefinition-davinci-pct-aeob-summary.md)
* [PCT Packet Section Codes](CodeSystem-PCTDocumentSection.md): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md), [Bundle/PCT-GFE-Packet-Prof-1](Bundle-PCT-GFE-Packet-Prof-1.md), [PCTAdvancedEOBComposition](StructureDefinition-davinci-pct-aeob-composition.md) and [PCTGFEComposition](StructureDefinition-davinci-pct-gfe-composition.md)
* [PCT Document Types](CodeSystem-PCTDocumentTypeTemporaryTrialUse.md): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [Bundle/PCT-GFE-Coordination-Bundle-1](Bundle-PCT-GFE-Coordination-Bundle-1.md)...Show 13 more,[Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md),[Bundle/PCT-GFE-Packet-Prof-1](Bundle-PCT-GFE-Packet-Prof-1.md),[DocumentReference/PCT-AEOB-DocumentReference-1](DocumentReference-PCT-AEOB-DocumentReference-1.md),[DocumentReference/PCT-GFE-DocumentReference-Inst-1](DocumentReference-PCT-GFE-DocumentReference-Inst-1.md),[DocumentReference/PCT-GFE-DocumentReference-Prof-1](DocumentReference-PCT-GFE-DocumentReference-Prof-1.md),[PCTAdvancedEOBComposition](StructureDefinition-davinci-pct-aeob-composition.md),[PCTAdvancedEOBDocumentReference](StructureDefinition-davinci-pct-aeob-documentreference.md),[PCTGFEComposition](StructureDefinition-davinci-pct-gfe-composition.md),[PCTGFEContributorTask](StructureDefinition-davinci-pct-gfe-contributor-task.md),[PCTGFECoordinationTask](StructureDefinition-davinci-pct-gfe-coordination-task.md),[PCTGFEDocumentReference](StructureDefinition-davinci-pct-gfe-documentreference.md),[Task/PCT-GFE-Coordination-Replacement-Task-1](Task-PCT-GFE-Coordination-Replacement-Task-1.md)and[Task/PCT-GFE-Coordination-Task-1](Task-PCT-GFE-Coordination-Task-1.md)
* [PCT Estimate Type Code System](CodeSystem-PCTEstimateTypeSummaryCSTemporaryTrialUse.md): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [Bundle/PCT-GFE-Bundle-Inst-1](Bundle-PCT-GFE-Bundle-Inst-1.md)...Show 8 more,[Bundle/PCT-GFE-Bundle-Prof-1](Bundle-PCT-GFE-Bundle-Prof-1.md),[Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md),[Bundle/PCT-GFE-Packet-Prof-1](Bundle-PCT-GFE-Packet-Prof-1.md),[Claim/PCT-GFE-Summary-1](Claim-PCT-GFE-Summary-1.md),[Claim/PCT-GFE-Summary-MRI](Claim-PCT-GFE-Summary-MRI.md),[ExplanationOfBenefit/PCT-AEOB-Summary-1](ExplanationOfBenefit-PCT-AEOB-Summary-1.md),[PCTAdvancedEOBSummary](StructureDefinition-davinci-pct-aeob-summary.md)and[PCTGFESummary](StructureDefinition-davinci-pct-gfe-summary.md)
* [PCT Financial Type Code System](CodeSystem-PCTFinancialType.md): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [ExplanationOfBenefit/PCT-AEOB-1](ExplanationOfBenefit-PCT-AEOB-1.md)...Show 4 more,[ExplanationOfBenefit/PCT-AEOB-Summary-1](ExplanationOfBenefit-PCT-AEOB-Summary-1.md),[PCTAdvancedEOB](StructureDefinition-davinci-pct-aeob.md),[PCTAdvancedEOBSummary](StructureDefinition-davinci-pct-aeob-summary.md)and[PCTFinancialTypeVS](ValueSet-PCTFinancialTypeVS.md)
* [PCT GFE Request Type Codes Code System](CodeSystem-PCTGFERequestTypeCSTemporaryTrialUse.md): [Bundle/PCT-GFE-Coordination-Bundle-1](Bundle-PCT-GFE-Coordination-Bundle-1.md), [Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md)...Show 11 more,[Bundle/PCT-GFE-Packet-Prof-1](Bundle-PCT-GFE-Packet-Prof-1.md),[PCTGFEContributorTask](StructureDefinition-davinci-pct-gfe-contributor-task.md),[PCTGFECoordinationTask](StructureDefinition-davinci-pct-gfe-coordination-task.md),[PCTGFERequestTypeVS](ValueSet-PCTGFERequestTypeVS.md),[RequestOriginationType](StructureDefinition-requestOriginationType.md),[Task/PCT-GFE-Contributor-Replacement-Task-1](Task-PCT-GFE-Contributor-Replacement-Task-1.md),[Task/PCT-GFE-Contributor-Replacement-Task-2](Task-PCT-GFE-Contributor-Replacement-Task-2.md),[Task/PCT-GFE-Contributor-Task-1](Task-PCT-GFE-Contributor-Task-1.md),[Task/PCT-GFE-Contributor-Task-2](Task-PCT-GFE-Contributor-Task-2.md),[Task/PCT-GFE-Coordination-Replacement-Task-1](Task-PCT-GFE-Coordination-Replacement-Task-1.md)and[Task/PCT-GFE-Coordination-Task-1](Task-PCT-GFE-Coordination-Task-1.md)
* [PCT Network Status](CodeSystem-PCTNetworkStatusCS.md): [PCTAdvancedEOB](StructureDefinition-davinci-pct-aeob.md), [PCTAdvancedEOBSummary](StructureDefinition-davinci-pct-aeob-summary.md), [PCTPayerBenefitPaymentStatusVS](ValueSet-PCTPayerBenefitPaymentStatusVS.md), [PCTPayerProviderNetworkStatusVS](ValueSet-PCTPayerProviderNetworkStatusVS.md) and [PCTTotal](ValueSet-PCTTotal.md)
* [PCT Organization Contact Purpose Type Code System](CodeSystem-PCTOrgContactPurposeType.md): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [Bundle/PCT-GFE-Bundle-Inst-1](Bundle-PCT-GFE-Bundle-Inst-1.md)...Show 4 more,[Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md),[GFE Service Help INC.](Organization-Submitter-Org-1.md),[PCTOrgContactPurposeTypeVS](ValueSet-PCTOrgContactPurposeTypeVS.md)and[PCTOrganization](StructureDefinition-davinci-pct-organization.md)
* [PCT Procedure Type](CodeSystem-PCTProcedureType.md): [PCTGFEInstitutional](StructureDefinition-davinci-pct-gfe-institutional.md), [PCTGFEProfessional](StructureDefinition-davinci-pct-gfe-professional.md), [PCTGFESummary](StructureDefinition-davinci-pct-gfe-summary.md) and [PCTProcedureTypeVS](ValueSet-PCTProcedureTypeVS.md)
* [PCT GFE Supporting Info Type Code System](CodeSystem-PCTSupportingInfoType.md): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [Bundle/PCT-GFE-Bundle-Inst-1](Bundle-PCT-GFE-Bundle-Inst-1.md)...Show 6 more,[Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md),[Claim/PCT-GFE-Institutional-1](Claim-PCT-GFE-Institutional-1.md),[Claim/PCT-GFE-Institutional-MRI](Claim-PCT-GFE-Institutional-MRI.md),[PCTGFEInstitutional](StructureDefinition-davinci-pct-gfe-institutional.md),[PCTGFEProfessional](StructureDefinition-davinci-pct-gfe-professional.md)and[PCTSupportingInfoTypeVS](ValueSet-PCTSupportingInfoTypeVS.md)
* [PCT GFE Request Task Business Status Code System](CodeSystem-PCTTaskBusinessStatusCSTemporaryTrialUse.md): [PCTGFEContributorTask](StructureDefinition-davinci-pct-gfe-contributor-task.md), [PCTGFECoordinationTask](StructureDefinition-davinci-pct-gfe-coordination-task.md) and [PCTTaskBusinessStatusCodes](ValueSet-PCTTaskBusinessStatusCodes.md)
* [PCT GFE Request Task Status Reason Code Code System](CodeSystem-PCTTaskStatusReasonCSTemporaryTrialUse.md): [PCTContributorTaskStatusReasonCodes](ValueSet-PCTContributorTaskStatusReasonCodes.md), [PCTCoordinationTaskStatusReasonCodes](ValueSet-PCTCoordinationTaskStatusReasonCodes.md), [PCTGFEContributorTask](StructureDefinition-davinci-pct-gfe-contributor-task.md) and [PCTGFECoordinationTask](StructureDefinition-davinci-pct-gfe-coordination-task.md)


* This material contains content from [LOINC](http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the [license](http://loinc.org/license). LOINC® is a registered United States trademark of Regenstrief Institute, Inc.

* [LOINC](http://terminology.hl7.org/6.5.0/CodeSystem-v3-loinc.html): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md)...Show 9 more,[Bundle/PCT-GFE-Packet-Prof-1](Bundle-PCT-GFE-Packet-Prof-1.md),[DocumentReference/PCT-AEOB-DocumentReference-1](DocumentReference-PCT-AEOB-DocumentReference-1.md),[DocumentReference/PCT-GFE-DocumentReference-Inst-1](DocumentReference-PCT-GFE-DocumentReference-Inst-1.md),[DocumentReference/PCT-GFE-DocumentReference-Prof-1](DocumentReference-PCT-GFE-DocumentReference-Prof-1.md),[PCTAdvancedEOBComposition](StructureDefinition-davinci-pct-aeob-composition.md),[PCTAdvancedEOBDocumentReference](StructureDefinition-davinci-pct-aeob-documentreference.md),[PCTGFEComposition](StructureDefinition-davinci-pct-gfe-composition.md),[PCTGFECoordinationTask](StructureDefinition-davinci-pct-gfe-coordination-task.md)and[PCTGFEDocumentReference](StructureDefinition-davinci-pct-gfe-documentreference.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [Adjudication Value Codes](http://terminology.hl7.org/6.5.0/CodeSystem-adjudication.html): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [ExplanationOfBenefit/PCT-AEOB-1](ExplanationOfBenefit-PCT-AEOB-1.md)...Show 5 more,[ExplanationOfBenefit/PCT-AEOB-Summary-1](ExplanationOfBenefit-PCT-AEOB-Summary-1.md),[PCTAdjudicationCategoryVS](ValueSet-PCTAdjudicationCategoryVS.md),[PCTAdjudicationVS](ValueSet-PCTAdjudicationVS.md),[PCTAdvancedEOB](StructureDefinition-davinci-pct-aeob.md)and[PCTAdvancedEOBSummary](StructureDefinition-davinci-pct-aeob-summary.md)
* [Benefit Term Codes](http://terminology.hl7.org/6.5.0/CodeSystem-benefit-term.html): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [ExplanationOfBenefit/PCT-AEOB-1](ExplanationOfBenefit-PCT-AEOB-1.md), [ExplanationOfBenefit/PCT-AEOB-Summary-1](ExplanationOfBenefit-PCT-AEOB-Summary-1.md), [PCTAdvancedEOB](StructureDefinition-davinci-pct-aeob.md) and [PCTAdvancedEOBSummary](StructureDefinition-davinci-pct-aeob-summary.md)
* [Unit Type Codes](http://terminology.hl7.org/6.5.0/CodeSystem-benefit-unit.html): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [ExplanationOfBenefit/PCT-AEOB-1](ExplanationOfBenefit-PCT-AEOB-1.md), [ExplanationOfBenefit/PCT-AEOB-Summary-1](ExplanationOfBenefit-PCT-AEOB-Summary-1.md), [PCTAdvancedEOB](StructureDefinition-davinci-pct-aeob.md) and [PCTAdvancedEOBSummary](StructureDefinition-davinci-pct-aeob-summary.md)
* [Claim Type Codes](http://terminology.hl7.org/6.5.0/CodeSystem-claim-type.html): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [Bundle/PCT-GFE-Bundle-Inst-1](Bundle-PCT-GFE-Bundle-Inst-1.md)...Show 10 more,[Bundle/PCT-GFE-Bundle-Prof-1](Bundle-PCT-GFE-Bundle-Prof-1.md),[Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md),[Bundle/PCT-GFE-Packet-Prof-1](Bundle-PCT-GFE-Packet-Prof-1.md),[Claim/PCT-GFE-Institutional-1](Claim-PCT-GFE-Institutional-1.md),[Claim/PCT-GFE-Institutional-MRI](Claim-PCT-GFE-Institutional-MRI.md),[Claim/PCT-GFE-Professional-MRI](Claim-PCT-GFE-Professional-MRI.md),[ExplanationOfBenefit/PCT-AEOB-1](ExplanationOfBenefit-PCT-AEOB-1.md),[PCTAdvancedEOB](StructureDefinition-davinci-pct-aeob.md),[PCTGFEInstitutional](StructureDefinition-davinci-pct-gfe-institutional.md)and[PCTGFEProfessional](StructureDefinition-davinci-pct-gfe-professional.md)
* [Claim Care Team Role Codes](http://terminology.hl7.org/6.5.0/CodeSystem-claimcareteamrole.html): [PCTCareTeamRoleVS](ValueSet-PCTCareTeamRoleVS.md), [PCTGFEInstitutional](StructureDefinition-davinci-pct-gfe-institutional.md), [PCTGFEProfessional](StructureDefinition-davinci-pct-gfe-professional.md) and [PCTGFESummary](StructureDefinition-davinci-pct-gfe-summary.md)
* [Contact entity type](http://terminology.hl7.org/6.5.0/CodeSystem-contactentity-type.html): [PCTOrgContactPurposeTypeVS](ValueSet-PCTOrgContactPurposeTypeVS.md) and [PCTOrganization](StructureDefinition-davinci-pct-organization.md)
* [Coverage Class Codes](http://terminology.hl7.org/6.5.0/CodeSystem-coverage-class.html): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [Bundle/PCT-GFE-Bundle-Inst-1](Bundle-PCT-GFE-Bundle-Inst-1.md)...Show 7 more,[Bundle/PCT-GFE-Bundle-Prof-1](Bundle-PCT-GFE-Bundle-Prof-1.md),[Bundle/PCT-GFE-Information-Bundle-1](Bundle-PCT-GFE-Information-Bundle-1.md),[Bundle/PCT-GFE-Missing-Bundle-1](Bundle-PCT-GFE-Missing-Bundle-1.md),[Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md),[Bundle/PCT-GFE-Packet-Prof-1](Bundle-PCT-GFE-Packet-Prof-1.md),[Coverage/coverage1001](Coverage-coverage1001.md)and[PCTCoverage](StructureDefinition-davinci-pct-coverage.md)
* [Coverage Copay Type Codes](http://terminology.hl7.org/6.5.0/CodeSystem-coverage-copay-type.html): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [Bundle/PCT-GFE-Bundle-Inst-1](Bundle-PCT-GFE-Bundle-Inst-1.md)...Show 7 more,[Bundle/PCT-GFE-Bundle-Prof-1](Bundle-PCT-GFE-Bundle-Prof-1.md),[Bundle/PCT-GFE-Information-Bundle-1](Bundle-PCT-GFE-Information-Bundle-1.md),[Bundle/PCT-GFE-Missing-Bundle-1](Bundle-PCT-GFE-Missing-Bundle-1.md),[Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md),[Bundle/PCT-GFE-Packet-Prof-1](Bundle-PCT-GFE-Packet-Prof-1.md),[Coverage/coverage1001](Coverage-coverage1001.md)and[PCTCoverage](StructureDefinition-davinci-pct-coverage.md)
* [DataAbsentReason](http://terminology.hl7.org/6.5.0/CodeSystem-data-absent-reason.html): [EstimateProcedureOrService](StructureDefinition-estimateProcedureOrService.md), [PCTAdvancedEOB](StructureDefinition-davinci-pct-aeob.md)...Show 4 more,[PCTGFEInstitutional](StructureDefinition-davinci-pct-gfe-institutional.md),[PCTGFEProfessional](StructureDefinition-davinci-pct-gfe-professional.md),[PCTServiceRequest](StructureDefinition-davinci-pct-servicerequest.md)and[USClaimMedicalProductOrServiceCodes](ValueSet-USClaimMedicalProductOrServiceCodes.md)
* [Diagnosis Type Codes](http://terminology.hl7.org/6.5.0/CodeSystem-diagnosistype.html): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [Bundle/PCT-GFE-Bundle-Inst-1](Bundle-PCT-GFE-Bundle-Inst-1.md)...Show 11 more,[Bundle/PCT-GFE-Bundle-Prof-1](Bundle-PCT-GFE-Bundle-Prof-1.md),[Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md),[Bundle/PCT-GFE-Packet-Prof-1](Bundle-PCT-GFE-Packet-Prof-1.md),[Claim/PCT-GFE-Institutional-1](Claim-PCT-GFE-Institutional-1.md),[Claim/PCT-GFE-Institutional-MRI](Claim-PCT-GFE-Institutional-MRI.md),[Claim/PCT-GFE-Professional-MRI](Claim-PCT-GFE-Professional-MRI.md),[Claim/PCT-GFE-Summary-1](Claim-PCT-GFE-Summary-1.md),[Claim/PCT-GFE-Summary-MRI](Claim-PCT-GFE-Summary-MRI.md),[PCTGFEInstitutional](StructureDefinition-davinci-pct-gfe-institutional.md),[PCTGFEProfessional](StructureDefinition-davinci-pct-gfe-professional.md)and[PCTGFESummary](StructureDefinition-davinci-pct-gfe-summary.md)
* [Example Diagnosis Related Group Codes](http://terminology.hl7.org/6.5.0/CodeSystem-ex-diagnosisrelatedgroup.html): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [Bundle/PCT-GFE-Bundle-Inst-1](Bundle-PCT-GFE-Bundle-Inst-1.md)...Show 8 more,[Bundle/PCT-GFE-Bundle-Prof-1](Bundle-PCT-GFE-Bundle-Prof-1.md),[Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md),[Bundle/PCT-GFE-Packet-Prof-1](Bundle-PCT-GFE-Packet-Prof-1.md),[Claim/PCT-GFE-Institutional-1](Claim-PCT-GFE-Institutional-1.md),[Claim/PCT-GFE-Institutional-MRI](Claim-PCT-GFE-Institutional-MRI.md),[Claim/PCT-GFE-Professional-MRI](Claim-PCT-GFE-Professional-MRI.md),[Claim/PCT-GFE-Summary-1](Claim-PCT-GFE-Summary-1.md)and[Claim/PCT-GFE-Summary-MRI](Claim-PCT-GFE-Summary-MRI.md)
* [Example Procedure Type Codes](http://terminology.hl7.org/6.5.0/CodeSystem-ex-procedure-type.html): [PCTGFEInstitutional](StructureDefinition-davinci-pct-gfe-institutional.md), [PCTGFEProfessional](StructureDefinition-davinci-pct-gfe-professional.md), [PCTGFESummary](StructureDefinition-davinci-pct-gfe-summary.md) and [PCTProcedureTypeVS](ValueSet-PCTProcedureTypeVS.md)
* [Medical Management Type](http://terminology.hl7.org/6.5.0/CodeSystem-medical-management-type.html): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [ExplanationOfBenefit/PCT-AEOB-1](ExplanationOfBenefit-PCT-AEOB-1.md) and [SubjectToMedicalMgmt](StructureDefinition-subjectToMedicalMgmt.md)
* [Organization type](http://terminology.hl7.org/6.5.0/CodeSystem-organization-type.html): [Boston Radiology Center](Organization-org1002.md), [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md)...Show 8 more,[Bundle/PCT-GFE-Bundle-Inst-1](Bundle-PCT-GFE-Bundle-Inst-1.md),[Bundle/PCT-GFE-Bundle-Prof-1](Bundle-PCT-GFE-Bundle-Prof-1.md),[Bundle/PCT-GFE-Information-Bundle-1](Bundle-PCT-GFE-Information-Bundle-1.md),[Bundle/PCT-GFE-Missing-Bundle-1](Bundle-PCT-GFE-Missing-Bundle-1.md),[Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md),[Bundle/PCT-GFE-Packet-Prof-1](Bundle-PCT-GFE-Packet-Prof-1.md),[GFE Service Help INC.](Organization-Submitter-Org-1.md)and[Umbrella Insurance Company](Organization-org1001.md)
* [Payee Type Codes](http://terminology.hl7.org/6.5.0/CodeSystem-payeetype.html): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [Bundle/PCT-GFE-Bundle-Inst-1](Bundle-PCT-GFE-Bundle-Inst-1.md)...Show 6 more,[Bundle/PCT-GFE-Bundle-Prof-1](Bundle-PCT-GFE-Bundle-Prof-1.md),[Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md),[Bundle/PCT-GFE-Packet-Prof-1](Bundle-PCT-GFE-Packet-Prof-1.md),[Claim/PCT-GFE-Institutional-1](Claim-PCT-GFE-Institutional-1.md),[Claim/PCT-GFE-Institutional-MRI](Claim-PCT-GFE-Institutional-MRI.md)and[Claim/PCT-GFE-Professional-MRI](Claim-PCT-GFE-Professional-MRI.md)
* [Process Priority Codes](http://terminology.hl7.org/6.5.0/CodeSystem-processpriority.html): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [Bundle/PCT-GFE-Bundle-Inst-1](Bundle-PCT-GFE-Bundle-Inst-1.md)...Show 14 more,[Bundle/PCT-GFE-Bundle-Prof-1](Bundle-PCT-GFE-Bundle-Prof-1.md),[Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md),[Bundle/PCT-GFE-Packet-Prof-1](Bundle-PCT-GFE-Packet-Prof-1.md),[Claim/PCT-GFE-Institutional-1](Claim-PCT-GFE-Institutional-1.md),[Claim/PCT-GFE-Institutional-MRI](Claim-PCT-GFE-Institutional-MRI.md),[Claim/PCT-GFE-Professional-MRI](Claim-PCT-GFE-Professional-MRI.md),[Claim/PCT-GFE-Summary-1](Claim-PCT-GFE-Summary-1.md),[Claim/PCT-GFE-Summary-MRI](Claim-PCT-GFE-Summary-MRI.md),[ExplanationOfBenefit/PCT-AEOB-1](ExplanationOfBenefit-PCT-AEOB-1.md),[PCTAdvancedEOB](StructureDefinition-davinci-pct-aeob.md),[PCTAdvancedEOBSummary](StructureDefinition-davinci-pct-aeob-summary.md),[PCTGFEInstitutional](StructureDefinition-davinci-pct-gfe-institutional.md),[PCTGFEProfessional](StructureDefinition-davinci-pct-gfe-professional.md)and[PCTGFESummary](StructureDefinition-davinci-pct-gfe-summary.md)
* [SubscriberPolicyholder Relationship Codes](http://terminology.hl7.org/6.5.0/CodeSystem-subscriber-relationship.html): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [Bundle/PCT-GFE-Bundle-Inst-1](Bundle-PCT-GFE-Bundle-Inst-1.md)...Show 7 more,[Bundle/PCT-GFE-Bundle-Prof-1](Bundle-PCT-GFE-Bundle-Prof-1.md),[Bundle/PCT-GFE-Information-Bundle-1](Bundle-PCT-GFE-Information-Bundle-1.md),[Bundle/PCT-GFE-Missing-Bundle-1](Bundle-PCT-GFE-Missing-Bundle-1.md),[Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md),[Bundle/PCT-GFE-Packet-Prof-1](Bundle-PCT-GFE-Packet-Prof-1.md),[Coverage/coverage1001](Coverage-coverage1001.md)and[Coverage/selfpaycoverage2001](Coverage-selfpaycoverage2001.md)
* [identifierType](http://terminology.hl7.org/6.5.0/CodeSystem-v2-0203.html): [Boston Radiology Center](Organization-org1002.md), [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md)...Show 21 more,[Bundle/PCT-GFE-Bundle-Inst-1](Bundle-PCT-GFE-Bundle-Inst-1.md),[Bundle/PCT-GFE-Bundle-Prof-1](Bundle-PCT-GFE-Bundle-Prof-1.md),[Bundle/PCT-GFE-Information-Bundle-1](Bundle-PCT-GFE-Information-Bundle-1.md),[Bundle/PCT-GFE-Missing-Bundle-1](Bundle-PCT-GFE-Missing-Bundle-1.md),[Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md),[Bundle/PCT-GFE-Packet-Prof-1](Bundle-PCT-GFE-Packet-Prof-1.md),[Claim/PCT-GFE-Institutional-1](Claim-PCT-GFE-Institutional-1.md),[Claim/PCT-GFE-Institutional-MRI](Claim-PCT-GFE-Institutional-MRI.md),[Claim/PCT-GFE-Professional-MRI](Claim-PCT-GFE-Professional-MRI.md),[ExplanationOfBenefit/PCT-AEOB-1](ExplanationOfBenefit-PCT-AEOB-1.md),[GFE Service Help INC.](Organization-Submitter-Org-1.md),[PCTAdvancedEOB](StructureDefinition-davinci-pct-aeob.md),[PCTCoverage](StructureDefinition-davinci-pct-coverage.md),[PCTGFEContributorTask](StructureDefinition-davinci-pct-gfe-contributor-task.md),[PCTGFECoordinationTask](StructureDefinition-davinci-pct-gfe-coordination-task.md),[PCTGFEInstitutional](StructureDefinition-davinci-pct-gfe-institutional.md),[PCTGFEProfessional](StructureDefinition-davinci-pct-gfe-professional.md),[PCTOrganization](StructureDefinition-davinci-pct-organization.md),[PCTPractitioner](StructureDefinition-davinci-pct-practitioner.md),[Practitioner/Submitter-Practitioner-1](Practitioner-Submitter-Practitioner-1.md)and[Umbrella Insurance Company](Organization-org1001.md)
* [ActRelationshipType](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActRelationshipType.html): [GFERelatedTask](StructureDefinition-gfeRelatedTask.md), [PCTGFETaskRelationship](ValueSet-PCTGFETaskRelationship.md), [Task/PCT-GFE-Contributor-Replacement-Task-1](Task-PCT-GFE-Contributor-Replacement-Task-1.md), [Task/PCT-GFE-Contributor-Replacement-Task-2](Task-PCT-GFE-Contributor-Replacement-Task-2.md) and [Task/PCT-GFE-Coordination-Replacement-Task-1](Task-PCT-GFE-Coordination-Replacement-Task-1.md)
* [MaritalStatus](http://terminology.hl7.org/6.5.0/CodeSystem-v3-MaritalStatus.html): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [Bundle/PCT-GFE-Bundle-Inst-1](Bundle-PCT-GFE-Bundle-Inst-1.md)...Show 6 more,[Bundle/PCT-GFE-Bundle-Prof-1](Bundle-PCT-GFE-Bundle-Prof-1.md),[Bundle/PCT-GFE-Information-Bundle-1](Bundle-PCT-GFE-Information-Bundle-1.md),[Bundle/PCT-GFE-Missing-Bundle-1](Bundle-PCT-GFE-Missing-Bundle-1.md),[Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md),[Bundle/PCT-GFE-Packet-Prof-1](Bundle-PCT-GFE-Packet-Prof-1.md)and[Patient/patient1001](Patient-patient1001.md)
* [RoleCode](http://terminology.hl7.org/6.5.0/CodeSystem-v3-RoleCode.html): [Bundle/PCT-GFE-Information-Bundle-1](Bundle-PCT-GFE-Information-Bundle-1.md) and [Hospital](Location-PCT-ServiceLocation-1.md)


* Using RxNorm codes of type SAB=RXNORM as this specification describes does not require a UMLS license. Access to the full set of RxNorm definitions, and/or additional use of other RxNorm structures and information requires a UMLS license. The use of RxNorm in this specification is pursuant to HL7's status as a licensee of the NLM UMLS. HL7's license does not convey the right to use RxNorm to any users of this specification; implementers must acquire a license to use RxNorm in their own right.

* [RxNorm](http://terminology.hl7.org/6.5.0/CodeSystem-v3-rxNorm.html): [MedicationRequest/PCT-MedicationRequest-1](MedicationRequest-PCT-MedicationRequest-1.md)


