# Change Log - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* **Change Log**

## Change Log

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

This is a log of the significant changes that have happened to this specification since it was first released. For each release, changes are expressed with respect to the prior publication (snapshot, ballot, or official release) and are organized into the following categories:

* Breaking changes: Those that will cause instances from prior releases to no potentially no longer be conformant in the newer version of the specification. These changes are denoted in recent version history
* Substantive changes: Changes that change the expectations on conformant systems. I.e. systems will likely need to modify their code to continue complying with the guide.
* Non-substantive changes: These are changes that do not necessarily require the change of code, but may add clarification or optional features.

> NOTE: This categorization is with respect to the standard, not any particular implementation. Changes that are non-breaking from a standards perspective might still break existing implementations. Non-substantive changes might still result in a need to add or change software code. This change list is not exhaustive. Changes to formatting and layout, as well as corrections to spelling, grammar, hyperlinks, etc. are not called out here. Changes mentioned for older versions may no longer be relevant due to changes in subsequent versions.

### Changes in Version 2.0.0

#### Changes to GFE and AEOB Estimate Bundles

* Changed GFE Collection Bundle and the AEOB Bundle from collection bundles to document bundles and renamed the profile to Packet ([GFE Packet](StructureDefinition-davinci-pct-gfe-packet.md) and [AEOB Packet](StructureDefinition-davinci-pct-aeob-packet.md)) and added DocumentReference profiles ([GFE Packet Document Reference](StructureDefinition-davinci-pct-gfe-documentreference.md) and [AEOB Packet Document Reference](StructureDefinition-davinci-pct-aeob-documentreference.md)) to enable searching and subscriptions. This included adding the [GFE Composition](StructureDefinition-davinci-pct-gfe-composition.md) and [AEOB Composition](StructureDefinition-davinci-pct-aeob-composition.md) profiles and a way to relate estimations. Added a number of improvements in the guidance. 
* [FHIR-49786](https://jira.hl7.org/browse/FHIR-49786) – Change the GFE Collection Bundle to be a document Bundle and add a Document reference to adequately address search and subscriptions ⚠️ **(Non-compatible change)**
* [FHIR-49761](https://jira.hl7.org/browse/FHIR-49761) – Change the AEOB Bundle to be a document Bundle and add a Document reference to adequately address search and subscriptions ⚠️ **(Non-compatible change)**
* [FHIR-45760](https://jira.hl7.org/browse/FHIR-45760) – Add information on frequency of resubmission ⚠️ **(Non-compatible change)**
* [FHIR-45868](https://jira.hl7.org/browse/FHIR-45868) – Add guidance on GFE Collection Bundle differences for coordination workflow and submission
* [FHIR-48826](https://jira.hl7.org/browse/FHIR-48826) – Improve wording on GFE Collection Bundle Initiating Provider/Organization slice
* [FHIR-46402](https://jira.hl7.org/browse/FHIR-46402) – The GFE Collection Bundle example does not have a GFE Bundle in it
* [FHIR-52301](https://jira.hl7.org/browse/FHIR-52301) - Change the gfe-packet and aeob-packet codes to the newly assigned LOINC codes
 
* Added slices to the [GFE Composition](StructureDefinition-davinci-pct-gfe-composition.md) and [AEOB Composition](StructureDefinition-davinci-pct-aeob-composition.md) profiles to provide full referenceability to all expected bundle resources from the Composition resource. 
* [FHIR-51740](https://jira.hl7.org/browse/FHIR-51740) – Add GFE Missing Bundle entries to Composition profiles ⚠️ **(Non-compatible change)**
 
* Provide specific definition and guidance on the what is considered as a request initiation time for the specific estimate type ([GFE Packet](StructureDefinition-davinci-pct-gfe-packet.md) and [AEOB Packet](StructureDefinition-davinci-pct-aeob-packet.md)) and their referencing DocumentReference ([GFE Packet Document Reference](StructureDefinition-davinci-pct-gfe-documentreference.md) and [AEOB Packet Document Reference](StructureDefinition-davinci-pct-aeob-documentreference.md)) 
* [FHIR-51554](https://jira.hl7.org/browse/FHIR-51554) – Add request initiation time to GFE and AEOB Composition profiles ⚠️ **(Non-compatible change)**
* [FHIR-51553](https://jira.hl7.org/browse/FHIR-51553) – AEOB DocumentReference request initiation time does not make clear what "request" event it is for
 
* Restrict estimate document types from being changed in the estimate Packet Compositions and DocumentReferences ([GFE Composition](StructureDefinition-davinci-pct-gfe-composition.md) and [AEOB Composition](StructureDefinition-davinci-pct-aeob-composition.md)) and their referencing DocumentReference ([GFE Packet Document Reference](StructureDefinition-davinci-pct-gfe-documentreference.md) and [AEOB Packet Document Reference](StructureDefinition-davinci-pct-aeob-documentreference.md)) 
* [FHIR-49640](https://jira.hl7.org/browse/FHIR-49640) – Require that the Document type cannot be changed to or from the type code provided ⚠️ **(Non-compatible change)**
 

#### Searching and Subscriptions

* Add searching capabilities for the estimate documents from patients and providers by creating searchable DocumentReference profiles ([GFE Packet Document Reference](StructureDefinition-davinci-pct-gfe-documentreference.md) and [AEOB Packet Document Reference](StructureDefinition-davinci-pct-aeob-documentreference.md)) that contain or reference document bundles ([GFE Packet](StructureDefinition-davinci-pct-gfe-packet.md) and [AEOB Packet](StructureDefinition-davinci-pct-aeob-packet.md)). And added [Search parameters](artifacts.md#3) 
* [FHIR-45936](https://jira.hl7.org/browse/FHIR-45936) – why are is the patient system polling
* [FHIR-36316](https://jira.hl7.org/browse/FHIR-36316) – Please add subscriptions in addition to polling…
* [FHIR-45939](https://jira.hl7.org/browse/FHIR-45939) – why polling?
* [FHIR-45935](https://jira.hl7.org/browse/FHIR-45935) – why is the patient having to make the request
* [FHIR-51901](https://jira.hl7.org/browse/FHIR-51901) – Correct Search Parameter expressions and update to reflect other changes ⚠️ **(Non-compatible change)**
 
* Added estimate availability [subscription capabilities](artifacts.md#7) for patients and providers 
* [FHIR-45738](https://jira.hl7.org/browse/FHIR-45738) – Consider referencing the Da Vinci Notifications IG
 
* Added coordination task update subscriptions [subscription capabilities](artifacts.md#7) for coordination requester and coordination contributors 
* [FHIR-45894](https://jira.hl7.org/browse/FHIR-45894) – Consider adding more guidance on Coordination workflow notifications
 

#### Patient Access

* Added guidance detailing patient access and subscriptions to estimates that includes [Search parameters](artifacts.md#3) and [subscription capabilities](artifacts.md#7) 
* [FHIR-45380](https://jira.hl7.org/browse/FHIR-45380) – Clarify means of sending AEOB to patient
* [FHIR-51543](https://jira.hl7.org/browse/FHIR-51543) – Narrative Improvement Needed for Patient Access systems
* [FHIR-44862](https://jira.hl7.org/browse/FHIR-44862) – Add ability for patient to receive GFEs in the event the payer cannot provide an AEOB
* [FHIR-45933](https://jira.hl7.org/browse/FHIR-45933) – Missing bundle resources question
 

#### Coordination Workflow and Tasks

* Update the gfe-retrieve operation to only support `completed` [GFE Contributor Task](StructureDefinition-davinci-pct-gfe-contributor-task.md) 
* [FHIR-48781](https://jira.hl7.org/browse/FHIR-48781) – Change the gfe-retrieve operation to only include GFE Bundles attached to GFE Contributor tasks that have a status of completed ⚠️ **(Non-compatible change)**
 
* Add ability to attach input and output parameters to the associated tasks 
* [FHIR-45806](https://jira.hl7.org/browse/FHIR-45806) – Add Task.input and Task.output constraints ⚠️ **(Non-compatible change)**
* [FHIR-45859](https://jira.hl7.org/browse/FHIR-45859) – Question re Task Status ⚠️ **(Non-compatible change)**
* [FHIR-45823](https://jira.hl7.org/browse/FHIR-45823) – Change the automated status update requirement for the Contributor task ⚠️ **(Non-compatible change)**
 
* Added a means to link associated tasks 
* [FHIR-46352](https://jira.hl7.org/browse/FHIR-46352) – Add a way to link previously related GFE Coordination Request Tasks
 
* Updates to [Coordination Task](StructureDefinition-davinci-pct-gfe-coordination-task.md)s will update associated [Contributor Task](StructureDefinition-davinci-pct-gfe-contributor-task.md). 
* [FHIR-45823](https://jira.hl7.org/browse/FHIR-45823) – Change the automated status update requirement for the Contributor task ⚠️ **(Non-compatible change)**
 
* Updated [Actor based access](gfe_coordination_specification.md#actor-based-access) 
* [FHIR-45943](https://jira.hl7.org/browse/FHIR-45943) – Can a contributor read after completion?
 
* Added several non-substantive capabilities to the [GFE Coordination Workflow](gfe_coordination_overview.md) 
* [FHIR-45895](https://jira.hl7.org/browse/FHIR-45895) – Add more guidance about out of band activities for the Coordination Workflow
 
* Add guidance in the [workflow at a glance](gfe_coordination_overview.md#workflow-at-a-glance) that a GFE requestor that also need to provide a GFE will act as a GFE Contributor 
* [FHIR-45735](https://jira.hl7.org/browse/FHIR-45735) – GFE Coordination Requesters GFE getting to Coordination platform
 
* Added guidance to the [GFE Overview](gfe_coordination_overview.md#workflow-at-a-glance) and [GFE Specification](gfe_coordination_specification.md#gfe-contributor-actions) pages that a Task should not be rejected if more information is required 
* [FHIR-45893](https://jira.hl7.org/browse/FHIR-45893) – Add Guidance stating that a contributor task should not be rejected if more info is required
 
* Added guidance for cancelling and [replacing of GFE contributor tasks](gfe_coordination_specification.md#replacing-a-gfe-contributor-task) 
* [FHIR-45858](https://jira.hl7.org/browse/FHIR-45858) – Coordinating Requestor Capabilities to Amend Tasks
* [FHIR-45892](https://jira.hl7.org/browse/FHIR-45892) – Add guidance regarding the updating of tasks
* [FHIR-45857](https://jira.hl7.org/browse/FHIR-45857) – GFE Coordinator Capabilities
 
* Add guidance to [Full GFE Coordination: End-to-End Workflow](gfe_coordination_overview.md#full-gfe-coordination-end-to-end-workflow) that if the contributor declines the task, `Task.status` shall be changed to rejected and the reason for the rejection should be placed in Task.statusReason. 
* [FHIR-45942](https://jira.hl7.org/browse/FHIR-45942) – is a rejection reason provided?
 

#### Coverage Related

* Updated the [PCT Coverage](StructureDefinition-davinci-pct-coverage.md) profile to enable the expression of self-pay or uninsured patient. 
* [FHIR-45855](https://jira.hl7.org/browse/FHIR-45855) – Create a self-pay/uninsured Coverage profile and make Coverage required for the information bundle ⚠️ **(Non-compatible change)**
* [FHIR-51648](https://jira.hl7.org/browse/FHIR-51648) – Create a single Coverage profile for both insured and self/pay/uninsured ⚠️ **(Non-compatible change)**
* [FHIR-49752](https://jira.hl7.org/browse/FHIR-49752) – Coverage extension for kind valueset is not showing
 
* Removed duplicative requirement for multiple references to the payer organization (removed Claim.insurer reference in the [Good Faith Estimate Professional](StructureDefinition-davinci-pct-gfe-professional.md) and [Good Faith Estimate Institutional](StructureDefinition-davinci-pct-gfe-institutional.md) profiles. 
* [FHIR-51649](https://jira.hl7.org/browse/FHIR-51649) – Remove Duplicative Insurer requirement from GFE (keep Coverage payer)
 

#### Moved several CodeSystems and ValueSets to the HL7 Terminology IG.

* Moved the CodeSystem PCTSubjectToMedicalMgmtReasonCS to the THO [Medical Management Type](http://terminology.hl7.org/6.5.0/CodeSystem-medical-management-type.html) 
* [FHIR-35549](https://jira.hl7.org/browse/FHIR-35549) – Defining URL should be anchored in THO not hl7.org/fhir.13
 
* Moved the CodeSystem and ValueSet PCTDiagnosisType to the THO [Diagnosis Type CodeSystem](http://terminology.hl7.org/6.5.0/CodeSystem-diagnosistype.html) and [Diagnosis Type ValueSet](http://terminology.hl7.org/6.5.0/ValueSet-diagnosistype.html) 
* [FHIR-35540](https://jira.hl7.org/browse/FHIR-3554) – Defining URL should be anchored in THO not hl7.org/fhir.4 for CodeSystem-PCTDiagnosisType.html ⚠️ **(Non-compatible change)**
 
* Removed the PCTOrgIdentifierCS from the IG and added codes to the to [THO identifierType CodeSystem](http://terminology.hl7.org/6.5.0/CodeSystem-v2-0203.html) 
* [FHIR-35545](https://jira.hl7.org/browse/FHIR-35545) – Defining URL should be anchored in THO not hl7.org/fhir.9 for CodeSystem-PCTOrgIdentifierTypeCS.html ⚠️ **(Non-compatible change)**
* [FHIR-51601](https://jira.hl7.org/browse/FHIR-51601) – Remove the PCTIdentifierType Code system and move to THO ⚠️ **(Non-compatible change)**
* [FHIR-45860](https://jira.hl7.org/browse/FHIR-45860) – Add a means to identify bundle purpose ⚠️ **(Non-compatible change)**
* [FHIR-51075](https://jira.hl7.org/browse/FHIR-51075) – Remove INTER identifier type code from the PCT IG ⚠️ **(Non-compatible change)**
 
* Removed the Codesystem PCTCareTeamRole and adopted the codes in [Claim Care Team Role Codes](http://terminology.hl7.org/6.5.0/CodeSystem-claimcareteamrole.html) 
* [FHIR-35538](https://jira.hl7.org/browse/FHIR-35538) – Defining URL should be anchored in THO not hl7.org/fhir.2 for CodeSystem-PCTCareTeamRole.html ⚠️ **(Non-compatible change)**
 
* Remove the PCTAEOBTypeVS ValueSet and change binding of [PCT Advanced EOB](StructureDefinition-davinci-pct-aeob.md) `ExplanationOfBenefit.type` to [THO Claim Type Codes](http://terminology.hl7.org/6.5.0/ValueSet-claim-type.html) 
* [FHIR-45819](https://jira.hl7.org/browse/FHIR-45819) – Consider anchoring the valuesets in THO (terminology.hl7.org). 3
 

#### Support US Core 7.0.0 and 6.1.0

* Added support and alignment to use Core 7.0.0 and US Core 6.1.0 
* [FHIR-45836](https://jira.hl7.org/browse/FHIR-45836) – Add support for US Core 6.1 ⚠️ **(Non-compatible change)**
* [FHIR-46187](https://jira.hl7.org/browse/FHIR-46187) – NAIC Code Number Identifier system not registered in THO ⚠️ **(Non-compatible change)**
* [FHIR-36638](https://jira.hl7.org/browse/FHIR-36638) – Patient Profile state can either be US state or out of US subdivision code. 
* Changed to US Core profile and removed the extension
 
 

#### Updates to Estimate Element Requirements and Guidance

* Add an additional Process Note Class of `conditional` to the code system and value set to the [Process Note Class Extension](StructureDefinition-processNoteClass.md) valueCodeableConcept binding 
* [FHIR-46228](https://jira.hl7.org/browse/FHIR-46228) – How should we represent the conditional aspects of an estimate?
 
* Add requirement for [PCT Advanced EOB](StructureDefinition-davinci-pct-aeob.md) `ExplanationOfBenefit.benefitBalance.category.text` as MS 
* [FHIR-42828](https://jira.hl7.org/browse/FHIR-42828) – Add requirement for EoB.benefitBalance Category text ⚠️ **(Non-compatible change)**
 
* Add the [Remaining Benefit Extension](StructureDefinition-remaining-benefit.md) to the [Advanced EOB Summary](StructureDefinition-davinci-pct-aeob-summary.md) profile 
* [FHIR-50082](https://jira.hl7.org/browse/FHIR-50082) – Add remaining extension to Summary ExplanationOfBenefit.benefitBalance.financial
 
* Added guidance to several entries to the [Advanced EOB Notes on Fields](StructureDefinition-davinci-pct-aeob.md#notes-on-fields) and [Summary Advanced EOB Notes on Fields](StructureDefinition-davinci-pct-aeob-summary.md#notes-on-fields)to improve guidance for elements 
* [FHIR-51541](https://jira.hl7.org/browse/FHIR-51541) – Review bullet on AEOB Profile: Notes on Fields: .total.amount
* [FHIR-42706](https://jira.hl7.org/browse/FHIR-42706) – Add description for benefit balance
* [FHIR-38769](https://jira.hl7.org/browse/FHIR-38769) – Add Operational requirement that there is a 1 to 1 relationship between a GFE and an AEOB
* [FHIR-51619](https://jira.hl7.org/browse/FHIR-51619) – Add Notes to AEOB Summary Profile regarding Totals
* [FHIR-46227](https://jira.hl7.org/browse/FHIR-46227) – Add guidance for AEOBs with examples for Prior Auth, Out of Network,
 
* Added the ability to indicate an estimate request is for a scheduled or non-scheduled service and the time of the request to the [GFE Composition](StructureDefinition-davinci-pct-gfe-composition.md) 
* [FHIR-45759](https://jira.hl7.org/browse/FHIR-45759) – Add 'shopping vs scheduled service' flag ⚠️ **(Non-compatible change)**
 
* Update the [GFE Service Linking Information Extension](StructureDefinition-gfeServiceLinkingInfo.md) to address several needs for linking separately submitted GFEs 
* [FHIR-34959](https://jira.hl7.org/browse/FHIR-34959) – gfeServiceLinkingInfo Comments ⚠️ **(Non-compatible change)**
 
* Require member liability and eligible slices to the `ExplanationOfBenefit.total` element in the [Advanced EOB](StructureDefinition-davinci-pct-aeob.md) and [Advanced EOB Summary](StructureDefinition-davinci-pct-aeob-summary.md) profiles. 
* [FHIR-51542](https://jira.hl7.org/browse/FHIR-51542) – Require Total Member Liability and Total Eligible on the AEOB Summary ⚠️ **(Non-compatible change)**
 
* Require [CPT Consumer Friendly Descriptor](https://www.ama-assn.org/health-care-advocacy/advocating-public-health/cpt-descriptors-comply-transparency-rule-health-plans) in the [Good Faith Estimate Institutional](StructureDefinition-davinci-pct-gfe-institutional.md), [Good Faith Estimate Professional](StructureDefinition-davinci-pct-gfe-professional.md), and [Advanced EOB](StructureDefinition-davinci-pct-aeob.md) profiles where a CPT code is used. 
* [FHIR-45909](https://jira.hl7.org/browse/FHIR-45909) – require use of CPT friendly descriptors ⚠️ **(Non-compatible change)**
 
* Removed the CountrySubdivisionCode From the [PCT Organization](StructureDefinition-davinci-pct-organization.md) `address` element. 
* [FHIR-51747](https://jira.hl7.org/browse/FHIR-51747) – Remove CountrySubdivisionCode extension ⚠️ **(Non-compatible change)**
 
* Change Claim Frequency code binding from an IG defined CodeSystem to the [NUBC Uniform Billing Type ValueSet](ValueSet-PCTGFETypeOfBillVS.md) in the [Good Faith Estimate Professional](StructureDefinition-davinci-pct-gfe-professional.md) profile 
* [FHIR-51072](https://jira.hl7.org/browse/FHIR-51072) – Remove Claim Frequency Supporting Info slice from Professional GFE Profile ⚠️ **(Non-compatible change)**
 
* Remove the requirement to always include the diagnosis code in the [Good Faith Estimate Professional](StructureDefinition-davinci-pct-gfe-professional.md) profile. 
* [FHIR-45178](https://jira.hl7.org/browse/FHIR-45178) – Diagnosis is required but not always known
* [FHIR-46091](https://jira.hl7.org/browse/FHIR-46091) – Add guidance regarding the inclusion of Diagnosis codes in GFEs
 
* Removed NPI as an identifier type in [PCT Organization](StructureDefinition-davinci-pct-organization.md) and [PCT Practitioner](StructureDefinition-davinci-pct-practitioner.md) 
* [FHIR-50457](https://jira.hl7.org/browse/FHIR-50457) – NPI isn't a valid identifier type ⚠️ **(Non-compatible change)**
 
* Updated the description for the [Advanced EOB](StructureDefinition-davinci-pct-aeob.md) and [Advanced EOB Summary](StructureDefinition-davinci-pct-aeob-summary.md) profiles `ExplanationOfBenefit.total:negotiated` 
* [FHIR-51544](https://jira.hl7.org/browse/FHIR-51544) – Update definition for the ExplanationOfBenefit.total:negotiated
 
* Added guidance to the estimation Profiles ([Good Faith Estimate Institutional](StructureDefinition-davinci-pct-gfe-institutional.md), [Good Faith Estimate Professional](StructureDefinition-davinci-pct-gfe-professional.md), and [GFE Summary](StructureDefinition-davinci-pct-gfe-summary.md), [Advanced EOB](StructureDefinition-davinci-pct-aeob.md) and [Advanced EOB Summary](StructureDefinition-davinci-pct-aeob-summary.md) ) for including additional information for medical management 
* [FHIR-45862](https://jira.hl7.org/browse/FHIR-45862) – Add guidance about where to place medical management/prior auth and other contextual info
 

#### Updates to Request and Submission Workflow and Operations

* Create a [gfe-coordination-request operation](/OperationDefinition-GFE-coordination-request.md) 
* [FHIR-45737](https://jira.hl7.org/browse/FHIR-45737) – May support individual resource posting seems incongruent with SHOULD statement for Requestor ⚠️ **(Non-compatible change)**
 
* Updates to the GFE Submission workflow to allow for early error response in the [Full GFE Coordination: End-to-End Workflow](gfe_coordination_overview.md#full-gfe-coordination-end-to-end-workflow) and [AEOB Response](gfe_submission_and_aeob_specification.md#aeob-response) 
* [FHIR-49778](https://jira.hl7.org/browse/FHIR-49778) – Update gfe-submit operation workflow to support providing error status as early in the process as possible ⚠️ **(Non-compatible change)**
* [FHIR-45856](https://jira.hl7.org/browse/FHIR-45856) – Error Messages
* [FHIR-45938](https://jira.hl7.org/browse/FHIR-45938) – work quetsion regarding AEOB with errors
* [FHIR-45937](https://jira.hl7.org/browse/FHIR-45937) – Error information should be actionable
 
* Added guidance that the AEOB should be made available to the submitting provider 
* [FHIR-45901](https://jira.hl7.org/browse/FHIR-45901) – require that the AEOB be returned to the provider
 
* Note that the Coordination Workflow is an option, not a requirement, for submission of the GFE Packet in the [Overview](index.md#overview) and [GFE Submit Workflow](index.md#gfe-submit-workflow) sections of the index page and [Business Actors of the Use Cases page](use_cases.md#business-actors) 
* [FHIR-45928](https://jira.hl7.org/browse/FHIR-45928) – Do not presume convening provider model for insured patients
* [FHIR-45853](https://jira.hl7.org/browse/FHIR-45853) – Purpose of IG
* [FHIR-45851](https://jira.hl7.org/browse/FHIR-45851) – Clarification regarding convening provider
* [FHIR-45854](https://jira.hl7.org/browse/FHIR-45854) – Issue with information flow between business actors
 
* Change the GFE Task operation to be resource ID based 
* [FHIR-48357](https://jira.hl7.org/browse/FHIR-48357) – Change Retrieve GFE Collection Bundle Operation from a global operation to a Task instance operation ⚠️ **(Non-compatible change)**
 
* Update to the correct term (GFE Packet and GFE Bundle) in numerous places in the IG 
* [FHIR-45381](https://jira.hl7.org/browse/FHIR-45381) - Some instances of bundle should be collection bundle
 

#### General Narrative Requirements and Guidance for Submissions to Payers

* Added guidance on addressing submissions that relate to a previous submission. 
* [FHIR-51746](https://jira.hl7.org/browse/FHIR-51746) – Add Guidance to the AEOB request for a relatesTo document that has already been processed.
 
* Added requirements and guidance for collation of multiple GFE Bundles 
* [FHIR-51078](https://jira.hl7.org/browse/FHIR-51078) – Add more narrative guidance on the two means to collate GFE Bundles ⚠️ **(Non-compatible change)**
 

#### Updates to the CapabilityStatements

* Updated the [Coordination Platform CapabilityStatement](CapabilityStatement-davinci-pct-coordination-platform.md), [Coordination Requester CapabilityStatement](CapabilityStatement-davinci-pct-coordination-requester.md), [GFE Provider CapabilityStatement](CapabilityStatement-davinci-pct-gfe-provider.md), and [Payer CapabilityStatement](CapabilityStatement-davinci-pct.md) 
* [FHIR-51684](https://jira.hl7.org/browse/FHIR-51684) – Add CapabilityStatements & requirements for the GFE & AEOB DocumentReference profiles, searching, and notification ⚠️ **(Non-compatible change)**
* [FHIR-52528](https://jira.hl7.org/browse/FHIR-52528) - Add CapabilityStatement requirements for providers that create GFEs for patients
 
* Add a requirement in the [Formal Specifications page CapabilityStatement Requirements](formal_specification.md#capabilitystatement-requirements) that servers conforming to the IG indicate the the version (e.g. STU1 or STU2) of the profile being supporting in `CapabilityStatement.instantiates` 
* [FHIR-45861](https://jira.hl7.org/browse/FHIR-45861) – Add guidance for implementers to detect the difference between STU1 and STU2 usage ⚠️ **(Non-compatible change)**
 

#### Other Changes

* Added a Section [About Data Retention and Access](formal_specification.md#ongoing-data-retention-and-access) 
* [FHIR-45941](https://jira.hl7.org/browse/FHIR-45941) – Coordination Platform question
 
* Create a means to better distinguish Bundles 
* [FHIR-45860](https://jira.hl7.org/browse/FHIR-45860) – Add a means to identify bundle purpose ⚠️ **(Non-compatible change)**
 
* Remove the unused PCT Endpoint extension 
* [FHIR-51692](https://jira.hl7.org/browse/FHIR-51692) – Remove the orphaned PCTEndpoint extension ⚠️ **(Non-compatible change)**
 
* Clarified the relation of the role of the convening and submitting providers 
* [FHIR-45852](https://jira.hl7.org/browse/FHIR-45852) – Misapplication of convening provider requirement
 
* Removed term definition for terms already defined in CodeSystem from the [Terms and Concepts section](index.md#terms-and-concepts) 
* [FHIR-45373](https://jira.hl7.org/browse/FHIR-45373) – Glossary could include a few related terms
 
* Added requirements and guidance for adjudication 
* [FHIR-45377](https://jira.hl7.org/browse/FHIR-45377) – Clarify scope of adjudication
 

### High Level Changes 2.0.0-ballot

This ballot version includes a new use case addressing the need to coordinate GFE collection among providers and makes some modifications to the existing GFE Submit workflow:

* Added the GFE Coordination Workflow [Overview](gfe_coordination_overview.md) and [Specification](gfe_coordination_specification.md) pages.
* Created the following profiles in support of the GFE Collection workflow: 
* [GFE Collection Bundle](https://hl7.org/fhir/us/davinci-pct/2024May/StructureDefinition-davinci-pct-gfe-collection-bundle.html) - This collection of GFE Bundles from GFE contributors that can then be made available to the patient or sent to a payer for insurance estimation.
* [GFE Coordination Bundle](https://hl7.org/fhir/us/davinci-pct/2024May/StructureDefinition-davinci-pct-gfe-coordination-bundle.html) - Contains necessary resources for GFE to request GFEs from one or multiple GFE contributing providers.
* [GFE Coordination Task](https://hl7.org/fhir/us/davinci-pct/2024May/StructureDefinition-davinci-pct-gfe-coordination-task.html) - Used to organize a GFE across providers for a single period of care for which all GFE Contributor Task resources will be linked.
* [GFE Contributor Task](https://hl7.org/fhir/us/davinci-pct/2024May/StructureDefinition-davinci-pct-gfe-contributor-task.html) - Used by a GFE coordinator to assign a GFE contributor task to a specific provider and may include information specific to that patient’s expected service.
* [GFE Information Bundle](https://hl7.org/fhir/us/davinci-pct/2024May/StructureDefinition-davinci-pct-gfe-information-bundle.html) - Contains the information necessary for GFE contributors to create their estimates.
* [GFE Missing Bundle](https://hl7.org/fhir/us/davinci-pct/2024May/StructureDefinition-davinci-pct-gfe-missing-bundle.html) - Used to indicate when a GFE Contributor task request was made, but no GFE Bundle was submitted.
* [GFE ServiceRequest](https://hl7.org/fhir/us/davinci-pct/2024May/StructureDefinition-davinci-pct-servicerequest.html) - Includes details about a service for which a GFE is being requested.
* [GFE MedicationRequest](https://hl7.org/fhir/us/davinci-pct/2024May/StructureDefinition-davinci-pct-medicationrequest.html) - Includes details about a medication for which a GFE is being requested.
* [GFE DeviceRequest](https://hl7.org/fhir/us/davinci-pct/2024May/StructureDefinition-davinci-pct-devicerequest.html) - Includes details about a device for which a GFE is being requested.
* [PCT Service Location](https://hl7.org/fhir/us/davinci-pct/2024May/StructureDefinition-davinci-pct-service-location.html) - Provides information where the service is to be performed or the item delivered.
 
* Created the following CapabilityStatements identifying requirements of the GFE Coordination workflow actors: 
* [Coordination Platform Capability Statement](https://hl7.org/fhir/us/davinci-pct/2024May/CapabilityStatement-davinci-pct-coordination-platform.html)
* [Coordination Requester Capability Statement](https://hl7.org/fhir/us/davinci-pct/2024May/CapabilityStatement-davinci-pct-coordination-requester.html)
* [GFE Contributor Capability Statement](https://hl7.org/fhir/us/davinci-pct/2024May/CapabilityStatement-davinci-pct-gfe-contributor.html)
 
* Created CodeSystems and ValueSets in support of the GFE Coordination workflow
* Created the [Retrieve GFE Collection Bundle (GFE-Retrieve) operation](https://hl7.org/fhir/us/davinci-pct/2024May/OperationDefinition-GFE-retrieve.html) to support the collection of GFE Bundles contributed through the GFE Coordination workflow.
* Updated the [GFE Submit](https://hl7.org/fhir/us/davinci-pct/2024May/OperationDefinition-GFE-submit.html) operation to take a [GFE Collection Bundle](https://hl7.org/fhir/us/davinci-pct/2024May/StructureDefinition-davinci-pct-gfe-collection-bundle.html) instead of the [GFE Bundle](https://hl7.org/fhir/us/davinci-pct/2024May/StructureDefinition-davinci-pct-gfe-bundle.html) (which is now contained in the GFE Collection Bundle)
* Added the [AEOB Summary](https://hl7.org/fhir/us/davinci-pct/2024May/StructureDefinition-davinci-pct-aeob-summary.html) and [GFE Summary](https://hl7.org/fhir/us/davinci-pct/2024May/StructureDefinition-davinci-pct-gfe-summary.html) profiles and requirements for their presence in the [AEOB Bundle](https://hl7.org/fhir/us/davinci-pct/2024May/StructureDefinition-davinci-pct-aeob-bundle.html) and [GFE Bundle](https://hl7.org/fhir/us/davinci-pct/2024May/StructureDefinition-davinci-pct-gfe-bundle.html) respectively
* Assign a standard status to all artifacts and pages.
* Small presentation and example changes.

#### Detailed Changes 2.0.0-ballot (JIRA Change Requests)

| | | |
| :--- | :--- | :--- |
| [FHIR-42832](https://jira.hl7.org/browse/FHIR-42832) | Persuasive with Modification | Add slices to the Advanced ExplanationOfBenefit total |
| [FHIR-42707](https://jira.hl7.org/browse/FHIR-42707) | Persuasive with Modification | GFE submit operation should describe the wrapping batch-response bundle |
| [FHIR-42785](https://jira.hl7.org/browse/FHIR-42785) | Persuasive with Modification | Add "negotiated" code to Network status CodeSystem and adjudication and item.adjudication bound ValueSet |
| [FHIR-43705](https://jira.hl7.org/browse/FHIR-43705) | Persuasive | Improve description of OperationOutcome OUT param in $gfe-submit |
| [FHIR-44952](https://jira.hl7.org/browse/FHIR-44952) | Persuasive | Relax insurance/coverage requirements on GFE Bundle and GFE claim profiles |
| [FHIR-44955](https://jira.hl7.org/browse/FHIR-44955) | Persuasive | Add CDT codes to GFE Claim codes ValueSet bindings |
| [FHIR-44971](https://jira.hl7.org/browse/FHIR-44971) | Persuasive | Create an operation to retrieve a GFE Collection Bundle for a task |
| [FHIR-44993](https://jira.hl7.org/browse/FHIR-44993) | Persuasive | Create CapabilityStatements for GFE Request workflow |
| [FHIR-45001](https://jira.hl7.org/browse/FHIR-45001) | Persuasive | Pre-adopt Coverage.kind into PCT Coverage profile and add declaration |
| [FHIR-45037](https://jira.hl7.org/browse/FHIR-45037) | Persuasive | Add proposed service location to GFE information request bundle |
| [FHIR-45053](https://jira.hl7.org/browse/FHIR-45053) | Persuasive | Remove GFE Submitter from Claim resource Profiles |
| [FHIR-45055](https://jira.hl7.org/browse/FHIR-45055) | Persuasive with Modification | Add a GFE Coordination Workflow to the IG |
| [FHIR-45151](https://jira.hl7.org/browse/FHIR-45151) | Persuasive | Add an STU note on all draft pages (narrative & profile) about it being draft |
| [FHIR-45152](https://jira.hl7.org/browse/FHIR-45152) | Persuasive | Change the home page STU Note text |
| [FHIR-44951](https://jira.hl7.org/browse/FHIR-44951) | Not Persuasive with Modification | Change the GFE Bundle to be contributor specific and add a GFE Collection Bundle |
| [FHIR-45054](https://jira.hl7.org/browse/FHIR-45054) | Persuasive with Modification | Create a GFE Coordination Bundle for submitting a GFE Coordination request |
| [FHIR-45061](https://jira.hl7.org/browse/FHIR-45061) | Persuasive | Section 3.3 US Core currently resolves to US Core 6.1 in two places. It should actually NOT point to US Core 6.1.0, but US Core 3.1.1 |
| [FHIR-45060](https://jira.hl7.org/browse/FHIR-45060) | Persuasive | The header for section 3.2.1 reads FHIR Version, but the link reads FHIR R4 US Core and points to US Core 6.1 instead of the FHIR R4 Specification. |
| [FHIR-43329](https://jira.hl7.org/browse/FHIR-43329) | Persuasive | Correct Example fullURL to use the right resource base |
| [FHIR-44859](https://jira.hl7.org/browse/FHIR-44859) | Persuasive | Correct the spelling of the word definition |
| [FHIR-44691](https://jira.hl7.org/browse/FHIR-44691) | Persuasive | Correct typo in index page regarding future IG |
| [FHIR-44970](https://jira.hl7.org/browse/FHIR-44970) | Persuasive | Add a GFE Request Information Bundle and related profiles |
| [FHIR-44954](https://jira.hl7.org/browse/FHIR-44954) | Persuasive | Create Coordinating Request Task and Contributing Provider Request Task Profiles |
| [FHIR-44778](https://jira.hl7.org/browse/FHIR-44778) | Persuasive | Create an GFE Summary Profile to add to the GFE Bundle |
| [FHIR-42827](https://jira.hl7.org/browse/FHIR-42827) | Persuasive | Create an AEOB Summary Profile to add to the AEOB Bundle |
| [FHIR-43330](https://jira.hl7.org/browse/FHIR-43330) | Persuasive with Modification | Correct invariant expressions where a coding is checked |

### High Level Changes 1.1.0

This STU Update includes a number of changes addressing some critical and minor fixes including:

* Set max occurrences for slice discriminator element 'type' to one of the Good Faith Estimate profiles.
* Corrected [Advanced Explanation Of Benefit Profile](https://hl7.org/fhir/us/davinci-pct/STU1.1/StructureDefinition-davinci-pct-aeob.html) benefit payment status and adjustment reason adjudication slices to the correct Value Set binding.
* Corrected [Advanced Explanation Of Benefit Profile](https://hl7.org/fhir/us/davinci-pct/STU1.1/StructureDefinition-davinci-pct-aeob.html) benefitBalance.financial element types and added remaining amount extension.
* Corrected numerous FHIRPath expressions for SearchParameter and Invariants.
* Assign context to all of the extensions
* Small presentation and example changes.

#### Detailed Changes 1.1.0 (JIRA Change Requests)

| | | |
| :--- | :--- | :--- |
| [FHIR-40526](https://jira.hl7.org/browse/FHIR-40526) | Accepted Technical Correction | Fixed Value CodeableConcept discriminator elements should have a max Cardinality of 1 |
| [FHIR-40812](https://jira.hl7.org/browse/FHIR-40812) | Persuasive | Change AEOB adjudication[adjustmentreason] binding to adjustment reason codes |
| [FHIR-42786](https://jira.hl7.org/browse/FHIR-42786) | Persuasive with Modification | Correct Adjudication reason ValueSet binding for network status adjudication category slices |
| [FHIR-41490](https://jira.hl7.org/browse/FHIR-41490) | Accepted Technical Correction | Update link for Asynchronous Interaction Request Pattern to point to R5 instead of CI |
| [FHIR-42825](https://jira.hl7.org/browse/FHIR-42825) | Persuasive with Modification | Add extension for benefit balance remaining amount |
| [FHIR-42910](https://jira.hl7.org/browse/FHIR-42910) | Persuasive | Change constraint in ExplanationOfBenefit.benefitBalance.financial allowed[x] and used[x] |
| [FHIR-43065](https://jira.hl7.org/browse/FHIR-43065) | Accepted Technical Correction | Correct Date Of Service SearchParameter expression |
| [FHIR-43111](https://jira.hl7.org/browse/FHIR-43111) | Persuasive | Correct Invariant issues identified in the IG Publisher |
| [FHIR-43077](https://jira.hl7.org/browse/FHIR-43077) | Persuasive | Assign context to all of the extensions |
| [FHIR-43330](https://jira.hl7.org/browse/FHIR-43330) | Persuasive with Modification | Assign context to all of the extensions |
| [FHIR-43329](https://jira.hl7.org/browse/FHIR-43329) | Persuasive | Correct Example fullURL to use the right resource base |

### High Level Changes 1.0.0

There were many changes to all the profiles, value sets, etc. since the last ballot. The details are listed in the section below. High level changes since the ballot are:

* The polling mechanism changed form polling based on Bundle.identifier to using the [asynchronous response pattern](http://build.fhir.org/async-bundle.html).
* Updated workflow diagrams on the [Use Cases](https://hl7.org/fhir/us/davinci-pct/STU1.1/use_cases.html) page.
* Most code systems have been moved to the [HL7 terminology](https://terminology.hl7.org/) page, and their code system URLs changed as a result.
* Harmonized with CARIN blue button EOB where possible to reduce implementation barriers
* Added Must Support definition, and updated elements to align with MS definition, and removed MS from elements where the minimum cardinality is 1 since these are required anyway
*  Updates to the AEOB profile to provide guidance and improve alignment with requirements for patient AEOBs including benefit period, benefit balance, adjudication and supporting info elements

#### Detailed Changes 1.0.0 (JIRA Change Requests)

| | | |
| :--- | :--- | :--- |
| [FHIR-35228](https://jira.hl7.org/browse/FHIR-35228) | Persuasive | PCT GFE Institutional .item, remove .item estimated DOS extension |
| [FHIR-34692](https://jira.hl7.org/browse/FHIR-34692) | Persuasive | Institutional profile - modify mapping of charge amount |
| [FHIR-34816](https://jira.hl7.org/browse/FHIR-34816) | Persuasive | Professional profile - modify mapping of charge amount |
| [FHIR-34928](https://jira.hl7.org/browse/FHIR-34928) | Persuasive with Modification | US Core Reference |
| [FHIR-34934](https://jira.hl7.org/browse/FHIR-34934) | Persuasive with Modification | Terms and concepts - Charge Master Description |
| [FHIR-34935](https://jira.hl7.org/browse/FHIR-34935) | Persuasive with Modification | Terms and concepts - Collection of Services |
| [FHIR-34938](https://jira.hl7.org/browse/FHIR-34938) | Persuasive | Systems Update |
| [FHIR-35207](https://jira.hl7.org/browse/FHIR-35207) | Persuasive with Modification | Disclaimer wording is awkward in MRI scenario |
| [FHIR-35234](https://jira.hl7.org/browse/FHIR-35234) | Persuasive | Remove section 4.4 Testing requirements |
| [FHIR-34925](https://jira.hl7.org/browse/FHIR-34925) | Persuasive | In the Coverage profile, remove Must Support from costToBeneficiary |
| [FHIR-34919](https://jira.hl7.org/browse/FHIR-34919) | Persuasive | Modify AEOB profile to add Practitioner |
| [FHIR-34915](https://jira.hl7.org/browse/FHIR-34915) | Persuasive with Modification | Require pattern for AEOB profile claim.use; add MS to claim.status |
| [FHIR-34904](https://jira.hl7.org/browse/FHIR-34904) | Persuasive | AEOB profile - remove expirationDate |
| [FHIR-34661](https://jira.hl7.org/browse/FHIR-34661) | Persuasive | Remove Must Support from Institutional.facility |
| [FHIR-34505](https://jira.hl7.org/browse/FHIR-34505) | Persuasive | Clarify wording for Claim Resource in GFE Bundle Resource |
| [FHIR-35236](https://jira.hl7.org/browse/FHIR-35236) | Persuasive | Remove inherited invariants from profile pages |
| [FHIR-34969](https://jira.hl7.org/browse/FHIR-34969) | Persuasive with Modification | stronger language in P&S section |
| [FHIR-34936](https://jira.hl7.org/browse/FHIR-34936) | Persuasive | Terms and concepts - De-identified Minimum Negotiated Rate |
| [FHIR-36025](https://jira.hl7.org/browse/FHIR-36025) | Persuasive | PCT AEOB Profile - Add PractitionerRole to provider |
| [FHIR-34933](https://jira.hl7.org/browse/FHIR-34933) | Persuasive | Terms and concepts updates - Consolidated Appropriations Act |
| [FHIR-34976](https://jira.hl7.org/browse/FHIR-34976) | Persuasive with Modification | change SHOULD to SHALL |
| [FHIR-34931](https://jira.hl7.org/browse/FHIR-34931) | Persuasive with Modification | Terms and concepts updates - Advanced EOB |
| [FHIR-34939](https://jira.hl7.org/browse/FHIR-34939) | Persuasive | Downloads |
| [FHIR-35230](https://jira.hl7.org/browse/FHIR-35230) | Persuasive | PCT GFE Professional - remove procedure:other slice |
| [FHIR-35274](https://jira.hl7.org/browse/FHIR-35274) | Persuasive | Security and Privacy section mentioning X12 |
| [FHIR-34791](https://jira.hl7.org/browse/FHIR-34791) | Persuasive with Modification | Require pattern for professional profile claim.use; add MS to claim.status |
| [FHIR-35357](https://jira.hl7.org/browse/FHIR-35357) | Persuasive | Move downloads to its own page with a menu link |
| [FHIR-35344](https://jira.hl7.org/browse/FHIR-35344) | Persuasive | Add link to GFE Submit operation in referenced Overview text |
| [FHIR-35340](https://jira.hl7.org/browse/FHIR-35340) | Persuasive | Include link to HRex IG in overview |
| [FHIR-35264](https://jira.hl7.org/browse/FHIR-35264) | Persuasive | Add link to GFE Submit operation |
| [FHIR-35266](https://jira.hl7.org/browse/FHIR-35266) | Persuasive | Define AEOB on first use on page |
| [FHIR-34927](https://jira.hl7.org/browse/FHIR-34927) | Persuasive with Modification | Update Example |
| [FHIR-35200](https://jira.hl7.org/browse/FHIR-35200) | Persuasive | All diagrams should have an identifier to make it easy to reference. |
| [FHIR-35170](https://jira.hl7.org/browse/FHIR-35170) | Persuasive with Modification | Add definition of GFE |
| [FHIR-34691](https://jira.hl7.org/browse/FHIR-34691) | Persuasive with Modification | Institutional profile - remove location extension |
| [FHIR-34995](https://jira.hl7.org/browse/FHIR-34995) | Persuasive | Clarify a single PCT GFE Bundle SHALL only contain gfe for a single patient |
| [FHIR-34942](https://jira.hl7.org/browse/FHIR-34942) | Persuasive | GFE Professional Claim .accident, constrain to locationAddress, add binding to country code |
| [FHIR-34941](https://jira.hl7.org/browse/FHIR-34941) | Persuasive | PCT GFE Institutional - .accident, constrain to locationAddress and add binding for country code |
| [FHIR-35102](https://jira.hl7.org/browse/FHIR-35102) | Persuasive with Modification | edit definition of Changemaster |
| [FHIR-34650](https://jira.hl7.org/browse/FHIR-34650) | Persuasive with Modification | Require pattern for institutional profile claim.use; add MS to claim.status |
| [FHIR-34980](https://jira.hl7.org/browse/FHIR-34980) | Persuasive | Patient Profile - remove employeeID |
| [FHIR-34794](https://jira.hl7.org/browse/FHIR-34794) | Persuasive with Modification | Define Servicing Facility reference resource as an organization, not a location |
| [FHIR-34984](https://jira.hl7.org/browse/FHIR-34984) | Persuasive with Modification | Remove PractitionerRole Profile |
| [FHIR-34906](https://jira.hl7.org/browse/FHIR-34906) | Persuasive with Modification | PCT GFE Institutional supportingInfo:typeOfBill .code |
| [FHIR-34983](https://jira.hl7.org/browse/FHIR-34983) | Persuasive | Remove the Location Profile |
| [FHIR-35147](https://jira.hl7.org/browse/FHIR-35147) | Persuasive | Remove Code Systems defined for testing purposes |
| [FHIR-36640](https://jira.hl7.org/browse/FHIR-36640) | Persuasive | Define Institutional Servicing Facility reference resource as an organization, not a location |
| [FHIR-35256](https://jira.hl7.org/browse/FHIR-35256) | Persuasive with Modification | More guidance is required for the AEOB Out of network provider info |
| [FHIR-35208](https://jira.hl7.org/browse/FHIR-35208) | Persuasive | Provide link to the CAA No Surprises legislation |
| [FHIR-35219](https://jira.hl7.org/browse/FHIR-35219) | Persuasive | PCT GFE Institutional - .careTeam:attending - PCT Practitioner only |
| [FHIR-34953](https://jira.hl7.org/browse/FHIR-34953) | Persuasive | Payer Intermediary and FHIR-X12 Translators |
| [FHIR-34787](https://jira.hl7.org/browse/FHIR-34787) | Persuasive | Move Security section to own page as a Menu item |
| [FHIR-34810](https://jira.hl7.org/browse/FHIR-34810) | Persuasive with Modification | Professional Profile: Difference between the Provider Event Methodology and the Provider GFE Grouper Methodology |
| [FHIR-34809](https://jira.hl7.org/browse/FHIR-34809) | Persuasive with Modification | Professional Profile - remove location extension |
| [FHIR-37632](https://jira.hl7.org/browse/FHIR-37632) | Not Persuasive with Modification | Make AEOB .benefitPeriod cardinality 1..1 |
| [FHIR-37636](https://jira.hl7.org/browse/FHIR-37636) | Persuasive | Add markdown datatype to disclaimer extension |
| [FHIR-36200](https://jira.hl7.org/browse/FHIR-36200) | Persuasive with Modification | AEOB - Add a String Element to contain the Description of the Provided Service |
| [FHIR-37625](https://jira.hl7.org/browse/FHIR-37625) | Persuasive with Modification | Change AEOB element short description and comments on ExplanationOfBenefit.created |
| [FHIR-34811](https://jira.hl7.org/browse/FHIR-34811) | Not Persuasive with Modification | Change GFE Billing Provider Line Item Control Number to item.sequence |
| [FHIR-34946](https://jira.hl7.org/browse/FHIR-34946) | Persuasive with Modification | use of the term "near real time" |
| [FHIR-35097](https://jira.hl7.org/browse/FHIR-35097) | Persuasive with Modification | Could payers reasonably produce an AEOB in 5 minutes? |
| [FHIR-34892](https://jira.hl7.org/browse/FHIR-34892) | Persuasive with Modification | Change terminology for 'Submitting Provider' to 'Convening Provider' |
| [FHIR-35233](https://jira.hl7.org/browse/FHIR-35233) | Persuasive | Fixed display values should not generally be required |
| [FHIR-35145](https://jira.hl7.org/browse/FHIR-35145) | Not Persuasive with Modification | Practitioner Profile - add NUCC Value Set to .qualification |
| [FHIR-34943](https://jira.hl7.org/browse/FHIR-34943) | Persuasive with Modification | Remove the Taxonomy extension from Organization |
| [FHIR-35262](https://jira.hl7.org/browse/FHIR-35262) | Persuasive | Change the use of payor to payer |
| [FHIR-35265](https://jira.hl7.org/browse/FHIR-35265) | Persuasive | Add EOB.use to explanation of predetermination |
| [FHIR-35268](https://jira.hl7.org/browse/FHIR-35268) | Persuasive | Correct wording on example regarding occurence of resource |
| [FHIR-36647](https://jira.hl7.org/browse/FHIR-36647) | Persuasive | Add missing '$' to FSH alias reference. |
| [FHIR-34956](https://jira.hl7.org/browse/FHIR-34956) | Not Persuasive with Modification | Out of Network Info |
| [FHIR-34792](https://jira.hl7.org/browse/FHIR-34792) | Persuasive | Modify .provider Reference Resource |
| [FHIR-34900](https://jira.hl7.org/browse/FHIR-34900) | Persuasive with Modification | PCT Practitioner - Add explicit identifier slice for Tax ID |
| [FHIR-35103](https://jira.hl7.org/browse/FHIR-35103) | Persuasive | rewrite in third person |
| [FHIR-35263](https://jira.hl7.org/browse/FHIR-35263) | Persuasive | Update the the finally published version of HRex |
| [FHIR-36198](https://jira.hl7.org/browse/FHIR-36198) | Persuasive | PCT Coverage - check to ensure is based on HRex - Missing Group Slice in IG |
| [FHIR-37653](https://jira.hl7.org/browse/FHIR-37653) | Persuasive | Align PCT Coverage with HRex 1.0.0 Coverage |
| [FHIR-35326](https://jira.hl7.org/browse/FHIR-35326) | Persuasive with Modification | Update Overview to better reflect the workflow |
| [FHIR-34951](https://jira.hl7.org/browse/FHIR-34951) | Persuasive with Modification | Stronger language as to why Provider SHOULD also receive AEOB |
| [FHIR-34954](https://jira.hl7.org/browse/FHIR-34954) | Persuasive with Modification | Overview Flow |
| [FHIR-34947](https://jira.hl7.org/browse/FHIR-34947) | Persuasive with Modification | should state the close relationship between GFEs/AEOBs and X12 claims/ERAs |
| [FHIR-35328](https://jira.hl7.org/browse/FHIR-35328) | Persuasive | Change overview language regarding X12 |
| [FHIR-35322](https://jira.hl7.org/browse/FHIR-35322) | Persuasive with Modification | Institutional profile - supportingInfo:typeOfBill update |
| [FHIR-35240](https://jira.hl7.org/browse/FHIR-35240) | Not Persuasive with Modification | Remove Organization.identfier ccn as MS element |
| [FHIR-34944](https://jira.hl7.org/browse/FHIR-34944) | Not Persuasive with Modification | In the Organization profile, update the ccn identifier description |
| [FHIR-34979](https://jira.hl7.org/browse/FHIR-34979) | Persuasive with Modification | Organization Profile - add payer id and NAIC identifiers |
| [FHIR-34937](https://jira.hl7.org/browse/FHIR-34937) | Persuasive | References to CAA |
| [FHIR-34924](https://jira.hl7.org/browse/FHIR-34924) | Persuasive with Modification | Reference to X12 |
| [FHIR-35104](https://jira.hl7.org/browse/FHIR-35104) | Persuasive with Modification | Advanced EOB Response to Provider(s) Must Be Optional |
| [FHIR-35056](https://jira.hl7.org/browse/FHIR-35056) | Not Persuasive with Modification | Revise PCT Organization Type Code System |
| [FHIR-34982](https://jira.hl7.org/browse/FHIR-34982) | Not Persuasive with Modification | Practitioner Profile - update the ccn identifier description |
| [FHIR-34922](https://jira.hl7.org/browse/FHIR-34922) | Persuasive | In the Coverage profile, define slices for .class |
| [FHIR-35014](https://jira.hl7.org/browse/FHIR-35014) | Persuasive with Modification | GFE Submitter Must be Uniform Across All GFEs within a Bundle |
| [FHIR-35379](https://jira.hl7.org/browse/FHIR-35379) | Persuasive | Add invariant requiring only a single GFE submitter |
| [FHIR-34687](https://jira.hl7.org/browse/FHIR-34687) | Not Persuasive with Modification | Institutional Profile - add estimated admission period |
| [FHIR-34666](https://jira.hl7.org/browse/FHIR-34666) | Persuasive with Modification | Define DRG as .supportingInfo on Institutional Profile |
| [FHIR-35330](https://jira.hl7.org/browse/FHIR-35330) | Persuasive | Correct overview wording using IG name |
| [FHIR-35202](https://jira.hl7.org/browse/FHIR-35202) | Persuasive | "Must Support" is not defined in this IG and it has to be since it is applied to several of the Resources |
| [FHIR-34945](https://jira.hl7.org/browse/FHIR-34945) | Persuasive with Modification | Organization Profile - delete tin identifier |
| [FHIR-38766](https://jira.hl7.org/browse/FHIR-38766) | Persuasive | Remove MS from AEOB.item.revenue |
| [FHIR-35237](https://jira.hl7.org/browse/FHIR-35237) | Persuasive | FHIR US Core 3.1 is required for providers/payers to support adjacent ONC/CMS regulation |
| [FHIR-38125](https://jira.hl7.org/browse/FHIR-38125) | Persuasive | Remove Must Support from PreAuthRef |
| [FHIR-35294](https://jira.hl7.org/browse/FHIR-35294) | Not Persuasive with Modification | Coverage Profile - modify .subscriber Reference resource |
| [FHIR-34990](https://jira.hl7.org/browse/FHIR-34990) | Not Persuasive with Modification | Define RelatedPerson Profile |
| [FHIR-35216](https://jira.hl7.org/browse/FHIR-35216) | Persuasive with Modification | AEOB Item links to GFE |
| [FHIR-34920](https://jira.hl7.org/browse/FHIR-34920) | Persuasive | On the AEOB profile, remove requirement for net; add requirement for adjudication |
| [FHIR-37934](https://jira.hl7.org/browse/FHIR-37934) | Persuasive | Make type of bill on institutional supportinginfo cardinality 1..1 |
| [FHIR-35108](https://jira.hl7.org/browse/FHIR-35108) | Persuasive with Modification | which x12 specifications? |
| [FHIR-36761](https://jira.hl7.org/browse/FHIR-36761) | Persuasive | Institutional GFE - Chg procedure:primary to procedure:principal, modify definition |
| [FHIR-35243](https://jira.hl7.org/browse/FHIR-35243) | Not Persuasive with Modification | Add relatedPerson to Subscriber reference types |
| [FHIR-35217](https://jira.hl7.org/browse/FHIR-35217) | Not Persuasive with Modification | Updating / Cancelling AEOB Request |
| [FHIR-37516](https://jira.hl7.org/browse/FHIR-37516) | Persuasive with Modification | Change careTeam:rendering slice on Institutional GFE to only be a Human (not Organization) |
| [FHIR-35095](https://jira.hl7.org/browse/FHIR-35095) | Persuasive | Utilize Distinct FHIR Profiles for Professional and Institutional Claims |
| [FHIR-38126](https://jira.hl7.org/browse/FHIR-38126) | Persuasive | Add Disclaimer extension to GFEs |
| [FHIR-34948](https://jira.hl7.org/browse/FHIR-34948) | Persuasive | Make a stronger case as to why FHIR is the best |
| [FHIR-35254](https://jira.hl7.org/browse/FHIR-35254) | Not Persuasive with Modification | compoundDrugLinkingNum needs more guidance |
| [FHIR-34905](https://jira.hl7.org/browse/FHIR-34905) | Persuasive with Modification | PCT GFE Professional - Create identifier slices rather than extensions |
| [FHIR-35246](https://jira.hl7.org/browse/FHIR-35246) | Persuasive with Modification | Create slices on identifier instead of creating extensions |
| [FHIR-35258](https://jira.hl7.org/browse/FHIR-35258) | Persuasive with Modification | Require type and subtype in AEOB |
| [FHIR-34903](https://jira.hl7.org/browse/FHIR-34903) | Persuasive with Modification | PCT GFE Institutional - Identifiers. Add slices to .identifier rather than creating extensions |
| [FHIR-35319](https://jira.hl7.org/browse/FHIR-35319) | Persuasive with Modification | Institutional Profile - define Point of Origin, Admission Type and Discharge Status |
| [FHIR-37720](https://jira.hl7.org/browse/FHIR-37720) | Persuasive with Modification | Add the extension gfeProviderAssignedIdentifier to the AEOB Profile. (at the header level) |
| [FHIR-34897](https://jira.hl7.org/browse/FHIR-34897) | Not Persuasive with Modification | PCT Practitioner - remove endpoint extension add slice on contact |
| [FHIR-36193](https://jira.hl7.org/browse/FHIR-36193) | Not Persuasive with Modification | Plan or Coverage Entity Name and GFE Plan or Coverage Payer Name appear to be the same |
| [FHIR-34901](https://jira.hl7.org/browse/FHIR-34901) | Persuasive with Modification | Institutional profile - define careTeamSequence |
| [FHIR-34955](https://jira.hl7.org/browse/FHIR-34955) | Persuasive with Modification | Network status in advanced EOB profile |
| [FHIR-35069](https://jira.hl7.org/browse/FHIR-35069) | Persuasive with Modification | Professional profile - update careTeam |
| [FHIR-35057](https://jira.hl7.org/browse/FHIR-35057) | Persuasive with Modification | Institutional profile - add diagnosis slice, add invariants |
| [FHIR-35249](https://jira.hl7.org/browse/FHIR-35249) | Persuasive with Modification | More clearly define the purpose and constraints of ProviderEventMethodology |
| [FHIR-35273](https://jira.hl7.org/browse/FHIR-35273) | Persuasive | Provide means to declare an in or out of network/coverage status for AEOB |
| [FHIR-35272](https://jira.hl7.org/browse/FHIR-35272) | Persuasive with Modification | Provide a means to specify a denial reason in AEOB |
| [FHIR-35222](https://jira.hl7.org/browse/FHIR-35222) | Persuasive with Modification | PCT GFE Institutional - Claim.CareTeam:operating - PCT Practitioner, fix NUCC |
| [FHIR-35261](https://jira.hl7.org/browse/FHIR-35261) | Persuasive | Make Conformance statement verbs in bold format |
| [FHIR-38644](https://jira.hl7.org/browse/FHIR-38644) | Persuasive with Modification | Add provider descriptions for patients to both encounter and claim level |
| [FHIR-37581](https://jira.hl7.org/browse/FHIR-37581) | Persuasive with Modification | Add clarifying comment to processNote with best practice for patient information |
| [FHIR-38840](https://jira.hl7.org/browse/FHIR-38840) | Persuasive with Modification | Allow GFE Submitter to be Practitioner in Institutional GFE |
| [FHIR-35088](https://jira.hl7.org/browse/FHIR-35088) | Persuasive with Modification | Institutional and Professional profiles - NDC mapping and Value Set |
| [FHIR-39416](https://jira.hl7.org/browse/FHIR-39416) | Persuasive with Modification | Remove disclaimer extension from AEOB and update processNote description and cardinality |
| [FHIR-35453](https://jira.hl7.org/browse/FHIR-35453) | Persuasive | Harmonize Profiles with the CARIN BB IG |
| [FHIR-34913](https://jira.hl7.org/browse/FHIR-34913) | Persuasive | Harmonize CARIN BB and PCT FHIR data element mapping and Value Sets |
| [FHIR-35238](https://jira.hl7.org/browse/FHIR-35238) | Persuasive | Include a CapabilityStatement |
| [FHIR-38842](https://jira.hl7.org/browse/FHIR-38842) | Persuasive with Modification | Patient should be able to search EOBs, not get Bundles |
| [FHIR-35063](https://jira.hl7.org/browse/FHIR-35063) | Persuasive with Modification | polling mechanism in question |
| [FHIR-34974](https://jira.hl7.org/browse/FHIR-34974) | Persuasive with Modification | need to better explain the need for all the workflow steps |
| [FHIR-35271](https://jira.hl7.org/browse/FHIR-35271) | Persuasive with Modification | AEOB Query should take a different approach |
| [FHIR-34789](https://jira.hl7.org/browse/FHIR-34789) | Persuasive | Rewrite to make easier to understand the API |
| [FHIR-34997](https://jira.hl7.org/browse/FHIR-34997) | Persuasive with Modification | Change who gets authentication done in AEOB request from payer |
| [FHIR-34914](https://jira.hl7.org/browse/FHIR-34914) | Persuasive with Modification | Response to gfe-submit is unclear |
| [FHIR-34952](https://jira.hl7.org/browse/FHIR-34952) | Persuasive with Modification | Process Flow Revisions |
| [FHIR-34940](https://jira.hl7.org/browse/FHIR-34940) | Persuasive with Modification | Process for Sharing Advanced EOBs with Providers |
| [FHIR-34533](https://jira.hl7.org/browse/FHIR-34533) | Persuasive with Modification | Is return type form GFE Submit Appropriate? |
| [FHIR-35124](https://jira.hl7.org/browse/FHIR-35124) | Persuasive with Modification | Use of the FHIR API for Advanced AOBs to Member Must Be Optional |
| [FHIR-35199](https://jira.hl7.org/browse/FHIR-35199) | Persuasive with Modification | Diagram in Overview seems to imply that the Patient could only get a response from an Intermediary |
| [FHIR-39463](https://jira.hl7.org/browse/FHIR-39463) | Persuasive | Remove MS from AEOB.priority |
| [FHIR-39465](https://jira.hl7.org/browse/FHIR-39465) | Persuasive | Make AEOB.insurance.coverage MS |
| [FHIR-35143](https://jira.hl7.org/browse/FHIR-35143) | Persuasive with Modification | Professional profile - modify requirement for careTeam.qualification |
| [FHIR-35140](https://jira.hl7.org/browse/FHIR-35140) | Persuasive with Modification | Institutional profile - modify requirement for careTeam.qualification |
| [FHIR-38771](https://jira.hl7.org/browse/FHIR-38771) | Persuasive with Modification | Add note in overview that this IG does not address eligibility, prior authorization, or coordination of benefits |
| [FHIR-34964](https://jira.hl7.org/browse/FHIR-34964) | Persuasive with Modification | provider web portal? |
| [FHIR-38127](https://jira.hl7.org/browse/FHIR-38127) | Persuasive | GFE profiles need to require item.net |
| [FHIR-35250](https://jira.hl7.org/browse/FHIR-35250) | Not Persuasive with Modification | Use Claim.billablePeriod instead of creating a new extension |
| [FHIR-34785](https://jira.hl7.org/browse/FHIR-34785) | Persuasive with Modification | simplify menu navigation |
| [FHIR-37963](https://jira.hl7.org/browse/FHIR-37963) | Persuasive | Redesign subjectToMedicalMgmt extension to support CodeableConcept and string |
| [FHIR-34786](https://jira.hl7.org/browse/FHIR-34786) | Persuasive with Modification | Simplify or Replace figures with tables |
| [FHIR-35051](https://jira.hl7.org/browse/FHIR-35051) | Persuasive with Modification | Modify GFE and AEOB Bundle Graphics |
| [FHIR-39415](https://jira.hl7.org/browse/FHIR-39415) | Persuasive with Modification | Add service description to AEOB header |
| [FHIR-34532](https://jira.hl7.org/browse/FHIR-34532) | Persuasive | Need example of return from gfe-submit |
| [FHIR-34963](https://jira.hl7.org/browse/FHIR-34963) | Persuasive with Modification | GFE and AEOB Bundle Graphics |
| [FHIR-39397](https://jira.hl7.org/browse/FHIR-39397) | Persuasive | Add clarity for the operation outcome when server doesn't include AEOB |
| [FHIR-34962](https://jira.hl7.org/browse/FHIR-34962) | Persuasive | GFE and AEOB Bundle Graphics |
| [FHIR-39346](https://jira.hl7.org/browse/FHIR-39346) | Persuasive | Add a slice on AEOB.identifier for unique claim id to align with CARIN, but clarify in the description that it is the payer's claim id. |
| [FHIR-34961](https://jira.hl7.org/browse/FHIR-34961) | Persuasive with Modification | Detailed Requirements Summary |
| [FHIR-35269](https://jira.hl7.org/browse/FHIR-35269) | Persuasive with Modification | Specify OperationOutcome requirements for common outcomes |
| [FHIR-39379](https://jira.hl7.org/browse/FHIR-39379) | Persuasive with Modification | Make date of service required and add search parameter |
| [FHIR-38770](https://jira.hl7.org/browse/FHIR-38770) | Persuasive | Add Operational requirement that the GFE linked in the AEOB is an exact copy of the provider submitted GFE Bundle |
| [FHIR-38120](https://jira.hl7.org/browse/FHIR-38120) | Persuasive | Add an Operational requirement about GFE stored as is as originally received and not updated. |
| [FHIR-38738](https://jira.hl7.org/browse/FHIR-38738) | Persuasive with Modification | Define assumptions about what payers must verify in the GFE |
| [FHIR-39380](https://jira.hl7.org/browse/FHIR-39380) | Persuasive | Guiding principle for repeating items in GFE in AEOB |
| [FHIR-38122](https://jira.hl7.org/browse/FHIR-38122) | Persuasive | Specify more details on the scope of the IG regarding coordination of benefits and other use cases |
| [FHIR-35260](https://jira.hl7.org/browse/FHIR-35260) | Persuasive with Modification | Add slice requirements for AEOB adjudication categories |
| [FHIR-38835](https://jira.hl7.org/browse/FHIR-38835) | Persuasive | Consider GFE Value to Indicate if Member Has Agreed to Balance Billing |
| [FHIR-35378](https://jira.hl7.org/browse/FHIR-35378) | Persuasive with Modification | Add entry slices on Bundles for expected and required resource types |
| [FHIR-34930](https://jira.hl7.org/browse/FHIR-34930) | Persuasive | Add Relationship Diagram |

### Version 0.1.0

Initial ballot version

