# Artifacts Summary - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

## Artifacts Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Behavior: Capability Statements 

The following artifacts define the specific capabilities that different types of systems are expected to have in order to comply with this implementation guide. Systems conforming to this implementation guide are expected to declare conformance to one or more of the following capability statements.

| | |
| :--- | :--- |
| [Patient Cost Transparency Implementation Guide Coordination Platform Capability Statement](CapabilityStatement-davinci-pct-coordination-platform.md) | Coordination Platform Capability Statement for the Da Vinci Patient Cost Transparency Implementation Guide |
| [Patient Cost Transparency Implementation Guide Coordination Requester Capability Statement](CapabilityStatement-davinci-pct-coordination-requester.md) | Coordination Requester Capability Statement for the Da Vinci Patient Cost Transparency Implementation Guide |
| [Patient Cost Transparency Implementation Guide GFE Contributor Capability Statement](CapabilityStatement-davinci-pct-gfe-contributor.md) | GFE Contributor Capability Statement for the Da Vinci Patient Cost Transparency Implementation Guide |
| [Patient Cost Transparency Implementation Guide Payer Capability Statement](CapabilityStatement-davinci-pct.md) | Payer capability statement for the Da Vinci Patient Cost Transparency Implementation Guide |
| [Patient Cost Transparency Implementation Guide Provider Capability Statement](CapabilityStatement-davinci-pct-gfe-provider.md) | Provider Capability Statement for the Da Vinci Patient Cost Transparency Implementation Guide, for sharing Good Faith Documents |

### Behavior: Operation Definitions 

These are custom operations that can be supported by and/or invoked by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Good Faith Estimate Coordination Request](OperationDefinition-GFE-coordination-request.md) | This operation is used by an entity to submit one or multiple GFEs as a Bundle containing the GFE(s) and other referenced resources for processing. The only input parameter is the single Bundle resource with one or multiple GFE(s) - each of which is based on the Claim resource (along with other referenced resources). The only output is a url for subsequent polling per[async pattern](https://hl7.org/fhir/R5/async-bundle.html). If after polling the response is complete, then the result will either be a single Bundle with the AEOB - which is based on the ExplanationOfBenefit resource, (and other referenced resources) or an OperationOutcome resource indicating the AEOB will be sent directly to the patient and not to the provider. |
| [Retrieve GFE Packet](OperationDefinition-GFE-retrieve.md) | This operation is used by an entity to retrieve a GFE Packet containing the GFE Bundle(s) and other referenced resources based on a GFE Coordination Task. There are no input parameters and the only output is a GFE Packet. If the context task is to a Coordinating Task, this will return the GFE Packet. If the context task is for a GFE Contributor Task, it returns the GFE Bundle, if present. If a GFE Bundle does not exist for an associated Contributor Task, in place of a GFE Bundle, a GFE Missing Bundle is provided (either directly in a response if the referenced task was a Contributor Task or inside the GFE Packet if the referenced task was a Coordinating Task.). This operation will only return GFE Bundles for GFE Contributor Tasks that have an appropriately attached GFE Bundle and a status of`completed`. All other Contributor Tasks that otherwise do not have a status of`rejected`or`cancelled`will have a GFE Missing Bundle included instead. |
| [Submit a GFE resource for the creation of an AEOB](OperationDefinition-GFE-submit.md) | This operation is used by an entity to submit one or multiple GFEs as a Bundle containing the GFE(s) and other referenced resources for processing. The only input parameter is the single Bundle resource with one or multiple GFE(s) - each of which is based on the Claim resource (along with other referenced resources). The only output is a url for subsequent polling per[async pattern](https://hl7.org/fhir/R5/async-bundle.html). If after polling the response is complete, then the result will either be a single Bundle with the AEOB - which is based on the ExplanationOfBenefit resource, (and other referenced resources) or an OperationOutcome resource indicating the AEOB will be sent directly to the patient and not to the provider. |

### Behavior: Search Parameters 

These define the properties by which a RESTful server can be searched. They can also be used for sorting and including related resources.

| | |
| :--- | :--- |
| [aeob-date-of-service](SearchParameter-aeob-date-of-service.md) | Select planned date of service |
| [DocumentReference docStatus](SearchParameter-DocumentReference-doc-status.md) | The status of the underlying document. |
| [Packet Condition](SearchParameter-packet-condition.md) | Significant condition involved in an estimate. |
| [Packet Estimate Request Initiation Time](SearchParameter-packet-request-initiation-time.md) | Instant from which the request originating request was being initiated. |
| [Packet Linking Identifier](SearchParameter-packet-linking-identifier.md) | An identifier assigned to a particular service or series of services to enabling linking. |
| [Packet Planned Period Of Service](SearchParameter-packet-PlannedPeriodOfService.md) | Planned date(s) of a particular admission/service or a series of admissions/services. |
| [Packet Procedure or Service](SearchParameter-packet-procedure-or-service.md) | Significant Procedures and/or products involved in an estimate. |
| [RelatedTask](SearchParameter-related-task.md) | Completed or terminated task(s) whose function is taken by this new task |
| [TaskRequestedPeriod](SearchParameter-task-requested-period.md) | Search for a task by when the task should be performed |

### Structures: General Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [PCT Coverage](StructureDefinition-davinci-pct-coverage.md) | PCT Coverage is a profile for capturing data that reflect a payer's coverage that was effective as of the proposed date of service or the date of admission of the GFE. |
| [PCT Organization](StructureDefinition-davinci-pct-organization.md) | The PCT Organization profile builds upon the US Core Organization profile. It is used to convey a payer, provider, payee, or service facility organization. |
| [PCT Practitioner](StructureDefinition-davinci-pct-practitioner.md) | The PCT Practitioner profile builds upon the US Core Practitioner profile. It is used to convey information about the practitioner who will be providing services to the patient as described on the GFE. |

### Structures: GFE Resource Profiles 

These define constraints on GFE and GFE Coordination Request related FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [PCT GFE Bundle](StructureDefinition-davinci-pct-gfe-bundle.md) | PCT GFE Bundle that contains all resources for a Good faith estimate submitted by a single GFE contributing provider. Organizations for both the provider and payer MAY be included. This single contributing provider GFE Bundle may be included in a set of GFE bundles from other providers in a GFE Packet that can then be made available to the patient or sent to a payer for insurance estimation. The scope of this guide does not include coordination of benefits for more than one coverage. This does not serve as a replacement for eligibility, prior authorization or other financial and administrative use cases. |
| [PCT GFE Composition](StructureDefinition-davinci-pct-gfe-composition.md) | PCT GFE Composition that assembles the contents of a GFE (represented by one or more individual GFE Bundles) into a single logical package. A Composition for the document type Bundle that enables versioning, signing and being referenced by a DocumentReference for searching and subscription notifications. |
| [PCT GFE Contributor Task](StructureDefinition-davinci-pct-gfe-contributor-task.md) | The PCT GFE Contributor Task is used by a GFE coordinator to assign a GFE contributor task to a specific provider and may include information specific to that patient’s expected service |
| [PCT GFE Coordination Bundle](StructureDefinition-davinci-pct-gfe-coordination-bundle.md) | PCT GFE Request Bundle that contains necessary resources for GFE to request GFEs from one or multiple GFE contributing providers. |
| [PCT GFE Coordination Task](StructureDefinition-davinci-pct-gfe-coordination-task.md) | The Good Faith Estimate (GFE) Coordination Task is used to organize a GFE across providers for a single period of care for which all GFE Contributor Task resources will be linked. The task includes the general inputs that are shared across all of the GFE contributor tasks. These inputs may include a ‘primary’ service and relevant conditions. |
| [PCT GFE DeviceRequest](StructureDefinition-davinci-pct-devicerequest.md) | The PCT DeviceRequest including details about a device for which a GFE is being requested. |
| [PCT GFE Information Bundle](StructureDefinition-davinci-pct-gfe-information-bundle.md) | PCT GFE Information Bundle that contains the information necessary for GFE contributors to create their estimates. This bundle may for all GFE Contributors or specific to a single contributor and may include, but is not limited to, the Patient Resource, request resources (such as ServiceRequest, MedicationRequest, and DeviceRequest), Service location information, Coverage and Payer Organization resources (if applicable). |
| [PCT GFE MedicationRequest](StructureDefinition-davinci-pct-medicationrequest.md) | The PCT MedicationRequest including details about a medication for which a GFE is being requested. |
| [PCT GFE Missing Bundle](StructureDefinition-davinci-pct-gfe-missing-bundle.md) | PCT GFE Missing Bundle is used to indicate when a GFE Contributor task request was made, but no GFE Bundle was submitted (attached to the ContributorTask). |
| [PCT GFE Packet](StructureDefinition-davinci-pct-gfe-packet.md) | PCT GFE Packet that contains GFE Bundles from GFE contributors. This document type bundle of GFE Bundles from GFE contributors that can then be made available to the patient or sent to a payer for insurance estimation. The scope of this guide does not include coordination of benefits or more than one coverage. This does not serve as a replacement for eligibility, prior authorization or other financial and administrative use cases. |
| [PCT GFE Packet Document Reference](StructureDefinition-davinci-pct-gfe-documentreference.md) | PCT GFE Packet Document Reference that enables searching and subscriptions for GFE Packets. |
| [PCT GFE ServiceRequest](StructureDefinition-davinci-pct-servicerequest.md) | The PCT ServiceRequest including details about a service for which a GFE is being requested. |
| [PCT Good Faith Estimate Summary](StructureDefinition-davinci-pct-gfe-summary.md) | PCT Good Faith Estimate Summary is a profile for summarizing costs associated with a set of Good Faith Estimate Claims for a single Period of Care. |
| [PCT Good Faith Estimate Institutional](StructureDefinition-davinci-pct-gfe-institutional.md) | PCT Good Faith Estimate Institutional is a profile for an institutional provider to capture estimation for items and services for the patient or, optionally, to submit to a payer (for patients using insurance). If submitting to a payer, this includes the data needed for a payer to process and create an Advanced EOB. This profile is used for an institutional GFE submission. |
| [PCT Good Faith Estimate Professional](StructureDefinition-davinci-pct-gfe-professional.md) | PCT Good Faith Estimate Professional is a profile for an professional provider to capture estimation for items and services for the patient or, optionally, to submit to a payer (for patients using insurance). If submitting to a payer, this includes the data needed to be processed by a payer for the creation of an Advanced EOB. This profile is used for a professional GFE submission. |
| [PCT Service Location](StructureDefinition-davinci-pct-service-location.md) | The PCT Service Location provides information where the service is to be performed or the item delivered. This could be used to express an actual physical location or a facility type. |

### Structures: AEOB Resource Profiles 

These define constraints on AEOB and GFE Submit related FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [PCT Advanced EOB](StructureDefinition-davinci-pct-aeob.md) | The No Surprises Act requires that group health plans and insurers provide advance cost estimates, called advanced explanations of benefits (advanced EOBs), for scheduled services. This profile is used for exchanging the Advanced EOB data. |
| [PCT Advanced EOB Summary](StructureDefinition-davinci-pct-aeob-summary.md) | This profile is used for exchanging a summary of Advanced Explanation of Benefit (AEOB) information, including costs and benefits, of all of the Advanced EOB data contained within an AEOB Packet. |
| [PCT AEOB Adjudication Error](StructureDefinition-davinci-pct-aeob-adjudication-error.md) | OperationOutcome returned from the gfeSubmit operation when there are adjudication errors during AEOB processing |
| [PCT AEOB Complete](StructureDefinition-davinci-pct-aeob-complete.md) | OperationOutcome returned from the gfeSubmit operation when the AEOB process is complete but no AEOB will be returned to the submitter (i.e. it was sent only to the patient) |
| [PCT AEOB Composition](StructureDefinition-davinci-pct-aeob-composition.md) | PCT AEOB Composition that assembles the contents of an AEOB (represented by one or more individual AEOB resources) into a single logical package. A Composition for the document type Bundle that enables versioning, signing and being referenced by a DocumentReference for searching and subscription notifications. |
| [PCT AEOB Packet](StructureDefinition-davinci-pct-aeob-packet.md) | PCT AEOB Packet that contains necessary resources for one or more an AEOBs. Organizations for both the payer and provider SHALL be included. An AEOB Summary SHALL be included and reflect the total estimate for the patient, including all AEOB resources within the Bundle. This version of the Bundle is a document type that will enable versioning, signing and being referenced by a DocumentReference for searching and subscription notifications. |
| [PCT AEOB Packet Document Reference](StructureDefinition-davinci-pct-aeob-documentreference.md) | PCT AEOB Packet Document Reference that enables searching and subscriptions for AEOB Packets. |
| [PCT GFE Validation Error](StructureDefinition-davinci-pct-gfe-validation-error.md) | OperationOutcome returned from the gfeSubmit operation when the GFE Bundle fails FHIR validation |

### Subscriptions 

These define provide definitions for subscriptions including R4B based SubscriptionTopic and subscription profiles.

| | |
| :--- | :--- |
| [Subscription - AEOB Available for Author Notification](StructureDefinition-davinci-pct-aeob-available-author-subscription.md) | An author focused Subscription when an Advanced Explanation of Benefit (AEOB) Packet DocumentReference is created or updated (for FHIR R4). This represents that an AEOB Bundle, either contained in or referred to by the DocumentReference has been newly created and is available or has been updated, should updates be made. |
| [Subscription - AEOB Available for Subject Notification](StructureDefinition-davinci-pct-aeob-available-subject-subscription.md) | A subject focused Subscription when an Advanced Explanation of Benefit (AEOB) Packet DocumentReference is created or updated (for FHIR R4). This represents that an AEOB Bundle, either contained in or referred to by the DocumentReference has been newly created and is available or has been updated, should updates be made. |
| [Subscription - GFE Available for Author Notification](StructureDefinition-davinci-pct-gfe-available-author-subscription.md) | An author focused Subscription when a Good Faith Estimate (GFE) Packet DocumentReference is created or updated (for FHIR R4). This represents that a GFE Bundle, either contained in or referred to by the DocumentReference has been newly created and is available or has been updated, should updates be made. |
| [Subscription - GFE Available for Subject Notification](StructureDefinition-davinci-pct-gfe-available-subject-subscription.md) | A subject focused Subscription when a Good Faith Estimate (GFE) Packet DocumentReference is created or updated (for FHIR R4). This represents that a GFE Bundle, either contained in or referred to by the DocumentReference has been newly created and is available or has been updated, should updates be made. |
| [Subscription - GFE Coordination Task Update Notification](StructureDefinition-davinci-pct-gfe-task-update-subscription.md) | Profile for a Subscription to provide a notification to an Provider involved in GFE Coordination effort (either as a GFE Coordination Requester or a GFE Contributor) whenever a Task is created, updated, or deleted (for FHIR R4). For the GFE Coordination requester this will trigger for a change on a Coordination or Contributor Task for which they are the requester. For a GFE Contributor this will trigger on a change to a Contributor Task for which they are the owner or on a change to an associated Coordination Task. This will be triggered on the creation, update, or deletion of Coordination (gfe-coordination-task) or Contributor Task (gfe-contributor-task) codes. |
| [SubscriptionTopic - AEOB Available for Author Notification](SubscriptionTopic-davinci-pct-aeob-available-author-notification.md) | Author focused Subscription Topic when an Advanced Explanation of Benefit (AEOB) Packet DocumentReference is created or updated (for FHIR R4). This represents that an AEOB Bundle, either contained in or referred to by the DocumentReference has been newly created and is available or has been updated, should updates be made.**Canonical URL:**http://hl7.org/fhir/us/davinci-pct/SubscriptionTopic/davinci-pct-aeob-available-author-notification |
| [SubscriptionTopic - AEOB Available for Subject Notification](SubscriptionTopic-davinci-pct-aeob-available-subject-notification.md) | Subject focused Subscription Topic for when an Advanced Explanation of Benefit DocumentReference is created or updated (for FHIR R4). This represents that an AEOB Packet, either contained in or referred to by the DocumentReference has been newly created and is available or has been updated, should updates be made.**Canonical URL:**http://hl7.org/fhir/us/davinci-pct/SubscriptionTopic/davinci-pct-aeob-available-subject-notification |
| [SubscriptionTopic - GFE Available for Author Notification](SubscriptionTopic-davinci-pct-gfe-available-author-notification.md) | Author focused Subscription Topic when a Good Faith Estimate (GFE) Packet DocumentReference is created or updated (for FHIR R4). This represents that an GFE Bundle, either contained in or referred to by the DocumentReference has been newly created and is available or has been updated, should updates be made.**Canonical URL:**http://hl7.org/fhir/us/davinci-pct/SubscriptionTopic/davinci-pct-gfe-available-author-notification |
| [SubscriptionTopic - GFE Available for Subject Notification](SubscriptionTopic-davinci-pct-gfe-available-subject-notification.md) | Subject focused Subscription Topic for when a Good Faith Estimate (GFE) Packet DocumentReference is created or updated (for FHIR R4). This represents that an GFE Packet, either contained in or referred to by the DocumentReference has been newly created and is available or has been updated, should updates be made.**Canonical URL:**http://hl7.org/fhir/us/davinci-pct/SubscriptionTopic/davinci-pct-gfe-available-subject-notification |
| [SubscriptionTopic - GFE Coordination Task Notification](SubscriptionTopic-davinci-pct-gfe-coordination-task-notification.md) | Subscription Topic to provide a notification to an Provider involved in GFE Coordination effort (either as a GFE Coordination Requester or a GFE Contributor) whenever a Task is created, updated, or deleted (for FHIR R4). For the GFE Coordination requester this will trigger for a change on a Coordination or Contributor Task for which they are the requester. For a GFE Contributor this will trigger on a change to a Contributor Task for which they are the owner or on a change to an associated Coordination Task. This will be triggered on the creation, update, or deletion of Coordination (gfe-coordination-task) or Contributor Task (gfe-contributor-task) codes.**Canonical URL:**http://hl7.org/fhir/us/davinci-pct/SubscriptionTopic/davinci-pct-gfe-coordination-task-notification |

### Structures: Extension Definitions 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Benefit Remaining](StructureDefinition-remaining-benefit.md) | The quantity of the benefit remaining to date. |
| [GFE Reference](StructureDefinition-gfeReference.md) | This extension is used to reference the GFE submitted by an entity that started the process for obtaining an Advanced EOB. |
| [GFEBillingProviderLineItemCtrlNum](StructureDefinition-gfeBillingProviderLineItemCtrlNum.md) | This extension is used by the provider to assign a unique identifier to this item. The intent of this element is to allow the provider to assign something other than 'line number' for their purposes (e.g. tracking and troubleshooting). |
| [GFEConsentForBalanceBilling](StructureDefinition-gfeConsentForBalanceBilling.md) | If the provider has received a written consent form indicating a patient has agreed to waive their protections and pay up to the full cost for the out-of-network item or service, this will be “true”. If the provider has not received written consent, this will be “false”. This is an attestation only. The billing provider is legally required to maintain the written notice and consent form. |
| [GFEDisclaimer](StructureDefinition-gfeDisclaimer.md) | Disclaimers the patient should be made aware of regarding the providers estimate (e.g. application of sliding scale for self-pay/uninsured patients) including any additional assumptions and requirements. Noting that that the information provided is only an estimate based on the items and services reasonably expected, at the time of scheduling (or requesting) the item or service, to be furnished and is subject to change. |
| [GFERelatedTask](StructureDefinition-gfeRelatedTask.md) | A relationship that the source Task has with the referenced GFE Task has with the source GFE Task. This may be used for cases when a new GFE is needed or a Task needs to be replaced for some reason and the requester and owner, where present, are the same between the referenced and source Task respectively. |
| [GFEServiceLinkingInfo](StructureDefinition-gfeServiceLinkingInfo.md) | This extension is used to provide the GFE Service Linking Information. This allows implementers to have the same identifier on multiple GFEs that are part of one period of care's services. This would be needed for some of the workflow options that businesses may decide to use. |
| [In Network Provider Options Link](StructureDefinition-inNetworkProviderOptionsLink.md) | This extension provides a payer link to information enabling the patient to find providers that are in network for the requested services. |
| [Planned Service Period](StructureDefinition-plannedServicePeriod.md) | Planned period of service the request is about |
| [ProcessNote Class](StructureDefinition-processNoteClass.md) | This extension is used to indicate a the class of AEOB Claim process notes |
| [ProviderEventMethodology](StructureDefinition-providerEventMethodology.md) | This extension is used for indicating the method a provider used to group services, and those providing such services, beyond what may be indicated through DRGs that the payer or patient may find helpful (e.g. grouping services by a standardized episode of care definition). This is provider generated text and should not be modified by the payer. |
| [ProviderTaxonomy](StructureDefinition-providerTaxonomy.md) | This extension is used to indicate the taxonomy code of the provider. |
| [ReferralNumber](StructureDefinition-referralNumber.md) | This extension is used to provide the Referral Number. |
| [Request Initiation Time](StructureDefinition-requestInitiationTime.md) | Instant from which the request is being initiated. |
| [RequestOriginationType](StructureDefinition-requestOriginationType.md) | Indicator as to whether the request for estimate originated from a scheduled or unscheduled service. |
| [Self-Pay Declared](StructureDefinition-selfPayDeclared.md) | Requester has explicitly declared self-pay. |
| [Service Description](StructureDefinition-serviceDescription.md) | This extension is used to communicate a plain language description of the procedure, product, or service. |
| [Significant Procedures and/or products involved](StructureDefinition-estimateProcedureOrService.md) | Significant Procedures and/or products involved in an estimate. |
| [Significant condition involved](StructureDefinition-estimateCondition.md) | Significant condition involved in an estimate. |
| [Subject To Medical Management](StructureDefinition-subjectToMedicalMgmt.md) | This extension is used to provide a reason to explain how the estimate may change subject to medical management. |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Claim Medical Product or Service Value Set](ValueSet-USClaimMedicalProductOrServiceCodes.md) | CPT - HCPCS - HIPPS - CDT codes to report medical procedures and services under public and private health insurance programs |
| [GFE Coordination Task Status Codes](ValueSet-PCTCoordinationTaskStatusCodes.md) | Codes allowed for a GFE Coordination Task status |
| [ICD-10 Procedure Codes](ValueSet-ICD10ProcedureCodes.md) | Procedure Codes from https://www.cms.gov/Medicare/Coding/ICD10 |
| [NUBC Point Of Origin](ValueSet-AHANUBCPointOfOriginVS.md) | The UB-04 Data File contains the complete set of NUBC codes. Every code in the range of possible codes is accounted for sequentially.There are no gaps because all used and unused codes are identified. This value set consists of the following:* FL 15 - Point of Origin for Admission or Visit for Non-newborn
* FL 15 - Point of Origin for Admission or Visit for Newborn
These codes are used to convey the patient point of origin for an admission or visit and are the property of the American Hospital Association.To obtain the underlying code systems, please see information[here](https://www.nubc.org/subscription-information)Statement of Understanding between AHA and HL7 can be found[here](http://www.hl7.org/documentcenter/public/mou/AHA%20HL7%20SOU%202020%20AHA%20Fully%20Executed.pdf). In particular see sections 4.1d and 4.2.The UB-04 Manual has a 12-month subscription period from June 30 through July 1.For frequently asked questions, see here[here](https://www.nubc.org/nubc-faqs) |
| [NUBC Priority (Type) of Admission or Visit](ValueSet-AHANUBCPriorityTypeOfAdmissionOrVisitVS.md) | The UB-04 Data File contains the complete set of NUBC codes. Every code in the range of possible codes is accounted for sequentially. There are no gaps because all used and unused codes are identified.This value set consists of the following:* FL 14 - Priority (Type) of Admission or Visit
These codes are used to convey the priority of an admission or visit and are the property of the American Hospital Association.To obtain the underlying code systems, please see information[here](https://www.nubc.org/subscription-information)Statement of Understanding between AHA and HL7 can be found[here](http://www.hl7.org/documentcenter/public/mou/AHA%20HL7%20SOU%202020%20AHA%20Fully%20Executed.pdf). In particular see sections 4.1d and 4.2.The UB-04 Manual has a 12-month subscription period from June 30 through July 1.For frequently asked questions, see here[here](https://www.nubc.org/nubc-faqs)This Code system is referenced in the content logical definition of the following value sets:This CodeSystem is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)This code system https://www.nubc.org/CodeSystem/PriorityTypeOfAdmitOrVisit defines many codes, but they are not represented here |
| [PCT AEOB Process Note Types](ValueSet-PCTAEOBProcessNoteVS.md) | Indicates the type of .processNote for AEOB. |
| [PCT Adjudication Value Set](ValueSet-PCTAdjudicationVS.md) | Describes the various amount fields used when payers receive and adjudicate a claim. It includes the values defined in http://terminology.hl7.org/CodeSystem/adjudication, as well as those defined in the C4BB Adjudication CodeSystem. |
| [PCT Adjustment Reason](ValueSet-PCTAdjustmentReasonVS.md) | Codes indicating reasons why a claim or line item is adjusted. |
| [PCT CMS HCPCS and AMA CPT Procedure Surgical Codes](ValueSet-PCTProcedureSurgicalCodes.md) | Combination of CMS HCPCS and AMA CPT codes to specify the type of surgical procedure |
| [PCT Care Team Role Value Set](ValueSet-PCTCareTeamRoleVS.md) | Codes to specify the the functional roles of the care team members. |
| [PCT Financial Type Value Set](ValueSet-PCTFinancialTypeVS.md) | Financial Type codes for benefitBalance.financial.type. |
| [PCT GFE CMS Place of Service Value Set](ValueSet-PCTGFECMSPOS.md) | CMS Place of Service codes |
| [PCT GFE Contributor Task Status Reason Codes ValueSet](ValueSet-PCTContributorTaskStatusReasonCodes.md) | Defining codes for defining GFE request GFE contributor task status reason types. |
| [PCT GFE Item Adjudication Value Set](ValueSet-PCTAdjudicationCategoryVS.md) | Value Set containing codes for the type of adjudication information provided. |
| [PCT GFE Item CPT - HCPCS Value Set](ValueSet-PCTGFEItemCptHcpcsVS.md) | CPT - HCPCS codes to report medical procedures and services under public and private health insurance programs |
| [PCT GFE Item NDC Value Set](ValueSet-PCTGFEItemNDCVS.md) | The FDA published list of NDC codes for finished drug products |
| [PCT GFE NUBC Revenue Value Set](ValueSet-PCTGFEItemRevenueVS.md) | NUBC UB-04 Revenue codes |
| [PCT GFE NUBC Uniform Billing (UB-04) Type of Bill Value Set](ValueSet-PCTGFETypeOfBillVS.md) | NUBC Uniform Billing (UB-04) codes to indicate the specific Type of Bill (TOB), e.g., hospital inpatient, outpatient, replacements, voids, etc. The first digit is a leading zero*. The fourth digit defines the frequency of the bill for the institutional and electronic professional claim. |
| [PCT GFE Request Coordination Task Status Reason Codes ValueSet](ValueSet-PCTCoordinationTaskStatusReasonCodes.md) | Defining codes for GFE Coordination Task status reason types. |
| [PCT GFE Request Task Business Status ValueSet](ValueSet-PCTTaskBusinessStatusCodes.md) | Codes for defining GFE request task business status types. |
| [PCT GFE Request Type Codes ValueSet](ValueSet-PCTGFERequestTypeVS.md) | Codes for the Good Faith Estimate (GFE) request origination types. |
| [PCT GFE Task Relationship](ValueSet-PCTGFETaskRelationship.md) | Code expressing a relationship that the source Task has with the referenced GFE Task has with the source GFE Task. |
| [PCT ICD-10 Diagnostic Codes](ValueSet-PCTDiagnosticCodes.md) | ICD-10 Codes to specify the type of diagnosis |
| [PCT Organization Contact Purpose Value Set](ValueSet-PCTOrgContactPurposeTypeVS.md) | Codes for the classification of organization contact purposes. This ValueSet is currently locally defined; an external FHIR value set may be created through the HL7 Terminology (THO) process to replace this value set in a future version. |
| [PCT Organization Type Value Set](ValueSet-PCTOrganizationTypeVS.md) | Codes to specify the type of entity involved in the PCT GFE process. This ValueSet is currently locally defined; an external FHIR value set may be created through the HL7 Terminology (THO) process to replace this value set in a future version. |
| [PCT Payer Benefit Payment Status](ValueSet-PCTPayerBenefitPaymentStatusVS.md) | Indicates the in network or out of network payment status of the claim or line item. |
| [PCT Payer Provider Network Status](ValueSet-PCTPayerProviderNetworkStatusVS.md) | Indicates the Provider network status with the Payer as of the effective date of service or admission. |
| [PCT Procedure Type Value Set](ValueSet-PCTProcedureTypeVS.md) | Codes to specify the type of procedure |
| [PCT Supporting Info Type Value Set](ValueSet-PCTSupportingInfoTypeVS.md) | Codes to specify the type of the supplied supporting information |
| [PCT Task Attachment Mime Types](ValueSet-PCTTaskAttachmentContentType.md) | Patient Cost Transparency Task Attachment Mime Types |
| [PCT Total Value Set](ValueSet-PCTTotal.md) | Describes the various amount fields used when payers receive and adjudicate a claim. It includes the values defined in http://terminology.hl7.org/CodeSystem/adjudication, as well as those defined in the Network Status. |
| [PCT benefitBalance.category codes](ValueSet-PCTBenefitBalanceCategoryVS.md) | Category codes for PCT benefitBalance.category from X12 service type. |
| [Provider GFE Contributor Task Status Codes](ValueSet-PCTContributorTaskStatusCodes.md) | Codes allowed for a GFE Contributor-specific service task status |
| [US Claim DRG Codes](ValueSet-USClaimDRGCodes.md) | US Claim Diagnosis Related Group Codes. All codes from MS-DRGs - AP-DRGs - APR-DRGs |

### Terminology: Code Systems 

These define new code systems used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [PCT AEOB Process Note Code System](CodeSystem-PCTAEOBProcessNoteCS.md) | Defining codes for process notes. This CodeSystem is currently defined by this IG, but is anticipated to be temporary. The concepts within are expected to be moved in a future version to a more central terminology specification such as THO, which will result in a code system url change and possibly modified codes and definitions. |
| [PCT Adjudication Category CodeSystem](CodeSystem-PCTAdjudicationCategoryCS.md) | Codes indicating the type of adjudication information provided. This CodeSystem is currently defined by this IG, but is anticipated to be temporary. The concepts within are expected to be moved in a future version to a more central terminology specification such as THO, which will result in a code system url change and possibly modified codes and definitions. |
| [PCT Adjudication Code System](CodeSystem-PCTAdjudication.md) | Describes the various amount fields used when payers receive and adjudicate a claim. It complements the values defined in http://terminology.hl7.org/CodeSystem/adjudication. This CodeSystem is currently defined by this IG, but is anticipated to be temporary. The concepts within are expected to be moved in a future version to a more central terminology specification such as THO, which will result in a code system url change and possibly modified codes and definitions. |
| [PCT Document Types](CodeSystem-PCTDocumentTypeTemporaryTrialUse.md) | Defining codes for types and categories of documents and collections used for Patient Cost Transparency estimates. This CodeSystem is currently defined by this IG, but is anticipated to be temporary. The concepts within are expected to be moved in a future version to a more central terminology specification such as LOINC, which will result in a code system url change and possibly modified codes and definitions. |
| [PCT Estimate Type Code System](CodeSystem-PCTEstimateTypeSummaryCSTemporaryTrialUse.md) | Defining the code for a estimate (GFE or AEOB) type summary. This CodeSystem is currently defined by this IG, but is anticipated to be temporary. The concepts within are expected to be moved in a future version to a more central terminology specification such as THO, which will result in a code system url change and possibly modified codes and definitions. |
| [PCT Financial Type Code System](CodeSystem-PCTFinancialType.md) | Financial Type codes for benefitBalance.financial.type. This CodeSystem is currently defined by this IG, but is anticipated to be temporary. The concepts within are expected to be moved in a future version to a more central terminology specification such as THO, which will result in a code system url change and possibly modified codes and definitions. |
| [PCT GFE Request Task Business Status Code System](CodeSystem-PCTTaskBusinessStatusCSTemporaryTrialUse.md) | Codes for defining GFE request task business status types. This CodeSystem is currently defined by this IG, but is anticipated to be temporary. The concepts within are expected to be moved in a future version to a more central terminology specification such as THO, which will result in a code system url change and possibly modified codes and definitions. |
| [PCT GFE Request Task Status Reason Code Code System](CodeSystem-PCTTaskStatusReasonCSTemporaryTrialUse.md) | Codes for defining GFE request task status reason types. This CodeSystem is currently defined by this IG, but is anticipated to be temporary. The concepts within are expected to be moved in a future version to a more central terminology specification such as THO, which will result in a code system url change and possibly modified codes and definitions. |
| [PCT GFE Request Type Codes Code System](CodeSystem-PCTGFERequestTypeCSTemporaryTrialUse.md) | Codes for defining GFE request types. This CodeSystem is currently defined by this IG, but is anticipated to be temporary. The concepts within are expected to be moved in a future version to a more central terminology specification such as THO, which will result in a code system url change and possibly modified codes and definitions. |
| [PCT GFE Supporting Info Type Code System](CodeSystem-PCTSupportingInfoType.md) | Defining codes for the classification of the supplied supporting information. This CodeSystem is currently defined by this IG, but is anticipated to be temporary. The concepts within are expected to be moved in a future version to a more central terminology specification such as THO, which will result in a code system url change and possibly modified codes and definitions. |
| [PCT Network Status](CodeSystem-PCTNetworkStatusCS.md) | Defining codes for network status. This CodeSystem is currently defined by this IG, but is anticipated to be temporary. The concepts within are expected to be moved in a future version to a more central terminology specification such as THO, which will result in a code system url change and possibly modified codes and definitions. |
| [PCT Organization Contact Purpose Type Code System](CodeSystem-PCTOrgContactPurposeType.md) | Organization Contact Purpose Type Code System. This CodeSystem is currently defined by this IG, but is anticipated to be temporary. The concepts within are expected to be moved in a future version to a more central terminology specification such as THO, which will result in a code system url change and possibly modified codes and definitions. |
| [PCT Packet Section Codes](CodeSystem-PCTDocumentSection.md) | Defining codes for the sections found in packets (document bundles) used for Patient Cost Transparency estimates. |
| [PCT Procedure Type](CodeSystem-PCTProcedureType.md) | Defining codes for the classification of procedure types. This CodeSystem is currently defined by this IG, but is anticipated to be temporary. The concepts within are expected to be moved in a future version to a more central terminology specification such as THO, which will result in a code system url change and possibly modified codes and definitions. |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [PCT-AEOB-1](ExplanationOfBenefit-PCT-AEOB-1.md) | An example instance of the PCTAdvancedEOB Profile |
| [PCT-AEOB-Adjudication-Error-Example-1](OperationOutcome-PCT-AEOB-Adjudication-Error-Example-1.md) | PCT AEOB Adjudication Error Example 1 |
| [PCT-AEOB-Complete-Example-1](OperationOutcome-PCT-AEOB-Complete-Example-1.md) | PCT AEOB Complete Example 1 |
| [PCT-AEOB-DocumentReference-1](DocumentReference-PCT-AEOB-DocumentReference-1.md) | PCT AEOB DocumentReference Example 1 |
| [PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md) | PCT AEOB Packet Example 1 |
| [PCT-AEOB-Summary-1](ExplanationOfBenefit-PCT-AEOB-Summary-1.md) | An example instance of the PCTAdvancedEOBSummary Profile |
| [PCT-DeviceRequest-1](DeviceRequest-PCT-DeviceRequest-1.md) | PCT DeviceRequest Example 1 |
| [PCT-GFE-Bundle-Inst-1](Bundle-PCT-GFE-Bundle-Inst-1.md) | PCT GFE Bundle Institutional Example 1 |
| [PCT-GFE-Bundle-Prof-1](Bundle-PCT-GFE-Bundle-Prof-1.md) | PCT GFE Bundle Professional Example 1 |
| [PCT-GFE-Contributor-Replacement-Task-1](Task-PCT-GFE-Contributor-Replacement-Task-1.md) | PCT GFE Contributor Task replacement example 1 |
| [PCT-GFE-Contributor-Replacement-Task-2](Task-PCT-GFE-Contributor-Replacement-Task-2.md) | PCT GFE Contributor Task replacement example 2 |
| [PCT-GFE-Contributor-Task-1](Task-PCT-GFE-Contributor-Task-1.md) | PCT GFE Contributor Task example 1 |
| [PCT-GFE-Contributor-Task-2](Task-PCT-GFE-Contributor-Task-2.md) | PCT GFE Contributor Task example 2 |
| [PCT-GFE-Coordination-Bundle-1](Bundle-PCT-GFE-Coordination-Bundle-1.md) | PCT GFE Coordination Bundle Example 1 |
| [PCT-GFE-Coordination-Replacement-Task-1](Task-PCT-GFE-Coordination-Replacement-Task-1.md) | PCT GFE Coordination Task replacement example 1 |
| [PCT-GFE-Coordination-Task-1](Task-PCT-GFE-Coordination-Task-1.md) | PCT GFE Coordination Task example 1 |
| [PCT-GFE-DocumentReference-Inst-1](DocumentReference-PCT-GFE-DocumentReference-Inst-1.md) | PCT GFE DocumentReference Institutional Example 1 |
| [PCT-GFE-DocumentReference-Prof-1](DocumentReference-PCT-GFE-DocumentReference-Prof-1.md) | PCT GFE DocumentReference Professional Example 1 |
| [PCT-GFE-Information-Bundle-1](Bundle-PCT-GFE-Information-Bundle-1.md) | PCT GFE Information Bundle Example 1 |
| [PCT-GFE-Institutional-1](Claim-PCT-GFE-Institutional-1.md) | PCT Institutional GFE Example 1 |
| [PCT-GFE-Institutional-MRI](Claim-PCT-GFE-Institutional-MRI.md) | PCT Institutional GFE for MRI |
| [PCT-GFE-Missing-Bundle-1](Bundle-PCT-GFE-Missing-Bundle-1.md) | PCT GFE Missing Bundle Example 1 |
| [PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md) | PCT GFE Packet Institutional Example 1 |
| [PCT-GFE-Packet-Prof-1](Bundle-PCT-GFE-Packet-Prof-1.md) | PCT GFE Packet Professional Example 1 |
| [PCT-GFE-Professional-MRI](Claim-PCT-GFE-Professional-MRI.md) | PCT Professional GFE Example 1 |
| [PCT-GFE-Summary-1](Claim-PCT-GFE-Summary-1.md) | PCT Summary GFE Example 1 |
| [PCT-GFE-Summary-MRI](Claim-PCT-GFE-Summary-MRI.md) | PCT Summary MRI GFE |
| [PCT-GFE-Validation-Error-Example-1](OperationOutcome-PCT-GFE-Validation-Error-Example-1.md) | PCT GFE Validation Error Example 1 |
| [PCT-MedicationRequest-1](MedicationRequest-PCT-MedicationRequest-1.md) | PCT MedicationRequest Example 1 |
| [PCT-ServiceLocation-1](Location-PCT-ServiceLocation-1.md) | PCT ServiceLocation Example 1 |
| [PCT-ServiceRequest-1](ServiceRequest-PCT-ServiceRequest-1.md) | PCT ServiceRequest Example 1 |
| [Submitter-Org-1](Organization-Submitter-Org-1.md) | Institutional GFE Submitter 1 |
| [Submitter-Practitioner-1](Practitioner-Submitter-Practitioner-1.md) | Professional GFE Submitter 1 |
| [coverage1001](Coverage-coverage1001.md) | An instance of PCTCoverage |
| [example-aeob-available-author-subscription-full](Subscription-example-aeob-available-author-subscription-full.md) | An example instance of the davinci-pct-aeob-available-author-subscription Profile returning the full DocumentReference resource |
| [example-aeob-available-author-subscription-id-only](Subscription-example-aeob-available-author-subscription-id-only.md) | An example instance of the davinci-pct-aeob-available-author-subscription Profile returning only the id of the DocumentReference resource |
| [example-aeob-available-subject-subscription](Subscription-example-aeob-available-subject-subscription.md) | An example instance of the davinci-pct-aeob-available-subject-subscription Profile returning the full DocumentReference resource |
| [example-gfe-available-author-subscription-full](Subscription-example-gfe-available-author-subscription-full.md) | An example instance of the davinci-pct-gfe-available-author-subscription Profile returning the full DocumentReference resource |
| [example-gfe-available-author-subscription-id-only](Subscription-example-gfe-available-author-subscription-id-only.md) | An example instance of the davinci-pct-gfe-available-author-subscription Profile returning only the id of the DocumentReference resource |
| [example-gfe-available-subject-subscription-full](Subscription-example-gfe-available-subject-subscription-full.md) | An example instance of the davinci-pct-gfe-available-subject-subscription Profile returning the full DocumentReference resource |
| [example-gfe-task-subscription](Subscription-example-gfe-task-subscription.md) | An example instance of the davinci-pct-gfe-task-update-subscription Profile |
| [example-gfe-task-subscription-partof](Subscription-example-gfe-task-subscription-partof.md) | An example instance of the davinci-pct-gfe-task-update-subscription Profile |
| [org1001](Organization-org1001.md) | An instance of PCTOrganization as a payer |
| [org1002](Organization-org1002.md) | An instance of PCTOrganization as a healthcare provider |
| [patient1001](Patient-patient1001.md) | An instance of Patient |
| [prac001](Practitioner-prac001.md) | An instance of PCTPractitioner |
| [prac002](Practitioner-prac002.md) | An instance of PCTPractitioner |
| [selfpaycoverage2001](Coverage-selfpaycoverage2001.md) | An instance of PCTCoverage |

