# Claim Medical Product or Service Value Set - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Claim Medical Product or Service Value Set**

## ValueSet: Claim Medical Product or Service Value Set 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-pct/ValueSet/USClaimMedicalProductOrServiceCodes | *Version*:2.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:USClaimMedicalProductOrServiceCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.4.48.36 | | |
| **Copyright/Legal**: Current Procedural Terminology (CPT) is copyright 2020 American Medical Association. All rights reserved. | | |

 
CPT - HCPCS - HIPPS - CDT codes to report medical procedures and services under public and private health insurance programs 

 **References** 

* [PCT Advanced EOB](StructureDefinition-davinci-pct-aeob.md)
* [PCT Good Faith Estimate Institutional](StructureDefinition-davinci-pct-gfe-institutional.md)
* [PCT Good Faith Estimate Professional](StructureDefinition-davinci-pct-gfe-professional.md)
* [PCT GFE ServiceRequest](StructureDefinition-davinci-pct-servicerequest.md)
* [Significant Procedures and/or products involved](StructureDefinition-estimateProcedureOrService.md)

**Changes since version 1.1.0:**

* The resource metadata has changed (description)

* The logical definition of the value set has changed

### Logical Definition (CLD)

 

### Expansion

This value set cannot be expanded because the terminology server(s) deemed it too costly to do so

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "USClaimMedicalProductOrServiceCodes",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-pct/ImplementationGuide/hl7.fhir.us.davinci-pct"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-pct/ImplementationGuide/hl7.fhir.us.davinci-pct"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-pct/ValueSet/USClaimMedicalProductOrServiceCodes",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.4.48.36"
    }
  ],
  "version" : "2.0.0",
  "name" : "USClaimMedicalProductOrServiceCodes",
  "title" : "Claim Medical Product or Service Value Set",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-26T16:21:43+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "name" : "HL7 International / Financial Management",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        },
        {
          "system" : "email",
          "value" : "fmlists@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "CPT - HCPCS - HIPPS - CDT codes to report medical procedures and services under public and private health insurance programs",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "copyright" : "Current Procedural Terminology (CPT) is copyright 2020 American Medical Association. All rights reserved.",
  "compose" : {
    "include" : [
      {
        "system" : "http://www.ama-assn.org/go/cpt"
      },
      {
        "system" : "http://www.ada.org/cdt"
      },
      {
        "system" : "http://www.cms.gov/Medicare/Coding/HCPCSReleaseCodeSets"
      },
      {
        "system" : "https://www.cms.gov/Medicare/Medicare-Fee-for-Service-Payment/ProspMedicareFeeSvcPmtGen/HIPPSCodes"
      },
      {
        "system" : "http://terminology.hl7.org/CodeSystem/data-absent-reason",
        "version" : "1.0.0",
        "concept" : [
          {
            "code" : "not-applicable",
            "display" : "Not Applicable"
          }
        ]
      }
    ]
  }
}

```
