# ICD-10 Procedure Codes - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ICD-10 Procedure Codes**

## ValueSet: ICD-10 Procedure Codes 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-pct/ValueSet/ICD10ProcedureCodes | *Version*:2.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:ICD10ProcedureCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.4.48.3 | | |

 
Procedure Codes from https://www.cms.gov/Medicare/Coding/ICD10 

 **References** 

* [PCT Good Faith Estimate Institutional](StructureDefinition-davinci-pct-gfe-institutional.md)
* [PCT Good Faith Estimate Summary](StructureDefinition-davinci-pct-gfe-summary.md)

**Changes since version 1.1.0:**

* No changes

### Logical Definition (CLD)

* Include all codes defined in [`http://www.cms.gov/Medicare/Coding/ICD10`](http://terminology.hl7.org/6.5.0/CodeSystem-icd10PCS.html)version Not Stated (use latest from terminology server)

 

### Expansion

Expansion from tx.fhir.org based on [codesystem ICD-10 Procedure Codes v2.0.1 (CodeSystem)](http://terminology.hl7.org/6.5.0/CodeSystem-icd10PCS.html)

This value set has >1000 codes in it. In order to keep the publication size manageable, only a selection (1000 codes) of the whole set of codes is shown

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "ICD10ProcedureCodes",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-pct/ImplementationGuide/hl7.fhir.us.davinci-pct"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-pct/ImplementationGuide/hl7.fhir.us.davinci-pct"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-pct/ValueSet/ICD10ProcedureCodes",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.4.48.3"
    }
  ],
  "version" : "2.0.0",
  "name" : "ICD10ProcedureCodes",
  "title" : "ICD-10 Procedure Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-26T16:21:43+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "name" : "HL7 International / Financial Management",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        },
        {
          "system" : "email",
          "value" : "fmlists@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "Procedure Codes from https://www.cms.gov/Medicare/Coding/ICD10",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://www.cms.gov/Medicare/Coding/ICD10"
      }
    ]
  }
}

```
