# NUBC Point Of Origin - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **NUBC Point Of Origin**

## ValueSet: NUBC Point Of Origin 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-pct/ValueSet/AHANUBCPointOfOriginVS | *Version*:2.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:AHANUBCPointOfOriginVS |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.4.48.1 | | |

 
The UB-04 Data File contains the complete set of NUBC codes. Every code in the range of possible codes is accounted for sequentially. 
There are no gaps because all used and unused codes are identified. This value set consists of the following: 
* FL 15 - Point of Origin for Admission or Visit for Non-newborn
* FL 15 - Point of Origin for Admission or Visit for Newborn
 
These codes are used to convey the patient point of origin for an admission or visit and are the property of the American Hospital Association. 
To obtain the underlying code systems, please see information[here](https://www.nubc.org/subscription-information)Statement of Understanding between AHA and HL7 can be found[here](http://www.hl7.org/documentcenter/public/mou/AHA%20HL7%20SOU%202020%20AHA%20Fully%20Executed.pdf). In particular see sections 4.1d and 4.2. 
The UB-04 Manual has a 12-month subscription period from June 30 through July 1. 
For frequently asked questions, see here[here](https://www.nubc.org/nubc-faqs) 

 **References** 

* [PCT Good Faith Estimate Institutional](StructureDefinition-davinci-pct-gfe-institutional.md)

**Changes since version 1.1.0:**

* No changes

### Logical Definition (CLD)

This value set includes codes based on the following rules:

* Include all codes defined in `http://terminology.hl7.org/CodeSystem/AHANUBCPointOfOriginNonnewborn`version Not Stated (use latest from terminology server)
* Include all codes defined in `http://terminology.hl7.org/CodeSystem/AHANUBCPointOfOriginNewborn`version Not Stated (use latest from terminology server)

 

### Expansion

No Expansion for this valueset (not supported by Publication Tooling)

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "AHANUBCPointOfOriginVS",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-pct/ImplementationGuide/hl7.fhir.us.davinci-pct"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-pct/ImplementationGuide/hl7.fhir.us.davinci-pct"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-pct/ValueSet/AHANUBCPointOfOriginVS",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.4.48.1"
    }
  ],
  "version" : "2.0.0",
  "name" : "AHANUBCPointOfOriginVS",
  "title" : "NUBC Point Of Origin",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-26T16:21:43+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "name" : "HL7 International / Financial Management",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        },
        {
          "system" : "email",
          "value" : "fmlists@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "The UB-04 Data File contains the complete set of NUBC codes. Every code in the range of possible codes is accounted for sequentially. \n\nThere are no gaps because all used and unused codes are identified. This value set consists of the following: \n* FL 15 - Point of Origin for Admission or Visit for Non-newborn\n* FL 15 - Point of Origin for Admission or Visit for Newborn\n\nThese codes are used to convey the patient point of origin for an admission or visit and are the property of the American Hospital Association.\n\nTo obtain the underlying code systems, please see information [here](https://www.nubc.org/subscription-information)\nStatement of Understanding between AHA and HL7 can be found [here](http://www.hl7.org/documentcenter/public/mou/AHA%20HL7%20SOU%202020%20AHA%20Fully%20Executed.pdf). In particular see sections 4.1d and 4.2.\n\nThe UB-04 Manual has a 12-month subscription period from June 30 through July 1.\n\nFor frequently asked questions, see here [here](https://www.nubc.org/nubc-faqs)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/AHANUBCPointOfOriginNonnewborn"
      },
      {
        "system" : "http://terminology.hl7.org/CodeSystem/AHANUBCPointOfOriginNewborn"
      }
    ]
  }
}

```
