# PCT-GFE-Coordination-Task-1 - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PCT-GFE-Coordination-Task-1**

## Example Task: PCT-GFE-Coordination-Task-1

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [PCT GFE Coordination Task](StructureDefinition-davinci-pct-gfe-coordination-task.md)

**Request Initiation Time**: 2024-03-27 11:01:00+0500

**Extension Definition for Task.requestedPeriod for Version 5.0**: ?? --> 2024-03-30 11:01:00+0500

**Planned Service Period**: 2024-04-27 10:00:00+0500 --> 2024-04-27 11:00:00+0500

**status**: Requested

**intent**: order

**code**: GFE Coordination Task

**requester**: [Organization GFE Service Help INC.](Organization-Submitter-Org-1.md)

**reasonCode**: Scheduled Service Request

### Inputs

| | | |
| :--- | :--- | :--- |
| - | **Type** | **Value[x]** |
| * | GFE Information Bundle | [Bundle: identifier = http://example.com/identifiers/bundle#59688475-2324-3242-2347384711; type = collection; timestamp = 2024-03-27 11:01:00+0500](Bundle-PCT-GFE-Information-Bundle-1.md) |



## Resource Content

```json
{
  "resourceType" : "Task",
  "id" : "PCT-GFE-Coordination-Task-1",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-coordination-task"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/requestInitiationTime",
      "valueInstant" : "2024-03-27T11:01:00+05:00"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Task.requestedPeriod",
      "valuePeriod" : {
        "end" : "2024-03-30T11:01:00+05:00"
      }
    },
    {
      "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/plannedServicePeriod",
      "valuePeriod" : {
        "start" : "2024-04-27T10:00:00+05:00",
        "end" : "2024-04-27T11:00:00+05:00"
      }
    }
  ],
  "status" : "requested",
  "intent" : "order",
  "code" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTGFERequestTypeCSTemporaryTrialUse",
        "code" : "gfe-coordination-task"
      }
    ]
  },
  "requester" : {
    "reference" : "Organization/Submitter-Org-1"
  },
  "reasonCode" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTGFERequestTypeCSTemporaryTrialUse",
        "code" : "scheduled-request"
      }
    ]
  },
  "input" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTDocumentTypeTemporaryTrialUse",
            "code" : "gfe-information-bundle"
          }
        ],
        "text" : "GFE Information Bundle"
      },
      "valueReference" : {
        "reference" : "Bundle/PCT-GFE-Information-Bundle-1"
      }
    }
  ]
}

```
