# Planned Service Period - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Planned Service Period**

## Extension: Planned Service Period 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-pct/StructureDefinition/plannedServicePeriod | *Version*:2.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:PlannedServicePeriod |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.4.42.33 | | |

Planned period of service the request is about

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [PCT GFE Contributor Task](StructureDefinition-davinci-pct-gfe-contributor-task.md) and [PCT GFE Coordination Task](StructureDefinition-davinci-pct-gfe-coordination-task.md)
* Examples for this Extension: [Bundle/PCT-GFE-Coordination-Bundle-1](Bundle-PCT-GFE-Coordination-Bundle-1.md), [Task/PCT-GFE-Contributor-Replacement-Task-1](Task-PCT-GFE-Contributor-Replacement-Task-1.md), [Task/PCT-GFE-Contributor-Replacement-Task-2](Task-PCT-GFE-Contributor-Replacement-Task-2.md), [Task/PCT-GFE-Contributor-Task-1](Task-PCT-GFE-Contributor-Task-1.md)...Show 3 more,[Task/PCT-GFE-Contributor-Task-2](Task-PCT-GFE-Contributor-Task-2.md),[Task/PCT-GFE-Coordination-Replacement-Task-1](Task-PCT-GFE-Coordination-Replacement-Task-1.md)and[Task/PCT-GFE-Coordination-Task-1](Task-PCT-GFE-Coordination-Task-1.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.davinci-pct|current/StructureDefinition/plannedServicePeriod)

**Changes since version 1.1.0:**

* New Content

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-plannedServicePeriod.csv), [Excel](StructureDefinition-plannedServicePeriod.xlsx), [Schematron](StructureDefinition-plannedServicePeriod.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "plannedServicePeriod",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-pct/ImplementationGuide/hl7.fhir.us.davinci-pct"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-pct/ImplementationGuide/hl7.fhir.us.davinci-pct"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/plannedServicePeriod",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.4.42.33"
    }
  ],
  "version" : "2.0.0",
  "name" : "PlannedServicePeriod",
  "title" : "Planned Service Period",
  "status" : "active",
  "date" : "2025-11-26T16:21:43+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "name" : "HL7 International / Financial Management",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        },
        {
          "system" : "email",
          "value" : "fmlists@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "Planned period of service the request is about",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Task"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Planned Service Period",
        "definition" : "Planned period of service the request is about"
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/plannedServicePeriod"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "short" : "Planned period of service the request is about",
        "min" : 1,
        "type" : [
          {
            "code" : "Period"
          }
        ]
      },
      {
        "id" : "Extension.value[x].start",
        "path" : "Extension.value[x].start",
        "min" : 1
      },
      {
        "id" : "Extension.value[x].end",
        "path" : "Extension.value[x].end",
        "mustSupport" : true
      }
    ]
  }
}

```
