# GFEServiceLinkingInfo - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **GFEServiceLinkingInfo**

## Extension: GFEServiceLinkingInfo 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-pct/StructureDefinition/gfeServiceLinkingInfo | *Version*:2.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:GFEServiceLinkingInfo |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.4.42.29 | | |

This extension is used to provide the GFE Service Linking Information. This allows implementers to have the same identifier on multiple GFEs that are part of one period of care's services. This would be needed for some of the workflow options that businesses may decide to use.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [PCT AEOB Packet Document Reference](StructureDefinition-davinci-pct-aeob-documentreference.md), [PCT GFE Composition](StructureDefinition-davinci-pct-gfe-composition.md), [PCT GFE Packet Document Reference](StructureDefinition-davinci-pct-gfe-documentreference.md), [PCT Good Faith Estimate Institutional](StructureDefinition-davinci-pct-gfe-institutional.md) and [PCT Good Faith Estimate Professional](StructureDefinition-davinci-pct-gfe-professional.md)
* Examples for this Extension: [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [Bundle/PCT-GFE-Bundle-Inst-1](Bundle-PCT-GFE-Bundle-Inst-1.md), [Bundle/PCT-GFE-Bundle-Prof-1](Bundle-PCT-GFE-Bundle-Prof-1.md), [Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md)...Show 4 more,[Bundle/PCT-GFE-Packet-Prof-1](Bundle-PCT-GFE-Packet-Prof-1.md),[Claim/PCT-GFE-Institutional-1](Claim-PCT-GFE-Institutional-1.md),[Claim/PCT-GFE-Institutional-MRI](Claim-PCT-GFE-Institutional-MRI.md)and[Claim/PCT-GFE-Professional-MRI](Claim-PCT-GFE-Professional-MRI.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.davinci-pct|current/StructureDefinition/gfeServiceLinkingInfo)

**Changes since version 1.1.0:**

* The data elements list has changed

* One or more text definitions, invariants or bindings have changed

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-gfeServiceLinkingInfo.csv), [Excel](StructureDefinition-gfeServiceLinkingInfo.xlsx), [Schematron](StructureDefinition-gfeServiceLinkingInfo.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "gfeServiceLinkingInfo",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-pct/ImplementationGuide/hl7.fhir.us.davinci-pct"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-pct/ImplementationGuide/hl7.fhir.us.davinci-pct"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/gfeServiceLinkingInfo",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.4.42.29"
    }
  ],
  "version" : "2.0.0",
  "name" : "GFEServiceLinkingInfo",
  "status" : "active",
  "date" : "2025-11-26T16:21:43+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "name" : "HL7 International / Financial Management",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        },
        {
          "system" : "email",
          "value" : "fmlists@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "This extension is used to provide the GFE Service Linking Information. This allows implementers to have the same identifier on multiple GFEs that are part of one period of care's services. This would be needed for some of the workflow options that businesses may decide to use.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Claim"
    },
    {
      "type" : "element",
      "expression" : "Composition"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "definition" : "This extension is used to provide the GFE Service Linking Information. This allows implementers to have the same identifier on multiple GFEs that are part of one period of care's services. This would be needed for some of the workflow options that businesses may decide to use."
      },
      {
        "id" : "Extension.extension:plannedPeriodOfService",
        "path" : "Extension.extension",
        "sliceName" : "plannedPeriodOfService",
        "short" : "A timeframe during which a patient is expected to receive healthcare services and/or items as outlined in a Good Faith Estimate (GFE).",
        "definition" : "A timeframe (scheduled or requested) during which a patient is expected to receive healthcare services generally related to a specific treatment goal, episode of care, or clinical objective as outlined in a Good Faith Estimate (GFE). This period typically begins with the initial scheduled service and includes all reasonably expected items and services that are associated with that primary service, even if rendered by different providers or facilities.",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Extension.extension:plannedPeriodOfService.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:plannedPeriodOfService.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "plannedPeriodOfService"
      },
      {
        "id" : "Extension.extension:plannedPeriodOfService.value[x]",
        "path" : "Extension.extension.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "date"
          },
          {
            "code" : "Period"
          }
        ]
      },
      {
        "id" : "Extension.extension:linkingIdentifier",
        "path" : "Extension.extension",
        "sliceName" : "linkingIdentifier",
        "short" : "An identifier assigned to a particular service or series of services, generally by a scheduling facility, to be used by all providers and practitioners who will be submitting a GFE for a patient's care.",
        "definition" : "An identifier assigned to a particular service or series of services, generally by a scheduling facility, to be used by all providers and practitioners who will be submitting a GFE for a patient's care.",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Extension.extension:linkingIdentifier.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:linkingIdentifier.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "linkingIdentifier"
      },
      {
        "id" : "Extension.extension:linkingIdentifier.value[x]",
        "path" : "Extension.extension.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "Extension.extension:linkingIdentifier.value[x].system",
        "path" : "Extension.extension.value[x].system",
        "min" : 1
      },
      {
        "id" : "Extension.extension:linkingIdentifier.value[x].value",
        "path" : "Extension.extension.value[x].value",
        "min" : 1
      },
      {
        "id" : "Extension.extension:anticipatedSubmittingProviderCount",
        "path" : "Extension.extension",
        "sliceName" : "anticipatedSubmittingProviderCount",
        "short" : "Total number of providers that are expected to submit GFEs.",
        "definition" : "The total number of providers that are expected to submit a GFE as part of a planned period of service or estimate request. This number includes all co-provider and the convening provider (if the convening provider is submitting a GFE). If this value is provided in more than one resource and there is a conflict in the number, the extension as part of the GFE Composition as part of the GFE Packet will be the definitive number.",
        "comment" : "The count of GFE submitting providers is useful for an intermediary or a payer that is collating multiple GFE submissions from multiple providers. This element is highly recommended if there are GFEs that will be submitted from multiple providers and is not needed if there is only a single submitting provider (e.g. only a single provider GFE or is the GFE Coordination process was done before submitting the GFE Packet).",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Extension.extension:anticipatedSubmittingProviderCount.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:anticipatedSubmittingProviderCount.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "anticipatedSubmittingProviderCount"
      },
      {
        "id" : "Extension.extension:anticipatedSubmittingProviderCount.value[x]",
        "path" : "Extension.extension.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "unsignedInt"
          }
        ]
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/gfeServiceLinkingInfo"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "max" : "0"
      }
    ]
  }
}

```
