# PCT Good Faith Estimate Summary - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PCT Good Faith Estimate Summary**

## Resource Profile: PCT Good Faith Estimate Summary 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-summary | *Version*:2.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:PCTGFESummary |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.4.42.17 | | |

 
PCT Good Faith Estimate Summary is a profile for summarizing costs associated with a set of Good Faith Estimate Claims for a single Period of Care. 

**Usages:**

* Use this Profile: [PCT GFE Bundle](StructureDefinition-davinci-pct-gfe-bundle.md)
* Examples for this Profile: [Claim/PCT-GFE-Summary-1](Claim-PCT-GFE-Summary-1.md) and [Claim/PCT-GFE-Summary-MRI](Claim-PCT-GFE-Summary-MRI.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.davinci-pct|current/StructureDefinition/davinci-pct-gfe-summary)

**Changes since version 1.1.0:**

* New Content

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-davinci-pct-gfe-summary.csv), [Excel](StructureDefinition-davinci-pct-gfe-summary.xlsx), [Schematron](StructureDefinition-davinci-pct-gfe-summary.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "davinci-pct-gfe-summary",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-summary",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.4.42.17"
    }
  ],
  "version" : "2.0.0",
  "name" : "PCTGFESummary",
  "title" : "PCT Good Faith Estimate  Summary",
  "status" : "active",
  "date" : "2025-11-26T16:21:43+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "name" : "HL7 International / Financial Management",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        },
        {
          "system" : "email",
          "value" : "fmlists@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "PCT Good Faith Estimate Summary is a profile for summarizing costs associated with a set of Good Faith Estimate Claims for a single Period of Care.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Claim",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Claim",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Claim.extension",
        "path" : "Claim.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Claim.extension:gfeDisclaimer",
        "path" : "Claim.extension",
        "sliceName" : "gfeDisclaimer",
        "short" : "Disclaimers the patient should be made aware of regarding the estimate, e.g. application of sliding scale for self-pay/uninsured patients",
        "definition" : "Disclaimers the patient should be made aware of regarding the providers estimate including any additional assumptions and requirements.  Noting that that the information provided is only an estimate based on the items and services reasonably expected, at the time of scheduling (or requesting) the item or service, to be furnished and is subject to change.",
        "comment" : "These disclaimers may include, but are not limited to things such as: provider discounts (e.g. application of sliding fee scale),  limitations, preconditions, requirements, assumptions (e.g. diagnostic vs. preventative), information known to be missing in the estimate, conditions that may affect the estimate, or anything that may affect the interpretation of the estimate.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/gfeDisclaimer"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Claim.extension:serviceDescription",
        "path" : "Claim.extension",
        "sliceName" : "serviceDescription",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/serviceDescription"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Claim.type",
        "path" : "Claim.type",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTEstimateTypeSummaryCSTemporaryTrialUse",
              "code" : "estimate-summary"
            }
          ]
        }
      },
      {
        "id" : "Claim.subType",
        "path" : "Claim.subType",
        "max" : "0"
      },
      {
        "id" : "Claim.use",
        "path" : "Claim.use",
        "patternCode" : "predetermination"
      },
      {
        "id" : "Claim.patient",
        "path" : "Claim.patient",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient|7.0.0"
            ]
          }
        ]
      },
      {
        "id" : "Claim.billablePeriod",
        "path" : "Claim.billablePeriod",
        "short" : "The full Period of Care for all services or products included in the estimate from the first event to the last event.",
        "mustSupport" : true
      },
      {
        "id" : "Claim.enterer",
        "path" : "Claim.enterer",
        "max" : "0"
      },
      {
        "id" : "Claim.insurer",
        "path" : "Claim.insurer",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-organization"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Claim.provider.extension",
        "path" : "Claim.provider.extension",
        "min" : 1
      },
      {
        "id" : "Claim.provider.extension:dataAbsentReason",
        "path" : "Claim.provider.extension",
        "sliceName" : "dataAbsentReason",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/data-absent-reason|5.2.0"
            ]
          }
        ]
      },
      {
        "id" : "Claim.provider.extension:dataAbsentReason.value[x]",
        "path" : "Claim.provider.extension.value[x]",
        "patternCode" : "not-applicable"
      },
      {
        "id" : "Claim.provider.reference",
        "path" : "Claim.provider.reference",
        "max" : "0"
      },
      {
        "id" : "Claim.provider.type",
        "path" : "Claim.provider.type",
        "max" : "0"
      },
      {
        "id" : "Claim.provider.identifier",
        "path" : "Claim.provider.identifier",
        "max" : "0"
      },
      {
        "id" : "Claim.provider.display",
        "path" : "Claim.provider.display",
        "max" : "0"
      },
      {
        "id" : "Claim.priority",
        "path" : "Claim.priority",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/process-priority"
        }
      },
      {
        "id" : "Claim.fundsReserve",
        "path" : "Claim.fundsReserve",
        "max" : "0"
      },
      {
        "id" : "Claim.prescription",
        "path" : "Claim.prescription",
        "max" : "0"
      },
      {
        "id" : "Claim.originalPrescription",
        "path" : "Claim.originalPrescription",
        "max" : "0"
      },
      {
        "id" : "Claim.payee",
        "path" : "Claim.payee",
        "max" : "0"
      },
      {
        "id" : "Claim.referral",
        "path" : "Claim.referral",
        "max" : "0"
      },
      {
        "id" : "Claim.facility",
        "path" : "Claim.facility",
        "max" : "0"
      },
      {
        "id" : "Claim.careTeam",
        "path" : "Claim.careTeam",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "role"
            }
          ],
          "description" : "Slice based on $this value",
          "ordered" : false,
          "rules" : "open"
        },
        "mustSupport" : true
      },
      {
        "id" : "Claim.careTeam.provider",
        "path" : "Claim.careTeam.provider",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-practitioner",
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-organization"
            ]
          }
        ]
      },
      {
        "id" : "Claim.careTeam.role",
        "path" : "Claim.careTeam.role",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/davinci-pct/ValueSet/PCTCareTeamRoleVS"
        }
      },
      {
        "id" : "Claim.careTeam.qualification",
        "path" : "Claim.careTeam.qualification",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/core/ValueSet/us-core-provider-role"
        }
      },
      {
        "id" : "Claim.careTeam:attending",
        "path" : "Claim.careTeam",
        "sliceName" : "attending",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Claim.careTeam:attending.provider",
        "path" : "Claim.careTeam.provider",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-practitioner"
            ]
          }
        ]
      },
      {
        "id" : "Claim.careTeam:attending.role",
        "path" : "Claim.careTeam.role",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/claimcareteamrole",
              "version" : "1.0.1",
              "code" : "attending"
            }
          ]
        }
      },
      {
        "id" : "Claim.careTeam:attending.qualification",
        "path" : "Claim.careTeam.qualification",
        "min" : 1
      },
      {
        "id" : "Claim.careTeam:operating",
        "path" : "Claim.careTeam",
        "sliceName" : "operating",
        "min" : 0,
        "max" : "2",
        "mustSupport" : true
      },
      {
        "id" : "Claim.careTeam:operating.provider",
        "path" : "Claim.careTeam.provider",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-practitioner"
            ]
          }
        ]
      },
      {
        "id" : "Claim.careTeam:operating.role",
        "path" : "Claim.careTeam.role",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/claimcareteamrole",
              "version" : "1.0.1",
              "code" : "operating"
            }
          ]
        }
      },
      {
        "id" : "Claim.careTeam:rendering",
        "path" : "Claim.careTeam",
        "sliceName" : "rendering",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Claim.careTeam:rendering.provider",
        "path" : "Claim.careTeam.provider",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-practitioner"
            ]
          }
        ]
      },
      {
        "id" : "Claim.careTeam:rendering.role",
        "path" : "Claim.careTeam.role",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/claimcareteamrole",
              "version" : "1.0.1",
              "code" : "rendering"
            }
          ]
        }
      },
      {
        "id" : "Claim.careTeam:referring",
        "path" : "Claim.careTeam",
        "sliceName" : "referring",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Claim.careTeam:referring.role",
        "path" : "Claim.careTeam.role",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/claimcareteamrole",
              "version" : "1.0.1",
              "code" : "referring"
            }
          ]
        }
      },
      {
        "id" : "Claim.supportingInfo",
        "path" : "Claim.supportingInfo",
        "max" : "0"
      },
      {
        "id" : "Claim.diagnosis",
        "path" : "Claim.diagnosis",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "type"
            }
          ],
          "description" : "Slice based on $this value",
          "ordered" : false,
          "rules" : "open"
        },
        "mustSupport" : true
      },
      {
        "id" : "Claim.diagnosis.type",
        "path" : "Claim.diagnosis.type",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://terminology.hl7.org/ValueSet/diagnosistype"
        }
      },
      {
        "id" : "Claim.diagnosis:principal",
        "path" : "Claim.diagnosis",
        "sliceName" : "principal",
        "short" : "Principal Diagnosis - Must Support means the information source SHALL be capable of populating and SHALL populate if available and permitted.",
        "comment" : "If the Principal Diagnosis code is known, it is important that it be shared in the GFE, particularly when the GFE is being sent to a payer for an insured patient. Payers very often need the diagnosis to be able to provide an estimate. Without the diagnosis, payers may assume the service is diagnostic and thus the patient responsibility may be higher or not covered at all than the diagnosis, such as for preventative services, would otherwise indicate. It is understood that in certain situations, such as scheduled services or GFE requests prior to orders, diagnosis is not needed or may not yet be known. However, when it is known, it is important that this information be shared to ensure the best possible estimate is provided to the patient.",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Claim.diagnosis:principal.sequence",
        "path" : "Claim.diagnosis.sequence",
        "patternPositiveInt" : 1
      },
      {
        "id" : "Claim.diagnosis:principal.diagnosis[x]",
        "path" : "Claim.diagnosis.diagnosis[x]",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/davinci-pct/ValueSet/PCTDiagnosticCodes"
        }
      },
      {
        "id" : "Claim.diagnosis:principal.type",
        "path" : "Claim.diagnosis.type",
        "min" : 1,
        "max" : "1",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/diagnosistype",
              "code" : "principal"
            }
          ]
        }
      },
      {
        "id" : "Claim.diagnosis:admitting",
        "path" : "Claim.diagnosis",
        "sliceName" : "admitting",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Claim.diagnosis:admitting.diagnosis[x]",
        "path" : "Claim.diagnosis.diagnosis[x]",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/davinci-pct/ValueSet/PCTDiagnosticCodes"
        }
      },
      {
        "id" : "Claim.diagnosis:admitting.type",
        "path" : "Claim.diagnosis.type",
        "min" : 1,
        "max" : "1",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/diagnosistype",
              "code" : "admitting"
            }
          ]
        }
      },
      {
        "id" : "Claim.diagnosis:patientReasonForVisit",
        "path" : "Claim.diagnosis",
        "sliceName" : "patientReasonForVisit",
        "min" : 0,
        "max" : "3",
        "mustSupport" : true
      },
      {
        "id" : "Claim.diagnosis:patientReasonForVisit.diagnosis[x]",
        "path" : "Claim.diagnosis.diagnosis[x]",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/davinci-pct/ValueSet/PCTDiagnosticCodes"
        }
      },
      {
        "id" : "Claim.diagnosis:patientReasonForVisit.type",
        "path" : "Claim.diagnosis.type",
        "min" : 1,
        "max" : "1",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/diagnosistype",
              "code" : "patientreasonforvisit"
            }
          ]
        }
      },
      {
        "id" : "Claim.diagnosis:externalcauseofinjury",
        "path" : "Claim.diagnosis",
        "sliceName" : "externalcauseofinjury",
        "min" : 0,
        "max" : "12",
        "mustSupport" : true
      },
      {
        "id" : "Claim.diagnosis:externalcauseofinjury.diagnosis[x]",
        "path" : "Claim.diagnosis.diagnosis[x]",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/davinci-pct/ValueSet/PCTDiagnosticCodes"
        }
      },
      {
        "id" : "Claim.diagnosis:externalcauseofinjury.type",
        "path" : "Claim.diagnosis.type",
        "min" : 1,
        "max" : "1",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/diagnosistype",
              "code" : "externalcauseofinjury"
            }
          ]
        }
      },
      {
        "id" : "Claim.diagnosis:other",
        "path" : "Claim.diagnosis",
        "sliceName" : "other",
        "min" : 0,
        "max" : "24",
        "mustSupport" : true
      },
      {
        "id" : "Claim.diagnosis:other.diagnosis[x]",
        "path" : "Claim.diagnosis.diagnosis[x]",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/davinci-pct/ValueSet/PCTDiagnosticCodes"
        }
      },
      {
        "id" : "Claim.diagnosis:other.type",
        "path" : "Claim.diagnosis.type",
        "min" : 1,
        "max" : "1",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/diagnosistype",
              "code" : "secondary"
            }
          ]
        }
      },
      {
        "id" : "Claim.procedure",
        "path" : "Claim.procedure",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "type"
            }
          ],
          "description" : "Slice based on $this value",
          "ordered" : false,
          "rules" : "open"
        },
        "mustSupport" : true
      },
      {
        "id" : "Claim.procedure.extension",
        "path" : "Claim.procedure.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Claim.procedure.extension:serviceDescription",
        "path" : "Claim.procedure.extension",
        "sliceName" : "serviceDescription",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/serviceDescription"
            ]
          }
        ]
      },
      {
        "id" : "Claim.procedure.type",
        "path" : "Claim.procedure.type",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/davinci-pct/ValueSet/PCTProcedureTypeVS"
        }
      },
      {
        "id" : "Claim.procedure:principal",
        "path" : "Claim.procedure",
        "sliceName" : "principal",
        "short" : "Principal clinical procedure performed",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Claim.procedure:principal.extension:serviceDescription",
        "path" : "Claim.procedure.extension",
        "sliceName" : "serviceDescription",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/serviceDescription"
            ]
          }
        ]
      },
      {
        "id" : "Claim.procedure:principal.sequence",
        "path" : "Claim.procedure.sequence",
        "patternPositiveInt" : 1
      },
      {
        "id" : "Claim.procedure:principal.type",
        "path" : "Claim.procedure.type",
        "min" : 1,
        "max" : "1",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTProcedureType",
              "code" : "principal"
            }
          ]
        }
      },
      {
        "id" : "Claim.procedure:principal.procedure[x]",
        "path" : "Claim.procedure.procedure[x]",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/davinci-pct/ValueSet/ICD10ProcedureCodes"
        }
      },
      {
        "id" : "Claim.procedure:anesthesiaRelated",
        "path" : "Claim.procedure",
        "sliceName" : "anesthesiaRelated",
        "min" : 0,
        "max" : "2",
        "mustSupport" : true
      },
      {
        "id" : "Claim.procedure:anesthesiaRelated.extension:serviceDescription",
        "path" : "Claim.procedure.extension",
        "sliceName" : "serviceDescription",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/serviceDescription"
            ]
          }
        ]
      },
      {
        "id" : "Claim.procedure:anesthesiaRelated.type",
        "path" : "Claim.procedure.type",
        "min" : 1,
        "max" : "1",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTProcedureType",
              "code" : "procedureRequiringAnesthesia"
            }
          ]
        }
      },
      {
        "id" : "Claim.procedure:anesthesiaRelated.procedure[x]",
        "path" : "Claim.procedure.procedure[x]",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/davinci-pct/ValueSet/PCTProcedureSurgicalCodes"
        }
      },
      {
        "id" : "Claim.procedure:other",
        "path" : "Claim.procedure",
        "sliceName" : "other",
        "min" : 0,
        "max" : "24",
        "mustSupport" : true
      },
      {
        "id" : "Claim.procedure:other.extension:serviceDescription",
        "path" : "Claim.procedure.extension",
        "sliceName" : "serviceDescription",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/serviceDescription"
            ]
          }
        ]
      },
      {
        "id" : "Claim.procedure:other.type",
        "path" : "Claim.procedure.type",
        "min" : 1,
        "max" : "1",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTProcedureType",
              "code" : "other"
            }
          ]
        }
      },
      {
        "id" : "Claim.procedure:other.procedure[x]",
        "path" : "Claim.procedure.procedure[x]",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/davinci-pct/ValueSet/PCTProcedureSurgicalCodes"
        }
      },
      {
        "id" : "Claim.insurance.coverage",
        "path" : "Claim.insurance.coverage",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-coverage"
            ]
          }
        ]
      },
      {
        "id" : "Claim.insurance.preAuthRef",
        "path" : "Claim.insurance.preAuthRef",
        "max" : "0"
      },
      {
        "id" : "Claim.accident.location[x]",
        "path" : "Claim.accident.location[x]",
        "type" : [
          {
            "code" : "Address"
          }
        ]
      },
      {
        "id" : "Claim.accident.location[x].country",
        "path" : "Claim.accident.location[x].country",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/iso3166-1-2"
        }
      },
      {
        "id" : "Claim.item",
        "path" : "Claim.item",
        "max" : "0"
      },
      {
        "id" : "Claim.total",
        "path" : "Claim.total",
        "short" : "Total GFE Charges",
        "min" : 1
      }
    ]
  }
}

```
