# PCT Good Faith Estimate Professional - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PCT Good Faith Estimate Professional**

## Resource Profile: PCT Good Faith Estimate Professional 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-professional | *Version*:2.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:PCTGFEProfessional |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.4.42.14 | | |

 
PCT Good Faith Estimate Professional is a profile for an professional provider to capture estimation for items and services for the patient or, optionally, to submit to a payer (for patients using insurance). If submitting to a payer, this includes the data needed to be processed by a payer for the creation of an Advanced EOB. This profile is used for a professional GFE submission. 

#### Notes on Fields

* The estimated service date, when available at the header level, is placed in Claim.billablePeriod. If the estimated date of service is available at the line level it is placed in Claim.item.serviced[x]. 
* **diagnosis:principal** - If Diagnosis code(s) is known, it is important that it be shared in the GFE through the Claim.diagnosis:principal or additional diagnosis data elements particularly when the GFE is being sent to a payer for an insured patient. Payers very often need the diagnosis to be able to provide an estimate. Without the diagnosis, payers may assume the service is diagnostic and thus the patient responsibility may be higher or not covered at all than the diagnosis, such as for preventative services, would otherwise indicate. It is understood that in certain situations, such as scheduled services or GFE requests prior to orders, diagnosis is not needed or may not yet be known. However, when it is known, it is important that this information be shared to ensure the best possible estimate is provided to the patient.

#### Examples of .providerEventMethodology usage examples below:

##### Example 1 – A provider is offering both a surgical and a drug therapy-based option to the patient. The provider can add text such as "Surgical care option" and "Drug therapy option" to the GFE so that the patient could easily understand the options without having to understand different CPT codes.

**Usages:**

* Use this Profile: [PCT GFE Bundle](StructureDefinition-davinci-pct-gfe-bundle.md)
* Examples for this Profile: [Claim/PCT-GFE-Professional-MRI](Claim-PCT-GFE-Professional-MRI.md)
* CapabilityStatements using this Profile: [Patient Cost Transparency Implementation Guide Payer Capability Statement](CapabilityStatement-davinci-pct.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.davinci-pct|current/StructureDefinition/davinci-pct-gfe-professional)

**Changes since version 1.1.0:**

* The resource metadata has changed (description)

* The data elements list has changed

* One or more text definitions, invariants or bindings have changed

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-davinci-pct-gfe-professional.csv), [Excel](StructureDefinition-davinci-pct-gfe-professional.xlsx), [Schematron](StructureDefinition-davinci-pct-gfe-professional.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "davinci-pct-gfe-professional",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-professional",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.4.42.14"
    }
  ],
  "version" : "2.0.0",
  "name" : "PCTGFEProfessional",
  "title" : "PCT Good Faith Estimate Professional",
  "status" : "active",
  "date" : "2025-11-26T16:21:43+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "name" : "HL7 International / Financial Management",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        },
        {
          "system" : "email",
          "value" : "fmlists@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "PCT Good Faith Estimate Professional is a profile for an professional provider to capture estimation for  items and services for the patient or, optionally, to submit to a payer (for patients using insurance). If submitting to a payer, this includes the data needed to be processed by a payer for the creation of an Advanced EOB. This profile is used for a professional GFE submission.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Claim",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Claim",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Claim.extension",
        "path" : "Claim.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Claim.extension:gfeServiceLinkingInfo",
        "path" : "Claim.extension",
        "sliceName" : "gfeServiceLinkingInfo",
        "short" : "GFE Service Linking Information",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/gfeServiceLinkingInfo"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Claim.extension:providerEventMethodology",
        "path" : "Claim.extension",
        "sliceName" : "providerEventMethodology",
        "short" : "Provider event collection methodology",
        "definition" : "How the provider determined the number of claims and the number and type of billing providers to include in the GFE. Examples include provider episodes of care experience, PACES, order set based on clinical guidelines, payor suggested grouping, or some other method of determination. The extension definition contains additional detail.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/providerEventMethodology"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Claim.extension:gfeDisclaimer",
        "path" : "Claim.extension",
        "sliceName" : "gfeDisclaimer",
        "short" : "Disclaimers the patient should be made aware of regarding the providers estimate, e.g. application of sliding scale for self-pay/uninsured patients",
        "definition" : "Disclaimers the patient should be made aware of regarding the providers estimate including any additional assumptions and requirements.  Noting that that the information provided is only an estimate based on the items and services reasonably expected, at the time of scheduling (or requesting) the item or service, to be furnished and is subject to change.",
        "comment" : "These disclaimers may include, but are not limited to things such as: provider discounts (e.g. application of sliding fee scale), limitations, preconditions, requirements, assumptions (e.g. diagnostic vs. preventative), information known to be missing in the estimate, conditions that may affect the estimate, or anything that may affect the interpretation of the estimate.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/gfeDisclaimer"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Claim.identifier",
        "path" : "Claim.identifier",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "type"
            }
          ],
          "description" : "Slice based on type value",
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Claim.identifier:PLAC",
        "path" : "Claim.identifier",
        "sliceName" : "PLAC",
        "short" : "Provider Assigned Identifier for GFE Claim",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Claim.identifier:PLAC.type",
        "path" : "Claim.identifier.type",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
              "code" : "PLAC",
              "display" : "Placer Identifier"
            }
          ]
        }
      },
      {
        "id" : "Claim.identifier:PLAC.system",
        "path" : "Claim.identifier.system",
        "mustSupport" : true
      },
      {
        "id" : "Claim.identifier:PLAC.value",
        "path" : "Claim.identifier.value",
        "min" : 1
      },
      {
        "id" : "Claim.type",
        "path" : "Claim.type",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/claim-type",
              "code" : "professional"
            }
          ]
        }
      },
      {
        "id" : "Claim.use",
        "path" : "Claim.use",
        "patternCode" : "predetermination"
      },
      {
        "id" : "Claim.patient",
        "path" : "Claim.patient",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient|7.0.0"
            ]
          }
        ]
      },
      {
        "id" : "Claim.insurer",
        "path" : "Claim.insurer",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-organization"
            ]
          }
        ]
      },
      {
        "id" : "Claim.provider",
        "path" : "Claim.provider",
        "short" : "Billing provider - party responsible for the GFE",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-organization",
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-practitioner"
            ]
          }
        ]
      },
      {
        "id" : "Claim.provider.extension",
        "path" : "Claim.provider.extension",
        "min" : 1
      },
      {
        "id" : "Claim.provider.extension:providerTaxonomy",
        "path" : "Claim.provider.extension",
        "sliceName" : "providerTaxonomy",
        "short" : "Provider taxonomy codes consisting of NUCC Health Care Provider Taxonomy Code Set for providers",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/providerTaxonomy"
            ]
          }
        ]
      },
      {
        "id" : "Claim.provider.extension:consentForBalanceBilling",
        "path" : "Claim.provider.extension",
        "sliceName" : "consentForBalanceBilling",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/gfeConsentForBalanceBilling"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Claim.priority",
        "path" : "Claim.priority",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/process-priority"
        }
      },
      {
        "id" : "Claim.payee",
        "path" : "Claim.payee",
        "mustSupport" : true
      },
      {
        "id" : "Claim.payee.party",
        "path" : "Claim.payee.party",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-practitioner",
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-organization"
            ]
          }
        ]
      },
      {
        "id" : "Claim.referral.extension",
        "path" : "Claim.referral.extension",
        "min" : 1
      },
      {
        "id" : "Claim.referral.extension:referralNumber",
        "path" : "Claim.referral.extension",
        "sliceName" : "referralNumber",
        "short" : "Referral Number",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/referralNumber"
            ]
          }
        ]
      },
      {
        "id" : "Claim.careTeam",
        "path" : "Claim.careTeam",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "role"
            }
          ],
          "description" : "Slice based on $this value",
          "ordered" : false,
          "rules" : "open"
        },
        "mustSupport" : true
      },
      {
        "id" : "Claim.careTeam.provider",
        "path" : "Claim.careTeam.provider",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-practitioner",
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-organization"
            ]
          }
        ]
      },
      {
        "id" : "Claim.careTeam.role",
        "path" : "Claim.careTeam.role",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/davinci-pct/ValueSet/PCTCareTeamRoleVS"
        }
      },
      {
        "id" : "Claim.careTeam.qualification",
        "path" : "Claim.careTeam.qualification",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/core/ValueSet/us-core-provider-role"
        }
      },
      {
        "id" : "Claim.careTeam:rendering",
        "path" : "Claim.careTeam",
        "sliceName" : "rendering",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Claim.careTeam:rendering.role",
        "path" : "Claim.careTeam.role",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/claimcareteamrole",
              "version" : "1.0.1",
              "code" : "rendering"
            }
          ]
        }
      },
      {
        "id" : "Claim.careTeam:rendering.qualification",
        "path" : "Claim.careTeam.qualification",
        "short" : "Practitioner credential or specialization - must provide a taxonomy code for the Professional case",
        "min" : 1
      },
      {
        "id" : "Claim.careTeam:referring",
        "path" : "Claim.careTeam",
        "sliceName" : "referring",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Claim.careTeam:referring.role",
        "path" : "Claim.careTeam.role",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/claimcareteamrole",
              "version" : "1.0.1",
              "code" : "referring"
            }
          ]
        }
      },
      {
        "id" : "Claim.supportingInfo",
        "path" : "Claim.supportingInfo",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "category"
            }
          ],
          "description" : "Slice based on $this value",
          "ordered" : false,
          "rules" : "open"
        },
        "mustSupport" : true
      },
      {
        "id" : "Claim.supportingInfo.category",
        "path" : "Claim.supportingInfo.category",
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.org/fhir/us/davinci-pct/ValueSet/PCTSupportingInfoTypeVS"
        }
      },
      {
        "id" : "Claim.supportingInfo:serviceFacility",
        "path" : "Claim.supportingInfo",
        "sliceName" : "serviceFacility",
        "short" : "Service Facility",
        "comment" : "Service Facility Location information conveys the name, full address and identifier of the facility where services were rendered when that is different from the Billing/Performing Provider.",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Claim.supportingInfo:serviceFacility.category",
        "path" : "Claim.supportingInfo.category",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTSupportingInfoType",
              "code" : "servicefacility"
            }
          ]
        }
      },
      {
        "id" : "Claim.supportingInfo:serviceFacility.value[x]",
        "path" : "Claim.supportingInfo.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Claim.supportingInfo:serviceFacility.value[x]:valueReference",
        "path" : "Claim.supportingInfo.value[x]",
        "sliceName" : "valueReference",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-organization"
            ]
          }
        ]
      },
      {
        "id" : "Claim.supportingInfo:claimFrequency",
        "path" : "Claim.supportingInfo",
        "sliceName" : "claimFrequency",
        "short" : "Claim Frequency component of the UB-04 Type of Bill Code (4th digit of the UB-04 Type of Bill code).",
        "comment" : "For the purposes of Patient Cost Transparency Estimates, this field may be used to modify or replace a GFE claim estimate within the same GFE Packet submission. This specification does not support the modification of Claim resources outside of the GFE Packet and client systems SHALL NOT expect the inclusion of the frequency code to affect the use or interpretation of any Claim outside of the GFE Packet.",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Claim.supportingInfo:claimFrequency.category",
        "path" : "Claim.supportingInfo.category",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTSupportingInfoType",
              "code" : "claimFrequency"
            }
          ]
        }
      },
      {
        "id" : "Claim.supportingInfo:claimFrequency.code",
        "path" : "Claim.supportingInfo.code",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/davinci-pct/ValueSet/PCTGFETypeOfBillVS"
        }
      },
      {
        "id" : "Claim.diagnosis",
        "path" : "Claim.diagnosis",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "type"
            }
          ],
          "description" : "Slice based on $this value",
          "ordered" : false,
          "rules" : "open"
        },
        "mustSupport" : true
      },
      {
        "id" : "Claim.diagnosis.type",
        "path" : "Claim.diagnosis.type",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://terminology.hl7.org/ValueSet/diagnosistype"
        }
      },
      {
        "id" : "Claim.diagnosis:principal",
        "path" : "Claim.diagnosis",
        "sliceName" : "principal",
        "short" : "Principal Diagnosis - Must Support means the information source SHALL be capable of populating and SHALL populate if available and permitted.",
        "comment" : "If the Principal Diagnosis code is known, it is important that it be shared in the GFE, particularly when the GFE is being sent to a payer for an insured patient. Payers very often need the diagnosis to be able to provide an estimate. Without the diagnosis, payers may assume the service is diagnostic and thus the patient responsibility may be higher or not covered at all than the diagnosis, such as for preventative services, would otherwise indicate. It is understood that in certain situations, such as scheduled services or GFE requests prior to orders, diagnosis is not needed or may not yet be known. However, when it is known, it is important that this information be shared to ensure the best possible estimate is provided to the patient.",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Claim.diagnosis:principal.sequence",
        "path" : "Claim.diagnosis.sequence",
        "patternPositiveInt" : 1
      },
      {
        "id" : "Claim.diagnosis:principal.diagnosis[x]",
        "path" : "Claim.diagnosis.diagnosis[x]",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/davinci-pct/ValueSet/PCTDiagnosticCodes"
        }
      },
      {
        "id" : "Claim.diagnosis:principal.type",
        "path" : "Claim.diagnosis.type",
        "min" : 1,
        "max" : "1",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/diagnosistype",
              "code" : "principal"
            }
          ]
        }
      },
      {
        "id" : "Claim.diagnosis:other",
        "path" : "Claim.diagnosis",
        "sliceName" : "other",
        "min" : 0,
        "max" : "11",
        "mustSupport" : true
      },
      {
        "id" : "Claim.diagnosis:other.diagnosis[x]",
        "path" : "Claim.diagnosis.diagnosis[x]",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/davinci-pct/ValueSet/PCTDiagnosticCodes"
        }
      },
      {
        "id" : "Claim.diagnosis:other.type",
        "path" : "Claim.diagnosis.type",
        "min" : 1,
        "max" : "1",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/diagnosistype",
              "code" : "secondary"
            }
          ]
        }
      },
      {
        "id" : "Claim.procedure",
        "path" : "Claim.procedure",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "type"
            }
          ],
          "description" : "Slice based on $this value",
          "ordered" : false,
          "rules" : "open"
        },
        "mustSupport" : true
      },
      {
        "id" : "Claim.procedure.extension",
        "path" : "Claim.procedure.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Claim.procedure.extension:serviceDescription",
        "path" : "Claim.procedure.extension",
        "sliceName" : "serviceDescription",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/serviceDescription"
            ]
          }
        ]
      },
      {
        "id" : "Claim.procedure.type",
        "path" : "Claim.procedure.type",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/davinci-pct/ValueSet/PCTProcedureTypeVS"
        }
      },
      {
        "id" : "Claim.procedure:anesthesiaRelated",
        "path" : "Claim.procedure",
        "sliceName" : "anesthesiaRelated",
        "min" : 0,
        "max" : "2",
        "mustSupport" : true
      },
      {
        "id" : "Claim.procedure:anesthesiaRelated.extension:serviceDescription",
        "path" : "Claim.procedure.extension",
        "sliceName" : "serviceDescription",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/serviceDescription"
            ]
          }
        ]
      },
      {
        "id" : "Claim.procedure:anesthesiaRelated.type",
        "path" : "Claim.procedure.type",
        "min" : 1,
        "max" : "1",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTProcedureType",
              "code" : "procedureRequiringAnesthesia"
            }
          ]
        }
      },
      {
        "id" : "Claim.procedure:anesthesiaRelated.procedure[x]",
        "path" : "Claim.procedure.procedure[x]",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/davinci-pct/ValueSet/PCTProcedureSurgicalCodes"
        }
      },
      {
        "id" : "Claim.procedure:other",
        "path" : "Claim.procedure",
        "sliceName" : "other",
        "min" : 0,
        "max" : "24",
        "mustSupport" : true
      },
      {
        "id" : "Claim.procedure:other.extension:serviceDescription",
        "path" : "Claim.procedure.extension",
        "sliceName" : "serviceDescription",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/serviceDescription"
            ]
          }
        ]
      },
      {
        "id" : "Claim.procedure:other.type",
        "path" : "Claim.procedure.type",
        "min" : 1,
        "max" : "1",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTProcedureType",
              "code" : "other"
            }
          ]
        }
      },
      {
        "id" : "Claim.procedure:other.procedure[x]",
        "path" : "Claim.procedure.procedure[x]",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/davinci-pct/ValueSet/PCTProcedureSurgicalCodes"
        }
      },
      {
        "id" : "Claim.insurance.coverage",
        "path" : "Claim.insurance.coverage",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-coverage"
            ]
          }
        ]
      },
      {
        "id" : "Claim.insurance.coverage.extension:dataAbsentReason",
        "path" : "Claim.insurance.coverage.extension",
        "sliceName" : "dataAbsentReason",
        "short" : "Coverage may be not applicable if estimate is for self-pay or uninsured",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/data-absent-reason|5.2.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Claim.insurance.preAuthRef",
        "path" : "Claim.insurance.preAuthRef",
        "max" : "2"
      },
      {
        "id" : "Claim.accident.location[x]",
        "path" : "Claim.accident.location[x]",
        "type" : [
          {
            "code" : "Address"
          }
        ]
      },
      {
        "id" : "Claim.accident.location[x].country",
        "path" : "Claim.accident.location[x].country",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/iso3166-1-2"
        }
      },
      {
        "id" : "Claim.item",
        "path" : "Claim.item",
        "min" : 1,
        "max" : "50"
      },
      {
        "id" : "Claim.item.extension",
        "path" : "Claim.item.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Claim.item.extension:referralNumber",
        "path" : "Claim.item.extension",
        "sliceName" : "referralNumber",
        "short" : "Referral Number",
        "min" : 0,
        "max" : "11",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/referralNumber"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Claim.item.extension:gfeBillingProviderLineItemCtrlNum",
        "path" : "Claim.item.extension",
        "sliceName" : "gfeBillingProviderLineItemCtrlNum",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/gfeBillingProviderLineItemCtrlNum"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Claim.item.extension:serviceDescription",
        "path" : "Claim.item.extension",
        "sliceName" : "serviceDescription",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/serviceDescription"
            ]
          }
        ]
      },
      {
        "id" : "Claim.item.extension:ProviderEventMethodology",
        "path" : "Claim.item.extension",
        "sliceName" : "ProviderEventMethodology",
        "short" : "Provider Event Methodology",
        "comment" : "The method a provider used to group services. The extension definition contains additional detail.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/providerEventMethodology"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Claim.item.careTeamSequence",
        "path" : "Claim.item.careTeamSequence",
        "mustSupport" : true
      },
      {
        "id" : "Claim.item.productOrService",
        "path" : "Claim.item.productOrService",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/davinci-pct/ValueSet/USClaimMedicalProductOrServiceCodes"
        }
      },
      {
        "id" : "Claim.item.productOrService.coding",
        "path" : "Claim.item.productOrService.coding",
        "constraint" : [
          {
            "key" : "pct-cpt-display",
            "severity" : "error",
            "human" : "CPT codes require a display value (CPT Consumer Friendly Descriptors recommended)",
            "expression" : "system = 'http://www.ama-assn.org/go/cpt' implies display.exists()",
            "source" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-professional"
          }
        ]
      },
      {
        "id" : "Claim.item.modifier",
        "path" : "Claim.item.modifier",
        "max" : "4",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/davinci-pct/ValueSet/PCTGFEItemCptHcpcsVS"
        }
      },
      {
        "id" : "Claim.item.modifier.coding",
        "path" : "Claim.item.modifier.coding",
        "constraint" : [
          {
            "key" : "pct-cpt-display",
            "severity" : "error",
            "human" : "CPT codes require a display value (CPT Consumer Friendly Descriptors recommended)",
            "expression" : "system = 'http://www.ama-assn.org/go/cpt' implies display.exists()",
            "source" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-professional"
          }
        ]
      },
      {
        "id" : "Claim.item.serviced[x]",
        "path" : "Claim.item.serviced[x]",
        "short" : "This is the planned or estimated date(s)s of service",
        "definition" : "This is the planned or estimated dates of service. Use Revenue code to determine inpatient stays if needed for adjudication",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Claim.item.location[x]",
        "path" : "Claim.item.location[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/davinci-pct/ValueSet/PCTGFECMSPOS"
        }
      },
      {
        "id" : "Claim.item.quantity",
        "path" : "Claim.item.quantity",
        "min" : 1
      },
      {
        "id" : "Claim.item.unitPrice",
        "path" : "Claim.item.unitPrice",
        "min" : 1
      },
      {
        "id" : "Claim.item.net",
        "path" : "Claim.item.net",
        "short" : "Total charge amount for the service line",
        "min" : 1
      },
      {
        "id" : "Claim.item.detail",
        "path" : "Claim.item.detail",
        "short" : "Drug Identification Information",
        "mustSupport" : true
      },
      {
        "id" : "Claim.item.detail.productOrService",
        "path" : "Claim.item.detail.productOrService",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/davinci-pct/ValueSet/USClaimMedicalProductOrServiceCodes"
        }
      },
      {
        "id" : "Claim.item.detail.quantity",
        "path" : "Claim.item.detail.quantity",
        "mustSupport" : true
      },
      {
        "id" : "Claim.total",
        "path" : "Claim.total",
        "short" : "Total GFE Charges Submitted",
        "min" : 1
      }
    ]
  }
}

```
