# PCT GFE Contributor Task - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PCT GFE Contributor Task**

## Resource Profile: PCT GFE Contributor Task 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-contributor-task | *Version*:2.0.0 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:PCTGFEContributorTask |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.4.42.15 | | |

 
The PCT GFE Contributor Task is used by a GFE coordinator to assign a GFE contributor task to a specific provider and may include information specific to that patient’s expected service 

The following profile relates to the Good Faith Estimate (GFE) Coordination workflow and is marked as **DRAFT**. This content has not yet met the requisite level of testing to be balloted as trial-use. However, this part of the specification has been reviewed by the Da Vinci Patient Cost Transparency (PCT) open community of providers, payers, and health information technology (IT) vendors and was determined to be at a sufficient level of development to be included in this publication for the purposes of soliciting feedback from, and enabling testing by, the larger implementation community with the intention of bringing the content related to the GFE Coordination workflow to full standard for trial use (STU) status in a future version. Feedback is welcome and may be submitted through the [FHIR change tracker](http://hl7.org/fhir-issues) indicating "US Da Vinci Patient Cost Transparency (PCT)(FHIR)" as the specification.

**Usages:**

* Use this Profile: [PCT GFE Coordination Bundle](StructureDefinition-davinci-pct-gfe-coordination-bundle.md)
* Refer to this Profile: [GFERelatedTask](StructureDefinition-gfeRelatedTask.md)
* Examples for this Profile: [Task/PCT-GFE-Contributor-Replacement-Task-1](Task-PCT-GFE-Contributor-Replacement-Task-1.md), [Task/PCT-GFE-Contributor-Replacement-Task-2](Task-PCT-GFE-Contributor-Replacement-Task-2.md), [Task/PCT-GFE-Contributor-Task-1](Task-PCT-GFE-Contributor-Task-1.md) and [Task/PCT-GFE-Contributor-Task-2](Task-PCT-GFE-Contributor-Task-2.md)
* CapabilityStatements using this Profile: [Patient Cost Transparency Implementation Guide Coordination Platform Capability Statement](CapabilityStatement-davinci-pct-coordination-platform.md) and [Patient Cost Transparency Implementation Guide Coordination Requester Capability Statement](CapabilityStatement-davinci-pct-coordination-requester.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.davinci-pct|current/StructureDefinition/davinci-pct-gfe-contributor-task)

**Changes since version 1.1.0:**

* New Content

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-davinci-pct-gfe-contributor-task.csv), [Excel](StructureDefinition-davinci-pct-gfe-contributor-task.xlsx), [Schematron](StructureDefinition-davinci-pct-gfe-contributor-task.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "davinci-pct-gfe-contributor-task",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-contributor-task",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.4.42.15"
    }
  ],
  "version" : "2.0.0",
  "name" : "PCTGFEContributorTask",
  "title" : "PCT GFE Contributor Task",
  "status" : "draft",
  "date" : "2025-11-26T16:21:43+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "name" : "HL7 International / Financial Management",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        },
        {
          "system" : "email",
          "value" : "fmlists@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "The PCT GFE Contributor Task is used by a GFE coordinator   to assign a GFE contributor task to a specific provider and may include information specific to that patient’s expected service",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Task",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Task",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Task",
        "path" : "Task"
      },
      {
        "id" : "Task.extension",
        "path" : "Task.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Task.extension:requested-period",
        "path" : "Task.extension",
        "sliceName" : "requested-period",
        "short" : "GFE Contributor specific time period the requested GFE should be provided in",
        "comment" : "Indicates the start and/or end of the period of time when the GFE bundle should be provided. Usually this is the same as the GFE Coordination Task, and if so, should not be specified in the provider specific task. However, there may be circumstances in which a specific GFE contributor may have a different timeline that should be included in the provider specific task (e.g. the provider was added to original request afterwards, in the case of a provider replacement; or there is a potential dependency on the provider's response).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/5.0/StructureDefinition/extension-Task.requestedPeriod"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Task.extension:requested-period.value[x].start",
        "path" : "Task.extension.value[x].start",
        "max" : "0"
      },
      {
        "id" : "Task.extension:requested-period.value[x].end",
        "path" : "Task.extension.value[x].end",
        "min" : 1
      },
      {
        "id" : "Task.extension:request-initiation-time",
        "path" : "Task.extension",
        "sliceName" : "request-initiation-time",
        "short" : "Estimate Request instant",
        "comment" : "Instant from which the request is being initiated. For patient initiated requests, this is the date and time the patient or their representative made the request. For a newly scheduled service, this represents the time of the scheduling activity (as opposed to the planned time of service). For all other requests, the time of the event that triggered the need for an estimate.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/requestInitiationTime"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Task.extension:planned-service-period",
        "path" : "Task.extension",
        "sliceName" : "planned-service-period",
        "short" : "GFE contributor specific planned or scheduled period of service the request is about",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/plannedServicePeriod"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Task.extension:predecessor-task",
        "path" : "Task.extension",
        "sliceName" : "predecessor-task",
        "short" : "A reference to the related Task which the current task replaces or carries forward the intention of.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/gfeRelatedTask"
            ]
          }
        ]
      },
      {
        "id" : "Task.identifier",
        "path" : "Task.identifier",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "type"
            }
          ],
          "description" : "Slice based on $this value",
          "rules" : "open"
        }
      },
      {
        "id" : "Task.identifier:PLAC",
        "path" : "Task.identifier",
        "sliceName" : "PLAC",
        "short" : "GFE Coordination Requester Assigned Identifier for GFE Request",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Task.identifier:PLAC.type",
        "path" : "Task.identifier.type",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
              "code" : "PLAC",
              "display" : "Placer Identifier"
            }
          ]
        }
      },
      {
        "id" : "Task.identifier:PLAC.system",
        "path" : "Task.identifier.system",
        "mustSupport" : true
      },
      {
        "id" : "Task.identifier:PLAC.value",
        "path" : "Task.identifier.value",
        "min" : 1
      },
      {
        "id" : "Task.partOf",
        "path" : "Task.partOf",
        "short" : "Reference to the GFE Coordination Task",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-coordination-task"
            ]
          }
        ]
      },
      {
        "id" : "Task.status",
        "path" : "Task.status",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/davinci-pct/ValueSet/PCTContributorTaskStatusCodes"
        }
      },
      {
        "id" : "Task.statusReason",
        "path" : "Task.statusReason",
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.org/fhir/us/davinci-pct/ValueSet/PCTContributorTaskStatusReasonCodes"
        }
      },
      {
        "id" : "Task.businessStatus",
        "path" : "Task.businessStatus",
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.org/fhir/us/davinci-pct/ValueSet/PCTTaskBusinessStatusCodes"
        }
      },
      {
        "id" : "Task.intent",
        "path" : "Task.intent",
        "patternCode" : "order"
      },
      {
        "id" : "Task.code",
        "path" : "Task.code",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTGFERequestTypeCSTemporaryTrialUse",
              "code" : "gfe-contributor-task"
            }
          ]
        }
      },
      {
        "id" : "Task.requester",
        "path" : "Task.requester",
        "short" : "The provider making the request",
        "comment" : "Generally this will be a reference to a Practitioner, PractitionerRole, or Organization resource residing on the Coordination Platform. If there is a need to express contact information that is specific to the request, and therefore is not included in the information on the Coordination Platform, the reference should point to a server and resource that does not have additional authentication or or authorization requirements.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-practitioner",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitionerrole|7.0.0",
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-organization"
            ]
          }
        ]
      },
      {
        "id" : "Task.performerType",
        "path" : "Task.performerType",
        "short" : "Specific performer types for the",
        "mustSupport" : true
      },
      {
        "id" : "Task.owner",
        "path" : "Task.owner",
        "short" : "GFE Contributor assigned to complete the task",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-practitioner",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitionerrole|7.0.0",
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-organization"
            ]
          }
        ]
      },
      {
        "id" : "Task.reasonCode",
        "path" : "Task.reasonCode",
        "short" : "The reasonCode is inherited from the GFE Coordination Task pointed to by Task.partOf",
        "max" : "0"
      },
      {
        "id" : "Task.restriction",
        "path" : "Task.restriction",
        "max" : "0"
      },
      {
        "id" : "Task.input",
        "path" : "Task.input",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "type"
            }
          ],
          "description" : "Slice based on value",
          "rules" : "open"
        },
        "short" : "GFE Contributor specific Information and references to service and supporting information, such as Conditions, Observations, and notes",
        "comment" : "Contained or referenced request information bundle made available to a specific GFE contributor that includes information about the products and or services requested and other supporting information, such as Conditions, Observations, and notes",
        "mustSupport" : true
      },
      {
        "id" : "Task.input:gfe-information-bundle",
        "path" : "Task.input",
        "sliceName" : "gfe-information-bundle",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Task.input:gfe-information-bundle.type",
        "path" : "Task.input.type",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTDocumentTypeTemporaryTrialUse",
              "code" : "gfe-information-bundle"
            }
          ]
        }
      },
      {
        "id" : "Task.input:gfe-information-bundle.value[x]",
        "path" : "Task.input.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "type" : [
          {
            "code" : "Attachment"
          },
          {
            "code" : "Reference"
          }
        ]
      },
      {
        "id" : "Task.input:gfe-information-bundle.value[x]:valueAttachment",
        "path" : "Task.input.value[x]",
        "sliceName" : "valueAttachment",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Attachment"
          }
        ]
      },
      {
        "id" : "Task.input:gfe-information-bundle.value[x]:valueAttachment.contentType",
        "path" : "Task.input.value[x].contentType",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/davinci-pct/ValueSet/PCTTaskAttachmentContentType"
        }
      },
      {
        "id" : "Task.input:gfe-information-bundle.value[x]:valueAttachment.data",
        "path" : "Task.input.value[x].data",
        "min" : 1
      },
      {
        "id" : "Task.input:gfe-information-bundle.value[x]:valueReference",
        "path" : "Task.input.value[x]",
        "sliceName" : "valueReference",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference"
          }
        ]
      },
      {
        "id" : "Task.input:gfe-information-bundle.value[x]:valueReference.reference",
        "path" : "Task.input.value[x].reference",
        "min" : 1
      },
      {
        "id" : "Task.output",
        "path" : "Task.output",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "type"
            }
          ],
          "description" : "Slice based on value",
          "rules" : "open"
        },
        "short" : "Any outputs from the GFE Contributor including the GFE Bundle or notes on why the specific task was unable to be completed",
        "comment" : "Any outputs for the GFE Contributor Task which might include notes on why the GFE Contributor Task was unable to be completed.",
        "mustSupport" : true
      },
      {
        "id" : "Task.output:gfe-bundle",
        "path" : "Task.output",
        "sliceName" : "gfe-bundle",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Task.output:gfe-bundle.type",
        "path" : "Task.output.type",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTDocumentTypeTemporaryTrialUse",
              "code" : "gfe-bundle"
            }
          ]
        }
      },
      {
        "id" : "Task.output:gfe-bundle.value[x]",
        "path" : "Task.output.value[x]",
        "type" : [
          {
            "code" : "Attachment"
          }
        ]
      },
      {
        "id" : "Task.output:gfe-bundle.value[x].contentType",
        "path" : "Task.output.value[x].contentType",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/davinci-pct/ValueSet/PCTTaskAttachmentContentType"
        }
      },
      {
        "id" : "Task.output:gfe-bundle.value[x].data",
        "path" : "Task.output.value[x].data",
        "min" : 1
      },
      {
        "id" : "Task.output:gfe-bundle.value[x].creation",
        "path" : "Task.output.value[x].creation",
        "min" : 1
      }
    ]
  }
}

```
