# PCT GFE DeviceRequest - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PCT GFE DeviceRequest**

## Resource Profile: PCT GFE DeviceRequest 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-devicerequest | *Version*:2.0.0 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:PCTDeviceRequest |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.4.42.21 | | |

 
The PCT DeviceRequest including details about a device for which a GFE is being requested. 

The following profile relates to the Good Faith Estimate (GFE) Coordination workflow and is marked as **DRAFT**. This content has not yet met the requisite level of testing to be balloted as trial-use. However, this part of the specification has been reviewed by the Da Vinci Patient Cost Transparency (PCT) open community of providers, payers, and health information technology (IT) vendors and was determined to be at a sufficient level of development to be included in this publication for the purposes of soliciting feedback from, and enabling testing by, the larger implementation community with the intention of bringing the content related to the GFE Coordination workflow to full standard for trial use (STU) status in a future version. Feedback is welcome and may be submitted through the [FHIR change tracker](http://hl7.org/fhir-issues) indicating "US Da Vinci Patient Cost Transparency (PCT)(FHIR)" as the specification.

**Usages:**

* Use this Profile: [PCT GFE Information Bundle](StructureDefinition-davinci-pct-gfe-information-bundle.md) and [PCT GFE Missing Bundle](StructureDefinition-davinci-pct-gfe-missing-bundle.md)
* Examples for this Profile: [DeviceRequest/PCT-DeviceRequest-1](DeviceRequest-PCT-DeviceRequest-1.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.davinci-pct|current/StructureDefinition/davinci-pct-devicerequest)

**Changes since version 1.1.0:**

* New Content

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-davinci-pct-devicerequest.csv), [Excel](StructureDefinition-davinci-pct-devicerequest.xlsx), [Schematron](StructureDefinition-davinci-pct-devicerequest.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "davinci-pct-devicerequest",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-devicerequest",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.4.42.21"
    }
  ],
  "version" : "2.0.0",
  "name" : "PCTDeviceRequest",
  "title" : "PCT GFE DeviceRequest",
  "status" : "draft",
  "date" : "2025-11-26T16:21:43+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "name" : "HL7 International / Financial Management",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        },
        {
          "system" : "email",
          "value" : "fmlists@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "The PCT DeviceRequest including details about a device for which a GFE is being requested.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "quick",
      "uri" : "http://siframework.org/cqf",
      "name" : "Quality Improvement and Clinical Knowledge (QUICK)"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "DeviceRequest",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/DeviceRequest",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "DeviceRequest.status",
        "path" : "DeviceRequest.status",
        "patternCode" : "active"
      },
      {
        "id" : "DeviceRequest.intent",
        "path" : "DeviceRequest.intent",
        "patternCode" : "proposal"
      },
      {
        "id" : "DeviceRequest.code[x]",
        "path" : "DeviceRequest.code[x]",
        "mustSupport" : true
      },
      {
        "id" : "DeviceRequest.subject",
        "path" : "DeviceRequest.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient|7.0.0"
            ]
          }
        ]
      }
    ]
  }
}

```
