# PCT Advanced EOB - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PCT Advanced EOB**

## Resource Profile: PCT Advanced EOB 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-aeob | *Version*:2.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:PCTAdvancedEOB |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.4.42.6 | | |

 
The No Surprises Act requires that group health plans and insurers provide advance cost estimates, called advanced explanations of benefits (advanced EOBs), for scheduled services. This profile is used for exchanging the Advanced EOB data. 

#### Notes on Fields

* .created: .created values convey the date and time the estimate was calculated, based on what was known about the state of the member’s benefits and accumulators for a given benefit period/plan year at that point in time (the .created date and time). 
* The gfeReference Extension is used to point to the GFE Bundle for which the originating GFE is contained. This along with the .claim.identifier can be used to identify the originating GFE this AEOB addresses. Note that it is common for there to be a one-to-one relationship between an AEOB and a GFE, however, this is not always the case.
* .benefitPeriod: .benefitPeriod values convey the term of benefits (a.k.a. "plan year") that the benefits used to calculate the estimate were based on. 
* .total.amount: Eligible amount = submitted amount - the noncovered amount - discount. The subscriber pays the member liability = deductible + coinsurance + copay + noncovered (if applicable). The eligible amount - the member liability is the potential payer's payment amount to the provider or the subscriber.
* .total.amount and .benefitbalance work together to reflect the expected member’s costs across all the Advanced EOB resources in this AEOB Packet(s). This means that all accumulations to deductible, out-of-pocket maximum, and other limits are collectively reflective of all GFEs in the GFE Packet(s), giving the Patient a comprehensive estimate for all expected service(s) or item(s) from one or more providers.
* .benefitbalance: benefit.balance shows the estimated balance by benefit category as if the expected item(s) or service(s) included in this estimate were applied. The .allowed value would reflect current allowed total limits for the specific category, unit, and term (e.g. Physical Therapy, Individual, annual.) The .used and .remaining would reflect current known balance plus or minus, respectively, the current estimate's expected item(s) or service(s) impact on the patient's benefit balance.
* total:submitted, total:memberliability, and total:eligible work together to communicate the high level summary to a patient. total:submitted is used to indicate the expected total amount submitted from the provider (charges). total:memberliability is used to indicate the expected amount the patient owes, and as stated above, the total:eligible - total:memberliability is the expected payer's payment amount.
* Working together .created values and .benefitPeriod values explicitly convey the temporal context for the state of benefits and accumulators that were used to calculate the estimate communicated in an advanced EOB. The state of a member’s benefits and accumulators for a given benefit period or the benefit period in effect may change between the date that an estimate is generated (.created) and when the services being estimated are actually rendered (e.g., the actual date of service), resulting in a difference between the estimated vs. actual cost to the member. 
* The .processnote data element is used to communicate disclaimers and specific information for this estimate to the patient. Processnote should include notes to meet legislative, legal, or otherwise required disclaimers. Notes should be clear and as specific to the situation at hand as possible including any additional assumptions and requirements. Examples of the types of information payers can use the processnote for include: 
* Disclaimer that the information provided in the notification is only an estimate based on the items and services reasonably expected, at the time of scheduling (or requesting) and is subject to change.
* Disclaimer that that coverage for such item or service is subject to a medical management technique, like prior authorization.
* Additional information about Prior Authorization, any assumptions made such as that the estimate is calculated assuming any applicable prior auth is approved and that the estimate may be higher if approval conditions are not met. If available, Payers could include Coverage Requirements Discovery (CRD) response information for improved patient transparency and information sharing.
* Unique assumptions about diagnosis code(s) impact on estimate accuracy, e.g. Diagnosis code was not specified. This estimate is based on assumption that this service is diagnostic and thus the patient responsibility may be higher than if the diagnosis was for preventative services.
* Additional information indicating that the AEOB contains one or more out of network providers and thus patient responsibility may be higher than if an in-network provider was chosen.
 
* extension:outOfNetworkProviderInfo: outOfNetworkProviderInfo is an extension to provide a payer link enabling the patient to find providers that are in-network for the requested services.
 
* adjudication: billingnetworkstatus, renderingnetworkstatus, benefitpaymentstatus, and adjustmentreason work together to indicate if the item or service is considered in or out of network for purposes of creating the estimate and thus indicating as such for providing the patient with relevant .processnote and outofnetworkproviderinfo.
 

#### Examples

 

##### Example 1 – Estimation based on current benefit period

 
* Situation: 
* A group health plan produces an advance cost estimate on July 2, 2023, for services scheduled on August 23, 2023. 
* The plan uses the state of the member’s current 2023 benefit period/plan year benefits and accumulators when calculating the estimate.
* The plan’s deductible for the 2023 benefit period benefits is $1500.
* At the time, the group health plan produces the estimate on July 2, 2023, the member has paid $1000 in eligible health care expenses against their $1500/2023 plan year deductible.
 
* Result: 
* The estimate is produced on July 2, 2023 (.created = “2023-07-02T13:28:17-05:00”). 
* The benefit period used as the basis for the estimation is the current 2023 benefit period/plan year (.benefitPeriod.start = “2023-01-01” & .benefitPeriod.end = “2023-12-31”).
* The estimated cost to the member is based on the fact that as of July 2, 2023 13:28:17-05:00, they have only met $1000 of their $1500/2023 plan year deductible.
 
 

##### Example 2 – Estimation based on a future benefit period

 
* Situation: 
* The payer can support estimations based on a future benefit period. 
* A group health plan is producing an advance cost estimate on December 15, 2024, for services scheduled in 2025.
* The plan uses the 2025 term of benefits (a.k.a. "plan year") when calculating the estimate.
* The plan’s deductible for the 2025 term of benefits is $1500.
* At the time, the group health plan produces the estimate on December 15, 2024, the member has incurred no claims against the 2025 term of benefits, and they have paid $0 in eligible health care expenses against their $1500/2025 plan year deductible.
 
* Result: 
* The estimate is produced on December 15, 2024 (.created = "2024-12-15T12:10:05-05:00"). 
* The benefit period used as the basis for the estimation is the 2025 plan year (.benefitPeriod.start = "2025-01-01" & .benefitPeriod.end = "2025-12-31").
* The estimated cost to the member is based on the fact that as of December 15, 2024 12:10:05-05:00, they have not met any portion of their $1500/2025 plan year deductible.
 
 

**Usages:**

* Use this Profile: [PCT AEOB Packet](StructureDefinition-davinci-pct-aeob-packet.md)
* Refer to this Profile: [PCT AEOB Composition](StructureDefinition-davinci-pct-aeob-composition.md)
* Examples for this Profile: [ExplanationOfBenefit/PCT-AEOB-1](ExplanationOfBenefit-PCT-AEOB-1.md)
* CapabilityStatements using this Profile: [Patient Cost Transparency Implementation Guide Payer Capability Statement](CapabilityStatement-davinci-pct.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.davinci-pct|current/StructureDefinition/davinci-pct-aeob)

**Changes since version 1.1.0:**

* New Content

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-davinci-pct-aeob.csv), [Excel](StructureDefinition-davinci-pct-aeob.xlsx), [Schematron](StructureDefinition-davinci-pct-aeob.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "davinci-pct-aeob",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-aeob",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.4.42.6"
    }
  ],
  "version" : "2.0.0",
  "name" : "PCTAdvancedEOB",
  "title" : "PCT Advanced EOB",
  "status" : "active",
  "date" : "2025-11-26T16:21:43+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "name" : "HL7 International / Financial Management",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        },
        {
          "system" : "email",
          "value" : "fmlists@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "The No Surprises Act requires that group health plans and insurers provide advance cost estimates, called advanced explanations of benefits (advanced EOBs), for scheduled services. This profile is used for exchanging the Advanced EOB data.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "ExplanationOfBenefit",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/ExplanationOfBenefit",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "ExplanationOfBenefit",
        "path" : "ExplanationOfBenefit",
        "constraint" : [
          {
            "key" : "pct-aeob-1",
            "severity" : "error",
            "human" : "Advanced EOB:  SHALL have serviceDescription at the item or header level (can be at both locations)",
            "expression" : "extension.where(url='http://hl7.org/fhir/us/davinci-pct/StructureDefinition/serviceDescription').exists() or item.extension.where(url='http://hl7.org/fhir/us/davinci-pct/StructureDefinition/serviceDescription').exists()",
            "source" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-aeob"
          },
          {
            "key" : "pct-aeob-2",
            "severity" : "error",
            "human" : "Advanced EOB:  SHALL have adjudication[submitted] at the item or header level (can be at both locations)",
            "expression" : "adjudication.where(category.coding.where(code='submitted').exists()).exists() or item.adjudication.where(category.coding.where(code='submitted').exists()).exists()",
            "source" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-aeob"
          },
          {
            "key" : "pct-aeob-3",
            "severity" : "error",
            "human" : "Advanced EOB:  SHALL have adjudication[memberliability] at the item or header level (can be at both locations)",
            "expression" : "adjudication.where(category.coding.where(code='memberliability').exists()).exists() or item.adjudication.where(category.coding.where(code='memberliability').exists()).exists()",
            "source" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-aeob"
          }
        ]
      },
      {
        "id" : "ExplanationOfBenefit.extension",
        "path" : "ExplanationOfBenefit.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "ExplanationOfBenefit.extension:gfeReference",
        "path" : "ExplanationOfBenefit.extension",
        "sliceName" : "gfeReference",
        "short" : "The GFE Bundle submitted by an entity that started the process for obtaining an Advanced EOB.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/gfeReference"
            ]
          }
        ]
      },
      {
        "id" : "ExplanationOfBenefit.extension:serviceDescription",
        "path" : "ExplanationOfBenefit.extension",
        "sliceName" : "serviceDescription",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/serviceDescription"
            ]
          }
        ],
        "condition" : ["pct-aeob-1"],
        "mustSupport" : true
      },
      {
        "id" : "ExplanationOfBenefit.extension:outOfNetworkProviderInfo",
        "path" : "ExplanationOfBenefit.extension",
        "sliceName" : "outOfNetworkProviderInfo",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/inNetworkProviderOptionsLink"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ExplanationOfBenefit.identifier",
        "path" : "ExplanationOfBenefit.identifier",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "type"
            }
          ],
          "description" : "Slice based on type value",
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "ExplanationOfBenefit.identifier:uniqueclaimid",
        "path" : "ExplanationOfBenefit.identifier",
        "sliceName" : "uniqueclaimid",
        "short" : "Unique Claim ID",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ExplanationOfBenefit.identifier:uniqueclaimid.type",
        "path" : "ExplanationOfBenefit.identifier.type",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
              "code" : "UCID"
            }
          ]
        }
      },
      {
        "id" : "ExplanationOfBenefit.type",
        "path" : "ExplanationOfBenefit.type",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/claim-type"
        }
      },
      {
        "id" : "ExplanationOfBenefit.use",
        "path" : "ExplanationOfBenefit.use",
        "patternCode" : "predetermination"
      },
      {
        "id" : "ExplanationOfBenefit.patient",
        "path" : "ExplanationOfBenefit.patient",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient|7.0.0"
            ]
          }
        ]
      },
      {
        "id" : "ExplanationOfBenefit.created",
        "path" : "ExplanationOfBenefit.created",
        "short" : "The date and time this estimate was calculated.",
        "comment" : "The date and time this estimate was calculated based on what was known at that point in time."
      },
      {
        "id" : "ExplanationOfBenefit.insurer",
        "path" : "ExplanationOfBenefit.insurer",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-organization"
            ]
          }
        ]
      },
      {
        "id" : "ExplanationOfBenefit.provider",
        "path" : "ExplanationOfBenefit.provider",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-practitioner",
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-organization"
            ]
          }
        ]
      },
      {
        "id" : "ExplanationOfBenefit.priority",
        "path" : "ExplanationOfBenefit.priority",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/process-priority"
        }
      },
      {
        "id" : "ExplanationOfBenefit.claim",
        "path" : "ExplanationOfBenefit.claim",
        "min" : 1
      },
      {
        "id" : "ExplanationOfBenefit.claim.identifier",
        "path" : "ExplanationOfBenefit.claim.identifier",
        "short" : "GFE identifier of the originally submitted claim",
        "definition" : "Matches the provider submitted GFE claim.identifier this Advance ExplanationOfBenefit is addressing where identifier.type = http://terminology.hl7.org/CodeSystem/v2-0203|PLAC (with the identifier.value and identifier.system matching the original GFE identifier values).",
        "min" : 1
      },
      {
        "id" : "ExplanationOfBenefit.claim.identifier.system",
        "path" : "ExplanationOfBenefit.claim.identifier.system",
        "mustSupport" : true
      },
      {
        "id" : "ExplanationOfBenefit.claim.identifier.value",
        "path" : "ExplanationOfBenefit.claim.identifier.value",
        "min" : 1
      },
      {
        "id" : "ExplanationOfBenefit.insurance.coverage",
        "path" : "ExplanationOfBenefit.insurance.coverage",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-coverage"
            ]
          }
        ]
      },
      {
        "id" : "ExplanationOfBenefit.item",
        "path" : "ExplanationOfBenefit.item",
        "min" : 1
      },
      {
        "id" : "ExplanationOfBenefit.item.extension",
        "path" : "ExplanationOfBenefit.item.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "ExplanationOfBenefit.item.extension:serviceDescription",
        "path" : "ExplanationOfBenefit.item.extension",
        "sliceName" : "serviceDescription",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/serviceDescription"
            ]
          }
        ],
        "condition" : ["pct-aeob-1"],
        "mustSupport" : true
      },
      {
        "id" : "ExplanationOfBenefit.item.revenue",
        "path" : "ExplanationOfBenefit.item.revenue",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/davinci-pct/ValueSet/PCTGFEItemRevenueVS"
        }
      },
      {
        "id" : "ExplanationOfBenefit.item.productOrService",
        "path" : "ExplanationOfBenefit.item.productOrService",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/davinci-pct/ValueSet/USClaimMedicalProductOrServiceCodes"
        }
      },
      {
        "id" : "ExplanationOfBenefit.item.productOrService.coding",
        "path" : "ExplanationOfBenefit.item.productOrService.coding",
        "constraint" : [
          {
            "key" : "pct-cpt-display",
            "severity" : "error",
            "human" : "CPT codes require a display value (CPT Consumer Friendly Descriptors recommended)",
            "expression" : "system = 'http://www.ama-assn.org/go/cpt' implies display.exists()",
            "source" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-aeob"
          }
        ]
      },
      {
        "id" : "ExplanationOfBenefit.item.modifier",
        "path" : "ExplanationOfBenefit.item.modifier",
        "max" : "4",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/davinci-pct/ValueSet/PCTGFEItemCptHcpcsVS"
        }
      },
      {
        "id" : "ExplanationOfBenefit.item.modifier.coding",
        "path" : "ExplanationOfBenefit.item.modifier.coding",
        "constraint" : [
          {
            "key" : "pct-cpt-display",
            "severity" : "error",
            "human" : "CPT codes require a display value (CPT Consumer Friendly Descriptors recommended)",
            "expression" : "system = 'http://www.ama-assn.org/go/cpt' implies display.exists()",
            "source" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-aeob"
          }
        ]
      },
      {
        "id" : "ExplanationOfBenefit.item.serviced[x]",
        "path" : "ExplanationOfBenefit.item.serviced[x]",
        "short" : "This is the planned or estimated date(s)s of service",
        "definition" : "This is the planned or estimated dates of service. Use Revenue code to determine inpatient stays if needed for adjudication",
        "min" : 1
      },
      {
        "id" : "ExplanationOfBenefit.item.quantity",
        "path" : "ExplanationOfBenefit.item.quantity",
        "mustSupport" : true
      },
      {
        "id" : "ExplanationOfBenefit.item.adjudication",
        "path" : "ExplanationOfBenefit.item.adjudication",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "category"
            }
          ],
          "description" : "Slice based on $this value",
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "ExplanationOfBenefit.item.adjudication.category",
        "path" : "ExplanationOfBenefit.item.adjudication.category",
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.org/fhir/us/davinci-pct/ValueSet/PCTAdjudicationCategoryVS"
        }
      },
      {
        "id" : "ExplanationOfBenefit.item.adjudication:medicalmanagement",
        "path" : "ExplanationOfBenefit.item.adjudication",
        "sliceName" : "medicalmanagement",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "ExplanationOfBenefit.item.adjudication:medicalmanagement.extension",
        "path" : "ExplanationOfBenefit.item.adjudication.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "ExplanationOfBenefit.item.adjudication:medicalmanagement.extension:subjectToMedicalMgmt",
        "path" : "ExplanationOfBenefit.item.adjudication.extension",
        "sliceName" : "subjectToMedicalMgmt",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/subjectToMedicalMgmt"
            ]
          }
        ]
      },
      {
        "id" : "ExplanationOfBenefit.item.adjudication:medicalmanagement.category",
        "path" : "ExplanationOfBenefit.item.adjudication.category",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTAdjudicationCategoryCS",
              "code" : "medicalmanagement"
            }
          ]
        }
      },
      {
        "id" : "ExplanationOfBenefit.item.adjudication:medicalmanagement.amount",
        "path" : "ExplanationOfBenefit.item.adjudication.amount",
        "max" : "0"
      },
      {
        "id" : "ExplanationOfBenefit.item.adjudication:medicalmanagement.value",
        "path" : "ExplanationOfBenefit.item.adjudication.value",
        "max" : "0"
      },
      {
        "id" : "ExplanationOfBenefit.item.adjudication:benefitpaymentstatus",
        "path" : "ExplanationOfBenefit.item.adjudication",
        "sliceName" : "benefitpaymentstatus",
        "short" : "Benefit Payment Status: Line level benefit payment status associated with professional claim estimates only.",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "ExplanationOfBenefit.item.adjudication:benefitpaymentstatus.category",
        "path" : "ExplanationOfBenefit.item.adjudication.category",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTAdjudicationCategoryCS",
              "code" : "benefitpaymentstatus"
            }
          ]
        }
      },
      {
        "id" : "ExplanationOfBenefit.item.adjudication:benefitpaymentstatus.reason",
        "path" : "ExplanationOfBenefit.item.adjudication.reason",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/davinci-pct/ValueSet/PCTPayerBenefitPaymentStatusVS"
        }
      },
      {
        "id" : "ExplanationOfBenefit.item.adjudication:adjustmentreason",
        "path" : "ExplanationOfBenefit.item.adjudication",
        "sliceName" : "adjustmentreason",
        "short" : "Adjustment Reason",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "ExplanationOfBenefit.item.adjudication:adjustmentreason.category",
        "path" : "ExplanationOfBenefit.item.adjudication.category",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTAdjudicationCategoryCS",
              "code" : "adjustmentreason"
            }
          ]
        }
      },
      {
        "id" : "ExplanationOfBenefit.item.adjudication:adjustmentreason.reason",
        "path" : "ExplanationOfBenefit.item.adjudication.reason",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/davinci-pct/ValueSet/PCTAdjustmentReasonVS"
        }
      },
      {
        "id" : "ExplanationOfBenefit.item.adjudication:submitted",
        "path" : "ExplanationOfBenefit.item.adjudication",
        "sliceName" : "submitted",
        "short" : "Provider submitted amount",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "ExplanationOfBenefit.item.adjudication:submitted.category",
        "path" : "ExplanationOfBenefit.item.adjudication.category",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/adjudication",
              "code" : "submitted"
            }
          ]
        }
      },
      {
        "id" : "ExplanationOfBenefit.item.adjudication:memberliability",
        "path" : "ExplanationOfBenefit.item.adjudication",
        "sliceName" : "memberliability",
        "short" : "Member liability",
        "comment" : "$0 is an acceptable value",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "ExplanationOfBenefit.item.adjudication:memberliability.category",
        "path" : "ExplanationOfBenefit.item.adjudication.category",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTAdjudicationCategoryCS",
              "code" : "memberliability"
            }
          ]
        }
      },
      {
        "id" : "ExplanationOfBenefit.item.adjudication:eligible",
        "path" : "ExplanationOfBenefit.item.adjudication",
        "sliceName" : "eligible",
        "short" : "Eligible amount",
        "comment" : "Eligible is similar to allowed amount. Eligible amount and Benefit amount may be different or the same, but if they are different the payer can supply both for the full picture of the estimate.",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "ExplanationOfBenefit.item.adjudication:eligible.category",
        "path" : "ExplanationOfBenefit.item.adjudication.category",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/adjudication",
              "code" : "eligible"
            }
          ]
        }
      },
      {
        "id" : "ExplanationOfBenefit.item.adjudication:benefit",
        "path" : "ExplanationOfBenefit.item.adjudication",
        "sliceName" : "benefit",
        "short" : "Benefit amount",
        "comment" : "Benefit is similar to allowed amount. Eligible amount and Benefit amount may be different or the same, but if they are different the payer can supply both for the full picture of the estimate.",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "ExplanationOfBenefit.item.adjudication:benefit.category",
        "path" : "ExplanationOfBenefit.item.adjudication.category",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/adjudication",
              "code" : "benefit"
            }
          ]
        }
      },
      {
        "id" : "ExplanationOfBenefit.adjudication",
        "path" : "ExplanationOfBenefit.adjudication",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "category"
            }
          ],
          "description" : "Slice based on $this value",
          "ordered" : false,
          "rules" : "open"
        },
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ExplanationOfBenefit.adjudication.category",
        "path" : "ExplanationOfBenefit.adjudication.category",
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.org/fhir/us/davinci-pct/ValueSet/PCTAdjudicationCategoryVS"
        }
      },
      {
        "id" : "ExplanationOfBenefit.adjudication:medicalmanagement",
        "path" : "ExplanationOfBenefit.adjudication",
        "sliceName" : "medicalmanagement",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ExplanationOfBenefit.adjudication:medicalmanagement.extension",
        "path" : "ExplanationOfBenefit.adjudication.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "ExplanationOfBenefit.adjudication:medicalmanagement.extension:subjectToMedicalMgmt",
        "path" : "ExplanationOfBenefit.adjudication.extension",
        "sliceName" : "subjectToMedicalMgmt",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/subjectToMedicalMgmt"
            ]
          }
        ]
      },
      {
        "id" : "ExplanationOfBenefit.adjudication:medicalmanagement.category",
        "path" : "ExplanationOfBenefit.adjudication.category",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTAdjudicationCategoryCS",
              "code" : "medicalmanagement"
            }
          ]
        }
      },
      {
        "id" : "ExplanationOfBenefit.adjudication:medicalmanagement.amount",
        "path" : "ExplanationOfBenefit.adjudication.amount",
        "max" : "0"
      },
      {
        "id" : "ExplanationOfBenefit.adjudication:medicalmanagement.value",
        "path" : "ExplanationOfBenefit.adjudication.value",
        "max" : "0"
      },
      {
        "id" : "ExplanationOfBenefit.adjudication:billingnetworkstatus",
        "path" : "ExplanationOfBenefit.adjudication",
        "sliceName" : "billingnetworkstatus",
        "short" : "Billing Provider Network Status",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ExplanationOfBenefit.adjudication:billingnetworkstatus.category",
        "path" : "ExplanationOfBenefit.adjudication.category",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTAdjudicationCategoryCS",
              "code" : "billingnetworkstatus"
            }
          ]
        }
      },
      {
        "id" : "ExplanationOfBenefit.adjudication:billingnetworkstatus.reason",
        "path" : "ExplanationOfBenefit.adjudication.reason",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/davinci-pct/ValueSet/PCTPayerBenefitPaymentStatusVS"
        }
      },
      {
        "id" : "ExplanationOfBenefit.adjudication:renderingnetworkstatus",
        "path" : "ExplanationOfBenefit.adjudication",
        "sliceName" : "renderingnetworkstatus",
        "short" : "Rendering Provider Network Status",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ExplanationOfBenefit.adjudication:renderingnetworkstatus.category",
        "path" : "ExplanationOfBenefit.adjudication.category",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTAdjudicationCategoryCS",
              "code" : "renderingnetworkstatus"
            }
          ]
        }
      },
      {
        "id" : "ExplanationOfBenefit.adjudication:renderingnetworkstatus.reason",
        "path" : "ExplanationOfBenefit.adjudication.reason",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/davinci-pct/ValueSet/PCTPayerBenefitPaymentStatusVS"
        }
      },
      {
        "id" : "ExplanationOfBenefit.adjudication:benefitpaymentstatus",
        "path" : "ExplanationOfBenefit.adjudication",
        "sliceName" : "benefitpaymentstatus",
        "short" : "Benefit Payment Status",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ExplanationOfBenefit.adjudication:benefitpaymentstatus.category",
        "path" : "ExplanationOfBenefit.adjudication.category",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTAdjudicationCategoryCS",
              "code" : "benefitpaymentstatus"
            }
          ]
        }
      },
      {
        "id" : "ExplanationOfBenefit.adjudication:benefitpaymentstatus.reason",
        "path" : "ExplanationOfBenefit.adjudication.reason",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/davinci-pct/ValueSet/PCTPayerBenefitPaymentStatusVS"
        }
      },
      {
        "id" : "ExplanationOfBenefit.adjudication:adjustmentreason",
        "path" : "ExplanationOfBenefit.adjudication",
        "sliceName" : "adjustmentreason",
        "short" : "Adjustment Reason",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ExplanationOfBenefit.adjudication:adjustmentreason.category",
        "path" : "ExplanationOfBenefit.adjudication.category",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTAdjudicationCategoryCS",
              "code" : "adjustmentreason"
            }
          ]
        }
      },
      {
        "id" : "ExplanationOfBenefit.adjudication:adjustmentreason.reason",
        "path" : "ExplanationOfBenefit.adjudication.reason",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/davinci-pct/ValueSet/PCTAdjustmentReasonVS"
        }
      },
      {
        "id" : "ExplanationOfBenefit.adjudication:submitted",
        "path" : "ExplanationOfBenefit.adjudication",
        "sliceName" : "submitted",
        "short" : "Provider submitted amount",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ExplanationOfBenefit.adjudication:submitted.category",
        "path" : "ExplanationOfBenefit.adjudication.category",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/adjudication",
              "code" : "submitted"
            }
          ]
        }
      },
      {
        "id" : "ExplanationOfBenefit.adjudication:memberliability",
        "path" : "ExplanationOfBenefit.adjudication",
        "sliceName" : "memberliability",
        "short" : "Member liability",
        "comment" : "$0 is an acceptable value",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ExplanationOfBenefit.adjudication:memberliability.category",
        "path" : "ExplanationOfBenefit.adjudication.category",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTAdjudicationCategoryCS",
              "code" : "memberliability"
            }
          ]
        }
      },
      {
        "id" : "ExplanationOfBenefit.adjudication:eligible",
        "path" : "ExplanationOfBenefit.adjudication",
        "sliceName" : "eligible",
        "short" : "Eligible amount",
        "comment" : "Eligible is similar to allowed amount. Eligible amount and Benefit amount may be different or the same, but if they are different the payer can supply both for the full picture of the estimate.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ExplanationOfBenefit.adjudication:eligible.category",
        "path" : "ExplanationOfBenefit.adjudication.category",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/adjudication",
              "code" : "eligible"
            }
          ]
        }
      },
      {
        "id" : "ExplanationOfBenefit.adjudication:benefit",
        "path" : "ExplanationOfBenefit.adjudication",
        "sliceName" : "benefit",
        "short" : "Benefit amount",
        "comment" : "Benefit is similar to allowed amount. Eligible amount and Benefit amount may be different or the same, but if they are different the payer can supply both for the full picture of the estimate.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ExplanationOfBenefit.adjudication:benefit.category",
        "path" : "ExplanationOfBenefit.adjudication.category",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/adjudication",
              "code" : "benefit"
            }
          ]
        }
      },
      {
        "id" : "ExplanationOfBenefit.total",
        "path" : "ExplanationOfBenefit.total",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "category"
            }
          ],
          "description" : "Slice based on value value",
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 3
      },
      {
        "id" : "ExplanationOfBenefit.total.category",
        "path" : "ExplanationOfBenefit.total.category",
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.org/fhir/us/davinci-pct/ValueSet/PCTTotal"
        }
      },
      {
        "id" : "ExplanationOfBenefit.total:submitted",
        "path" : "ExplanationOfBenefit.total",
        "sliceName" : "submitted",
        "short" : "Total provider submitted amount",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "ExplanationOfBenefit.total:submitted.category",
        "path" : "ExplanationOfBenefit.total.category",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/adjudication",
              "code" : "submitted"
            }
          ]
        }
      },
      {
        "id" : "ExplanationOfBenefit.total:memberliability",
        "path" : "ExplanationOfBenefit.total",
        "sliceName" : "memberliability",
        "short" : "Total member liability",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "ExplanationOfBenefit.total:memberliability.category",
        "path" : "ExplanationOfBenefit.total.category",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTAdjudicationCategoryCS",
              "code" : "memberliability"
            }
          ]
        }
      },
      {
        "id" : "ExplanationOfBenefit.total:eligible",
        "path" : "ExplanationOfBenefit.total",
        "sliceName" : "eligible",
        "short" : "Total eligible amount",
        "comment" : "Eligible is similar to allowed amount. Eligible amount and Benefit amount may be different or the same, but if they are different the payer can supply both for the full picture of the estimate.",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "ExplanationOfBenefit.total:eligible.category",
        "path" : "ExplanationOfBenefit.total.category",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/adjudication",
              "code" : "eligible"
            }
          ]
        }
      },
      {
        "id" : "ExplanationOfBenefit.total:innetwork",
        "path" : "ExplanationOfBenefit.total",
        "sliceName" : "innetwork",
        "short" : "Total in network amount - only include when total type is applicable",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "ExplanationOfBenefit.total:innetwork.category",
        "path" : "ExplanationOfBenefit.total.category",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTNetworkStatusCS",
              "code" : "innetwork"
            }
          ]
        }
      },
      {
        "id" : "ExplanationOfBenefit.total:outofnetwork",
        "path" : "ExplanationOfBenefit.total",
        "sliceName" : "outofnetwork",
        "short" : "Total out of network amount - only include when total type is applicable",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "ExplanationOfBenefit.total:outofnetwork.category",
        "path" : "ExplanationOfBenefit.total.category",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTNetworkStatusCS",
              "code" : "outofnetwork"
            }
          ]
        }
      },
      {
        "id" : "ExplanationOfBenefit.total:noncovered",
        "path" : "ExplanationOfBenefit.total",
        "sliceName" : "noncovered",
        "short" : "Total noncovered amount - only include when total type is applicable",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "ExplanationOfBenefit.total:noncovered.category",
        "path" : "ExplanationOfBenefit.total.category",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTAdjudication",
              "code" : "noncovered"
            }
          ]
        }
      },
      {
        "id" : "ExplanationOfBenefit.total:negotiated",
        "path" : "ExplanationOfBenefit.total",
        "sliceName" : "negotiated",
        "short" : "Total negotiated amount - Total for special negotiated status for a service or product in relation to a patient's coverage that is established outside of a formal network contract",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "ExplanationOfBenefit.total:negotiated.category",
        "path" : "ExplanationOfBenefit.total.category",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTNetworkStatusCS",
              "code" : "negotiated"
            }
          ]
        }
      },
      {
        "id" : "ExplanationOfBenefit.total:benefit",
        "path" : "ExplanationOfBenefit.total",
        "sliceName" : "benefit",
        "short" : "Total benefit amount - only include when total type is applicable",
        "comment" : "Benefit is similar to allowed amount. Eligible amount and Benefit amount may be different or the same, but if they are different the payer can supply both for the full picture of the estimate.",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "ExplanationOfBenefit.total:benefit.category",
        "path" : "ExplanationOfBenefit.total.category",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/adjudication",
              "code" : "benefit"
            }
          ]
        }
      },
      {
        "id" : "ExplanationOfBenefit.processNote",
        "path" : "ExplanationOfBenefit.processNote",
        "short" : "Disclaimers go here. Notes should be clear and as specific to the situation at hand as possible including any additional assumptions and requirements. This may include notes about prior authorization, out of network providers, benefit period,  and other legal or otherwise required disclaimers.",
        "comment" : "These disclaimers may include, but are not limited to things such as: notes on prior authorization or other medical management requirements, provider discounts, limitations, preconditions, assumptions, information known to be missing in the estimate, conditions that may affect the estimate, or anything that may affect the interpretation of the estimate.",
        "min" : 1
      },
      {
        "id" : "ExplanationOfBenefit.processNote.extension",
        "path" : "ExplanationOfBenefit.processNote.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "ExplanationOfBenefit.processNote.extension:processNoteClass",
        "path" : "ExplanationOfBenefit.processNote.extension",
        "sliceName" : "processNoteClass",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/processNoteClass"
            ]
          }
        ]
      },
      {
        "id" : "ExplanationOfBenefit.benefitPeriod",
        "path" : "ExplanationOfBenefit.benefitPeriod",
        "min" : 1
      },
      {
        "id" : "ExplanationOfBenefit.benefitBalance",
        "path" : "ExplanationOfBenefit.benefitBalance",
        "short" : "Estimated Balance by Benefit Category as if the expected item(s) or service(s) included in this estimate were applied.",
        "definition" : "Estimated Balance by Benefit Category as if the expected item(s) or service(s) included in this estimate were applied. Note: The available balance is based on known claims and does not account for other Good Faith Estimates (GFEs). Benefit balances will remain unchanged until the claim adjudication process applies benefits. Consequently, if multiple estimates pertain to the same benefit, the benefit balance will not consider other estimates.",
        "min" : 1
      },
      {
        "id" : "ExplanationOfBenefit.benefitBalance.category",
        "path" : "ExplanationOfBenefit.benefitBalance.category",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/davinci-pct/ValueSet/PCTBenefitBalanceCategoryVS"
        }
      },
      {
        "id" : "ExplanationOfBenefit.benefitBalance.category.text",
        "path" : "ExplanationOfBenefit.benefitBalance.category.text",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "ExplanationOfBenefit.benefitBalance.unit",
        "path" : "ExplanationOfBenefit.benefitBalance.unit",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/benefit-unit"
        }
      },
      {
        "id" : "ExplanationOfBenefit.benefitBalance.term",
        "path" : "ExplanationOfBenefit.benefitBalance.term",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/benefit-term"
        }
      },
      {
        "id" : "ExplanationOfBenefit.benefitBalance.financial",
        "path" : "ExplanationOfBenefit.benefitBalance.financial",
        "min" : 1
      },
      {
        "id" : "ExplanationOfBenefit.benefitBalance.financial.extension",
        "path" : "ExplanationOfBenefit.benefitBalance.financial.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "ExplanationOfBenefit.benefitBalance.financial.extension:remaining",
        "path" : "ExplanationOfBenefit.benefitBalance.financial.extension",
        "sliceName" : "remaining",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/remaining-benefit"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ExplanationOfBenefit.benefitBalance.financial.type",
        "path" : "ExplanationOfBenefit.benefitBalance.financial.type",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/davinci-pct/ValueSet/PCTFinancialTypeVS"
        }
      },
      {
        "id" : "ExplanationOfBenefit.benefitBalance.financial.allowed[x]",
        "path" : "ExplanationOfBenefit.benefitBalance.financial.allowed[x]",
        "min" : 1,
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                "valueBoolean" : true
              }
            ],
            "code" : "unsignedInt"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                "valueBoolean" : true
              }
            ],
            "code" : "Money"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ExplanationOfBenefit.benefitBalance.financial.used[x]",
        "path" : "ExplanationOfBenefit.benefitBalance.financial.used[x]",
        "min" : 1,
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                "valueBoolean" : true
              }
            ],
            "code" : "unsignedInt"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                "valueBoolean" : true
              }
            ],
            "code" : "Money"
          }
        ],
        "mustSupport" : true
      }
    ]
  }
}

```
