# PCT AEOB Composition - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PCT AEOB Composition**

## Resource Profile: PCT AEOB Composition 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-aeob-composition | *Version*:2.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:PCTAdvancedEOBComposition |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.4.42.51 | | |

 
PCT AEOB Composition that assembles the contents of an AEOB (represented by one or more individual AEOB resources) into a single logical package. A Composition for the document type Bundle that enables versioning, signing and being referenced by a DocumentReference for searching and subscription notifications. 

### Example Usage

This profile does not include directly linked examples (available in an "Examples" tab at the top of this page) because the profile requires that referenced resources be included in the same bundle in which they exist.

As such, the example of this profile is included in [Advanced Explanation of Benefit Packet example](Bundle-PCT-AEOB-Packet-1.md)

**Usages:**

* Use this Profile: [PCT AEOB Packet](StructureDefinition-davinci-pct-aeob-packet.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.davinci-pct|current/StructureDefinition/davinci-pct-aeob-composition)

**Changes since version 1.1.0:**

* New Content

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-davinci-pct-aeob-composition.csv), [Excel](StructureDefinition-davinci-pct-aeob-composition.xlsx), [Schematron](StructureDefinition-davinci-pct-aeob-composition.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "davinci-pct-aeob-composition",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-aeob-composition",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.4.42.51"
    }
  ],
  "version" : "2.0.0",
  "name" : "PCTAdvancedEOBComposition",
  "title" : "PCT AEOB Composition",
  "status" : "active",
  "date" : "2025-11-26T16:21:43+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "name" : "HL7 International / Financial Management",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        },
        {
          "system" : "email",
          "value" : "fmlists@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "PCT AEOB Composition that assembles the contents of an AEOB (represented by one or more individual AEOB resources) into a single logical package. A Composition for the document type Bundle that enables versioning, signing and being referenced by a DocumentReference for searching and subscription notifications.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "fhirdocumentreference",
      "uri" : "http://hl7.org/fhir/documentreference",
      "name" : "FHIR DocumentReference"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Composition",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Composition",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Composition",
        "path" : "Composition"
      },
      {
        "id" : "Composition.extension",
        "path" : "Composition.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Composition.extension:requestInitiationTime",
        "path" : "Composition.extension",
        "sliceName" : "requestInitiationTime",
        "short" : "Estimate Request instant (instance GFE Packet submitted to payer)",
        "comment" : "Instant from which the request is being initiated. The time of the AEOB request made to a payer to fulfill, this is the time in which the GFE submission was made to the payer.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/requestInitiationTime"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Composition.identifier",
        "path" : "Composition.identifier",
        "min" : 1
      },
      {
        "id" : "Composition.identifier.system",
        "path" : "Composition.identifier.system",
        "min" : 1
      },
      {
        "id" : "Composition.identifier.value",
        "path" : "Composition.identifier.value",
        "min" : 1
      },
      {
        "id" : "Composition.type",
        "path" : "Composition.type",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "111479-2"
            }
          ]
        }
      },
      {
        "id" : "Composition.category",
        "path" : "Composition.category",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "coding"
            }
          ],
          "description" : "Slice defining composition as an estimate - category",
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Composition.category:estimate",
        "path" : "Composition.category",
        "sliceName" : "estimate",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Composition.category:estimate.coding",
        "path" : "Composition.category.coding",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "$this"
            }
          ],
          "description" : "Slice defining composition as an estimate - category coding",
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Composition.category:estimate.coding:estimate-coding",
        "path" : "Composition.category.coding",
        "sliceName" : "estimate-coding",
        "min" : 1,
        "max" : "1",
        "patternCoding" : {
          "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTDocumentTypeTemporaryTrialUse",
          "code" : "estimate"
        },
        "mustSupport" : true
      },
      {
        "id" : "Composition.subject",
        "path" : "Composition.subject",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient|7.0.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Composition.date",
        "path" : "Composition.date",
        "constraint" : [
          {
            "key" : "pct-datetime-to-seconds",
            "severity" : "error",
            "human" : "Datetime must be at least to seconds.",
            "expression" : "$this is dateTime implies $this.toString().length() >= 19",
            "source" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-aeob-composition"
          }
        ]
      },
      {
        "id" : "Composition.author",
        "path" : "Composition.author",
        "short" : "All involved authoring parties, including payer all Good Faith Estimate (GFE) providers",
        "min" : 2,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-organization",
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-practitioner"
            ]
          }
        ]
      },
      {
        "id" : "Composition.title",
        "path" : "Composition.title",
        "mustSupport" : true
      },
      {
        "id" : "Composition.relatesTo",
        "path" : "Composition.relatesTo",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "code"
            }
          ],
          "description" : "Slice different relationships",
          "rules" : "open"
        },
        "short" : "Relationship to other AEOB packets. Required if this estimate is replacing another."
      },
      {
        "id" : "Composition.relatesTo:replaces",
        "path" : "Composition.relatesTo",
        "sliceName" : "replaces",
        "short" : "The identifier of the document (Composition.identifier) this estimate replaces",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Composition.relatesTo:replaces.code",
        "path" : "Composition.relatesTo.code",
        "patternCode" : "replaces"
      },
      {
        "id" : "Composition.relatesTo:replaces.target[x]",
        "path" : "Composition.relatesTo.target[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Composition.relatesTo:replaces.target[x]:targetIdentifier",
        "path" : "Composition.relatesTo.target[x]",
        "sliceName" : "targetIdentifier",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Composition.relatesTo:replaces.target[x]:targetIdentifier.system",
        "path" : "Composition.relatesTo.target[x].system",
        "min" : 1
      },
      {
        "id" : "Composition.relatesTo:replaces.target[x]:targetIdentifier.value",
        "path" : "Composition.relatesTo.target[x].value",
        "min" : 1
      },
      {
        "id" : "Composition.section",
        "path" : "Composition.section",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "code"
            }
          ],
          "description" : "Slice different resources included in the bundle",
          "rules" : "open"
        },
        "short" : "Sections for Advanced Explanation of Benefit (AEOB) Summary, Individual AEOBs, and associates Good Faith Estimates (GFEs)",
        "min" : 3
      },
      {
        "id" : "Composition.section:aeob-summary",
        "path" : "Composition.section",
        "sliceName" : "aeob-summary",
        "short" : "SHALL have a reference to one PCTAdvancedEOBSummary, contained within the document bundle",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:aeob-summary.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTDocumentSection",
              "code" : "aeob-summary-section"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:aeob-summary.entry",
        "path" : "Composition.section.entry",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-aeob-summary"
            ],
            "aggregation" : ["bundled"]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:aeob",
        "path" : "Composition.section",
        "sliceName" : "aeob",
        "short" : "SHALL have a reference to one or more PCTAdvancedEOB resource(s), all contained within the document bundle",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:aeob.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTDocumentSection",
              "code" : "aeob-section"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:aeob.entry",
        "path" : "Composition.section.entry",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-aeob"
            ],
            "aggregation" : ["bundled"]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:gfeBundle",
        "path" : "Composition.section",
        "sliceName" : "gfeBundle",
        "short" : "SHALL reference one PCTGFEBundle or PCTGFEMissingBundle resource, which may be contained in the document bundle or may reference an external resource, and the associated author (GFE Contributor) or proposed author (in the case of a missing GFE Bundle) contained in the document bundle.",
        "min" : 1,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:gfeBundle.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTDocumentSection",
              "code" : "gfe-section"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:gfeBundle.author",
        "path" : "Composition.section.author",
        "short" : "Associated GFE author (GFE Contributor) or proposed author (in the case of a missing GFE Bundle) contained in the document bundle",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-practitioner",
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-organization"
            ],
            "aggregation" : ["bundled"]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:gfeBundle.entry",
        "path" : "Composition.section.entry",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-bundle",
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-missing-bundle"
            ]
          }
        ],
        "mustSupport" : true
      }
    ]
  }
}

```
