# PCT-ServiceRequest-1 - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PCT-ServiceRequest-1**

## Example ServiceRequest: PCT-ServiceRequest-1

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [PCT GFE ServiceRequest](StructureDefinition-davinci-pct-servicerequest.md)

**status**: Active

**intent**: Proposal

**code**: Magnetic resonance (eg, proton) imaging, any joint of lower extremity; with contrast material(s)

**subject**: [Eve Betterhalf Female, DoB: 1955-07-23 ( http://example.com/identifiers/patient#1001)](Patient-patient1001.md)



## Resource Content

```json
{
  "resourceType" : "ServiceRequest",
  "id" : "PCT-ServiceRequest-1",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-servicerequest"
    ]
  },
  "status" : "active",
  "intent" : "proposal",
  "code" : {
    "coding" : [
      {
        "system" : "http://www.ama-assn.org/go/cpt",
        "code" : "73722",
        "display" : "Magnetic resonance (eg, proton) imaging, any joint of lower extremity; with contrast material(s)"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/patient1001"
  }
}

```
