# Submitter-Practitioner-1 - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Submitter-Practitioner-1**

## Example Practitioner: Submitter-Practitioner-1

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [PCT Practitioner](StructureDefinition-davinci-pct-practitioner.md)

**identifier**: [United States National Provider Identifier](http://terminology.hl7.org/6.5.0/NamingSystem-npi.html)/9941339100, Electronic Transmitter Identification Number/ETIN-20020001

**active**: true

**name**: Nora Ologist

**telecom**: ph: 860-547-3301(Work), [csender@GFEServiceHelp.com](mailto:csender@GFEServiceHelp.com)



## Resource Content

```json
{
  "resourceType" : "Practitioner",
  "id" : "Submitter-Practitioner-1",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-practitioner"
    ]
  },
  "identifier" : [
    {
      "system" : "http://hl7.org/fhir/sid/us-npi",
      "value" : "9941339100"
    },
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "ETIN"
          }
        ]
      },
      "system" : "http://example.com/us-etin",
      "value" : "ETIN-20020001"
    }
  ],
  "active" : true,
  "name" : [
    {
      "text" : "Nora Ologist",
      "family" : "Ologist",
      "given" : ["Nora"]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "860-547-3301",
      "use" : "work"
    },
    {
      "system" : "email",
      "value" : "csender@GFEServiceHelp.com",
      "use" : "work"
    }
  ]
}

```
