# org1002 - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **org1002**

## Example Organization: org1002

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [PCT Organization](StructureDefinition-davinci-pct-organization.md)

**identifier**: [United States National Provider Identifier](http://terminology.hl7.org/6.5.0/NamingSystem-npi.html)/9941339100, Tax ID number/TAX-3211001

**active**: true

**type**: Healthcare Provider

**name**: Boston Radiology Center

**telecom**: ph: 781-232-3200(Work)

**address**: 32 Fruit Street Boston MA 02114 US 



## Resource Content

```json
{
  "resourceType" : "Organization",
  "id" : "org1002",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-organization"
    ]
  },
  "identifier" : [
    {
      "system" : "http://hl7.org/fhir/sid/us-npi",
      "value" : "9941339100"
    },
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "TAX"
          }
        ]
      },
      "system" : "urn:oid:2.16.840.1.113883.4.4",
      "value" : "TAX-3211001"
    }
  ],
  "active" : true,
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/organization-type",
          "code" : "prov",
          "display" : "Healthcare Provider"
        }
      ]
    }
  ],
  "name" : "Boston Radiology Center",
  "telecom" : [
    {
      "system" : "phone",
      "value" : "781-232-3200",
      "use" : "work"
    }
  ],
  "address" : [
    {
      "line" : ["32 Fruit Street"],
      "city" : "Boston",
      "state" : "MA",
      "postalCode" : "02114",
      "country" : "US"
    }
  ]
}

```
