# PCT-MedicationRequest-1 - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PCT-MedicationRequest-1**

## Example MedicationRequest: PCT-MedicationRequest-1

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [PCT GFE MedicationRequest](StructureDefinition-davinci-pct-medicationrequest.md)

**status**: Active

**intent**: Proposal

**medication**: gadobenate

**subject**: [Eve Betterhalf Female, DoB: 1955-07-23 ( http://example.com/identifiers/patient#1001)](Patient-patient1001.md)



## Resource Content

```json
{
  "resourceType" : "MedicationRequest",
  "id" : "PCT-MedicationRequest-1",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-medicationrequest"
    ]
  },
  "status" : "active",
  "intent" : "proposal",
  "medicationCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://www.nlm.nih.gov/research/umls/rxnorm",
        "code" : "692620",
        "display" : "gadobenate"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/patient1001"
  }
}

```
