# PCT-AEOB-Summary-1 - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PCT-AEOB-Summary-1**

## Example ExplanationOfBenefit: PCT-AEOB-Summary-1

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [PCT Advanced EOB Summary](StructureDefinition-davinci-pct-aeob-summary.md)

**Service Description**: Example service

**In Network Provider Options Link**: [http://example.org/out-of-network.html](http://example.org/out-of-network.html)

**status**: Active

**type**: Estimate Summary

**use**: Predetermination

**patient**: [Eve Betterhalf Female, DoB: 1955-07-23 ( http://example.com/identifiers/patient#1001)](Patient-patient1001.md)

**billablePeriod**: 2022-01-01 --> 2022-01-01

**created**: 2021-10-12

**insurer**: [Organization Umbrella Insurance Company](Organization-org1001.md)

**provider**: ?rref?

**outcome**: Processing Complete

### Insurances

| | | |
| :--- | :--- | :--- |
| - | **Focal** | **Coverage** |
| * | true | [Coverage: extension = insurance; status = active; subscriberId = PFP123450000; relationship = Self; period = 2021-01-01 --> 2022-01-01](Coverage-coverage1001.md) |

> **total****category**:Submitted Amount

### Amounts

| | | |
| :--- | :--- | :--- |
| - | **Value** | **Currency** |
| * | 200 | United States dollar |


> **total****category**:Member liability

### Amounts

| | | |
| :--- | :--- | :--- |
| - | **Value** | **Currency** |
| * | 20 | United States dollar |


> **total****category**:Eligible Amount

### Amounts

| | | |
| :--- | :--- | :--- |
| - | **Value** | **Currency** |
| * | 190 | United States dollar |


### ProcessNotes

| | | |
| :--- | :--- | :--- |
| - | **Extension** | **Text** |
| * |  | processNote disclaimer text |

**benefitPeriod**: 2022-01-01 --> 2022-01-01

> **benefitBalance****category**:Medical Care**unit**:Individual**term**:Annual

### Financials

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| - | **Extension** | **Type** | **Allowed[x]** | **Used[x]** |
| * |  | Allowed | $1.00(USD) | $1.00(USD) |




## Resource Content

```json
{
  "resourceType" : "ExplanationOfBenefit",
  "id" : "PCT-AEOB-Summary-1",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-aeob-summary"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/serviceDescription",
      "valueString" : "Example service"
    },
    {
      "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/inNetworkProviderOptionsLink",
      "valueUrl" : "http://example.org/out-of-network.html"
    }
  ],
  "status" : "active",
  "type" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTEstimateTypeSummaryCSTemporaryTrialUse",
        "code" : "estimate-summary",
        "display" : "Estimate Summary"
      }
    ]
  },
  "use" : "predetermination",
  "patient" : {
    "reference" : "Patient/patient1001"
  },
  "billablePeriod" : {
    "start" : "2022-01-01",
    "end" : "2022-01-01"
  },
  "created" : "2021-10-12",
  "insurer" : {
    "reference" : "Organization/org1001"
  },
  "provider" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
        "valueCode" : "not-applicable"
      }
    ]
  },
  "outcome" : "complete",
  "insurance" : [
    {
      "focal" : true,
      "coverage" : {
        "reference" : "Coverage/coverage1001"
      }
    }
  ],
  "total" : [
    {
      "category" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/adjudication",
            "version" : "1.0.1",
            "code" : "submitted",
            "display" : "Submitted Amount"
          }
        ]
      },
      "amount" : {
        "value" : 200,
        "currency" : "USD"
      }
    },
    {
      "category" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTAdjudicationCategoryCS",
            "code" : "memberliability",
            "display" : "Member liability"
          }
        ]
      },
      "amount" : {
        "value" : 20,
        "currency" : "USD"
      }
    },
    {
      "category" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/adjudication",
            "version" : "1.0.1",
            "code" : "eligible",
            "display" : "Eligible Amount"
          }
        ]
      },
      "amount" : {
        "value" : 190,
        "currency" : "USD"
      }
    }
  ],
  "processNote" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/processNoteClass",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTAEOBProcessNoteCS",
                "code" : "disclaimer",
                "display" : "Disclaimer"
              }
            ]
          }
        }
      ],
      "text" : "processNote disclaimer text"
    }
  ],
  "benefitPeriod" : {
    "start" : "2022-01-01",
    "end" : "2022-01-01"
  },
  "benefitBalance" : [
    {
      "category" : {
        "coding" : [
          {
            "system" : "https://x12.org/codes/service-type-codes",
            "code" : "1",
            "display" : "Medical Care"
          }
        ],
        "text" : "Medical Care"
      },
      "unit" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/benefit-unit",
            "code" : "individual"
          }
        ]
      },
      "term" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/benefit-term",
            "code" : "annual"
          }
        ]
      },
      "financial" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/remaining-benefit",
              "valueMoney" : {
                "value" : 0,
                "currency" : "USD"
              }
            }
          ],
          "type" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTFinancialType",
                "code" : "allowed"
              }
            ]
          },
          "allowedMoney" : {
            "value" : 1,
            "currency" : "USD"
          },
          "usedMoney" : {
            "value" : 1,
            "currency" : "USD"
          }
        }
      ]
    }
  ]
}

```
