# PCT-GFE-DocumentReference-Prof-1 - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PCT-GFE-DocumentReference-Prof-1**

## Example DocumentReference: PCT-GFE-DocumentReference-Prof-1

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [PCT GFE Packet Document Reference](StructureDefinition-davinci-pct-gfe-documentreference.md)

**Request Initiation Time**: 2025-01-08 09:01:00+0500

**Significant Procedures and/or products involved**: Magnetic resonance (eg, proton) imaging, brain (including brain stem); without contrast material

**Significant condition involved**: Unspecified focal traumatic brain injury

**status**: Current

**docStatus**: Final

**type**: Good faith estimate

**category**: Estimation Packet

**subject**: [Eve Betterhalf Female, DoB: 1955-07-23 ( http://example.com/identifiers/patient#1001)](Patient-patient1001.md)

**date**: 2025-01-10 11:01:00+0500

**author**: 

* [Organization Umbrella Insurance Company](Organization-org1001.md)
* [Organization GFE Service Help INC.](Organization-Submitter-Org-1.md)

> **content**

### Attachments

| | |
| :--- | :--- |
| - | **Url** |
| * | [http://example.org/fhir/Bundle/PCT-GFE-Packet-Prof-1](http://example.org/fhir/Bundle/PCT-GFE-Packet-Prof-1) |




## Resource Content

```json
{
  "resourceType" : "DocumentReference",
  "id" : "PCT-GFE-DocumentReference-Prof-1",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-documentreference"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/requestInitiationTime",
      "valueInstant" : "2025-01-08T09:01:00+05:00"
    },
    {
      "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/estimateProcedureOrService",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://www.ama-assn.org/go/cpt",
            "code" : "70551",
            "display" : "Magnetic resonance (eg, proton) imaging, brain (including brain stem); without contrast material"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/estimateCondition",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/sid/icd-10-cm",
            "code" : "S06.30",
            "display" : "Unspecified focal traumatic brain injury"
          }
        ]
      }
    }
  ],
  "status" : "current",
  "docStatus" : "final",
  "type" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "111480-0",
        "display" : "Good faith estimate"
      }
    ]
  },
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTDocumentTypeTemporaryTrialUse",
          "code" : "estimate"
        }
      ]
    }
  ],
  "subject" : {
    "reference" : "Patient/patient1001"
  },
  "date" : "2025-01-10T11:01:00+05:00",
  "author" : [
    {
      "reference" : "Organization/org1001"
    },
    {
      "reference" : "Organization/Submitter-Org-1"
    }
  ],
  "content" : [
    {
      "attachment" : {
        "url" : "http://example.org/fhir/Bundle/PCT-GFE-Packet-Prof-1"
      }
    }
  ]
}

```
