# PCT-DeviceRequest-1 - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PCT-DeviceRequest-1**

## Example DeviceRequest: PCT-DeviceRequest-1

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [PCT GFE DeviceRequest](StructureDefinition-davinci-pct-devicerequest.md)

**status**: Active

**intent**: Proposal

**code**: KNEE ORTHOSIS, ELASTIC WITH CONDYLAR PADS AND JOINTS, WITH OR WITHOUT PATELLAR CONTROL, PREFABRICATED, INCLUDES FITTING AND ADJUSTMENT

**subject**: [Eve Betterhalf Female, DoB: 1955-07-23 ( http://example.com/identifiers/patient#1001)](Patient-patient1001.md)



## Resource Content

```json
{
  "resourceType" : "DeviceRequest",
  "id" : "PCT-DeviceRequest-1",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-devicerequest"
    ]
  },
  "status" : "active",
  "intent" : "proposal",
  "codeCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://www.cms.gov/Medicare/Coding/HCPCSReleaseCodeSets",
        "code" : "L1820",
        "display" : "KNEE ORTHOSIS, ELASTIC WITH CONDYLAR PADS AND JOINTS, WITH OR WITHOUT PATELLAR CONTROL, PREFABRICATED, INCLUDES FITTING AND ADJUSTMENT"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/patient1001"
  }
}

```
