# selfpaycoverage2001 - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **selfpaycoverage2001**

## Example Coverage: selfpaycoverage2001

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [PCT Coverage](StructureDefinition-davinci-pct-coverage.md)

**Extension Definition for Coverage.kind for Version 5.0**: self-pay

**Self-Pay Declared**: true

**status**: Active

**subscriberId**: Absent because : not-applicable

**beneficiary**: [Eve Betterhalf Female, DoB: 1955-07-23 ( http://example.com/identifiers/patient#1001)](Patient-patient1001.md)

**relationship**: Self

**payor**: [Eve Betterhalf Female, DoB: 1955-07-23 ( http://example.com/identifiers/patient#1001)](Patient-patient1001.md)



## Resource Content

```json
{
  "resourceType" : "Coverage",
  "id" : "selfpaycoverage2001",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-coverage"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Coverage.kind",
      "valueCode" : "self-pay"
    },
    {
      "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/selfPayDeclared",
      "valueBoolean" : true
    }
  ],
  "status" : "active",
  "_subscriberId" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
        "valueCode" : "not-applicable"
      }
    ]
  },
  "beneficiary" : {
    "reference" : "Patient/patient1001"
  },
  "relationship" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/subscriber-relationship",
        "code" : "self",
        "display" : "Self"
      }
    ]
  },
  "payor" : [
    {
      "reference" : "Patient/patient1001"
    }
  ]
}

```
