# PCT GFE Supporting Info Type Code System - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PCT GFE Supporting Info Type Code System**

## CodeSystem: PCT GFE Supporting Info Type Code System 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTSupportingInfoType | *Version*:2.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:PCTSupportingInfoType |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.4.16.17 | | |
| **Copyright/Legal**: This CodeSystem is not copyrighted. | | |

 
Defining codes for the classification of the supplied supporting information. This CodeSystem is currently defined by this IG, but is anticipated to be temporary. The concepts within are expected to be moved in a future version to a more central terminology specification such as THO, which will result in a code system url change and possibly modified codes and definitions. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [PCTSupportingInfoTypeVS](ValueSet-PCTSupportingInfoTypeVS.md)

**Changes since version 1.1.0:**

* The resource metadata has changed (description)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "PCTSupportingInfoType",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-pct/ImplementationGuide/hl7.fhir.us.davinci-pct"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-pct/ImplementationGuide/hl7.fhir.us.davinci-pct"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTSupportingInfoType",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.4.16.17"
    }
  ],
  "version" : "2.0.0",
  "name" : "PCTSupportingInfoType",
  "title" : "PCT GFE Supporting Info Type Code System",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-26T16:21:43+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "name" : "HL7 International / Financial Management",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        },
        {
          "system" : "email",
          "value" : "fmlists@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "Defining codes for the classification of the supplied supporting information. This CodeSystem is currently defined by this IG, but is anticipated to be temporary. The concepts within are expected to be moved in a future version to a more central terminology specification such as THO, which will result in a code system url change and possibly modified codes and definitions.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "copyright" : "This CodeSystem is not copyrighted.",
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 7,
  "concept" : [
    {
      "code" : "cmspos",
      "display" : "CMS Place of Service",
      "definition" : "Place of Service Codes are two-digit codes placed on health care professional claims to indicate the setting in which a service was provided. The Centers for Medicare & Medicaid Services (CMS) maintain POS codes used throughout the health care industry."
    },
    {
      "code" : "typeofbill",
      "display" : "Type of Bill",
      "definition" : "UB-04 Type of Bill (FL-04) provides specific information for payer purposes."
    },
    {
      "code" : "servicefacility",
      "display" : "Service Facility",
      "definition" : "The facility where the service occurred. Examples include hospitals, nursing homes, laboratories or homeless shelters."
    },
    {
      "code" : "drg",
      "display" : "DRG",
      "definition" : "DRG (Diagnosis Related Group), including the code system, the DRG version and the code value"
    },
    {
      "code" : "pointoforigin",
      "display" : "Point of Origin",
      "definition" : "UB-04 Source of Admission (FL-15) identifies the place where the patient is identified as needing admission to a facility."
    },
    {
      "code" : "admtype",
      "display" : "Admission Type",
      "definition" : "UB-04 Priority of the admission (FL-14) indicates, for example, an admission type of elective indicates that the patient's condition permitted time for medical services to be scheduled."
    },
    {
      "code" : "claimFrequency",
      "display" : "Claim Frequency",
      "definition" : "Claim frequency - uses the last digit of the NUBC type of billing code."
    }
  ]
}

```
