# PCT GFE Request Type Codes Code System - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PCT GFE Request Type Codes Code System**

## CodeSystem: PCT GFE Request Type Codes Code System 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTGFERequestTypeCSTemporaryTrialUse | *Version*:2.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:PCTGFERequestTypeCSTemporaryTrialUse |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.4.16.10 | | |
| **Copyright/Legal**: This CodeSystem is not copyrighted. | | |

 
Codes for defining GFE request types. This CodeSystem is currently defined by this IG, but is anticipated to be temporary. The concepts within are expected to be moved in a future version to a more central terminology specification such as THO, which will result in a code system url change and possibly modified codes and definitions. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [PCTGFERequestTypeVS](ValueSet-PCTGFERequestTypeVS.md)

**Changes since version 1.1.0:**

* New Content



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "PCTGFERequestTypeCSTemporaryTrialUse",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-pct/ImplementationGuide/hl7.fhir.us.davinci-pct"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-pct/ImplementationGuide/hl7.fhir.us.davinci-pct"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTGFERequestTypeCSTemporaryTrialUse",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.4.16.10"
    }
  ],
  "version" : "2.0.0",
  "name" : "PCTGFERequestTypeCSTemporaryTrialUse",
  "title" : "PCT GFE Request Type Codes Code System",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-26T16:21:43+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "name" : "HL7 International / Financial Management",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        },
        {
          "system" : "email",
          "value" : "fmlists@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "Codes for defining GFE request types. This CodeSystem is currently defined by this IG, but is anticipated to be temporary. The concepts within are expected to be moved in a future version to a more central terminology specification such as THO, which will result in a code system url change and possibly modified codes and definitions.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "copyright" : "This CodeSystem is not copyrighted.",
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 4,
  "concept" : [
    {
      "code" : "gfe-coordination-task",
      "display" : "GFE Coordination Task",
      "definition" : "The Coordination Task representing the general request for a Good Faith Estimate (GFE) from all potential GFE contributors."
    },
    {
      "code" : "gfe-contributor-task",
      "display" : "GFE Contributor Task",
      "definition" : "The Contributor Task representing a provider specific request for a Good Faith Estimate (GFE)."
    },
    {
      "code" : "scheduled-request",
      "display" : "Scheduled Service Request",
      "definition" : "Request of a GFE for a scheduled service."
    },
    {
      "code" : "nonscheduled-request",
      "display" : "Nonscheduled Service Request",
      "definition" : "Request of a GFE for a scheduled service, such as a request from a patient."
    }
  ]
}

```
