# PCT Financial Type Code System - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PCT Financial Type Code System**

## CodeSystem: PCT Financial Type Code System 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTFinancialType | *Version*:2.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:PCTFinancialType |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.4.16.8 | | |
| **Copyright/Legal**: This CodeSystem is not copyrighted. | | |

 
Financial Type codes for benefitBalance.financial.type. This CodeSystem is currently defined by this IG, but is anticipated to be temporary. The concepts within are expected to be moved in a future version to a more central terminology specification such as THO, which will result in a code system url change and possibly modified codes and definitions. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [PCTFinancialTypeVS](ValueSet-PCTFinancialTypeVS.md)

**Changes since version 1.1.0:**

* The resource metadata has changed (description)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "PCTFinancialType",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-pct/ImplementationGuide/hl7.fhir.us.davinci-pct"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-pct/ImplementationGuide/hl7.fhir.us.davinci-pct"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTFinancialType",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.4.16.8"
    }
  ],
  "version" : "2.0.0",
  "name" : "PCTFinancialType",
  "title" : "PCT Financial Type Code System",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-26T16:21:43+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "name" : "HL7 International / Financial Management",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        },
        {
          "system" : "email",
          "value" : "fmlists@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "Financial Type codes for benefitBalance.financial.type. This CodeSystem is currently defined by this IG, but is anticipated to be temporary. The concepts within are expected to be moved in a future version to a more central terminology specification such as THO, which will result in a code system url change and possibly modified codes and definitions.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "copyright" : "This CodeSystem is not copyrighted.",
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 10,
  "concept" : [
    {
      "code" : "allowed",
      "display" : "Allowed",
      "definition" : "The maximum amount a plan will pay for a covered health care service. May also be called \"payment allowance\", or \"negotiated rate\"."
    },
    {
      "code" : "coinsurance",
      "display" : "Co-Insurance",
      "definition" : "The amount the insured individual pays, as a set percentage of the cost of covered services, as an out-of-pocket payment to the provider. Example: Insured pays 20% and the insurer pays 80%."
    },
    {
      "code" : "copay",
      "display" : "CoPay",
      "definition" : "A fixed amount ($20, for example) the insured individual pays for a covered health care service after the deductible is paid."
    },
    {
      "code" : "deductible",
      "display" : "Deductible",
      "definition" : "The amount the insured individual pays for covered health care services before the insurance plan starts to pay."
    },
    {
      "code" : "eligible",
      "display" : "Eligible Amount",
      "definition" : "Amount of the charge which is considered for adjudication."
    },
    {
      "code" : "memberliability",
      "display" : "Member Liability",
      "definition" : "The amount of the member's liability."
    },
    {
      "code" : "noncovered",
      "display" : "Noncovered",
      "definition" : "The portion of the cost of the service that was deemed not eligible by the insurer because the service or member was not covered by the subscriber contract."
    },
    {
      "code" : "out-of-pocket-maximum",
      "display" : "Out-of-Pocket Maximum",
      "definition" : "The most the insured individual has to pay for covered services in a plan year. After this amount is spent on deductibles, copayments, and coinsurance for in-network care and services, the health plan pays 100% of the costs of covered benefits."
    },
    {
      "code" : "visit",
      "display" : "Visit",
      "definition" : "A medical visit means diagnostic, therapeutic, or consultative services provided to a client by a healthcare professional in an outpatient setting."
    },
    {
      "code" : "penalty",
      "display" : "Penalty",
      "definition" : "Benefit penalty is an approach used by the insurance company to reduce their payment on a claim when the patient or medical provider does not satisfy the rules of the health plan. Benefit penalties may occur when a pre-authorization is not obtained, for example."
    }
  ]
}

```
