# PCT Adjudication Category CodeSystem - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PCT Adjudication Category CodeSystem**

## CodeSystem: PCT Adjudication Category CodeSystem 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTAdjudicationCategoryCS | *Version*:2.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:PCTAdjudicationCategoryCS |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.4.16.3 | | |

 
Codes indicating the type of adjudication information provided. This CodeSystem is currently defined by this IG, but is anticipated to be temporary. The concepts within are expected to be moved in a future version to a more central terminology specification such as THO, which will result in a code system url change and possibly modified codes and definitions. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [PCTAdjudicationCategoryVS](ValueSet-PCTAdjudicationCategoryVS.md)

**Changes since version 1.1.0:**

* The resource metadata has changed (description)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "PCTAdjudicationCategoryCS",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-pct/ImplementationGuide/hl7.fhir.us.davinci-pct"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-pct/ImplementationGuide/hl7.fhir.us.davinci-pct"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTAdjudicationCategoryCS",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.4.16.3"
    }
  ],
  "version" : "2.0.0",
  "name" : "PCTAdjudicationCategoryCS",
  "title" : "PCT Adjudication Category CodeSystem",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-26T16:21:43+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "name" : "HL7 International / Financial Management",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        },
        {
          "system" : "email",
          "value" : "fmlists@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "Codes indicating the type of adjudication information provided. This CodeSystem is currently defined by this IG, but is anticipated to be temporary. The concepts within are expected to be moved in a future version to a more central terminology specification such as THO, which will result in a code system url change and possibly modified codes and definitions.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 6,
  "concept" : [
    {
      "code" : "billingnetworkstatus",
      "display" : "Billing Network Status",
      "definition" : "Indicates the Billing Provider network status in relation to the patient's coverage."
    },
    {
      "code" : "renderingnetworkstatus",
      "display" : "Rendering Network Status",
      "definition" : "Indicates the Rendering Provider network status in relation to the patient's coverage."
    },
    {
      "code" : "benefitpaymentstatus",
      "display" : "Benefit Payment Status",
      "definition" : "Indicates the in network or out of network payment status of the claim."
    },
    {
      "code" : "adjustmentreason",
      "display" : "Adjustment Reason",
      "definition" : "Defines the adjudication slice to identify the adjustment reason"
    },
    {
      "code" : "medicalmanagement",
      "display" : "Medical Management",
      "definition" : "Defines the adjudication slice to identify medical management"
    },
    {
      "code" : "memberliability",
      "display" : "Member Liability",
      "definition" : "Defines the adjudication slice to identify member liability"
    }
  ]
}

```
