# PCT-GFE-Summary-MRI - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PCT-GFE-Summary-MRI**

## Example Claim: PCT-GFE-Summary-MRI

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [PCT Good Faith Estimate Summary](StructureDefinition-davinci-pct-gfe-summary.md)

**status**: Active

**type**: Estimate Summary

**use**: Predetermination

**patient**: [Eve Betterhalf Female, DoB: 1955-07-23 ( http://example.com/identifiers/patient#1001)](Patient-patient1001.md)

**billablePeriod**: 2021-10-31 --> (ongoing)

**created**: 2021-10-05

**insurer**: [Organization Umbrella Insurance Company](Organization-org1001.md)

**provider**: ?rref?

**priority**: Normal

### Diagnoses

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| - | **Sequence** | **Diagnosis[x]** | **Type** | **PackageCode** |
| * | 1 | Unspecified focal traumatic brain injury | Principal Diagnosis | Head trauma - concussion |

### Insurances

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Sequence** | **Focal** | **Coverage** |
| * | 1 | true | [Coverage: extension = insurance; status = active; subscriberId = PFP123450000; relationship = Self; period = 2021-01-01 --> 2022-01-01](Coverage-coverage1001.md) |

### Totals

| | | |
| :--- | :--- | :--- |
| - | **Value** | **Currency** |
| * | 200 | United States dollar |



## Resource Content

```json
{
  "resourceType" : "Claim",
  "id" : "PCT-GFE-Summary-MRI",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-summary"
    ]
  },
  "status" : "active",
  "type" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTEstimateTypeSummaryCSTemporaryTrialUse",
        "code" : "estimate-summary",
        "display" : "Estimate Summary"
      }
    ]
  },
  "use" : "predetermination",
  "patient" : {
    "reference" : "Patient/patient1001"
  },
  "billablePeriod" : {
    "start" : "2021-10-31"
  },
  "created" : "2021-10-05",
  "insurer" : {
    "reference" : "Organization/org1001"
  },
  "provider" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
        "valueCode" : "not-applicable"
      }
    ]
  },
  "priority" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/processpriority",
        "code" : "normal"
      }
    ]
  },
  "diagnosis" : [
    {
      "sequence" : 1,
      "diagnosisCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/sid/icd-10-cm",
            "code" : "S06.30",
            "display" : "Unspecified focal traumatic brain injury"
          }
        ]
      },
      "type" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/diagnosistype",
              "code" : "principal"
            }
          ]
        }
      ],
      "packageCode" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/ex-diagnosisrelatedgroup",
            "code" : "400",
            "display" : "Head trauma - concussion"
          }
        ]
      }
    }
  ],
  "insurance" : [
    {
      "sequence" : 1,
      "focal" : true,
      "coverage" : {
        "reference" : "Coverage/coverage1001"
      }
    }
  ],
  "total" : {
    "value" : 200,
    "currency" : "USD"
  }
}

```
