# PCT-GFE-Professional-MRI - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PCT-GFE-Professional-MRI**

## Example Claim: PCT-GFE-Professional-MRI

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [PCT Good Faith Estimate Professional](StructureDefinition-davinci-pct-gfe-professional.md)

**ProviderEventMethodology**: EEMM1022

> **GFEServiceLinkingInfo**
* linkingIdentifier: `http://example.org/Claim/identifiers`/223452-2342-2435-008001
* plannedPeriodOfService: 2021-10-31

**identifier**: Placer Identifier/GFEProviderAssignedID0002

**status**: Active

**type**: Professional

**use**: Predetermination

**patient**: [Eve Betterhalf Female, DoB: 1955-07-23 ( http://example.com/identifiers/patient#1001)](Patient-patient1001.md)

**created**: 2021-10-05

**insurer**: [Organization Umbrella Insurance Company](Organization-org1001.md)

**provider**: [Practitioner Nora Ologist](Practitioner-Submitter-Practitioner-1.md)

**priority**: Normal

### Payees

| | |
| :--- | :--- |
| - | **Type** |
| * | Provider |

**referral**: Referral Number

### Diagnoses

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| - | **Sequence** | **Diagnosis[x]** | **Type** | **PackageCode** |
| * | 1 | Unspecified focal traumatic brain injury | Principal Diagnosis | Head trauma - concussion |

### Insurances

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Sequence** | **Focal** | **Coverage** |
| * | 1 | true | [Coverage: extension = insurance; status = active; subscriberId = PFP123450000; relationship = Self; period = 2021-01-01 --> 2022-01-01](Coverage-coverage1001.md) |

> **item****Service Description**: Imaging**GFEBillingProviderLineItemCtrlNum**: GFEBillingProviderLineItemCtrlNum-0001**sequence**: 1**productOrService**:Magnetic resonance (eg, proton) imaging, brain (including brain stem); without contrast material**modifier**:Magnetic resonance (eg, proton) imaging, brain (including brain stem); without contrast material**serviced**: 2021-10-31**location**:Inpatient Hospital**quantity**: 1

### UnitPrices

| | | |
| :--- | :--- | :--- |
| - | **Value** | **Currency** |
| * | 200 | United States dollar |

### Nets

| | | |
| :--- | :--- | :--- |
| - | **Value** | **Currency** |
| * | 200 | United States dollar |


### Totals

| | | |
| :--- | :--- | :--- |
| - | **Value** | **Currency** |
| * | 200 | United States dollar |



## Resource Content

```json
{
  "resourceType" : "Claim",
  "id" : "PCT-GFE-Professional-MRI",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-professional"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/providerEventMethodology",
      "valueString" : "EEMM1022"
    },
    {
      "extension" : [
        {
          "url" : "linkingIdentifier",
          "valueIdentifier" : {
            "system" : "http://example.org/Claim/identifiers",
            "value" : "223452-2342-2435-008001"
          }
        },
        {
          "url" : "plannedPeriodOfService",
          "valueDate" : "2021-10-31"
        }
      ],
      "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/gfeServiceLinkingInfo"
    }
  ],
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "PLAC",
            "display" : "Placer Identifier"
          }
        ]
      },
      "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
      "value" : "GFEProviderAssignedID0002"
    }
  ],
  "status" : "active",
  "type" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/claim-type",
        "code" : "professional",
        "display" : "Professional"
      }
    ]
  },
  "use" : "predetermination",
  "patient" : {
    "reference" : "Patient/patient1001"
  },
  "created" : "2021-10-05",
  "insurer" : {
    "reference" : "Organization/org1001"
  },
  "provider" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/providerTaxonomy",
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://nucc.org/provider-taxonomy",
              "code" : "2085D0003X",
              "display" : "Diagnostic Neuroimaging (Radiology) Physician"
            }
          ]
        }
      }
    ],
    "reference" : "Practitioner/Submitter-Practitioner-1"
  },
  "priority" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/processpriority",
        "code" : "normal"
      }
    ]
  },
  "payee" : {
    "type" : {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/payeetype",
          "code" : "provider"
        }
      ]
    }
  },
  "referral" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/referralNumber",
        "valueString" : "REF12022002-122"
      }
    ],
    "display" : "Referral Number"
  },
  "diagnosis" : [
    {
      "sequence" : 1,
      "diagnosisCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/sid/icd-10-cm",
            "code" : "S06.30",
            "display" : "Unspecified focal traumatic brain injury"
          }
        ]
      },
      "type" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/diagnosistype",
              "code" : "principal"
            }
          ]
        }
      ],
      "packageCode" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/ex-diagnosisrelatedgroup",
            "code" : "400",
            "display" : "Head trauma - concussion"
          }
        ]
      }
    }
  ],
  "insurance" : [
    {
      "sequence" : 1,
      "focal" : true,
      "coverage" : {
        "reference" : "Coverage/coverage1001"
      }
    }
  ],
  "item" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/serviceDescription",
          "valueString" : "Imaging"
        },
        {
          "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/gfeBillingProviderLineItemCtrlNum",
          "valueIdentifier" : {
            "value" : "GFEBillingProviderLineItemCtrlNum-0001"
          }
        }
      ],
      "sequence" : 1,
      "productOrService" : {
        "coding" : [
          {
            "system" : "http://www.ama-assn.org/go/cpt",
            "code" : "70551",
            "display" : "Magnetic resonance (eg, proton) imaging, brain (including brain stem); without contrast material"
          }
        ]
      },
      "modifier" : [
        {
          "coding" : [
            {
              "system" : "http://www.ama-assn.org/go/cpt",
              "code" : "70551",
              "display" : "Magnetic resonance (eg, proton) imaging, brain (including brain stem); without contrast material"
            }
          ]
        }
      ],
      "servicedDate" : "2021-10-31",
      "locationCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://www.cms.gov/Medicare/Coding/place-of-service-codes/Place_of_Service_Code_Set",
            "code" : "21",
            "display" : "Inpatient Hospital"
          }
        ]
      },
      "quantity" : {
        "value" : 1
      },
      "unitPrice" : {
        "value" : 200,
        "currency" : "USD"
      },
      "net" : {
        "value" : 200,
        "currency" : "USD"
      }
    }
  ],
  "total" : {
    "value" : 200,
    "currency" : "USD"
  }
}

```
