# PCT-AEOB-Packet-1 - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PCT-AEOB-Packet-1**

## Example Bundle: PCT-AEOB-Packet-1

**Document Details**

Profile: [PCT AEOB Packet](StructureDefinition-davinci-pct-aeob-packet.md)

Final Document at 2025-01-10 11:01:00+0500 by [Organization Umbrella Insurance Company](Organization-org1001.md), [Organization GFE Service Help INC.](Organization-Submitter-Org-1.md) for [Eve Betterhalf Female, DoB: 1955-07-23 ( http://example.com/identifiers/patient#1001)](Patient-patient1001.md) 

-------

**Document Subject**

**Eve Betterhalf** female, DoB: 1955-07-23 ( `http://example.com/identifiers/patient`/1001)

-------

| | |
| :--- | :--- |
| Marital Status: | unmarried |
| Contact Details: | * ph: 781-949-4949(MOBILE)
* 222 Burlington Road, Bedford MA 01730
 |
| Language: | English (United States)(preferred) |

-------

-------

## Additional Resources Included in Document

-------

Entry 2 - fullUrl = http://example.org/fhir/ExplanationOfBenefit/PCT-AEOB-Summary-1

Resource ExplanationOfBenefit:

> 

Profile: [PCT Advanced EOB Summary](StructureDefinition-davinci-pct-aeob-summary.md)

**Service Description**: Example service**In Network Provider Options Link**:[http://example.org/out-of-network.html](http://example.org/out-of-network.html)**status**: Active**type**:Estimate Summary**use**: Predetermination**patient**:[Eve Betterhalf Female, DoB: 1955-07-23 ( http://example.com/identifiers/patient#1001)](Patient-patient1001.md)**billablePeriod**: 2022-01-01 --> 2022-01-01**created**: 2021-10-12**insurer**:[Organization Umbrella Insurance Company](Organization-org1001.md)**provider**: ?rref?**outcome**: complete

### Insurances

| | | |
| :--- | :--- | :--- |
| - | **Focal** | **Coverage** |
| * | true | [Coverage: extension = insurance; status = active; subscriberId = PFP123450000; relationship = Self; period = 2021-01-01 --> 2022-01-01](Coverage-coverage1001.md) |

> **total****category**:Submitted Amount

### Amounts

| | | |
| :--- | :--- | :--- |
| - | **Value** | **Currency** |
| * | 200 | USD |


> **total****category**:Member liability

### Amounts

| | | |
| :--- | :--- | :--- |
| - | **Value** | **Currency** |
| * | 20 | USD |


> **total****category**:Eligible Amount

### Amounts

| | | |
| :--- | :--- | :--- |
| - | **Value** | **Currency** |
| * | 190 | USD |


### ProcessNotes

| | | |
| :--- | :--- | :--- |
| - | **Extension** | **Text** |
| * |  | processNote disclaimer text |

**benefitPeriod**: 2022-01-01 --> 2022-01-01
> **benefitBalance****category**:Medical Care**unit**:Individual**term**:Annual

### Financials

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| - | **Extension** | **Type** | **Allowed[x]** | **Used[x]** |
| * |  | Allowed | $1.00(USD) | $1.00(USD) |



-------

Entry 3 - fullUrl = http://example.org/fhir/ExplanationOfBenefit/PCT-AEOB-1

Resource ExplanationOfBenefit:

> 

Profile: [PCT Advanced EOB](StructureDefinition-davinci-pct-aeob.md)

**GFE Reference**:[Bundle: identifier = http://example.com/identifiers/bundle#59688475-2324-3242-23473847; type = collection; timestamp = 2021-11-09 11:01:00+0500](Bundle-PCT-GFE-Bundle-Inst-1.md)**Service Description**: Example service**In Network Provider Options Link**:[http://example.org/out-of-network.html](http://example.org/out-of-network.html)**identifier**: Unique Claim Identifier/?ngen-9?**status**: Active**type**:Institutional**use**: Predetermination**patient**:[Eve Betterhalf Female, DoB: 1955-07-23 ( http://example.com/identifiers/patient#1001)](Patient-patient1001.md)**created**: 2021-10-12**insurer**:[Organization Umbrella Insurance Company](Organization-org1001.md)**provider**:[Organization Boston Radiology Center](Organization-org1002.md)**priority**:Normal**claim**: Identifier:`http://example.com/identifiers/bundle`/59688475-2324-3242-23473847**outcome**: complete

### Insurances

| | | |
| :--- | :--- | :--- |
| - | **Focal** | **Coverage** |
| * | true | [Coverage: extension = insurance; status = active; subscriberId = PFP123450000; relationship = Self; period = 2021-01-01 --> 2022-01-01](Coverage-coverage1001.md) |

> **item****sequence**: 1**revenue**:Magnetic Resonance Technology (MRT) - Brain/brain stem**productOrService**:Magnetic resonance (eg, proton) imaging, brain (including brain stem); without contrast material**modifier**:Magnetic resonance (eg, proton) imaging, brain (including brain stem); without contrast material**serviced**: 2022-01-01

### Nets

| | | |
| :--- | :--- | :--- |
| - | **Value** | **Currency** |
| * | 200 | USD |

### Adjudications

| | | |
| :--- | :--- | :--- |
| - | **Extension** | **Category** |
| * |  | Medical Management |


### Adjudications

| | | |
| :--- | :--- | :--- |
| - | **Extension** | **Category** |
| * |  | Medical Management |
| * |  | Submitted Amount |
| * |  | Member Liability |

> **total****category**:Submitted Amount

### Amounts

| | | |
| :--- | :--- | :--- |
| - | **Value** | **Currency** |
| * | 200 | USD |


> **total****category**:Member liability

### Amounts

| | | |
| :--- | :--- | :--- |
| - | **Value** | **Currency** |
| * | 20 | USD |


> **total****category**:Eligible Amount

### Amounts

| | | |
| :--- | :--- | :--- |
| - | **Value** | **Currency** |
| * | 190 | USD |


### ProcessNotes

| | | |
| :--- | :--- | :--- |
| - | **Extension** | **Text** |
| * |  | processNote disclaimer text |

**benefitPeriod**: 2022-01-01 --> 2023-01-01
> **benefitBalance****category**:Medical Care**unit**:Individual**term**:Annual

### Financials

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| - | **Extension** | **Type** | **Allowed[x]** | **Used[x]** |
| * |  | Allowed | $1.00(USD) | $1.00(USD) |



-------

Entry 4 - fullUrl = http://example.org/fhir/Patient/patient1001

Resource Patient:

> **Eve Betterhalf**female, DoB: 1955-07-23 (`http://example.com/identifiers/patient`/1001)
-------

| | |
| :--- | :--- |
| Marital Status: | unmarried |
| Contact Details: | * ph: 781-949-4949(MOBILE)
* 222 Burlington Road, Bedford MA 01730
 |
| Language: | English (United States)(preferred) |


-------

Entry 5 - fullUrl = http://example.org/fhir/Coverage/coverage1001

Resource Coverage:

> 

Profile: [PCT Coverage](StructureDefinition-davinci-pct-coverage.md)

**Extension Definition for Coverage.kind for Version 5.0**: insurance**status**: Active**subscriberId**: PFP123450000**beneficiary**:[Eve Betterhalf Female, DoB: 1955-07-23 ( http://example.com/identifiers/patient#1001)](Patient-patient1001.md)**relationship**:Self**period**: 2021-01-01 --> 2022-01-01

### Classes

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Type** | **Value** | **Name** |
| * | Plan | Premim Family Plus | Premim Family Plus Plan |

### CostToBeneficiaries

| | | |
| :--- | :--- | :--- |
| - | **Type** | **Value[x]** |
| * | Copay Percentage | 20 |


-------

Entry 6 - fullUrl = http://example.org/fhir/Organization/org1001

Resource Organization:

> 

Profile: [PCT Organization](StructureDefinition-davinci-pct-organization.md)

**identifier**: Electronic Transmitter Identification Number/ETIN-3200002**active**: true**type**:Payer**name**: Umbrella Insurance Company

### Contacts

| | | |
| :--- | :--- | :--- |
| - | **Telecom** | **Address** |
| * | ph: 860-547-5001(Work) | 680 Asylum Street Hartford CT 06155 US |


-------

Entry 7 - fullUrl = http://example.org/fhir/Organization/Submitter-Org-1

Resource Organization:

> 

Profile: [PCT Organization](StructureDefinition-davinci-pct-organization.md)

**identifier**: Electronic Transmitter Identification Number/ETIN-10010301**active**: true**type**:Non-Healthcare Business or Corporation**name**: GFE Service Help INC.
> **contact****purpose**:GFE-related**name**: Clara Sender**telecom**: ph: 781-632-3209(Work),[csender@GFEServiceHelp.com](mailto:csender@GFEServiceHelp.com)

-------

Entry 8 - fullUrl = http://example.org/fhir/Organization/org1002

Resource Organization:

> 

Profile: [PCT Organization](StructureDefinition-davinci-pct-organization.md)

**identifier**:[United States National Provider Identifier](http://terminology.hl7.org/6.5.0/NamingSystem-npi.html)/9941339100, Tax ID number/TAX-3211001**active**: true**type**:Healthcare Provider**name**: Boston Radiology Center

### Contacts

| | | |
| :--- | :--- | :--- |
| - | **Telecom** | **Address** |
| * | ph: 781-232-3200(Work) | 32 Fruit Street Boston MA 02114 US |


-------

Entry 9 - fullUrl = http://example.org/fhir/Bundle/PCT-GFE-Bundle-Inst-1

Resource Bundle:

> 

Profile: [PCT GFE Bundle](StructureDefinition-davinci-pct-gfe-bundle.md)

Bundle PCT-GFE-Bundle-Inst-1 of type collection
-------
Entry 1 - fullUrl = http://example.org/fhir/Claim/PCT-GFE-Summary-1Resource Claim:
> 

Profile: [PCT Good Faith Estimate Summary](StructureDefinition-davinci-pct-gfe-summary.md)

**status**: Active**type**:Estimate Summary**use**: Predetermination**patient**:[Eve Betterhalf Female, DoB: 1955-07-23 ( http://example.com/identifiers/patient#1001)](Patient-patient1001.md)**billablePeriod**: 2021-10-31 --> 2021-10-31**created**: 2021-10-05**insurer**:[Organization Umbrella Insurance Company](Organization-org1001.md)**provider**: ?rref?**priority**:Normal

### Diagnoses

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Sequence** | **Diagnosis[x]** | **Type** |
| * | 1 | Unspecified focal traumatic brain injury | Principal Diagnosis |

### Insurances

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Sequence** | **Focal** | **Coverage** |
| * | 1 | true | [Coverage: extension = insurance; status = active; subscriberId = PFP123450000; relationship = Self; period = 2021-01-01 --> 2022-01-01](Coverage-coverage1001.md) |

### Totals

| | | |
| :--- | :--- | :--- |
| - | **Value** | **Currency** |
| * | 200 | USD |


-------
Entry 2 - fullUrl = http://example.org/fhir/Claim/PCT-GFE-Institutional-1Resource Claim:
> 

Profile: [PCT Good Faith Estimate Institutional](StructureDefinition-davinci-pct-gfe-institutional.md)

**ProviderEventMethodology**: EEMM1021**GFEDisclaimer**: For estimation purposes only
> **GFEServiceLinkingInfo**
* linkingIdentifier: `http://example.org/Claim/identifiers`/223452-2342-2435-008001
* plannedPeriodOfService: 2021-10-31

**identifier**: Placer Identifier/GFEProviderAssignedID0001**status**: Active**type**:Institutional**use**: Predetermination**patient**:[Eve Betterhalf Female, DoB: 1955-07-23 ( http://example.com/identifiers/patient#1001)](Patient-patient1001.md)**created**: 2021-10-05**insurer**:[Organization Umbrella Insurance Company](Organization-org1001.md)**provider**:[Organization GFE Service Help INC.](Organization-Submitter-Org-1.md)**priority**:Normal

### Payees

| | |
| :--- | :--- |
| - | **Type** |
| * | Provider |

**referral**: Referral Number

### SupportingInfos

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Sequence** | **Category** | **Code** |
| * | 1 | Type of Bill | Hospital Inpatient (Part A) |

### Diagnoses

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Sequence** | **Diagnosis[x]** | **Type** |
| * | 1 | Unspecified focal traumatic brain injury | Principal Diagnosis |

### Insurances

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Sequence** | **Focal** | **Coverage** |
| * | 1 | true | [Coverage: extension = insurance; status = active; subscriberId = PFP123450000; relationship = Self; period = 2021-01-01 --> 2022-01-01](Coverage-coverage1001.md) |

> **item****Service Description**: Imaging**sequence**: 1**revenue**:Magnetic Resonance Technology (MRT) - Brain/brain stem**productOrService**:Magnetic resonance (eg, proton) imaging, brain (including brain stem); without contrast material**modifier**:Magnetic resonance (eg, proton) imaging, brain (including brain stem); without contrast material**serviced**: 2021-10-31**quantity**: 1

### Nets

| | | |
| :--- | :--- | :--- |
| - | **Value** | **Currency** |
| * | 200 | USD |


### Totals

| | | |
| :--- | :--- | :--- |
| - | **Value** | **Currency** |
| * | 200 | USD |


-------
Entry 3 - fullUrl = http://example.org/fhir/Organization/Submitter-Org-1Resource Organization:
> 

Profile: [PCT Organization](StructureDefinition-davinci-pct-organization.md)

**identifier**: Electronic Transmitter Identification Number/ETIN-10010301**active**: true**type**:Non-Healthcare Business or Corporation**name**: GFE Service Help INC.
> **contact****purpose**:GFE-related**name**: Clara Sender**telecom**: ph: 781-632-3209(Work),[csender@GFEServiceHelp.com](mailto:csender@GFEServiceHelp.com)

-------
Entry 4 - fullUrl = http://example.org/fhir/Organization/org1001Resource Organization:
> 

Profile: [PCT Organization](StructureDefinition-davinci-pct-organization.md)

**identifier**: Electronic Transmitter Identification Number/ETIN-3200002**active**: true**type**:Payer**name**: Umbrella Insurance Company

### Contacts

| | | |
| :--- | :--- | :--- |
| - | **Telecom** | **Address** |
| * | ph: 860-547-5001(Work) | 680 Asylum Street Hartford CT 06155 US |


-------
Entry 5 - fullUrl = http://example.org/fhir/Patient/patient1001Resource Patient:
> **Eve Betterhalf**female, DoB: 1955-07-23 (`http://example.com/identifiers/patient`/1001)
-------

| | |
| :--- | :--- |
| Marital Status: | unmarried |
| Contact Details: | * ph: 781-949-4949(MOBILE)
* 222 Burlington Road, Bedford MA 01730
 |
| Language: | English (United States)(preferred) |


-------
Entry 6 - fullUrl = http://example.org/fhir/Coverage/coverage1001Resource Coverage:
> 

Profile: [PCT Coverage](StructureDefinition-davinci-pct-coverage.md)

**Extension Definition for Coverage.kind for Version 5.0**: insurance**status**: Active**subscriberId**: PFP123450000**beneficiary**:[Eve Betterhalf Female, DoB: 1955-07-23 ( http://example.com/identifiers/patient#1001)](Patient-patient1001.md)**relationship**:Self**period**: 2021-01-01 --> 2022-01-01

### Classes

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Type** | **Value** | **Name** |
| * | Plan | Premim Family Plus | Premim Family Plus Plan |

### CostToBeneficiaries

| | | |
| :--- | :--- | :--- |
| - | **Type** | **Value[x]** |
| * | Copay Percentage | 20 |



-------

Entry 10 - fullUrl = http://example.org/fhir/Bundle/PCT-GFE-Missing-Bundle-1

Resource Bundle:

> 

Profile: [PCT GFE Missing Bundle](StructureDefinition-davinci-pct-gfe-missing-bundle.md)

Bundle PCT-GFE-Missing-Bundle-1 of type collection
-------
Entry 1 - fullUrl = http://example.org/fhir/Organization/org1002Resource Organization:
> 

Profile: [PCT Organization](StructureDefinition-davinci-pct-organization.md)

**identifier**:[United States National Provider Identifier](http://terminology.hl7.org/6.5.0/NamingSystem-npi.html)/9941339100, Tax ID number/TAX-3211001**active**: true**type**:Healthcare Provider**name**: Boston Radiology Center

### Contacts

| | | |
| :--- | :--- | :--- |
| - | **Telecom** | **Address** |
| * | ph: 781-232-3200(Work) | 32 Fruit Street Boston MA 02114 US |


-------
Entry 2 - fullUrl = http://example.org/fhir/Patient/patient1001Resource Patient:
> **Eve Betterhalf**female, DoB: 1955-07-23 (`http://example.com/identifiers/patient`/1001)
-------

| | |
| :--- | :--- |
| Marital Status: | unmarried |
| Contact Details: | * ph: 781-949-4949(MOBILE)
* 222 Burlington Road, Bedford MA 01730
 |
| Language: | English (United States)(preferred) |


-------
Entry 3 - fullUrl = http://example.org/fhir/Coverage/coverage1001Resource Coverage:
> 

Profile: [PCT Coverage](StructureDefinition-davinci-pct-coverage.md)

**Extension Definition for Coverage.kind for Version 5.0**: insurance**status**: Active**subscriberId**: PFP123450000**beneficiary**:[Eve Betterhalf Female, DoB: 1955-07-23 ( http://example.com/identifiers/patient#1001)](Patient-patient1001.md)**relationship**:Self**period**: 2021-01-01 --> 2022-01-01

### Classes

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Type** | **Value** | **Name** |
| * | Plan | Premim Family Plus | Premim Family Plus Plan |

### CostToBeneficiaries

| | | |
| :--- | :--- | :--- |
| - | **Type** | **Value[x]** |
| * | Copay Percentage | 20 |


-------
Entry 4 - fullUrl = http://example.org/fhir/Organization/org1001Resource Organization:
> 

Profile: [PCT Organization](StructureDefinition-davinci-pct-organization.md)

**identifier**: Electronic Transmitter Identification Number/ETIN-3200002**active**: true**type**:Payer**name**: Umbrella Insurance Company

### Contacts

| | | |
| :--- | :--- | :--- |
| - | **Telecom** | **Address** |
| * | ph: 860-547-5001(Work) | 680 Asylum Street Hartford CT 06155 US |


-------
Entry 5 - fullUrl = http://example.org/fhir/DeviceRequest/PCT-DeviceRequest-1Resource DeviceRequest:
> 

Profile: [PCT GFE DeviceRequest](StructureDefinition-davinci-pct-devicerequest.md)

**status**: Active**intent**: Proposal**subject**:[Eve Betterhalf Female, DoB: 1955-07-23 ( http://example.com/identifiers/patient#1001)](Patient-patient1001.md)



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "PCT-AEOB-Packet-1",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-aeob-packet"
    ]
  },
  "identifier" : {
    "system" : "http://example.com/identifiers/bundle",
    "value" : "59688475-2324-3242-1234568"
  },
  "type" : "document",
  "timestamp" : "2025-01-10T11:01:00+05:00",
  "entry" : [
    {
      "fullUrl" : "http://example.org/fhir/Composition/PCT-AEOB-Composition-1",
      "resource" : {
        "resourceType" : "Composition",
        "id" : "PCT-AEOB-Composition-1",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-aeob-composition"
          ]
        },
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Composition_PCT-AEOB-Composition-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Composition PCT-AEOB-Composition-1</b></p><a name=\"PCT-AEOB-Composition-1\"> </a><a name=\"hcPCT-AEOB-Composition-1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-davinci-pct-aeob-composition.html\">PCT AEOB Composition</a></p></div><p><b>Request Initiation Time</b>: 2025-01-08 09:01:00+0500</p><p><b>identifier</b>: <code>http://www.example.org/identifiers/composition</code>/019283475</p><p><b>status</b>: Final</p><p><b>type</b>: <span title=\"Codes:{http://loinc.org 111479-2}\">Advanced explanation of benefits</span></p><p><b>category</b>: <span title=\"Codes:{http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTDocumentTypeTemporaryTrialUse estimate}\">Estimation Packet</span></p><p><b>date</b>: 2025-01-10 11:01:00+0500</p><p><b>author</b>: </p><ul><li><a href=\"Organization-org1001.html\">Organization Umbrella Insurance Company</a></li><li><a href=\"Organization-Submitter-Org-1.html\">Organization GFE Service Help INC.</a></li></ul><p><b>title</b>: Advanced Explanation of Benefit Packet for Eve Betterhalf - 2025-01-10</p></div>"
        },
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/requestInitiationTime",
            "valueInstant" : "2025-01-08T09:01:00+05:00"
          }
        ],
        "identifier" : {
          "system" : "http://www.example.org/identifiers/composition",
          "value" : "019283475"
        },
        "status" : "final",
        "type" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "111479-2",
              "display" : "Advanced explanation of benefits"
            }
          ]
        },
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTDocumentTypeTemporaryTrialUse",
                "code" : "estimate"
              }
            ]
          }
        ],
        "subject" : {
          "reference" : "Patient/patient1001"
        },
        "date" : "2025-01-10T11:01:00+05:00",
        "author" : [
          {
            "reference" : "Organization/org1001"
          },
          {
            "reference" : "Organization/Submitter-Org-1"
          }
        ],
        "title" : "Advanced Explanation of Benefit Packet for Eve Betterhalf - 2025-01-10",
        "section" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTDocumentSection",
                  "code" : "aeob-summary-section"
                }
              ]
            },
            "text" : {
              "status" : "extensions",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><p class=\"res-header-id\"><b>Generated Narrative: ExplanationOfBenefit PCT-AEOB-Summary-1</b></p><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-davinci-pct-aeob-summary.html\">PCT Advanced EOB Summary</a></p></div><p><b>Service Description</b>: Example service</p><p><b>In Network Provider Options Link</b>: <a href=\"http://example.org/out-of-network.html\">http://example.org/out-of-network.html</a></p><p><b>status</b>: Active</p><p><b>type</b>: <span title=\"Codes:{http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTEstimateTypeSummaryCSTemporaryTrialUse estimate-summary}\">Estimate Summary</span></p><p><b>use</b>: Predetermination</p><p><b>patient</b>: <a href=\"Patient-patient1001.html\">Eve Betterhalf Female, DoB: 1955-07-23 ( http://example.com/identifiers/patient#1001)</a></p><p><b>billablePeriod</b>: 2022-01-01 --&gt; 2022-01-01</p><p><b>created</b>: 2021-10-12</p><p><b>insurer</b>: <a href=\"Organization-org1001.html\">Organization Umbrella Insurance Company</a></p><p><b>provider</b>: ?rref?</p><p><b>outcome</b>: Processing Complete</p><h3>Insurances</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Focal</b></td><td><b>Coverage</b></td></tr><tr><td style=\"display: none\">*</td><td>true</td><td><a href=\"Coverage-coverage1001.html\">Coverage: extension = insurance; status = active; subscriberId = PFP123450000; relationship = Self; period = 2021-01-01 --&gt; 2022-01-01</a></td></tr></table><blockquote><p><b>total</b></p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/adjudication submitted}\">Submitted Amount</span></p><h3>Amounts</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Value</b></td><td><b>Currency</b></td></tr><tr><td style=\"display: none\">*</td><td>200</td><td>United States dollar</td></tr></table></blockquote><blockquote><p><b>total</b></p><p><b>category</b>: <span title=\"Codes:{http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTAdjudicationCategoryCS memberliability}\">Member liability</span></p><h3>Amounts</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Value</b></td><td><b>Currency</b></td></tr><tr><td style=\"display: none\">*</td><td>20</td><td>United States dollar</td></tr></table></blockquote><blockquote><p><b>total</b></p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/adjudication eligible}\">Eligible Amount</span></p><h3>Amounts</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Value</b></td><td><b>Currency</b></td></tr><tr><td style=\"display: none\">*</td><td>190</td><td>United States dollar</td></tr></table></blockquote><h3>ProcessNotes</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Extension</b></td><td><b>Text</b></td></tr><tr><td style=\"display: none\">*</td><td/><td>processNote disclaimer text</td></tr></table><p><b>benefitPeriod</b>: 2022-01-01 --&gt; 2022-01-01</p><blockquote><p><b>benefitBalance</b></p><p><b>category</b>: <span title=\"Codes:{https://x12.org/codes/service-type-codes 1}\">Medical Care</span></p><p><b>unit</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/benefit-unit individual}\">Individual</span></p><p><b>term</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/benefit-term annual}\">Annual</span></p><h3>Financials</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Extension</b></td><td><b>Type</b></td><td><b>Allowed[x]</b></td><td><b>Used[x]</b></td></tr><tr><td style=\"display: none\">*</td><td/><td><span title=\"Codes:{http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTFinancialType allowed}\">Allowed</span></td><td><span title=\"US Dollar\">$1.00</span> (USD)</td><td><span title=\"US Dollar\">$1.00</span> (USD)</td></tr></table></blockquote></div>"
            },
            "entry" : [
              {
                "reference" : "ExplanationOfBenefit/PCT-AEOB-Summary-1"
              }
            ]
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTDocumentSection",
                  "code" : "aeob-section"
                }
              ]
            },
            "text" : {
              "status" : "extensions",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><p class=\"res-header-id\"><b>Generated Narrative: ExplanationOfBenefit PCT-AEOB-Summary-1</b></p><a name=\"PCT-AEOB-Summary-1\"/><a name=\"hcPCT-AEOB-Summary-1\"/><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-davinci-pct-aeob-summary.html\">PCT Advanced EOB Summary</a></p></div><p><b>Service Description</b>: Example service</p><p><b>In Network Provider Options Link</b>: <a href=\"http://example.org/out-of-network.html\">http://example.org/out-of-network.html</a></p><p><b>status</b>: Active</p><p><b>type</b>: <span title=\"Codes:{http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTEstimateTypeSummaryCSTemporaryTrialUse estimate-summary}\">Estimate Summary</span></p><p><b>use</b>: Predetermination</p><p><b>patient</b>: <a href=\"Patient-patient1001.html\">Eve Betterhalf Female, DoB: 1955-07-23 ( http://example.com/identifiers/patient#1001)</a></p><p><b>billablePeriod</b>: 2022-01-01 --&gt; 2022-01-01</p><p><b>created</b>: 2021-10-12</p><p><b>insurer</b>: <a href=\"Organization-org1001.html\">Organization Umbrella Insurance Company</a></p><p><b>provider</b>: ?rref?</p><p><b>outcome</b>: Processing Complete</p><h3>Insurances</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Focal</b></td><td><b>Coverage</b></td></tr><tr><td style=\"display: none\">*</td><td>true</td><td><a href=\"Coverage-coverage1001.html\">Coverage: extension = insurance; status = active; subscriberId = PFP123450000; relationship = Self; period = 2021-01-01 --&gt; 2022-01-01</a></td></tr></table><blockquote><p><b>total</b></p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/adjudication submitted}\">Submitted Amount</span></p><h3>Amounts</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Value</b></td><td><b>Currency</b></td></tr><tr><td style=\"display: none\">*</td><td>200</td><td>United States dollar</td></tr></table></blockquote><blockquote><p><b>total</b></p><p><b>category</b>: <span title=\"Codes:{http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTAdjudicationCategoryCS memberliability}\">Member liability</span></p><h3>Amounts</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Value</b></td><td><b>Currency</b></td></tr><tr><td style=\"display: none\">*</td><td>20</td><td>United States dollar</td></tr></table></blockquote><blockquote><p><b>total</b></p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/adjudication eligible}\">Eligible Amount</span></p><h3>Amounts</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Value</b></td><td><b>Currency</b></td></tr><tr><td style=\"display: none\">*</td><td>190</td><td>United States dollar</td></tr></table></blockquote><h3>ProcessNotes</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Extension</b></td><td><b>Text</b></td></tr><tr><td style=\"display: none\">*</td><td/><td>processNote disclaimer text</td></tr></table><p><b>benefitPeriod</b>: 2022-01-01 --&gt; 2022-01-01</p><blockquote><p><b>benefitBalance</b></p><p><b>category</b>: <span title=\"Codes:{https://x12.org/codes/service-type-codes 1}\">Medical Care</span></p><p><b>unit</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/benefit-unit individual}\">Individual</span></p><p><b>term</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/benefit-term annual}\">Annual</span></p><h3>Financials</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Extension</b></td><td><b>Type</b></td><td><b>Allowed[x]</b></td><td><b>Used[x]</b></td></tr><tr><td style=\"display: none\">*</td><td/><td><span title=\"Codes:{http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTFinancialType allowed}\">Allowed</span></td><td><span title=\"US Dollar\">$1.00</span> (USD)</td><td><span title=\"US Dollar\">$1.00</span> (USD)</td></tr></table></blockquote></div>"
            },
            "entry" : [
              {
                "reference" : "ExplanationOfBenefit/PCT-AEOB-1"
              }
            ]
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTDocumentSection",
                  "code" : "gfe-section"
                }
              ]
            },
            "author" : [
              {
                "reference" : "Organization/Submitter-Org-1"
              }
            ],
            "text" : {
              "status" : "extensions",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><p class=\"res-header-id\"><b>Generated Narrative: PCT-GFE-Missing-Bundle-1</b></p><p><b>patient</b>: <a href=\"Patient-patient1001.html\">Eve Betterhalf Female, DoB: 1955-07-23 (http://example.com/identifiers/patient#1001)</a></p><p><b>coverage</b>: <a href=\"Patient-patient1001.html\">Coverage_coverage1001, period: 2021-01-01 --&gt; 2022-01-01</a></p><p><b>organization</b>: <a href=\"Organization-org1001.html\">Umbrella Insurance Company</a></p><h3>Requested Services</h3><ul><li><b>device request</b>: KNEE ORTHOSIS, ELASTIC WITH CONDYLAR PADS AND JOINTS, WITH OR WITHOUT PATELLAR CONTROL, PREFABRICATED, INCLUDES FITTING AND ADJUSTMENT</li></ul></div>"
            },
            "entry" : [
              {
                "reference" : "Bundle/PCT-GFE-Bundle-Inst-1"
              }
            ]
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTDocumentSection",
                  "code" : "gfe-section"
                }
              ]
            },
            "author" : [
              {
                "reference" : "Organization/Submitter-Org-1"
              }
            ],
            "entry" : [
              {
                "reference" : "Bundle/PCT-GFE-Missing-Bundle-1"
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/ExplanationOfBenefit/PCT-AEOB-Summary-1",
      "resource" : {
        "resourceType" : "ExplanationOfBenefit",
        "id" : "PCT-AEOB-Summary-1",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-aeob-summary"
          ]
        },
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"ExplanationOfBenefit_PCT-AEOB-Summary-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: ExplanationOfBenefit PCT-AEOB-Summary-1</b></p><a name=\"PCT-AEOB-Summary-1\"> </a><a name=\"hcPCT-AEOB-Summary-1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-davinci-pct-aeob-summary.html\">PCT Advanced EOB Summary</a></p></div><p><b>Service Description</b>: Example service</p><p><b>In Network Provider Options Link</b>: <a href=\"http://example.org/out-of-network.html\">http://example.org/out-of-network.html</a></p><p><b>status</b>: Active</p><p><b>type</b>: <span title=\"Codes:{http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTEstimateTypeSummaryCSTemporaryTrialUse estimate-summary}\">Estimate Summary</span></p><p><b>use</b>: Predetermination</p><p><b>patient</b>: <a href=\"Patient-patient1001.html\">Eve Betterhalf Female, DoB: 1955-07-23 ( http://example.com/identifiers/patient#1001)</a></p><p><b>billablePeriod</b>: 2022-01-01 --&gt; 2022-01-01</p><p><b>created</b>: 2021-10-12</p><p><b>insurer</b>: <a href=\"Organization-org1001.html\">Organization Umbrella Insurance Company</a></p><p><b>provider</b>: ?rref?</p><p><b>outcome</b>: Processing Complete</p><h3>Insurances</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Focal</b></td><td><b>Coverage</b></td></tr><tr><td style=\"display: none\">*</td><td>true</td><td><a href=\"Coverage-coverage1001.html\">Coverage: extension = insurance; status = active; subscriberId = PFP123450000; relationship = Self; period = 2021-01-01 --&gt; 2022-01-01</a></td></tr></table><blockquote><p><b>total</b></p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/adjudication submitted}\">Submitted Amount</span></p><h3>Amounts</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Value</b></td><td><b>Currency</b></td></tr><tr><td style=\"display: none\">*</td><td>200</td><td>United States dollar</td></tr></table></blockquote><blockquote><p><b>total</b></p><p><b>category</b>: <span title=\"Codes:{http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTAdjudicationCategoryCS memberliability}\">Member liability</span></p><h3>Amounts</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Value</b></td><td><b>Currency</b></td></tr><tr><td style=\"display: none\">*</td><td>20</td><td>United States dollar</td></tr></table></blockquote><blockquote><p><b>total</b></p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/adjudication eligible}\">Eligible Amount</span></p><h3>Amounts</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Value</b></td><td><b>Currency</b></td></tr><tr><td style=\"display: none\">*</td><td>190</td><td>United States dollar</td></tr></table></blockquote><h3>ProcessNotes</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Extension</b></td><td><b>Text</b></td></tr><tr><td style=\"display: none\">*</td><td/><td>processNote disclaimer text</td></tr></table><p><b>benefitPeriod</b>: 2022-01-01 --&gt; 2022-01-01</p><blockquote><p><b>benefitBalance</b></p><p><b>category</b>: <span title=\"Codes:{https://x12.org/codes/service-type-codes 1}\">Medical Care</span></p><p><b>unit</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/benefit-unit individual}\">Individual</span></p><p><b>term</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/benefit-term annual}\">Annual</span></p><h3>Financials</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Extension</b></td><td><b>Type</b></td><td><b>Allowed[x]</b></td><td><b>Used[x]</b></td></tr><tr><td style=\"display: none\">*</td><td/><td><span title=\"Codes:{http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTFinancialType allowed}\">Allowed</span></td><td><span title=\"US Dollar\">$1.00</span> (USD)</td><td><span title=\"US Dollar\">$1.00</span> (USD)</td></tr></table></blockquote></div>"
        },
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/serviceDescription",
            "valueString" : "Example service"
          },
          {
            "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/inNetworkProviderOptionsLink",
            "valueUrl" : "http://example.org/out-of-network.html"
          }
        ],
        "status" : "active",
        "type" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTEstimateTypeSummaryCSTemporaryTrialUse",
              "code" : "estimate-summary",
              "display" : "Estimate Summary"
            }
          ]
        },
        "use" : "predetermination",
        "patient" : {
          "reference" : "Patient/patient1001"
        },
        "billablePeriod" : {
          "start" : "2022-01-01",
          "end" : "2022-01-01"
        },
        "created" : "2021-10-12",
        "insurer" : {
          "reference" : "Organization/org1001"
        },
        "provider" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
              "valueCode" : "not-applicable"
            }
          ]
        },
        "outcome" : "complete",
        "insurance" : [
          {
            "focal" : true,
            "coverage" : {
              "reference" : "Coverage/coverage1001"
            }
          }
        ],
        "total" : [
          {
            "category" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/adjudication",
                  "version" : "1.0.1",
                  "code" : "submitted",
                  "display" : "Submitted Amount"
                }
              ]
            },
            "amount" : {
              "value" : 200,
              "currency" : "USD"
            }
          },
          {
            "category" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTAdjudicationCategoryCS",
                  "code" : "memberliability",
                  "display" : "Member liability"
                }
              ]
            },
            "amount" : {
              "value" : 20,
              "currency" : "USD"
            }
          },
          {
            "category" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/adjudication",
                  "version" : "1.0.1",
                  "code" : "eligible",
                  "display" : "Eligible Amount"
                }
              ]
            },
            "amount" : {
              "value" : 190,
              "currency" : "USD"
            }
          }
        ],
        "processNote" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/processNoteClass",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTAEOBProcessNoteCS",
                      "code" : "disclaimer",
                      "display" : "Disclaimer"
                    }
                  ]
                }
              }
            ],
            "text" : "processNote disclaimer text"
          }
        ],
        "benefitPeriod" : {
          "start" : "2022-01-01",
          "end" : "2022-01-01"
        },
        "benefitBalance" : [
          {
            "category" : {
              "coding" : [
                {
                  "system" : "https://x12.org/codes/service-type-codes",
                  "code" : "1",
                  "display" : "Medical Care"
                }
              ],
              "text" : "Medical Care"
            },
            "unit" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/benefit-unit",
                  "code" : "individual"
                }
              ]
            },
            "term" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/benefit-term",
                  "code" : "annual"
                }
              ]
            },
            "financial" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/remaining-benefit",
                    "valueMoney" : {
                      "value" : 0,
                      "currency" : "USD"
                    }
                  }
                ],
                "type" : {
                  "coding" : [
                    {
                      "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTFinancialType",
                      "code" : "allowed"
                    }
                  ]
                },
                "allowedMoney" : {
                  "value" : 1,
                  "currency" : "USD"
                },
                "usedMoney" : {
                  "value" : 1,
                  "currency" : "USD"
                }
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/ExplanationOfBenefit/PCT-AEOB-1",
      "resource" : {
        "resourceType" : "ExplanationOfBenefit",
        "id" : "PCT-AEOB-1",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-aeob"
          ]
        },
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"ExplanationOfBenefit_PCT-AEOB-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: ExplanationOfBenefit PCT-AEOB-1</b></p><a name=\"PCT-AEOB-1\"> </a><a name=\"hcPCT-AEOB-1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-davinci-pct-aeob.html\">PCT Advanced EOB</a></p></div><p><b>GFE Reference</b>: <a href=\"Bundle-PCT-GFE-Bundle-Inst-1.html\">Bundle: identifier = http://example.com/identifiers/bundle#59688475-2324-3242-23473847; type = collection; timestamp = 2021-11-09 11:01:00+0500</a></p><p><b>Service Description</b>: Example service</p><p><b>In Network Provider Options Link</b>: <a href=\"http://example.org/out-of-network.html\">http://example.org/out-of-network.html</a></p><p><b>identifier</b>: Unique Claim Identifier/?ngen-9?</p><p><b>status</b>: Active</p><p><b>type</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/claim-type institutional}\">Institutional</span></p><p><b>use</b>: Predetermination</p><p><b>patient</b>: <a href=\"Patient-patient1001.html\">Eve Betterhalf Female, DoB: 1955-07-23 ( http://example.com/identifiers/patient#1001)</a></p><p><b>created</b>: 2021-10-12</p><p><b>insurer</b>: <a href=\"Organization-org1001.html\">Organization Umbrella Insurance Company</a></p><p><b>provider</b>: <a href=\"Organization-org1002.html\">Organization Boston Radiology Center</a></p><p><b>priority</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/processpriority normal}\">Normal</span></p><p><b>claim</b>: Identifier: <code>http://example.com/identifiers/bundle</code>/59688475-2324-3242-23473847</p><p><b>outcome</b>: Processing Complete</p><h3>Insurances</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Focal</b></td><td><b>Coverage</b></td></tr><tr><td style=\"display: none\">*</td><td>true</td><td><a href=\"Coverage-coverage1001.html\">Coverage: extension = insurance; status = active; subscriberId = PFP123450000; relationship = Self; period = 2021-01-01 --&gt; 2022-01-01</a></td></tr></table><blockquote><p><b>item</b></p><p><b>sequence</b>: 1</p><p><b>revenue</b>: <span title=\"Codes:{https://www.nubc.org/CodeSystem/RevenueCodes 0611}\">Magnetic Resonance Technology (MRT) - Brain/brain stem</span></p><p><b>productOrService</b>: <span title=\"Codes:{http://www.ama-assn.org/go/cpt 70551}\">Magnetic resonance (eg, proton) imaging, brain (including brain stem); without contrast material</span></p><p><b>modifier</b>: <span title=\"Codes:{http://www.ama-assn.org/go/cpt 70551}\">Magnetic resonance (eg, proton) imaging, brain (including brain stem); without contrast material</span></p><p><b>serviced</b>: 2022-01-01</p><h3>Nets</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Value</b></td><td><b>Currency</b></td></tr><tr><td style=\"display: none\">*</td><td>200</td><td>United States dollar</td></tr></table><h3>Adjudications</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Extension</b></td><td><b>Category</b></td></tr><tr><td style=\"display: none\">*</td><td/><td><span title=\"Codes:{http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTAdjudicationCategoryCS medicalmanagement}\">Medical Management</span></td></tr></table></blockquote><h3>Adjudications</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Extension</b></td><td><b>Category</b></td></tr><tr><td style=\"display: none\">*</td><td/><td><span title=\"Codes:{http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTAdjudicationCategoryCS medicalmanagement}\">Medical Management</span></td></tr><tr><td style=\"display: none\">*</td><td> </td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/adjudication submitted}\">Submitted Amount</span></td></tr><tr><td style=\"display: none\">*</td><td> </td><td><span title=\"Codes:{http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTAdjudicationCategoryCS memberliability}\">Member Liability</span></td></tr></table><blockquote><p><b>total</b></p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/adjudication submitted}\">Submitted Amount</span></p><h3>Amounts</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Value</b></td><td><b>Currency</b></td></tr><tr><td style=\"display: none\">*</td><td>200</td><td>United States dollar</td></tr></table></blockquote><blockquote><p><b>total</b></p><p><b>category</b>: <span title=\"Codes:{http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTAdjudicationCategoryCS memberliability}\">Member liability</span></p><h3>Amounts</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Value</b></td><td><b>Currency</b></td></tr><tr><td style=\"display: none\">*</td><td>20</td><td>United States dollar</td></tr></table></blockquote><blockquote><p><b>total</b></p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/adjudication eligible}\">Eligible Amount</span></p><h3>Amounts</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Value</b></td><td><b>Currency</b></td></tr><tr><td style=\"display: none\">*</td><td>190</td><td>United States dollar</td></tr></table></blockquote><h3>ProcessNotes</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Extension</b></td><td><b>Text</b></td></tr><tr><td style=\"display: none\">*</td><td/><td>processNote disclaimer text</td></tr></table><p><b>benefitPeriod</b>: 2022-01-01 --&gt; 2023-01-01</p><blockquote><p><b>benefitBalance</b></p><p><b>category</b>: <span title=\"Codes:{https://x12.org/codes/service-type-codes 1}\">Medical Care</span></p><p><b>unit</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/benefit-unit individual}\">Individual</span></p><p><b>term</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/benefit-term annual}\">Annual</span></p><h3>Financials</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Extension</b></td><td><b>Type</b></td><td><b>Allowed[x]</b></td><td><b>Used[x]</b></td></tr><tr><td style=\"display: none\">*</td><td/><td><span title=\"Codes:{http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTFinancialType allowed}\">Allowed</span></td><td><span title=\"US Dollar\">$1.00</span> (USD)</td><td><span title=\"US Dollar\">$1.00</span> (USD)</td></tr></table></blockquote></div>"
        },
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/gfeReference",
            "valueReference" : {
              "reference" : "Bundle/PCT-GFE-Bundle-Inst-1"
            }
          },
          {
            "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/serviceDescription",
            "valueString" : "Example service"
          },
          {
            "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/inNetworkProviderOptionsLink",
            "valueUrl" : "http://example.org/out-of-network.html"
          }
        ],
        "identifier" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                  "code" : "UCID"
                }
              ]
            }
          }
        ],
        "status" : "active",
        "type" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/claim-type",
              "code" : "institutional",
              "display" : "Institutional"
            }
          ]
        },
        "use" : "predetermination",
        "patient" : {
          "reference" : "Patient/patient1001"
        },
        "created" : "2021-10-12",
        "insurer" : {
          "reference" : "Organization/org1001"
        },
        "provider" : {
          "reference" : "Organization/org1002"
        },
        "priority" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/processpriority",
              "code" : "normal"
            }
          ]
        },
        "claim" : {
          "identifier" : {
            "system" : "http://example.com/identifiers/bundle",
            "value" : "59688475-2324-3242-23473847"
          }
        },
        "outcome" : "complete",
        "insurance" : [
          {
            "focal" : true,
            "coverage" : {
              "reference" : "Coverage/coverage1001"
            }
          }
        ],
        "item" : [
          {
            "sequence" : 1,
            "revenue" : {
              "coding" : [
                {
                  "system" : "https://www.nubc.org/CodeSystem/RevenueCodes",
                  "code" : "0611",
                  "display" : "Magnetic Resonance Technology (MRT) - Brain/brain stem"
                }
              ]
            },
            "productOrService" : {
              "coding" : [
                {
                  "system" : "http://www.ama-assn.org/go/cpt",
                  "code" : "70551",
                  "display" : "Magnetic resonance (eg, proton) imaging, brain (including brain stem); without contrast material"
                }
              ]
            },
            "modifier" : [
              {
                "coding" : [
                  {
                    "system" : "http://www.ama-assn.org/go/cpt",
                    "code" : "70551",
                    "display" : "Magnetic resonance (eg, proton) imaging, brain (including brain stem); without contrast material"
                  }
                ]
              }
            ],
            "servicedDate" : "2022-01-01",
            "net" : {
              "value" : 200,
              "currency" : "USD"
            },
            "adjudication" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/subjectToMedicalMgmt",
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://terminology.hl7.org/CodeSystem/medical-management-type",
                          "code" : "concurrent-review",
                          "display" : "Concurrent Review"
                        }
                      ]
                    }
                  }
                ],
                "category" : {
                  "coding" : [
                    {
                      "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTAdjudicationCategoryCS",
                      "code" : "medicalmanagement",
                      "display" : "Medical Management"
                    }
                  ]
                }
              }
            ]
          }
        ],
        "adjudication" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/subjectToMedicalMgmt",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/medical-management-type",
                      "code" : "concurrent-review",
                      "display" : "Concurrent Review"
                    }
                  ]
                }
              }
            ],
            "category" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTAdjudicationCategoryCS",
                  "code" : "medicalmanagement",
                  "display" : "Medical Management"
                }
              ]
            }
          },
          {
            "category" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/adjudication",
                  "code" : "submitted",
                  "display" : "Submitted Amount"
                }
              ]
            }
          },
          {
            "category" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTAdjudicationCategoryCS",
                  "code" : "memberliability",
                  "display" : "Member Liability"
                }
              ]
            }
          }
        ],
        "total" : [
          {
            "category" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/adjudication",
                  "version" : "1.0.1",
                  "code" : "submitted",
                  "display" : "Submitted Amount"
                }
              ]
            },
            "amount" : {
              "value" : 200,
              "currency" : "USD"
            }
          },
          {
            "category" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTAdjudicationCategoryCS",
                  "code" : "memberliability",
                  "display" : "Member liability"
                }
              ]
            },
            "amount" : {
              "value" : 20,
              "currency" : "USD"
            }
          },
          {
            "category" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/adjudication",
                  "version" : "1.0.1",
                  "code" : "eligible",
                  "display" : "Eligible Amount"
                }
              ]
            },
            "amount" : {
              "value" : 190,
              "currency" : "USD"
            }
          }
        ],
        "processNote" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/processNoteClass",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTAEOBProcessNoteCS",
                      "code" : "disclaimer",
                      "display" : "Disclaimer"
                    }
                  ]
                }
              }
            ],
            "text" : "processNote disclaimer text"
          }
        ],
        "benefitPeriod" : {
          "start" : "2022-01-01",
          "end" : "2023-01-01"
        },
        "benefitBalance" : [
          {
            "category" : {
              "coding" : [
                {
                  "system" : "https://x12.org/codes/service-type-codes",
                  "code" : "1",
                  "display" : "Medical Care"
                }
              ],
              "text" : "Medical Care"
            },
            "unit" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/benefit-unit",
                  "code" : "individual"
                }
              ]
            },
            "term" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/benefit-term",
                  "code" : "annual"
                }
              ]
            },
            "financial" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/remaining-benefit",
                    "valueMoney" : {
                      "value" : 0,
                      "currency" : "USD"
                    }
                  }
                ],
                "type" : {
                  "coding" : [
                    {
                      "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTFinancialType",
                      "code" : "allowed"
                    }
                  ]
                },
                "allowedMoney" : {
                  "value" : 1,
                  "currency" : "USD"
                },
                "usedMoney" : {
                  "value" : 1,
                  "currency" : "USD"
                }
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Patient/patient1001",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "patient1001",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient|7.0.0"
          ]
        },
        "text" : {
          "status" : "additional",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Patient_patient1001\"> </a><p style=\"border: 1px #661aff solid; background-color: #e6e6ff; padding: 10px;\"><b>Eve Betterhalf</b> female, DoB: 1955-07-23 ( <code>http://example.com/identifiers/patient</code>/1001)</p><hr/><table class=\"grid\"><tr><td style=\"background-color: #f3f5da\" title=\"Known Marital status of Patient\">Marital Status:</td><td colspan=\"3\"><span title=\"Codes: {http://terminology.hl7.org/CodeSystem/v3-MaritalStatus U}\">unmarried</span></td></tr><tr><td style=\"background-color: #f3f5da\" title=\"Ways to contact the Patient\">Contact Details:</td><td colspan=\"3\"><ul><li>ph: 781-949-4949(MOBILE)</li><li>222 Burlington Road, Bedford MA 01730</li></ul></td></tr><tr><td style=\"background-color: #f3f5da\" title=\"Languages spoken\">Language:</td><td colspan=\"3\"><span title=\"Codes: {urn:ietf:bcp:47 en-US}\">English (United States)</span> (preferred)</td></tr></table></div>"
        },
        "identifier" : [
          {
            "system" : "http://example.com/identifiers/patient",
            "value" : "1001"
          }
        ],
        "name" : [
          {
            "text" : "Eve Betterhalf",
            "family" : "Betterhalf",
            "given" : ["Eve"]
          }
        ],
        "telecom" : [
          {
            "system" : "phone",
            "value" : "781-949-4949",
            "use" : "mobile"
          }
        ],
        "gender" : "female",
        "birthDate" : "1955-07-23",
        "address" : [
          {
            "text" : "222 Burlington Road, Bedford MA 01730"
          }
        ],
        "maritalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-MaritalStatus",
              "code" : "U",
              "display" : "unmarried"
            }
          ]
        },
        "communication" : [
          {
            "language" : {
              "coding" : [
                {
                  "system" : "urn:ietf:bcp:47",
                  "code" : "en-US",
                  "display" : "English (United States)"
                }
              ]
            },
            "preferred" : true
          }
        ]
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Coverage/coverage1001",
      "resource" : {
        "resourceType" : "Coverage",
        "id" : "coverage1001",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-coverage"
          ]
        },
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Coverage_coverage1001\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Coverage coverage1001</b></p><a name=\"coverage1001\"> </a><a name=\"hccoverage1001\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-davinci-pct-coverage.html\">PCT Coverage</a></p></div><p><b>Extension Definition for Coverage.kind for Version 5.0</b>: insurance</p><p><b>status</b>: Active</p><p><b>subscriberId</b>: PFP123450000</p><p><b>beneficiary</b>: <a href=\"Patient-patient1001.html\">Eve Betterhalf Female, DoB: 1955-07-23 ( http://example.com/identifiers/patient#1001)</a></p><p><b>relationship</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/subscriber-relationship self}\">Self</span></p><p><b>period</b>: 2021-01-01 --&gt; 2022-01-01</p><p><b>payor</b>: <a href=\"Organization-org1001.html\">Organization Umbrella Insurance Company</a></p><h3>Classes</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Type</b></td><td><b>Value</b></td><td><b>Name</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/coverage-class plan}\">Plan</span></td><td>Premim Family Plus</td><td>Premim Family Plus Plan</td></tr></table><h3>CostToBeneficiaries</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Type</b></td><td><b>Value[x]</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/coverage-copay-type copaypct}\">Copay Percentage</span></td><td>20</td></tr></table></div>"
        },
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Coverage.kind",
            "valueCode" : "insurance"
          }
        ],
        "status" : "active",
        "subscriberId" : "PFP123450000",
        "beneficiary" : {
          "reference" : "Patient/patient1001"
        },
        "relationship" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/subscriber-relationship",
              "code" : "self",
              "display" : "Self"
            }
          ]
        },
        "period" : {
          "start" : "2021-01-01",
          "end" : "2022-01-01"
        },
        "payor" : [
          {
            "reference" : "Organization/org1001"
          }
        ],
        "class" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/coverage-class",
                  "code" : "plan",
                  "display" : "Plan"
                }
              ]
            },
            "value" : "Premim Family Plus",
            "name" : "Premim Family Plus Plan"
          }
        ],
        "costToBeneficiary" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/coverage-copay-type",
                  "code" : "copaypct",
                  "display" : "Copay Percentage"
                }
              ]
            },
            "valueQuantity" : {
              "value" : 20
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Organization/org1001",
      "resource" : {
        "resourceType" : "Organization",
        "id" : "org1001",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-organization"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Organization_org1001\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Organization org1001</b></p><a name=\"org1001\"> </a><a name=\"hcorg1001\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-davinci-pct-organization.html\">PCT Organization</a></p></div><p><b>identifier</b>: Electronic Transmitter Identification Number/ETIN-3200002</p><p><b>active</b>: true</p><p><b>type</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/organization-type pay}\">Payer</span></p><p><b>name</b>: Umbrella Insurance Company</p><p><b>telecom</b>: ph: 860-547-5001(Work)</p><p><b>address</b>: 680 Asylum Street Hartford CT 06155 US </p></div>"
        },
        "identifier" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                  "code" : "ETIN"
                }
              ]
            },
            "value" : "ETIN-3200002"
          }
        ],
        "active" : true,
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/organization-type",
                "code" : "pay",
                "display" : "Payer"
              }
            ]
          }
        ],
        "name" : "Umbrella Insurance Company",
        "telecom" : [
          {
            "system" : "phone",
            "value" : "860-547-5001",
            "use" : "work"
          }
        ],
        "address" : [
          {
            "line" : ["680 Asylum Street"],
            "city" : "Hartford",
            "state" : "CT",
            "postalCode" : "06155",
            "country" : "US"
          }
        ]
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Organization/Submitter-Org-1",
      "resource" : {
        "resourceType" : "Organization",
        "id" : "Submitter-Org-1",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-organization"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Organization_Submitter-Org-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Organization Submitter-Org-1</b></p><a name=\"Submitter-Org-1\"> </a><a name=\"hcSubmitter-Org-1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-davinci-pct-organization.html\">PCT Organization</a></p></div><p><b>identifier</b>: Electronic Transmitter Identification Number/ETIN-10010301</p><p><b>active</b>: true</p><p><b>type</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/organization-type bus}\">Non-Healthcare Business or Corporation</span></p><p><b>name</b>: GFE Service Help INC.</p><blockquote><p><b>contact</b></p><p><b>purpose</b>: <span title=\"Codes:{http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTOrgContactPurposeType GFERELATED}\">GFE-related</span></p><p><b>name</b>: Clara Sender</p><p><b>telecom</b>: ph: 781-632-3209(Work), <a href=\"mailto:csender@GFEServiceHelp.com\">csender@GFEServiceHelp.com</a></p></blockquote></div>"
        },
        "identifier" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                  "code" : "ETIN"
                }
              ]
            },
            "value" : "ETIN-10010301"
          }
        ],
        "active" : true,
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/organization-type",
                "code" : "bus"
              }
            ]
          }
        ],
        "name" : "GFE Service Help INC.",
        "contact" : [
          {
            "purpose" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTOrgContactPurposeType",
                  "code" : "GFERELATED"
                }
              ]
            },
            "name" : {
              "text" : "Clara Sender"
            },
            "telecom" : [
              {
                "system" : "phone",
                "value" : "781-632-3209",
                "use" : "work"
              },
              {
                "system" : "email",
                "value" : "csender@GFEServiceHelp.com",
                "use" : "work"
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Organization/org1002",
      "resource" : {
        "resourceType" : "Organization",
        "id" : "org1002",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-organization"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Organization_org1002\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Organization org1002</b></p><a name=\"org1002\"> </a><a name=\"hcorg1002\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-davinci-pct-organization.html\">PCT Organization</a></p></div><p><b>identifier</b>: <a href=\"http://terminology.hl7.org/6.5.0/NamingSystem-npi.html\" title=\"National Provider Identifier\">United States National Provider Identifier</a>/9941339100, Tax ID number/TAX-3211001</p><p><b>active</b>: true</p><p><b>type</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/organization-type prov}\">Healthcare Provider</span></p><p><b>name</b>: Boston Radiology Center</p><p><b>telecom</b>: ph: 781-232-3200(Work)</p><p><b>address</b>: 32 Fruit Street Boston MA 02114 US </p></div>"
        },
        "identifier" : [
          {
            "system" : "http://hl7.org/fhir/sid/us-npi",
            "value" : "9941339100"
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                  "code" : "TAX"
                }
              ]
            },
            "system" : "urn:oid:2.16.840.1.113883.4.4",
            "value" : "TAX-3211001"
          }
        ],
        "active" : true,
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/organization-type",
                "code" : "prov",
                "display" : "Healthcare Provider"
              }
            ]
          }
        ],
        "name" : "Boston Radiology Center",
        "telecom" : [
          {
            "system" : "phone",
            "value" : "781-232-3200",
            "use" : "work"
          }
        ],
        "address" : [
          {
            "line" : ["32 Fruit Street"],
            "city" : "Boston",
            "state" : "MA",
            "postalCode" : "02114",
            "country" : "US"
          }
        ]
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Bundle/PCT-GFE-Bundle-Inst-1",
      "resource" : {
        "resourceType" : "Bundle",
        "id" : "PCT-GFE-Bundle-Inst-1",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-bundle"
          ]
        },
        "identifier" : {
          "system" : "http://example.com/identifiers/bundle",
          "value" : "59688475-2324-3242-23473847"
        },
        "type" : "collection",
        "timestamp" : "2021-11-09T11:01:00+05:00",
        "entry" : [
          {
            "fullUrl" : "http://example.org/fhir/Claim/PCT-GFE-Summary-1",
            "resource" : {
              "resourceType" : "Claim",
              "id" : "PCT-GFE-Summary-1",
              "meta" : {
                "profile" : [
                  "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-summary"
                ]
              },
              "status" : "active",
              "type" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTEstimateTypeSummaryCSTemporaryTrialUse",
                    "code" : "estimate-summary",
                    "display" : "Estimate Summary"
                  }
                ]
              },
              "use" : "predetermination",
              "patient" : {
                "reference" : "Patient/patient1001"
              },
              "billablePeriod" : {
                "start" : "2021-10-31",
                "end" : "2021-10-31"
              },
              "created" : "2021-10-05",
              "insurer" : {
                "reference" : "Organization/org1001"
              },
              "provider" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
                    "valueCode" : "not-applicable"
                  }
                ]
              },
              "priority" : {
                "coding" : [
                  {
                    "system" : "http://terminology.hl7.org/CodeSystem/processpriority",
                    "code" : "normal"
                  }
                ]
              },
              "diagnosis" : [
                {
                  "sequence" : 1,
                  "diagnosisCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/sid/icd-10-cm",
                        "code" : "S06.30",
                        "display" : "Unspecified focal traumatic brain injury"
                      }
                    ]
                  },
                  "type" : [
                    {
                      "coding" : [
                        {
                          "system" : "http://terminology.hl7.org/CodeSystem/diagnosistype",
                          "code" : "principal"
                        }
                      ]
                    }
                  ],
                  "packageCode" : {
                    "coding" : [
                      {
                        "system" : "http://terminology.hl7.org/CodeSystem/ex-diagnosisrelatedgroup",
                        "code" : "400",
                        "display" : "Head trauma - concussion"
                      }
                    ]
                  }
                }
              ],
              "insurance" : [
                {
                  "sequence" : 1,
                  "focal" : true,
                  "coverage" : {
                    "reference" : "Coverage/coverage1001"
                  }
                }
              ],
              "total" : {
                "value" : 200,
                "currency" : "USD"
              }
            }
          },
          {
            "fullUrl" : "http://example.org/fhir/Claim/PCT-GFE-Institutional-1",
            "resource" : {
              "resourceType" : "Claim",
              "id" : "PCT-GFE-Institutional-1",
              "meta" : {
                "profile" : [
                  "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-institutional"
                ]
              },
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/providerEventMethodology",
                  "valueString" : "EEMM1021"
                },
                {
                  "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/gfeDisclaimer",
                  "valueString" : "For estimation purposes only"
                },
                {
                  "extension" : [
                    {
                      "url" : "linkingIdentifier",
                      "valueIdentifier" : {
                        "system" : "http://example.org/Claim/identifiers",
                        "value" : "223452-2342-2435-008001"
                      }
                    },
                    {
                      "url" : "plannedPeriodOfService",
                      "valueDate" : "2021-10-31"
                    }
                  ],
                  "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/gfeServiceLinkingInfo"
                }
              ],
              "identifier" : [
                {
                  "type" : {
                    "coding" : [
                      {
                        "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                        "code" : "PLAC",
                        "display" : "Placer Identifier"
                      }
                    ]
                  },
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                  "value" : "GFEProviderAssignedID0001"
                }
              ],
              "status" : "active",
              "type" : {
                "coding" : [
                  {
                    "system" : "http://terminology.hl7.org/CodeSystem/claim-type",
                    "code" : "institutional",
                    "display" : "Institutional"
                  }
                ]
              },
              "use" : "predetermination",
              "patient" : {
                "reference" : "Patient/patient1001"
              },
              "created" : "2021-10-05",
              "insurer" : {
                "reference" : "Organization/org1001"
              },
              "provider" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/providerTaxonomy",
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://nucc.org/provider-taxonomy",
                          "code" : "2085D0003X",
                          "display" : "Diagnostic Neuroimaging (Radiology) Physician"
                        }
                      ]
                    }
                  },
                  {
                    "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/gfeConsentForBalanceBilling",
                    "valueBoolean" : true
                  }
                ],
                "reference" : "Organization/Submitter-Org-1"
              },
              "priority" : {
                "coding" : [
                  {
                    "system" : "http://terminology.hl7.org/CodeSystem/processpriority",
                    "code" : "normal"
                  }
                ]
              },
              "payee" : {
                "type" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/payeetype",
                      "code" : "provider"
                    }
                  ]
                }
              },
              "referral" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/referralNumber",
                    "valueString" : "REF12022002-121"
                  }
                ],
                "display" : "Referral Number"
              },
              "supportingInfo" : [
                {
                  "sequence" : 1,
                  "category" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTSupportingInfoType",
                        "code" : "typeofbill"
                      }
                    ]
                  },
                  "code" : {
                    "coding" : [
                      {
                        "system" : "https://www.nubc.org/CodeSystem/TypeOfBill",
                        "code" : "011X",
                        "display" : "Hospital Inpatient (Part A)"
                      }
                    ]
                  }
                }
              ],
              "diagnosis" : [
                {
                  "sequence" : 1,
                  "diagnosisCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/sid/icd-10-cm",
                        "code" : "S06.30",
                        "display" : "Unspecified focal traumatic brain injury"
                      }
                    ]
                  },
                  "type" : [
                    {
                      "coding" : [
                        {
                          "system" : "http://terminology.hl7.org/CodeSystem/diagnosistype",
                          "code" : "principal"
                        }
                      ]
                    }
                  ],
                  "packageCode" : {
                    "coding" : [
                      {
                        "system" : "http://terminology.hl7.org/CodeSystem/ex-diagnosisrelatedgroup",
                        "code" : "400",
                        "display" : "Head trauma - concussion"
                      }
                    ]
                  }
                }
              ],
              "insurance" : [
                {
                  "sequence" : 1,
                  "focal" : true,
                  "coverage" : {
                    "reference" : "Coverage/coverage1001"
                  }
                }
              ],
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/serviceDescription",
                      "valueString" : "Imaging"
                    }
                  ],
                  "sequence" : 1,
                  "revenue" : {
                    "coding" : [
                      {
                        "system" : "https://www.nubc.org/CodeSystem/RevenueCodes",
                        "code" : "0611",
                        "display" : "Magnetic Resonance Technology (MRT) - Brain/brain stem"
                      }
                    ]
                  },
                  "productOrService" : {
                    "coding" : [
                      {
                        "system" : "http://www.ama-assn.org/go/cpt",
                        "code" : "70551",
                        "display" : "Magnetic resonance (eg, proton) imaging, brain (including brain stem); without contrast material"
                      }
                    ]
                  },
                  "modifier" : [
                    {
                      "coding" : [
                        {
                          "system" : "http://www.ama-assn.org/go/cpt",
                          "code" : "70551",
                          "display" : "Magnetic resonance (eg, proton) imaging, brain (including brain stem); without contrast material"
                        }
                      ]
                    }
                  ],
                  "servicedDate" : "2021-10-31",
                  "quantity" : {
                    "value" : 1
                  },
                  "net" : {
                    "value" : 200,
                    "currency" : "USD"
                  }
                }
              ],
              "total" : {
                "value" : 200,
                "currency" : "USD"
              }
            }
          },
          {
            "fullUrl" : "http://example.org/fhir/Organization/Submitter-Org-1",
            "resource" : {
              "resourceType" : "Organization",
              "id" : "Submitter-Org-1",
              "meta" : {
                "profile" : [
                  "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-organization"
                ]
              },
              "identifier" : [
                {
                  "type" : {
                    "coding" : [
                      {
                        "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                        "code" : "ETIN"
                      }
                    ]
                  },
                  "value" : "ETIN-10010301"
                }
              ],
              "active" : true,
              "type" : [
                {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/organization-type",
                      "code" : "bus"
                    }
                  ]
                }
              ],
              "name" : "GFE Service Help INC.",
              "contact" : [
                {
                  "purpose" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTOrgContactPurposeType",
                        "code" : "GFERELATED"
                      }
                    ]
                  },
                  "name" : {
                    "text" : "Clara Sender"
                  },
                  "telecom" : [
                    {
                      "system" : "phone",
                      "value" : "781-632-3209",
                      "use" : "work"
                    },
                    {
                      "system" : "email",
                      "value" : "csender@GFEServiceHelp.com",
                      "use" : "work"
                    }
                  ]
                }
              ]
            }
          },
          {
            "fullUrl" : "http://example.org/fhir/Organization/org1001",
            "resource" : {
              "resourceType" : "Organization",
              "id" : "org1001",
              "meta" : {
                "profile" : [
                  "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-organization"
                ]
              },
              "identifier" : [
                {
                  "type" : {
                    "coding" : [
                      {
                        "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                        "code" : "ETIN"
                      }
                    ]
                  },
                  "value" : "ETIN-3200002"
                }
              ],
              "active" : true,
              "type" : [
                {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/organization-type",
                      "code" : "pay",
                      "display" : "Payer"
                    }
                  ]
                }
              ],
              "name" : "Umbrella Insurance Company",
              "telecom" : [
                {
                  "system" : "phone",
                  "value" : "860-547-5001",
                  "use" : "work"
                }
              ],
              "address" : [
                {
                  "line" : ["680 Asylum Street"],
                  "city" : "Hartford",
                  "state" : "CT",
                  "postalCode" : "06155",
                  "country" : "US"
                }
              ]
            }
          },
          {
            "fullUrl" : "http://example.org/fhir/Patient/patient1001",
            "resource" : {
              "resourceType" : "Patient",
              "id" : "patient1001",
              "meta" : {
                "profile" : [
                  "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient|7.0.0"
                ]
              },
              "text" : {
                "status" : "additional",
                "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><p style=\"border: 1px #661aff solid; background-color: #e6e6ff; padding: 10px;\"><b>Eve Betterhalf</b> female, DoB: 1955-07-23 ( <code>http://example.com/identifiers/patient</code>/1001)</p><hr/><table class=\"grid\"><tr><td style=\"background-color: #f3f5da\" title=\"Known Marital status of Patient\">Marital Status:</td><td colspan=\"3\"><span title=\"Codes: {http://terminology.hl7.org/CodeSystem/v3-MaritalStatus U}\">unmarried</span></td></tr><tr><td style=\"background-color: #f3f5da\" title=\"Ways to contact the Patient\">Contact Details:</td><td colspan=\"3\"><ul><li>ph: 781-949-4949(MOBILE)</li><li>222 Burlington Road, Bedford MA 01730</li></ul></td></tr><tr><td style=\"background-color: #f3f5da\" title=\"Languages spoken\">Language:</td><td colspan=\"3\"><span title=\"Codes: {urn:ietf:bcp:47 en-US}\">English (United States)</span> (preferred)</td></tr></table></div>"
              },
              "identifier" : [
                {
                  "system" : "http://example.com/identifiers/patient",
                  "value" : "1001"
                }
              ],
              "name" : [
                {
                  "text" : "Eve Betterhalf",
                  "family" : "Betterhalf",
                  "given" : ["Eve"]
                }
              ],
              "telecom" : [
                {
                  "system" : "phone",
                  "value" : "781-949-4949",
                  "use" : "mobile"
                }
              ],
              "gender" : "female",
              "birthDate" : "1955-07-23",
              "address" : [
                {
                  "text" : "222 Burlington Road, Bedford MA 01730"
                }
              ],
              "maritalStatus" : {
                "coding" : [
                  {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-MaritalStatus",
                    "code" : "U",
                    "display" : "unmarried"
                  }
                ]
              },
              "communication" : [
                {
                  "language" : {
                    "coding" : [
                      {
                        "system" : "urn:ietf:bcp:47",
                        "code" : "en-US",
                        "display" : "English (United States)"
                      }
                    ]
                  },
                  "preferred" : true
                }
              ]
            }
          },
          {
            "fullUrl" : "http://example.org/fhir/Coverage/coverage1001",
            "resource" : {
              "resourceType" : "Coverage",
              "id" : "coverage1001",
              "meta" : {
                "profile" : [
                  "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-coverage"
                ]
              },
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Coverage.kind",
                  "valueCode" : "insurance"
                }
              ],
              "status" : "active",
              "subscriberId" : "PFP123450000",
              "beneficiary" : {
                "reference" : "Patient/patient1001"
              },
              "relationship" : {
                "coding" : [
                  {
                    "system" : "http://terminology.hl7.org/CodeSystem/subscriber-relationship",
                    "code" : "self",
                    "display" : "Self"
                  }
                ]
              },
              "period" : {
                "start" : "2021-01-01",
                "end" : "2022-01-01"
              },
              "payor" : [
                {
                  "reference" : "Organization/org1001"
                }
              ],
              "class" : [
                {
                  "type" : {
                    "coding" : [
                      {
                        "system" : "http://terminology.hl7.org/CodeSystem/coverage-class",
                        "code" : "plan",
                        "display" : "Plan"
                      }
                    ]
                  },
                  "value" : "Premim Family Plus",
                  "name" : "Premim Family Plus Plan"
                }
              ],
              "costToBeneficiary" : [
                {
                  "type" : {
                    "coding" : [
                      {
                        "system" : "http://terminology.hl7.org/CodeSystem/coverage-copay-type",
                        "code" : "copaypct",
                        "display" : "Copay Percentage"
                      }
                    ]
                  },
                  "valueQuantity" : {
                    "value" : 20
                  }
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Bundle/PCT-GFE-Missing-Bundle-1",
      "resource" : {
        "resourceType" : "Bundle",
        "id" : "PCT-GFE-Missing-Bundle-1",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-missing-bundle"
          ]
        },
        "identifier" : {
          "system" : "http://example.com/identifiers/bundle",
          "value" : "59688475-2324-3242-2347384376"
        },
        "type" : "collection",
        "timestamp" : "2024-03-27T11:01:00+05:00",
        "entry" : [
          {
            "fullUrl" : "http://example.org/fhir/Organization/org1002",
            "resource" : {
              "resourceType" : "Organization",
              "id" : "org1002",
              "meta" : {
                "profile" : [
                  "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-organization"
                ]
              },
              "identifier" : [
                {
                  "system" : "http://hl7.org/fhir/sid/us-npi",
                  "value" : "9941339100"
                },
                {
                  "type" : {
                    "coding" : [
                      {
                        "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                        "code" : "TAX"
                      }
                    ]
                  },
                  "system" : "urn:oid:2.16.840.1.113883.4.4",
                  "value" : "TAX-3211001"
                }
              ],
              "active" : true,
              "type" : [
                {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/organization-type",
                      "code" : "prov",
                      "display" : "Healthcare Provider"
                    }
                  ]
                }
              ],
              "name" : "Boston Radiology Center",
              "telecom" : [
                {
                  "system" : "phone",
                  "value" : "781-232-3200",
                  "use" : "work"
                }
              ],
              "address" : [
                {
                  "line" : ["32 Fruit Street"],
                  "city" : "Boston",
                  "state" : "MA",
                  "postalCode" : "02114",
                  "country" : "US"
                }
              ]
            }
          },
          {
            "fullUrl" : "http://example.org/fhir/Patient/patient1001",
            "resource" : {
              "resourceType" : "Patient",
              "id" : "patient1001",
              "meta" : {
                "profile" : [
                  "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient|7.0.0"
                ]
              },
              "text" : {
                "status" : "additional",
                "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><p style=\"border: 1px #661aff solid; background-color: #e6e6ff; padding: 10px;\"><b>Eve Betterhalf</b> female, DoB: 1955-07-23 ( <code>http://example.com/identifiers/patient</code>/1001)</p><hr/><table class=\"grid\"><tr><td style=\"background-color: #f3f5da\" title=\"Known Marital status of Patient\">Marital Status:</td><td colspan=\"3\"><span title=\"Codes: {http://terminology.hl7.org/CodeSystem/v3-MaritalStatus U}\">unmarried</span></td></tr><tr><td style=\"background-color: #f3f5da\" title=\"Ways to contact the Patient\">Contact Details:</td><td colspan=\"3\"><ul><li>ph: 781-949-4949(MOBILE)</li><li>222 Burlington Road, Bedford MA 01730</li></ul></td></tr><tr><td style=\"background-color: #f3f5da\" title=\"Languages spoken\">Language:</td><td colspan=\"3\"><span title=\"Codes: {urn:ietf:bcp:47 en-US}\">English (United States)</span> (preferred)</td></tr></table></div>"
              },
              "identifier" : [
                {
                  "system" : "http://example.com/identifiers/patient",
                  "value" : "1001"
                }
              ],
              "name" : [
                {
                  "text" : "Eve Betterhalf",
                  "family" : "Betterhalf",
                  "given" : ["Eve"]
                }
              ],
              "telecom" : [
                {
                  "system" : "phone",
                  "value" : "781-949-4949",
                  "use" : "mobile"
                }
              ],
              "gender" : "female",
              "birthDate" : "1955-07-23",
              "address" : [
                {
                  "text" : "222 Burlington Road, Bedford MA 01730"
                }
              ],
              "maritalStatus" : {
                "coding" : [
                  {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-MaritalStatus",
                    "code" : "U",
                    "display" : "unmarried"
                  }
                ]
              },
              "communication" : [
                {
                  "language" : {
                    "coding" : [
                      {
                        "system" : "urn:ietf:bcp:47",
                        "code" : "en-US",
                        "display" : "English (United States)"
                      }
                    ]
                  },
                  "preferred" : true
                }
              ]
            }
          },
          {
            "fullUrl" : "http://example.org/fhir/Coverage/coverage1001",
            "resource" : {
              "resourceType" : "Coverage",
              "id" : "coverage1001",
              "meta" : {
                "profile" : [
                  "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-coverage"
                ]
              },
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Coverage.kind",
                  "valueCode" : "insurance"
                }
              ],
              "status" : "active",
              "subscriberId" : "PFP123450000",
              "beneficiary" : {
                "reference" : "Patient/patient1001"
              },
              "relationship" : {
                "coding" : [
                  {
                    "system" : "http://terminology.hl7.org/CodeSystem/subscriber-relationship",
                    "code" : "self",
                    "display" : "Self"
                  }
                ]
              },
              "period" : {
                "start" : "2021-01-01",
                "end" : "2022-01-01"
              },
              "payor" : [
                {
                  "reference" : "Organization/org1001"
                }
              ],
              "class" : [
                {
                  "type" : {
                    "coding" : [
                      {
                        "system" : "http://terminology.hl7.org/CodeSystem/coverage-class",
                        "code" : "plan",
                        "display" : "Plan"
                      }
                    ]
                  },
                  "value" : "Premim Family Plus",
                  "name" : "Premim Family Plus Plan"
                }
              ],
              "costToBeneficiary" : [
                {
                  "type" : {
                    "coding" : [
                      {
                        "system" : "http://terminology.hl7.org/CodeSystem/coverage-copay-type",
                        "code" : "copaypct",
                        "display" : "Copay Percentage"
                      }
                    ]
                  },
                  "valueQuantity" : {
                    "value" : 20
                  }
                }
              ]
            }
          },
          {
            "fullUrl" : "http://example.org/fhir/Organization/org1001",
            "resource" : {
              "resourceType" : "Organization",
              "id" : "org1001",
              "meta" : {
                "profile" : [
                  "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-organization"
                ]
              },
              "identifier" : [
                {
                  "type" : {
                    "coding" : [
                      {
                        "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                        "code" : "ETIN"
                      }
                    ]
                  },
                  "value" : "ETIN-3200002"
                }
              ],
              "active" : true,
              "type" : [
                {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/organization-type",
                      "code" : "pay",
                      "display" : "Payer"
                    }
                  ]
                }
              ],
              "name" : "Umbrella Insurance Company",
              "telecom" : [
                {
                  "system" : "phone",
                  "value" : "860-547-5001",
                  "use" : "work"
                }
              ],
              "address" : [
                {
                  "line" : ["680 Asylum Street"],
                  "city" : "Hartford",
                  "state" : "CT",
                  "postalCode" : "06155",
                  "country" : "US"
                }
              ]
            }
          },
          {
            "id" : "PCT-DeviceRequest-1",
            "fullUrl" : "http://example.org/fhir/DeviceRequest/PCT-DeviceRequest-1",
            "resource" : {
              "resourceType" : "DeviceRequest",
              "id" : "PCT-DeviceRequest-1",
              "meta" : {
                "profile" : [
                  "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-devicerequest"
                ]
              },
              "status" : "active",
              "intent" : "proposal",
              "codeCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://www.cms.gov/Medicare/Coding/HCPCSReleaseCodeSets",
                    "code" : "L1820",
                    "display" : "KNEE ORTHOSIS, ELASTIC WITH CONDYLAR PADS AND JOINTS, WITH OR WITHOUT PATELLAR CONTROL, PREFABRICATED, INCLUDES FITTING AND ADJUSTMENT"
                  }
                ]
              },
              "subject" : {
                "reference" : "Patient/patient1001"
              }
            }
          }
        ]
      }
    }
  ]
}

```
