# Resource davinci-pct-gfe-coordination-task-notification



## Resource Content

```json
{
  "resourceType" : "Basic",
  "id" : "davinci-pct-gfe-coordination-task-notification",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-pct/ImplementationGuide/hl7.fhir.us.davinci-pct"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-pct/ImplementationGuide/hl7.fhir.us.davinci-pct"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-SubscriptionTopic.url",
      "valueUri" : "http://hl7.org/fhir/us/davinci-pct/SubscriptionTopic/davinci-pct-gfe-coordination-task-notification"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-SubscriptionTopic.version",
      "valueString" : "2.0.0"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-SubscriptionTopic.name",
      "valueString" : "PCTGFECoordinationTaskSubscriptionTopic"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-SubscriptionTopic.title",
      "valueString" : "SubscriptionTopic - GFE Coordination Task Notification"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-SubscriptionTopic.status",
      "valueCode" : "active"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-SubscriptionTopic.experimental",
      "valueBoolean" : false
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-SubscriptionTopic.date",
      "valueDateTime" : "2025-04-17"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-SubscriptionTopic.publisher",
      "valueString" : "HL7 International / Financial Management"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-SubscriptionTopic.contact",
      "valueContactDetail" : {
        "name" : "HL7 International / Financial Management",
        "telecom" : [
          {
            "system" : "url",
            "value" : "http://www.hl7.org/Special/committees/fm"
          },
          {
            "system" : "email",
            "value" : "fmlists@lists.hl7.org"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-SubscriptionTopic.description",
      "valueMarkdown" : "Subscription Topic to provide a notification to an Provider involved in GFE Coordination effort (either as a GFE Coordination Requester or a GFE Contributor) whenever a Task is created, updated, or deleted (for FHIR R4). For the GFE Coordination requester this will trigger for a change on a Coordination or Contributor Task for which they are the requester. For a GFE Contributor this will trigger on a change to a Contributor Task for which they are the owner or on a change to an associated Coordination Task. This will be triggered on the creation, update, or deletion of Coordination (gfe-coordination-task) or Contributor Task (gfe-contributor-task) codes.\n\r**Canonical URL:** http://hl7.org/fhir/us/davinci-pct/SubscriptionTopic/davinci-pct-gfe-coordination-task-notification"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-SubscriptionTopic.jurisdiction",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "urn:iso:std:iso:3166",
            "code" : "US"
          }
        ]
      }
    },
    {
      "extension" : [
        {
          "url" : "description",
          "valueMarkdown" : "Triggered when a GFE Coordination or Contributor Task created, updated, or deleted"
        },
        {
          "url" : "resource",
          "valueUri" : "http://hl7.org/fhir/StructureDefinition/Task"
        },
        {
          "url" : "supportedInteraction",
          "valueCode" : "create"
        },
        {
          "url" : "supportedInteraction",
          "valueCode" : "update"
        },
        {
          "url" : "supportedInteraction",
          "valueCode" : "delete"
        },
        {
          "extension" : [
            {
              "url" : "resultForCreate",
              "valueCode" : "test-passes"
            },
            {
              "url" : "current",
              "valueString" : "code=gfe-coordination-task,gfe-contributor-task"
            },
            {
              "url" : "resultForDelete",
              "valueCode" : "test-passes"
            },
            {
              "url" : "requireBoth",
              "valueBoolean" : false
            }
          ],
          "url" : "queryCriteria"
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-SubscriptionTopic.resourceTrigger"
    },
    {
      "extension" : [
        {
          "url" : "description",
          "valueMarkdown" : "Filter based on the requester of a Task."
        },
        {
          "url" : "resource",
          "valueUri" : "Task"
        },
        {
          "url" : "filterParameter",
          "valueString" : "requester"
        },
        {
          "url" : "filterDefinition",
          "valueUri" : "http://hl7.org/fhir/SearchParameter/Task-requester"
        },
        {
          "url" : "comparator",
          "valueCode" : "eq"
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-SubscriptionTopic.canFilterBy"
    },
    {
      "extension" : [
        {
          "url" : "description",
          "valueMarkdown" : "Filter based on the owner (performer) of a Task."
        },
        {
          "url" : "resource",
          "valueUri" : "Task"
        },
        {
          "url" : "filterParameter",
          "valueString" : "owner"
        },
        {
          "url" : "filterDefinition",
          "valueUri" : "http://hl7.org/fhir/SearchParameter/Task-owner"
        },
        {
          "url" : "comparator",
          "valueCode" : "eq"
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-SubscriptionTopic.canFilterBy"
    },
    {
      "extension" : [
        {
          "url" : "description",
          "valueMarkdown" : "Filter based on the owner (performer) of a Task that is part of another Task."
        },
        {
          "url" : "resource",
          "valueUri" : "Task"
        },
        {
          "url" : "filterParameter",
          "valueString" : "_has:Task:part-of:owner"
        },
        {
          "url" : "comparator",
          "valueCode" : "eq"
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-SubscriptionTopic.canFilterBy"
    },
    {
      "extension" : [
        {
          "url" : "description",
          "valueMarkdown" : "Filter based on the status (draft | requested | received | accepted | +) of a Task."
        },
        {
          "url" : "resource",
          "valueUri" : "Task"
        },
        {
          "url" : "filterParameter",
          "valueString" : "status"
        },
        {
          "url" : "filterDefinition",
          "valueUri" : "http://hl7.org/fhir/SearchParameter/Task-status"
        },
        {
          "url" : "comparator",
          "valueCode" : "eq"
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-SubscriptionTopic.canFilterBy"
    },
    {
      "extension" : [
        {
          "url" : "description",
          "valueMarkdown" : "Filter based on the task business status (closed +) of a Task."
        },
        {
          "url" : "resource",
          "valueUri" : "Task"
        },
        {
          "url" : "filterParameter",
          "valueString" : "business-status"
        },
        {
          "url" : "filterDefinition",
          "valueUri" : "http://hl7.org/fhir/SearchParameter/Task-business-status"
        },
        {
          "url" : "comparator",
          "valueCode" : "eq"
        },
        {
          "url" : "modifier",
          "valueCode" : "not"
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-SubscriptionTopic.canFilterBy"
    },
    {
      "extension" : [
        {
          "url" : "resource",
          "valueUri" : "Task"
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-SubscriptionTopic.notificationShape"
    }
  ],
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.4.44.7"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/fhir-types",
        "code" : "SubscriptionTopic"
      }
    ]
  }
}

```
