# Terminology Licensure - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* **Terminology Licensure**

## Terminology Licensure

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

### Code Systems Requiring Licenses

#### Access to Licensed Code Systems

This HL7 specification contains and references intellectual property owned by third parties ("Third-Party IP"). Implementers and testers of this specification **SHALL** abide by the license requirements for each terminology content artifact used within a functioning implementation. Terminology licenses **SHALL** be obtained from the Third-Party IP owner for each code system and/or other specified artifact used. Each organization is solely responsible for deploying or testing this specification to ensure their implementations comply with licensing requirements of each Third-Party IP.

#### Licensed Industry Standard Code Systems
This IG includes value set bindings to code systems that reference industry standard codes which require implementers to purchase a license before the coded concepts can be used. The following information summarizes the set of licensed Code Systems required by this IG and provides links to the information about where to go to obtain a license.
* [AMA CPT](http://www.ama-assn.org/go/cpt): The CPT procedure and modifier codes are owned by the American Medical Association.
* [ADA CDT](http://www.ada.org/cdt): The CDT codes are owned by the American Dental Association.
* [X12](http://www.x12.org/codes/claim-adjustment-reason-codes/): CARC (Claim Adjustment Reason Codes) are owned by X12.
* [NUBC](https://www.nubc.org): The NUBC secretariat is the American Hospital Association.
* [NUCC](http://www.nucc.org/): National Uniform Claim Committee (NUCC) is presently maintaining the Taxonomy code set. The codes are free and publicly available for download and use. If the use however is " For commercial use, including sales or licensing, a license must be obtained". It would be appropriate for an app developer to file the license form just like they would for any other code set; however, there is no fee.
* [NCPDP](https://www.ncpdp.org): Retail Pharmacy data standards are defined by the NCPDP .
* [3M APR-DRG](https://www.3m.com/3M/en_US/health-information-systems-us/drive-value-based-care/patient-classification-methodologies/apr-drgs/): AP-DRGs and APR-DRGs are owned by 3M. Use of AP-DRGs and APR-DRGs require a license. 

### Code Systems Not Requiring Licenses
This IG includes value set bindings to code systems that are industry standard codes available for use without licenses. The following information summarizes the set of Code Systems required by this IG that are available for use:
* [ICD-CM Diagnosis Codes (ICD-10-CM)](https://www.icd10data.com/ICD10CM/Codes): International Statistical Classification of Diseases and Related Health Problems (ICD). This IG will use version 10. The ICD-10-CM code set is maintained by the National Center for Health Statistics (NCHS) of the Centers for Disease Control and Prevention (CDC) for use in the United States. It is based on ICD-10, which was developed by the World Health Organization (WHO) as a medical classification.
* [ICD-Procedure Codes (ICD-PCS)](https://www.icd10data.com/ICD10PCS/Codes): The ICD-10-PCS code set is owned by CMS.
* [DRGs](https://www.cms.gov/Medicare/Medicare-Fee-for-Service-Payment/AcuteInpatientPPS/MS-DRG-Classifications-and-Software.html).:MS-DRGs are owned by CMS. MS-DRGs are used for the Medicare population.
* [HCPCS Level II Procedure and Modifier Codes](https://www.cms.gov/Medicare/Coding/HCPCSReleaseCodeSets/Alpha-Numeric-HCPCS-Items/2020-HCPCS-Record-Layout ): Primarily include non-physician products, supplies, and procedures not included in CPT. They are owned by CMS and are available for use.
* [NDC (National Drug Codes)](http://hl7.org/fhir/sid/ndc.md  ): The US Federal Drug Administration (FDA) Data Standards Council assigns the first 5 digits of the 11 digit code.
* [RARCCodes](http://www.wpc-edi.com/reference/codelists/healthcare/remittance-advice-remark-codes): The RARC codes are owned by CMS.

