# Security - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* **Security**

## Security

| |
| :--- |
| *Page standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) |

### Privacy & Security Considerations

The sharing of information from provider to payer for determining an Advanced Explanation of Benefits (AEOB) is subject to the Health Insurance Portability and Accountability Act's (HIPAA) "minimum necessary" regulations (specifically 45 CFR 164.514(d)(3) and (d)(4)). Payers are responsible for ensuring that only information necessary to create an AEOB is solicited, and providers are responsible for ensuring that only data that is reasonably relevant to creating an AEOB is transmitted.

Some of the data shared as part of the GFE Coordination, Submission and AEOB processes may have associated constraints on the use of that information for other purposes, including subsequent disclosure to other payers, practitioners, policyholders, etc. While HL7 FHIR supports conveying this information via security labels on transmitted resources, this information is not currently mappable (and thus findable) in the X12 837 transactions. Payers who do not view the FHIR version of the transmitted information should be aware of the possibility of these limitations and ensure they have policies that enforce appropriate sharing constraints on data.

To access information about an AEOB, the provider system will need to access the payer system. This will require that the provider system authenticates to the payer system or an intermediary. The Da Vinci HRex Implementation guide specifies how this authentication is handled. PCT servers **SHOULD** support server-server OAuth and **MAY** support mutually authenticated TLS. In a future release of this guide, direction will limit the option to server-server OAuth. Every system claiming conformance to this IG **SHALL** meet the requirements defined in the [Security and Privacy section of the Da Vinci HRex IG](http://hl7.org/fhir/us/davinci-hrex/STU1.1/security.html). The FHIR implementer’s [Security Principles](http://hl7.org/fhir/R4/security.html), [Security & Privacy Module](http://hl7.org/fhir/R4/secpriv-module.html), and [Implementer's Checklist](http://hl7.org/fhir/R4/safety.html) helps implementers be sure that they have considered all the parts of FHIR that impact their system design regarding privacy, security, provenance, and safety.

Once the system authentication has occurred, the payer will perform any authorization required for the provider to see the current state of the AEOB.

